/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DurationUtils;

public class ThreadUtils {
    public static final AlwaysTruePredicate ALWAYS_TRUE_PREDICATE = new AlwaysTruePredicate();

    /*
     * WARNING - void declaration
     */
    public static Thread findThreadById(long threadId) {
        void var0_1;
        Collection<Thread> result = ThreadUtils.findThreads(new ThreadIdPredicate(threadId));
        if (result.isEmpty()) {
            return null;
        }
        return (Thread)var0_1.iterator().next();
    }

    /*
     * WARNING - void declaration
     */
    public static Thread findThreadById(long threadId, String threadGroupName) {
        void var2_2;
        Validate.notNull(threadGroupName, "threadGroupName", new Object[0]);
        Thread thread = ThreadUtils.findThreadById(threadId);
        if (thread != null && thread.getThreadGroup() != null && thread.getThreadGroup().getName().equals(var2_2)) {
            void var0_1;
            return var0_1;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static Thread findThreadById(long threadId, ThreadGroup threadGroup) {
        void var2_2;
        Validate.notNull(threadGroup, "threadGroup", new Object[0]);
        Thread thread = ThreadUtils.findThreadById(threadId);
        if (thread != null && var2_2.equals(thread.getThreadGroup())) {
            void var0_1;
            return var0_1;
        }
        return null;
    }

    public static Collection<ThreadGroup> findThreadGroups(ThreadGroup group, boolean recurse, ThreadGroupPredicate predicate) {
        ArrayList arrayList;
        int n;
        ThreadGroup[] threadGroups;
        Validate.notNull(group, "group", new Object[0]);
        Validate.notNull(predicate, "predicate", new Object[0]);
        int count = group.activeGroupCount();
        do {
            n = count;
        } while ((count = group.enumerate(threadGroups = new ThreadGroup[n + n / 2 + 1], recurse)) >= threadGroups.length);
        ArrayList result = new ArrayList(count);
        for (int i = 0; i < count; ++i) {
            if (!predicate.test(threadGroups[i])) continue;
            result.add(threadGroups[i]);
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    public static Collection<ThreadGroup> findThreadGroups(ThreadGroupPredicate predicate) {
        ThreadGroupPredicate threadGroupPredicate;
        return ThreadUtils.findThreadGroups(ThreadUtils.getSystemThreadGroup(), true, threadGroupPredicate);
    }

    public static Collection<ThreadGroup> findThreadGroupsByName(String threadGroupName) {
        String string;
        return ThreadUtils.findThreadGroups(new NamePredicate(string));
    }

    public static Collection<Thread> findThreads(ThreadGroup group, boolean recurse, ThreadPredicate predicate) {
        ArrayList arrayList;
        int n;
        Thread[] threads;
        Validate.notNull(group, "The group must not be null", new Object[0]);
        Validate.notNull(predicate, "The predicate must not be null", new Object[0]);
        int count = group.activeCount();
        do {
            n = count;
        } while ((count = group.enumerate(threads = new Thread[n + n / 2 + 1], recurse)) >= threads.length);
        ArrayList result = new ArrayList(count);
        for (int i = 0; i < count; ++i) {
            if (!predicate.test(threads[i])) continue;
            result.add(threads[i]);
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    public static Collection<Thread> findThreads(ThreadPredicate predicate) {
        ThreadPredicate threadPredicate;
        return ThreadUtils.findThreads(ThreadUtils.getSystemThreadGroup(), true, threadPredicate);
    }

    public static Collection<Thread> findThreadsByName(String threadName) {
        String string;
        return ThreadUtils.findThreads(new NamePredicate(string));
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<Thread> findThreadsByName(String threadName, String threadGroupName) {
        void var2_2;
        Iterator iterator;
        Validate.notNull(threadName, "threadName", new Object[0]);
        Validate.notNull(threadGroupName, "threadGroupName", new Object[0]);
        Collection<ThreadGroup> threadGroups = ThreadUtils.findThreadGroups(new NamePredicate(threadGroupName));
        if (threadGroups.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Thread> result = new ArrayList<Thread>();
        NamePredicate threadNamePredicate = new NamePredicate(threadName);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            ThreadGroup group = (ThreadGroup)iterator.next();
            result.addAll(ThreadUtils.findThreads((ThreadGroup)var3_3, false, threadNamePredicate));
        }
        return Collections.unmodifiableCollection(var2_2);
    }

    public static Collection<Thread> findThreadsByName(String threadName, ThreadGroup threadGroup) {
        String string;
        return ThreadUtils.findThreads(threadGroup, false, new NamePredicate(string));
    }

    public static Collection<ThreadGroup> getAllThreadGroups() {
        return ThreadUtils.findThreadGroups(ALWAYS_TRUE_PREDICATE);
    }

    public static Collection<Thread> getAllThreads() {
        return ThreadUtils.findThreads(ALWAYS_TRUE_PREDICATE);
    }

    /*
     * WARNING - void declaration
     */
    public static ThreadGroup getSystemThreadGroup() {
        void var0;
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    public static void join(Thread thread, Duration duration) throws InterruptedException {
        void var1_1;
        DurationUtils.accept(thread::join, (Duration)var1_1);
    }

    public static void sleep(Duration duration) throws InterruptedException {
        Duration duration2;
        DurationUtils.accept(Thread::sleep, duration2);
    }

    @FunctionalInterface
    public static interface ThreadPredicate {
        public boolean test(Thread var1);
    }

    public static class ThreadIdPredicate
    implements ThreadPredicate {
        private final long threadId;

        /*
         * WARNING - void declaration
         */
        public ThreadIdPredicate(long threadId) {
            void var1_1;
            if (threadId <= 0L) {
                throw new IllegalArgumentException("The thread id must be greater than zero");
            }
            this.threadId = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean test(Thread thread) {
            void var1_1;
            return thread != null && var1_1.getId() == this.threadId;
        }
    }

    @FunctionalInterface
    public static interface ThreadGroupPredicate {
        public boolean test(ThreadGroup var1);
    }

    public static class NamePredicate
    implements ThreadGroupPredicate,
    ThreadPredicate {
        private final String name;

        /*
         * WARNING - void declaration
         */
        public NamePredicate(String name) {
            void var1_1;
            Validate.notNull(name, "name", new Object[0]);
            this.name = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean test(Thread thread) {
            void var1_1;
            return thread != null && var1_1.getName().equals(this.name);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean test(ThreadGroup threadGroup) {
            void var1_1;
            return threadGroup != null && var1_1.getName().equals(this.name);
        }
    }

    private static final class AlwaysTruePredicate
    implements ThreadGroupPredicate,
    ThreadPredicate {
        private AlwaysTruePredicate() {
        }

        @Override
        public final boolean test(Thread thread) {
            return true;
        }

        @Override
        public final boolean test(ThreadGroup threadGroup) {
            return true;
        }
    }
}

