/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.CharSequenceUtils;
import org.apache.commons.lang3.CharUtils;
import org.apache.commons.lang3.Charsets;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.function.ToBooleanBiFunction;

public class StringUtils {
    private static final int STRING_BUILDER_SIZE = 256;
    public static final String SPACE = " ";
    public static final String EMPTY = "";
    public static final String LF = "\n";
    public static final String CR = "\r";
    public static final int INDEX_NOT_FOUND = -1;
    private static final int PAD_LIMIT = 8192;
    private static final Pattern STRIP_ACCENTS_PATTERN = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");

    /*
     * WARNING - void declaration
     */
    public static String abbreviate(String str, int maxWidth) {
        void var1_1;
        return StringUtils.abbreviate(str, "...", 0, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String abbreviate(String str, int offset, int maxWidth) {
        void var2_2;
        void var1_1;
        return StringUtils.abbreviate(str, "...", (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String abbreviate(String str, String abbrevMarker, int maxWidth) {
        void var2_2;
        void var1_1;
        return StringUtils.abbreviate(str, (String)var1_1, 0, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String abbreviate(String str, String abbrevMarker, int offset, int maxWidth) {
        void var3_3;
        String string;
        void var1_1;
        if (StringUtils.isNotEmpty(str) && EMPTY.equals(abbrevMarker) && maxWidth > 0) {
            return StringUtils.substring(str, 0, maxWidth);
        }
        if (StringUtils.isAnyEmpty(str, abbrevMarker)) {
            return str;
        }
        int abbrevMarkerLength = abbrevMarker.length();
        int minAbbrevWidth = abbrevMarkerLength + 1;
        int n = abbrevMarkerLength;
        int minAbbrevWidthOffset = n + n + 1;
        if (maxWidth < minAbbrevWidth) {
            throw new IllegalArgumentException(String.format("Minimum abbreviation width is %d", minAbbrevWidth));
        }
        int strLen = str.length();
        if (strLen <= maxWidth) {
            return str;
        }
        if (offset > strLen) {
            offset = strLen;
        }
        if (strLen - offset < maxWidth - abbrevMarkerLength) {
            offset = strLen - (maxWidth - abbrevMarkerLength);
        }
        if (offset <= abbrevMarkerLength + 1) {
            return str.substring(0, maxWidth - abbrevMarkerLength) + abbrevMarker;
        }
        if (maxWidth < minAbbrevWidthOffset) {
            throw new IllegalArgumentException(String.format("Minimum abbreviation width with offset is %d", minAbbrevWidthOffset));
        }
        if (offset + maxWidth - abbrevMarkerLength < strLen) {
            void var2_2;
            return abbrevMarker + StringUtils.abbreviate(str.substring((int)var2_2), abbrevMarker, maxWidth - abbrevMarkerLength);
        }
        return (String)var1_1 + string.substring(strLen - (var3_3 - abbrevMarkerLength));
    }

    /*
     * WARNING - void declaration
     */
    public static String abbreviateMiddle(String str, String middle, int length) {
        void var2_2;
        String string;
        void var1_1;
        void var3_3;
        if (StringUtils.isAnyEmpty(str, middle) || length >= str.length() || length < middle.length() + 2) {
            return str;
        }
        int targetSting = length - middle.length();
        int startOffset = targetSting / 2 + targetSting % 2;
        int endOffset = str.length() - targetSting / 2;
        return str.substring(0, (int)var3_3) + (String)var1_1 + string.substring((int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static String appendIfMissing(String str, CharSequence suffix, boolean ignoreCase, CharSequence ... suffixes) {
        void var1_1;
        String string;
        if (str == null || StringUtils.isEmpty(suffix) || StringUtils.endsWith(str, suffix, ignoreCase)) {
            return str;
        }
        if (ArrayUtils.isNotEmpty(suffixes)) {
            void var3_3;
            for (void s : var3_3) {
                if (!StringUtils.endsWith(str, (CharSequence)s, ignoreCase)) continue;
                return str;
            }
        }
        return string + var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String appendIfMissing(String str, CharSequence suffix, CharSequence ... suffixes) {
        void var2_2;
        void var1_1;
        return StringUtils.appendIfMissing(str, (CharSequence)var1_1, false, (CharSequence[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String appendIfMissingIgnoreCase(String str, CharSequence suffix, CharSequence ... suffixes) {
        void var2_2;
        void var1_1;
        return StringUtils.appendIfMissing(str, (CharSequence)var1_1, true, (CharSequence[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String capitalize(String str) {
        void var3_3;
        int newCodePoint;
        int strLen = StringUtils.length(str);
        if (strLen == 0) {
            return str;
        }
        int firstCodepoint = str.codePointAt(0);
        if (firstCodepoint == (newCodePoint = Character.toTitleCase(firstCodepoint))) {
            return str;
        }
        int[] newCodePoints = new int[strLen];
        int outOffset = 0;
        ++outOffset;
        newCodePoints[0] = newCodePoint;
        for (int inOffset = Character.charCount(firstCodepoint); inOffset < strLen; inOffset += Character.charCount((int)var3_3)) {
            int codepoint = str.codePointAt(inOffset);
            newCodePoints[outOffset++] = codepoint;
        }
        return new String(newCodePoints, 0, outOffset);
    }

    /*
     * WARNING - void declaration
     */
    public static String center(String str, int size) {
        void var1_1;
        return StringUtils.center(str, (int)var1_1, ' ');
    }

    /*
     * WARNING - void declaration
     */
    public static String center(String str, int size, char padChar) {
        void var2_2;
        void var1_1;
        void var3_3;
        String string;
        if (str == null || size <= 0) {
            return str;
        }
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        string = StringUtils.leftPad(string, (int)(var3_3 + pads / 2), padChar);
        string = StringUtils.rightPad(string, (int)var1_1, (char)var2_2);
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static String center(String str, int size, String padStr) {
        void var2_2;
        void var1_1;
        void var3_3;
        String string;
        int strLen;
        int pads;
        if (str == null || size <= 0) {
            return str;
        }
        if (StringUtils.isEmpty(padStr)) {
            padStr = SPACE;
        }
        if ((pads = size - (strLen = str.length())) <= 0) {
            return str;
        }
        string = StringUtils.leftPad(string, (int)(var3_3 + pads / 2), padStr);
        string = StringUtils.rightPad(string, (int)var1_1, (String)var2_2);
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static String chomp(String str) {
        void var1_2;
        String string;
        void var2_3;
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        if (str.length() == 1) {
            char ch = str.charAt(0);
            if (ch == '\r' || ch == '\n') {
                return EMPTY;
            }
            return str;
        }
        int lastIdx = str.length() - 1;
        char last = str.charAt(lastIdx);
        if (last == '\n') {
            if (str.charAt(lastIdx - 1) == '\r') {
                --lastIdx;
            }
        } else if (var2_3 != 13) {
            ++lastIdx;
        }
        return string.substring(0, (int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static String chomp(String str, String separator) {
        void var1_1;
        return StringUtils.removeEnd(str, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String chop(String str) {
        void var2_3;
        String string;
        if (str == null) {
            return null;
        }
        int strLen = str.length();
        if (strLen < 2) {
            return EMPTY;
        }
        int lastIdx = strLen - 1;
        String ret = str.substring(0, lastIdx);
        char c = string.charAt(lastIdx);
        if (c == '\n' && ret.charAt(lastIdx - 1) == '\r') {
            void var1_2;
            return ret.substring(0, (int)(var1_2 - true));
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public static int compare(String str1, String str2) {
        void var1_1;
        return StringUtils.compare(str1, (String)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public static int compare(String str1, String str2, boolean nullIsLess) {
        void var1_1;
        String string;
        if (str1 == str2) {
            return 0;
        }
        if (str1 == null) {
            if (nullIsLess) {
                return -1;
            }
            return 1;
        }
        if (str2 == null) {
            void var2_2;
            if (var2_2 != false) {
                return 1;
            }
            return -1;
        }
        return string.compareTo((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int compareIgnoreCase(String str1, String str2) {
        void var1_1;
        return StringUtils.compareIgnoreCase(str1, (String)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public static int compareIgnoreCase(String str1, String str2, boolean nullIsLess) {
        void var1_1;
        String string;
        if (str1 == str2) {
            return 0;
        }
        if (str1 == null) {
            if (nullIsLess) {
                return -1;
            }
            return 1;
        }
        if (str2 == null) {
            void var2_2;
            if (var2_2 != false) {
                return 1;
            }
            return -1;
        }
        return string.compareToIgnoreCase((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean contains(CharSequence seq, CharSequence searchSeq) {
        void var1_1;
        CharSequence charSequence;
        if (seq == null || searchSeq == null) {
            return false;
        }
        return CharSequenceUtils.indexOf(charSequence, (CharSequence)var1_1, 0) >= 0;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean contains(CharSequence seq, int searchChar) {
        void var1_1;
        CharSequence charSequence;
        if (StringUtils.isEmpty(seq)) {
            return false;
        }
        return CharSequenceUtils.indexOf(charSequence, (int)var1_1, 0) >= 0;
    }

    public static boolean containsAny(CharSequence cs, char ... searchChars) {
        if (StringUtils.isEmpty(cs) || ArrayUtils.isEmpty(searchChars)) {
            return false;
        }
        int csLength = cs.length();
        int searchLength = searchChars.length;
        int csLast = csLength - 1;
        int searchLast = searchLength - 1;
        for (int i = 0; i < csLength; ++i) {
            char ch = cs.charAt(i);
            for (int j = 0; j < searchLength; ++j) {
                if (searchChars[j] != ch) continue;
                if (Character.isHighSurrogate(ch)) {
                    if (j == searchLast) {
                        return true;
                    }
                    if (i >= csLast || searchChars[j + 1] != cs.charAt(i + 1)) continue;
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean containsAny(CharSequence cs, CharSequence searchChars) {
        void var1_1;
        CharSequence charSequence;
        if (searchChars == null) {
            return false;
        }
        return StringUtils.containsAny(charSequence, CharSequenceUtils.toCharArray((CharSequence)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static boolean containsAny(CharSequence cs, CharSequence ... searchCharSequences) {
        void var1_1;
        CharSequence charSequence;
        return StringUtils.containsAny(StringUtils::contains, charSequence, (CharSequence[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean containsAny(ToBooleanBiFunction<CharSequence, CharSequence> test, CharSequence cs, CharSequence ... searchCharSequences) {
        void var2_2;
        if (StringUtils.isEmpty(cs) || ArrayUtils.isEmpty(searchCharSequences)) {
            return false;
        }
        for (void searchCharSequence : var2_2) {
            if (!test.applyAsBoolean(cs, (CharSequence)searchCharSequence)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean containsAnyIgnoreCase(CharSequence cs, CharSequence ... searchCharSequences) {
        void var1_1;
        CharSequence charSequence;
        return StringUtils.containsAny(StringUtils::containsIgnoreCase, charSequence, (CharSequence[])var1_1);
    }

    public static boolean containsIgnoreCase(CharSequence str, CharSequence searchStr) {
        if (str == null || searchStr == null) {
            return false;
        }
        int len = searchStr.length();
        int max = str.length() - len;
        for (int i = 0; i <= max; ++i) {
            if (!CharSequenceUtils.regionMatches(str, true, i, searchStr, 0, len)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsNone(CharSequence cs, char ... searchChars) {
        if (cs == null || searchChars == null) {
            return true;
        }
        int csLen = cs.length();
        int csLast = csLen - 1;
        int searchLen = searchChars.length;
        int searchLast = searchLen - 1;
        for (int i = 0; i < csLen; ++i) {
            char ch = cs.charAt(i);
            for (int j = 0; j < searchLen; ++j) {
                if (searchChars[j] != ch) continue;
                if (Character.isHighSurrogate(ch)) {
                    if (j == searchLast) {
                        return false;
                    }
                    if (i >= csLast || searchChars[j + 1] != cs.charAt(i + 1)) continue;
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean containsNone(CharSequence cs, String invalidChars) {
        void var1_1;
        CharSequence charSequence;
        if (invalidChars == null) {
            return true;
        }
        return StringUtils.containsNone(charSequence, var1_1.toCharArray());
    }

    /*
     * WARNING - void declaration
     */
    public static boolean containsOnly(CharSequence cs, char ... valid) {
        void var1_1;
        CharSequence charSequence;
        if (valid == null || cs == null) {
            return false;
        }
        if (cs.length() == 0) {
            return true;
        }
        if (valid.length == 0) {
            return false;
        }
        return StringUtils.indexOfAnyBut(charSequence, (char[])var1_1) == -1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean containsOnly(CharSequence cs, String validChars) {
        void var1_1;
        CharSequence charSequence;
        if (cs == null || validChars == null) {
            return false;
        }
        return StringUtils.containsOnly(charSequence, var1_1.toCharArray());
    }

    public static boolean containsWhitespace(CharSequence seq) {
        if (StringUtils.isEmpty(seq)) {
            return false;
        }
        int strLen = seq.length();
        for (int i = 0; i < strLen; ++i) {
            if (!Character.isWhitespace(seq.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static void convertRemainingAccentCharacters(StringBuilder decomposed) {
        for (int i = 0; i < decomposed.length(); ++i) {
            if (decomposed.charAt(i) == '\u0141') {
                decomposed.setCharAt(i, 'L');
                continue;
            }
            if (decomposed.charAt(i) != '\u0142') continue;
            decomposed.setCharAt(i, 'l');
        }
    }

    /*
     * WARNING - void declaration
     */
    public static int countMatches(CharSequence str, char ch) {
        void var2_2;
        if (StringUtils.isEmpty(str)) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (ch != str.charAt(i)) continue;
            ++count;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static int countMatches(CharSequence str, CharSequence sub) {
        void var2_2;
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(sub)) {
            return 0;
        }
        int count = 0;
        int idx = 0;
        while ((idx = CharSequenceUtils.indexOf(str, sub, idx)) != -1) {
            ++count;
            idx += sub.length();
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CharSequence> T defaultIfBlank(T str, T defaultStr) {
        T t;
        if (StringUtils.isBlank(str)) {
            void var1_1;
            return var1_1;
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CharSequence> T defaultIfEmpty(T str, T defaultStr) {
        T t;
        if (StringUtils.isEmpty(str)) {
            void var1_1;
            return var1_1;
        }
        return t;
    }

    public static String defaultString(String str) {
        return StringUtils.defaultString(str, EMPTY);
    }

    /*
     * WARNING - void declaration
     */
    public static String defaultString(String str, String defaultStr) {
        String string;
        if (str == null) {
            void var1_1;
            return var1_1;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static String deleteWhitespace(String str) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        int sz = str.length();
        char[] chs = new char[sz];
        int count = 0;
        for (int i = 0; i < sz; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            chs[count++] = str.charAt(i);
        }
        if (count == var1_1) {
            String string;
            return string;
        }
        if (count == 0) {
            return EMPTY;
        }
        return new String((char[])var2_2, 0, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static String difference(String str1, String str2) {
        void var0_1;
        void var1_2;
        if (str1 == null) {
            return str2;
        }
        if (str2 == null) {
            return str1;
        }
        int at = StringUtils.indexOfDifference((CharSequence)str1, (CharSequence)str2);
        if (at == -1) {
            return EMPTY;
        }
        return var1_2.substring((int)var0_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean endsWith(CharSequence str, CharSequence suffix) {
        void var1_1;
        return StringUtils.endsWith(str, (CharSequence)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean endsWith(CharSequence str, CharSequence suffix, boolean ignoreCase) {
        void var1_1;
        void var3_3;
        void var2_2;
        CharSequence charSequence;
        if (str == null || suffix == null) {
            return str == suffix;
        }
        if (suffix.length() > str.length()) {
            return false;
        }
        int strOffset = str.length() - suffix.length();
        return CharSequenceUtils.regionMatches(charSequence, (boolean)var2_2, (int)var3_3, suffix, 0, var1_1.length());
    }

    /*
     * WARNING - void declaration
     */
    public static boolean endsWithAny(CharSequence sequence, CharSequence ... searchStrings) {
        void var1_1;
        if (StringUtils.isEmpty(sequence) || ArrayUtils.isEmpty(searchStrings)) {
            return false;
        }
        for (void searchString : var1_1) {
            if (!StringUtils.endsWith(sequence, (CharSequence)searchString)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean endsWithIgnoreCase(CharSequence str, CharSequence suffix) {
        void var1_1;
        return StringUtils.endsWith(str, (CharSequence)var1_1, true);
    }

    public static boolean equals(CharSequence cs1, CharSequence cs2) {
        if (cs1 == cs2) {
            return true;
        }
        if (cs1 == null || cs2 == null) {
            return false;
        }
        if (cs1.length() != cs2.length()) {
            return false;
        }
        if (cs1 instanceof String && cs2 instanceof String) {
            return cs1.equals(cs2);
        }
        int length = cs1.length();
        for (int i = 0; i < length; ++i) {
            if (cs1.charAt(i) == cs2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean equalsAny(CharSequence string, CharSequence ... searchStrings) {
        if (ArrayUtils.isNotEmpty(searchStrings)) {
            void var1_1;
            for (void next : var1_1) {
                if (!StringUtils.equals(string, (CharSequence)next)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean equalsAnyIgnoreCase(CharSequence string, CharSequence ... searchStrings) {
        if (ArrayUtils.isNotEmpty(searchStrings)) {
            void var1_1;
            for (void next : var1_1) {
                if (!StringUtils.equalsIgnoreCase(string, (CharSequence)next)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean equalsIgnoreCase(CharSequence cs1, CharSequence cs2) {
        CharSequence charSequence;
        void var1_1;
        if (cs1 == cs2) {
            return true;
        }
        if (cs1 == null || cs2 == null) {
            return false;
        }
        if (cs1.length() != cs2.length()) {
            return false;
        }
        return CharSequenceUtils.regionMatches(cs1, true, 0, (CharSequence)var1_1, 0, charSequence.length());
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public static <T extends CharSequence> T firstNonBlank(T ... values) {
        if (values != null) {
            T[] TArray;
            for (T val : TArray) {
                void var3_3;
                if (!StringUtils.isNotBlank(val)) continue;
                return var3_3;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public static <T extends CharSequence> T firstNonEmpty(T ... values) {
        if (values != null) {
            T[] TArray;
            for (T val : TArray) {
                void var3_3;
                if (!StringUtils.isNotEmpty(val)) continue;
                return var3_3;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] getBytes(String string, Charset charset) {
        void var1_1;
        String string2;
        if (string == null) {
            return ArrayUtils.EMPTY_BYTE_ARRAY;
        }
        return string2.getBytes(Charsets.toCharset((Charset)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] getBytes(String string, String charset) throws UnsupportedEncodingException {
        void var1_1;
        String string2;
        if (string == null) {
            return ArrayUtils.EMPTY_BYTE_ARRAY;
        }
        return string2.getBytes(Charsets.toCharsetName((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static String getCommonPrefix(String ... strs) {
        void var1_1;
        String[] stringArray;
        if (ArrayUtils.isEmpty(strs)) {
            return EMPTY;
        }
        int smallestIndexOfDiff = StringUtils.indexOfDifference(strs);
        if (smallestIndexOfDiff == -1) {
            if (strs[0] == null) {
                return EMPTY;
            }
            return strs[0];
        }
        if (smallestIndexOfDiff == 0) {
            return EMPTY;
        }
        return stringArray[0].substring(0, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String getDigits(String str) {
        void var2_2;
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        int sz = str.length();
        StringBuilder strDigits = new StringBuilder(sz);
        for (int i = 0; i < sz; ++i) {
            char tempChar = str.charAt(i);
            if (!Character.isDigit(tempChar)) continue;
            strDigits.append(tempChar);
        }
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static int getFuzzyDistance(CharSequence term, CharSequence query, Locale locale) {
        void var2_3;
        if (term == null || query == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        if (locale == null) {
            throw new IllegalArgumentException("Locale must not be null");
        }
        CharSequence termLowerCase = term.toString().toLowerCase(locale);
        String queryLowerCase = query.toString().toLowerCase(locale);
        int score = 0;
        int termIndex = 0;
        int previousMatchingCharacterIndex = Integer.MIN_VALUE;
        for (int queryIndex = 0; queryIndex < queryLowerCase.length(); ++queryIndex) {
            char queryChar = queryLowerCase.charAt(queryIndex);
            boolean termCharacterMatchFound = false;
            while (termIndex < ((String)termLowerCase).length() && !termCharacterMatchFound) {
                char termChar = ((String)termLowerCase).charAt(termIndex);
                if (queryChar == termChar) {
                    ++score;
                    if (previousMatchingCharacterIndex + 1 == termIndex) {
                        score += 2;
                    }
                    previousMatchingCharacterIndex = termIndex;
                    termCharacterMatchFound = true;
                }
                ++termIndex;
            }
        }
        return (int)var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CharSequence> T getIfBlank(T str, Supplier<T> defaultSupplier) {
        T t;
        if (StringUtils.isBlank(str)) {
            void var1_1;
            if (defaultSupplier == null) {
                return null;
            }
            return (T)((CharSequence)var1_1.get());
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CharSequence> T getIfEmpty(T str, Supplier<T> defaultSupplier) {
        T t;
        if (StringUtils.isEmpty(str)) {
            void var1_1;
            if (defaultSupplier == null) {
                return null;
            }
            return (T)((CharSequence)var1_1.get());
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static double getJaroWinklerDistance(CharSequence first, CharSequence second) {
        void var2_2;
        double d;
        void var3_3;
        void var1_1;
        CharSequence charSequence;
        if (first == null || second == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int[] mtp = StringUtils.matches(first, second);
        double m = mtp[0];
        if (m == 0.0) {
            return 0.0;
        }
        double j = (m / (double)charSequence.length() + m / (double)var1_1.length() + (m - (double)mtp[1]) / var3_3) / 3.0;
        double d2 = d < 0.7 ? j : j + Math.min(0.1, 1.0 / (double)mtp[3]) * (double)var2_2[2] * (1.0 - j);
        return (double)Math.round(d2 * 100.0) / 100.0;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static int getLevenshteinDistance(CharSequence s, CharSequence t) {
        void var2_2;
        if (s == null || t == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        if (n > m) {
            CharSequence tmp = s;
            s = t;
            t = tmp;
            n = m;
            m = t.length();
        }
        int[] p = new int[n + 1];
        int i = 0;
        while (i <= n) {
            int n2 = i++;
            p[n2] = n2;
        }
        for (int j = 1; j <= m; ++j) {
            int upper_left = p[0];
            char t_j = t.charAt(j - 1);
            p[0] = j;
            for (i = 1; i <= n; ++i) {
                int upper = p[i];
                int cost = s.charAt(i - 1) == t_j ? 0 : 1;
                p[i] = Math.min(Math.min(p[i - 1] + 1, p[i] + 1), upper_left + cost);
                upper_left = upper;
            }
        }
        return p[var2_2];
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static int getLevenshteinDistance(CharSequence s, CharSequence t, int threshold) {
        void var2_2;
        if (s == null || t == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        if (threshold < 0) {
            throw new IllegalArgumentException("Threshold must not be negative");
        }
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            if (m <= threshold) {
                return m;
            }
            return -1;
        }
        if (m == 0) {
            if (n <= threshold) {
                return n;
            }
            return -1;
        }
        if (Math.abs(n - m) > threshold) {
            return -1;
        }
        if (n > m) {
            CharSequence tmp = s;
            s = t;
            t = tmp;
            n = m;
            m = t.length();
        }
        int[] p = new int[n + 1];
        int[] d = new int[n + 1];
        int boundary = Math.min(n, threshold) + 1;
        int i = 0;
        while (i < boundary) {
            int n2 = i++;
            p[n2] = n2;
        }
        Arrays.fill(p, boundary, p.length, Integer.MAX_VALUE);
        Arrays.fill(d, Integer.MAX_VALUE);
        for (int j = 1; j <= m; ++j) {
            int max;
            char t_j = t.charAt(j - 1);
            d[0] = j;
            int min = Math.max(1, j - threshold);
            int n3 = max = j > Integer.MAX_VALUE - threshold ? n : Math.min(n, j + threshold);
            if (min > max) {
                return -1;
            }
            if (min > 1) {
                d[min - 1] = Integer.MAX_VALUE;
            }
            for (int i2 = min; i2 <= max; ++i2) {
                d[i2] = s.charAt(i2 - 1) == t_j ? p[i2 - 1] : 1 + Math.min(Math.min(d[i2 - 1], p[i2]), p[i2 - 1]);
            }
            int[] _d = p;
            p = d;
            d = _d;
        }
        if (p[n] <= var2_2) {
            void var3_3;
            return p[var3_3];
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(CharSequence seq, CharSequence searchSeq) {
        void var1_1;
        CharSequence charSequence;
        if (seq == null || searchSeq == null) {
            return -1;
        }
        return CharSequenceUtils.indexOf(charSequence, (CharSequence)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(CharSequence seq, CharSequence searchSeq, int startPos) {
        void var2_2;
        void var1_1;
        CharSequence charSequence;
        if (seq == null || searchSeq == null) {
            return -1;
        }
        return CharSequenceUtils.indexOf(charSequence, (CharSequence)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(CharSequence seq, int searchChar) {
        void var1_1;
        CharSequence charSequence;
        if (StringUtils.isEmpty(seq)) {
            return -1;
        }
        return CharSequenceUtils.indexOf(charSequence, (int)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(CharSequence seq, int searchChar, int startPos) {
        void var2_2;
        void var1_1;
        CharSequence charSequence;
        if (StringUtils.isEmpty(seq)) {
            return -1;
        }
        return CharSequenceUtils.indexOf(charSequence, (int)var1_1, (int)var2_2);
    }

    public static int indexOfAny(CharSequence cs, char ... searchChars) {
        if (StringUtils.isEmpty(cs) || ArrayUtils.isEmpty(searchChars)) {
            return -1;
        }
        int csLen = cs.length();
        int csLast = csLen - 1;
        int searchLen = searchChars.length;
        int searchLast = searchLen - 1;
        for (int i = 0; i < csLen; ++i) {
            char ch = cs.charAt(i);
            for (int j = 0; j < searchLen; ++j) {
                if (searchChars[j] != ch) continue;
                if (i < csLast && j < searchLast && Character.isHighSurrogate(ch)) {
                    if (searchChars[j + 1] != cs.charAt(i + 1)) continue;
                    return i;
                }
                return i;
            }
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOfAny(CharSequence str, CharSequence ... searchStrs) {
        void var2_3;
        if (str == null || searchStrs == null) {
            return -1;
        }
        int ret = Integer.MAX_VALUE;
        CharSequence[] charSequenceArray = searchStrs;
        int n = searchStrs.length;
        for (int i = 0; i < n; ++i) {
            void var1_2;
            int tmp;
            CharSequence search = charSequenceArray[i];
            if (search == null || (tmp = CharSequenceUtils.indexOf(str, search, 0)) == -1 || tmp >= ret) continue;
            ret = var1_2;
        }
        if (ret == Integer.MAX_VALUE) {
            return -1;
        }
        return (int)var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOfAny(CharSequence cs, String searchChars) {
        void var1_1;
        CharSequence charSequence;
        if (StringUtils.isEmpty(cs) || StringUtils.isEmpty(searchChars)) {
            return -1;
        }
        return StringUtils.indexOfAny(charSequence, var1_1.toCharArray());
    }

    public static int indexOfAnyBut(CharSequence cs, char ... searchChars) {
        if (StringUtils.isEmpty(cs) || ArrayUtils.isEmpty(searchChars)) {
            return -1;
        }
        int csLen = cs.length();
        int csLast = csLen - 1;
        int searchLen = searchChars.length;
        int searchLast = searchLen - 1;
        block0: for (int i = 0; i < csLen; ++i) {
            char ch = cs.charAt(i);
            for (int j = 0; j < searchLen; ++j) {
                if (searchChars[j] == ch && (i >= csLast || j >= searchLast || !Character.isHighSurrogate(ch) || searchChars[j + 1] == cs.charAt(i + 1))) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static int indexOfAnyBut(CharSequence seq, CharSequence searchChars) {
        if (StringUtils.isEmpty(seq) || StringUtils.isEmpty(searchChars)) {
            return -1;
        }
        int strLen = seq.length();
        for (int i = 0; i < strLen; ++i) {
            boolean chFound;
            char ch = seq.charAt(i);
            boolean bl = chFound = CharSequenceUtils.indexOf(searchChars, ch, 0) >= 0;
            if (i + 1 < strLen && Character.isHighSurrogate(ch)) {
                char ch2 = seq.charAt(i + 1);
                if (!chFound || CharSequenceUtils.indexOf(searchChars, ch2, 0) >= 0) continue;
                return i;
            }
            if (chFound) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOfDifference(CharSequence ... css) {
        void var1_1;
        void var2_2;
        if (ArrayUtils.getLength(css) <= 1) {
            return -1;
        }
        boolean anyStringNull = false;
        boolean allStringsNull = true;
        int arrayLen = css.length;
        int shortestStrLen = Integer.MAX_VALUE;
        int longestStrLen = 0;
        CharSequence[] charSequenceArray = css;
        int n = css.length;
        for (int i = 0; i < n; ++i) {
            CharSequence cs = charSequenceArray[i];
            if (cs == null) {
                anyStringNull = true;
                shortestStrLen = 0;
                continue;
            }
            allStringsNull = false;
            shortestStrLen = Math.min(cs.length(), shortestStrLen);
            longestStrLen = Math.max(cs.length(), longestStrLen);
        }
        if (var2_2 != false || longestStrLen == 0 && var1_1 == false) {
            return -1;
        }
        if (shortestStrLen == 0) {
            return 0;
        }
        int firstDiff = -1;
        for (int stringPos = 0; stringPos < shortestStrLen; ++stringPos) {
            char comparisonChar = css[0].charAt(stringPos);
            for (int arrayPos = 1; arrayPos < arrayLen; ++arrayPos) {
                if (css[arrayPos].charAt(stringPos) == comparisonChar) continue;
                firstDiff = stringPos;
                break;
            }
            if (firstDiff != -1) break;
        }
        if (firstDiff == -1 && shortestStrLen != longestStrLen) {
            return shortestStrLen;
        }
        return firstDiff;
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOfDifference(CharSequence cs1, CharSequence cs2) {
        CharSequence charSequence;
        void var1_1;
        int i;
        if (cs1 == cs2) {
            return -1;
        }
        if (cs1 == null || cs2 == null) {
            return 0;
        }
        for (i = 0; i < cs1.length() && i < cs2.length() && cs1.charAt(i) == cs2.charAt(i); ++i) {
        }
        if (i < var1_1.length() || i < charSequence.length()) {
            void var2_2;
            return (int)var2_2;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOfIgnoreCase(CharSequence str, CharSequence searchStr) {
        void var1_1;
        return StringUtils.indexOfIgnoreCase(str, (CharSequence)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOfIgnoreCase(CharSequence str, CharSequence searchStr, int startPos) {
        void i;
        int endLimit;
        if (str == null || searchStr == null) {
            return -1;
        }
        if (startPos < 0) {
            startPos = 0;
        }
        if (startPos > (endLimit = str.length() - searchStr.length() + 1)) {
            return -1;
        }
        if (searchStr.length() == 0) {
            return startPos;
        }
        while (i < endLimit) {
            if (CharSequenceUtils.regionMatches(str, true, (int)i, searchStr, 0, searchStr.length())) {
                return (int)i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean isAllBlank(CharSequence ... css) {
        CharSequence[] charSequenceArray;
        if (ArrayUtils.isEmpty(css)) {
            return true;
        }
        for (CharSequence charSequence : charSequenceArray) {
            if (!StringUtils.isNotBlank(charSequence)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllEmpty(CharSequence ... css) {
        CharSequence[] charSequenceArray;
        if (ArrayUtils.isEmpty(css)) {
            return true;
        }
        for (CharSequence charSequence : charSequenceArray) {
            if (!StringUtils.isNotEmpty(charSequence)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllLowerCase(CharSequence cs) {
        if (StringUtils.isEmpty(cs)) {
            return false;
        }
        int sz = cs.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isLowerCase(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllUpperCase(CharSequence cs) {
        if (StringUtils.isEmpty(cs)) {
            return false;
        }
        int sz = cs.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isUpperCase(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlpha(CharSequence cs) {
        if (StringUtils.isEmpty(cs)) {
            return false;
        }
        int sz = cs.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isLetter(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphanumeric(CharSequence cs) {
        if (StringUtils.isEmpty(cs)) {
            return false;
        }
        int sz = cs.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isLetterOrDigit(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isAlphanumericSpace(CharSequence cs) {
        if (cs == null) {
            return false;
        }
        int sz = cs.length();
        for (int i = 0; i < sz; ++i) {
            void var3_3;
            char nowChar = cs.charAt(i);
            if (nowChar == ' ' || Character.isLetterOrDigit((char)var3_3)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isAlphaSpace(CharSequence cs) {
        if (cs == null) {
            return false;
        }
        int sz = cs.length();
        for (int i = 0; i < sz; ++i) {
            void var3_3;
            char nowChar = cs.charAt(i);
            if (nowChar == ' ' || Character.isLetter((char)var3_3)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAnyBlank(CharSequence ... css) {
        CharSequence[] charSequenceArray;
        if (ArrayUtils.isEmpty(css)) {
            return false;
        }
        for (CharSequence charSequence : charSequenceArray) {
            if (!StringUtils.isBlank(charSequence)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnyEmpty(CharSequence ... css) {
        CharSequence[] charSequenceArray;
        if (ArrayUtils.isEmpty(css)) {
            return false;
        }
        for (CharSequence charSequence : charSequenceArray) {
            if (!StringUtils.isEmpty(charSequence)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAsciiPrintable(CharSequence cs) {
        if (cs == null) {
            return false;
        }
        int sz = cs.length();
        for (int i = 0; i < sz; ++i) {
            if (CharUtils.isAsciiPrintable(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen = StringUtils.length(cs);
        if (strLen == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(CharSequence cs) {
        CharSequence charSequence;
        return cs == null || charSequence.length() == 0;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isMixedCase(CharSequence cs) {
        void var2_2;
        void var1_1;
        if (StringUtils.isEmpty(cs) || cs.length() == 1) {
            return false;
        }
        boolean containsUppercase = false;
        boolean containsLowercase = false;
        int sz = cs.length();
        for (int i = 0; i < sz; ++i) {
            if (containsUppercase && containsLowercase) {
                return true;
            }
            if (Character.isUpperCase(cs.charAt(i))) {
                containsUppercase = true;
                continue;
            }
            if (!Character.isLowerCase(cs.charAt(i))) continue;
            containsLowercase = true;
        }
        return var1_1 != false && var2_2 != false;
    }

    public static boolean isNoneBlank(CharSequence ... css) {
        return !StringUtils.isAnyBlank(css);
    }

    public static boolean isNoneEmpty(CharSequence ... css) {
        return !StringUtils.isAnyEmpty(css);
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !StringUtils.isBlank(cs);
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !StringUtils.isEmpty(cs);
    }

    public static boolean isNumeric(CharSequence cs) {
        if (StringUtils.isEmpty(cs)) {
            return false;
        }
        int sz = cs.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isNumericSpace(CharSequence cs) {
        if (cs == null) {
            return false;
        }
        int sz = cs.length();
        for (int i = 0; i < sz; ++i) {
            void var3_3;
            char nowChar = cs.charAt(i);
            if (nowChar == ' ' || Character.isDigit((char)var3_3)) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhitespace(CharSequence cs) {
        if (cs == null) {
            return false;
        }
        int sz = cs.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static String join(boolean[] array, char delimiter) {
        boolean[] blArray;
        void var1_1;
        if (array == null) {
            return null;
        }
        return StringUtils.join(array, (char)var1_1, 0, blArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static String join(boolean[] array, char delimiter, int startIndex, int endIndex) {
        void var1_2;
        void i;
        if (array == null) {
            return null;
        }
        if (endIndex - startIndex <= 0) {
            return EMPTY;
        }
        StringJoiner joiner = StringUtils.newStringJoiner(delimiter);
        while (i < endIndex) {
            joiner.add(String.valueOf(array[i]));
            ++i;
        }
        return var1_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String join(byte[] array, char delimiter) {
        byte[] byArray;
        void var1_1;
        if (array == null) {
            return null;
        }
        return StringUtils.join(array, (char)var1_1, 0, byArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static String join(byte[] array, char delimiter, int startIndex, int endIndex) {
        void var1_2;
        void i;
        if (array == null) {
            return null;
        }
        if (endIndex - startIndex <= 0) {
            return EMPTY;
        }
        StringJoiner joiner = StringUtils.newStringJoiner(delimiter);
        while (i < endIndex) {
            joiner.add(String.valueOf(array[i]));
            ++i;
        }
        return var1_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String join(char[] array, char delimiter) {
        char[] cArray;
        void var1_1;
        if (array == null) {
            return null;
        }
        return StringUtils.join(array, (char)var1_1, 0, cArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static String join(char[] array, char delimiter, int startIndex, int endIndex) {
        void var1_2;
        void i;
        if (array == null) {
            return null;
        }
        if (endIndex - startIndex <= 0) {
            return EMPTY;
        }
        StringJoiner joiner = StringUtils.newStringJoiner(delimiter);
        while (i < endIndex) {
            joiner.add(String.valueOf(array[i]));
            ++i;
        }
        return var1_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String join(double[] array, char delimiter) {
        double[] dArray;
        void var1_1;
        if (array == null) {
            return null;
        }
        return StringUtils.join(array, (char)var1_1, 0, dArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static String join(double[] array, char delimiter, int startIndex, int endIndex) {
        void var1_2;
        void i;
        if (array == null) {
            return null;
        }
        if (endIndex - startIndex <= 0) {
            return EMPTY;
        }
        StringJoiner joiner = StringUtils.newStringJoiner(delimiter);
        while (i < endIndex) {
            joiner.add(String.valueOf(array[i]));
            ++i;
        }
        return var1_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String join(float[] array, char delimiter) {
        float[] fArray;
        void var1_1;
        if (array == null) {
            return null;
        }
        return StringUtils.join(array, (char)var1_1, 0, fArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static String join(float[] array, char delimiter, int startIndex, int endIndex) {
        void var1_2;
        void i;
        if (array == null) {
            return null;
        }
        if (endIndex - startIndex <= 0) {
            return EMPTY;
        }
        StringJoiner joiner = StringUtils.newStringJoiner(delimiter);
        while (i < endIndex) {
            joiner.add(String.valueOf(array[i]));
            ++i;
        }
        return var1_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String join(int[] array, char separator) {
        int[] nArray;
        void var1_1;
        if (array == null) {
            return null;
        }
        return StringUtils.join(array, (char)var1_1, 0, nArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static String join(int[] array, char delimiter, int startIndex, int endIndex) {
        void var1_2;
        void i;
        if (array == null) {
            return null;
        }
        if (endIndex - startIndex <= 0) {
            return EMPTY;
        }
        StringJoiner joiner = StringUtils.newStringJoiner(delimiter);
        while (i < endIndex) {
            joiner.add(String.valueOf(array[i]));
            ++i;
        }
        return var1_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String join(Iterable<?> iterable, char separator) {
        void var1_1;
        Iterable<?> iterable2;
        if (iterable == null) {
            return null;
        }
        return StringUtils.join(iterable2.iterator(), (char)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String join(Iterable<?> iterable, String separator) {
        void var1_1;
        Iterable<?> iterable2;
        if (iterable == null) {
            return null;
        }
        return StringUtils.join(iterable2.iterator(), (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String join(Iterator<?> iterator, char separator) {
        void var3_3;
        if (iterator == null) {
            return null;
        }
        if (!iterator.hasNext()) {
            return EMPTY;
        }
        Object first = iterator.next();
        if (!iterator.hasNext()) {
            return StringUtils.toStringOrEmpty(first);
        }
        StringBuilder buf = new StringBuilder(256);
        if (first != null) {
            buf.append(first);
        }
        while (iterator.hasNext()) {
            void var2_2;
            buf.append(separator);
            Object obj = iterator.next();
            if (obj == null) continue;
            buf.append(var2_2);
        }
        return var3_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String join(Iterator<?> iterator, String separator) {
        void var3_3;
        if (iterator == null) {
            return null;
        }
        if (!iterator.hasNext()) {
            return EMPTY;
        }
        Object first = iterator.next();
        if (!iterator.hasNext()) {
            return Objects.toString(first, EMPTY);
        }
        StringBuilder buf = new StringBuilder(256);
        if (first != null) {
            buf.append(first);
        }
        while (iterator.hasNext()) {
            void var2_2;
            Object obj;
            if (separator != null) {
                buf.append(separator);
            }
            if ((obj = iterator.next()) == null) continue;
            buf.append(var2_2);
        }
        return var3_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String join(List<?> list, char separator, int startIndex, int endIndex) {
        void var1_1;
        void var3_3;
        void var2_2;
        List<?> list2;
        if (list == null) {
            return null;
        }
        int n = endIndex - startIndex;
        if (n <= 0) {
            return EMPTY;
        }
        list2 = list2.subList((int)var2_2, (int)var3_3);
        return StringUtils.join(list2.iterator(), (char)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String join(List<?> list, String separator, int startIndex, int endIndex) {
        void var1_1;
        void var3_3;
        void var2_2;
        List<?> list2;
        if (list == null) {
            return null;
        }
        int n = endIndex - startIndex;
        if (n <= 0) {
            return EMPTY;
        }
        list2 = list2.subList((int)var2_2, (int)var3_3);
        return StringUtils.join(list2.iterator(), (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String join(long[] array, char separator) {
        long[] lArray;
        void var1_1;
        if (array == null) {
            return null;
        }
        return StringUtils.join(array, (char)var1_1, 0, lArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static String join(long[] array, char delimiter, int startIndex, int endIndex) {
        void var1_2;
        void i;
        if (array == null) {
            return null;
        }
        if (endIndex - startIndex <= 0) {
            return EMPTY;
        }
        StringJoiner joiner = StringUtils.newStringJoiner(delimiter);
        while (i < endIndex) {
            joiner.add(String.valueOf(array[i]));
            ++i;
        }
        return var1_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String join(Object[] array, char delimiter) {
        Object[] objectArray;
        void var1_1;
        if (array == null) {
            return null;
        }
        return StringUtils.join(array, (char)var1_1, 0, objectArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static String join(Object[] array, char delimiter, int startIndex, int endIndex) {
        void var1_2;
        void i;
        if (array == null) {
            return null;
        }
        if (endIndex - startIndex <= 0) {
            return EMPTY;
        }
        StringJoiner joiner = StringUtils.newStringJoiner(delimiter);
        while (i < endIndex) {
            joiner.add(StringUtils.toStringOrEmpty(array[i]));
            ++i;
        }
        return var1_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String join(Object[] array, String delimiter) {
        Object[] objectArray;
        void var1_1;
        if (array == null) {
            return null;
        }
        return StringUtils.join(array, (String)var1_1, 0, objectArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static String join(Object[] array, String delimiter, int startIndex, int endIndex) {
        void var1_1;
        void i;
        if (array == null) {
            return null;
        }
        if (endIndex - startIndex <= 0) {
            return EMPTY;
        }
        StringJoiner joiner = new StringJoiner(StringUtils.toStringOrEmpty(delimiter));
        while (i < endIndex) {
            joiner.add(StringUtils.toStringOrEmpty(array[i]));
            ++i;
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String join(short[] array, char delimiter) {
        short[] sArray;
        void var1_1;
        if (array == null) {
            return null;
        }
        return StringUtils.join(array, (char)var1_1, 0, sArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static String join(short[] array, char delimiter, int startIndex, int endIndex) {
        void var1_2;
        void i;
        if (array == null) {
            return null;
        }
        if (endIndex - startIndex <= 0) {
            return EMPTY;
        }
        StringJoiner joiner = StringUtils.newStringJoiner(delimiter);
        while (i < endIndex) {
            joiner.add(String.valueOf(array[i]));
            ++i;
        }
        return var1_2.toString();
    }

    @SafeVarargs
    public static <T> String join(T ... elements) {
        return StringUtils.join((Object[])elements, null);
    }

    /*
     * WARNING - void declaration
     */
    public static String joinWith(String delimiter, Object ... array) {
        String string;
        void var1_1;
        if (array == null) {
            throw new IllegalArgumentException("Object varargs must not be null");
        }
        return StringUtils.join((Object[])var1_1, string);
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(CharSequence seq, CharSequence searchSeq) {
        CharSequence charSequence;
        void var1_1;
        if (seq == null) {
            return -1;
        }
        return CharSequenceUtils.lastIndexOf(seq, (CharSequence)var1_1, charSequence.length());
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(CharSequence seq, CharSequence searchSeq, int startPos) {
        void var2_2;
        void var1_1;
        return CharSequenceUtils.lastIndexOf(seq, (CharSequence)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(CharSequence seq, int searchChar) {
        CharSequence charSequence;
        void var1_1;
        if (StringUtils.isEmpty(seq)) {
            return -1;
        }
        return CharSequenceUtils.lastIndexOf(seq, (int)var1_1, charSequence.length());
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(CharSequence seq, int searchChar, int startPos) {
        void var2_2;
        void var1_1;
        CharSequence charSequence;
        if (StringUtils.isEmpty(seq)) {
            return -1;
        }
        return CharSequenceUtils.lastIndexOf(charSequence, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOfAny(CharSequence str, CharSequence ... searchStrs) {
        void var2_3;
        if (str == null || searchStrs == null) {
            return -1;
        }
        int ret = -1;
        CharSequence[] charSequenceArray = searchStrs;
        int n = searchStrs.length;
        for (int i = 0; i < n; ++i) {
            void var1_2;
            int tmp;
            CharSequence search = charSequenceArray[i];
            if (search == null || (tmp = CharSequenceUtils.lastIndexOf(str, search, str.length())) <= ret) continue;
            ret = var1_2;
        }
        return (int)var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOfIgnoreCase(CharSequence str, CharSequence searchStr) {
        CharSequence charSequence;
        void var1_1;
        if (str == null || searchStr == null) {
            return -1;
        }
        return StringUtils.lastIndexOfIgnoreCase(str, (CharSequence)var1_1, charSequence.length());
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOfIgnoreCase(CharSequence str, CharSequence searchStr, int startPos) {
        void i;
        if (str == null || searchStr == null) {
            return -1;
        }
        int searchStrLength = searchStr.length();
        int strLength = str.length();
        if (startPos > strLength - searchStrLength) {
            startPos = strLength - searchStrLength;
        }
        if (startPos < 0) {
            return -1;
        }
        if (searchStrLength == 0) {
            return startPos;
        }
        while (i >= 0) {
            if (CharSequenceUtils.regionMatches(str, true, (int)i, searchStr, 0, searchStrLength)) {
                return (int)i;
            }
            --i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int lastOrdinalIndexOf(CharSequence str, CharSequence searchStr, int ordinal) {
        void var2_2;
        void var1_1;
        return StringUtils.ordinalIndexOf(str, (CharSequence)var1_1, (int)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    public static String left(String str, int len) {
        void var1_1;
        String string;
        if (str == null) {
            return null;
        }
        if (len < 0) {
            return EMPTY;
        }
        if (str.length() <= len) {
            return str;
        }
        return string.substring(0, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String leftPad(String str, int size) {
        void var1_1;
        return StringUtils.leftPad(str, (int)var1_1, ' ');
    }

    /*
     * WARNING - void declaration
     */
    public static String leftPad(String str, int size, char padChar) {
        String string;
        void var3_3;
        void var2_2;
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        if (pads > 8192) {
            void var1_1;
            return StringUtils.leftPad(str, (int)var1_1, String.valueOf(padChar));
        }
        return StringUtils.repeat((char)var2_2, (int)var3_3).concat(string);
    }

    /*
     * WARNING - void declaration
     */
    public static String leftPad(String str, int size, String padStr) {
        String string;
        void var1_2;
        if (str == null) {
            return null;
        }
        if (StringUtils.isEmpty(padStr)) {
            padStr = SPACE;
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        if (padLen == 1 && pads <= 8192) {
            return StringUtils.leftPad(str, size, padStr.charAt(0));
        }
        if (pads == padLen) {
            return padStr.concat(str);
        }
        if (pads < padLen) {
            return padStr.substring(0, pads).concat(str);
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i = 0; i < pads; ++i) {
            padding[i] = padChars[i % padLen];
        }
        return new String((char[])var1_2).concat(string);
    }

    public static int length(CharSequence cs) {
        CharSequence charSequence;
        if (cs == null) {
            return 0;
        }
        return charSequence.length();
    }

    public static String lowerCase(String str) {
        String string;
        if (str == null) {
            return null;
        }
        return string.toLowerCase();
    }

    /*
     * WARNING - void declaration
     */
    public static String lowerCase(String str, Locale locale) {
        void var1_1;
        String string;
        if (str == null) {
            return null;
        }
        return string.toLowerCase(LocaleUtils.toLocale((Locale)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private static int[] matches(CharSequence first, CharSequence second) {
        void var2_2;
        int i;
        CharSequence min;
        CharSequence max;
        if (first.length() > second.length()) {
            max = first;
            min = second;
        } else {
            max = second;
            min = first;
        }
        int range = Math.max(max.length() / 2 - 1, 0);
        int[] matchIndexes = new int[min.length()];
        Arrays.fill(matchIndexes, -1);
        boolean[] matchFlags = new boolean[max.length()];
        int matches = 0;
        block0: for (int mi = 0; mi < min.length(); ++mi) {
            char c1 = min.charAt(mi);
            int xn = Math.min(mi + range + 1, max.length());
            for (int xi = Math.max(mi - range, 0); xi < xn; ++xi) {
                if (matchFlags[xi] || c1 != max.charAt(xi)) continue;
                matchIndexes[mi] = xi;
                matchFlags[xi] = true;
                ++matches;
                continue block0;
            }
        }
        char[] ms1 = new char[matches];
        char[] ms2 = new char[matches];
        int si = 0;
        for (i = 0; i < min.length(); ++i) {
            if (matchIndexes[i] == -1) continue;
            ms1[si] = min.charAt(i);
            ++si;
        }
        si = 0;
        for (i = 0; i < max.length(); ++i) {
            if (!matchFlags[i]) continue;
            ms2[si] = max.charAt(i);
            ++si;
        }
        int transpositions = 0;
        for (int mi = 0; mi < ms1.length; ++mi) {
            if (ms1[mi] == ms2[mi]) continue;
            ++transpositions;
        }
        int prefix = 0;
        for (int mi = 0; mi < min.length() && first.charAt(mi) == second.charAt(mi); ++mi) {
            ++prefix;
        }
        return new int[]{matches, transpositions / 2, prefix, var2_2.length()};
    }

    /*
     * WARNING - void declaration
     */
    public static String mid(String str, int pos, int len) {
        void var2_2;
        String string;
        void var1_1;
        if (str == null) {
            return null;
        }
        if (len < 0 || pos > str.length()) {
            return EMPTY;
        }
        if (pos < 0) {
            pos = 0;
        }
        if (str.length() <= pos + len) {
            return str.substring(pos);
        }
        void v0 = var1_1;
        return string.substring((int)v0, (int)(v0 + var2_2));
    }

    private static StringJoiner newStringJoiner(char delimiter) {
        char c;
        return new StringJoiner(String.valueOf(c));
    }

    /*
     * WARNING - void declaration
     */
    public static String normalizeSpace(String str) {
        void var3_3;
        void var2_2;
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        int size = str.length();
        char[] newChars = new char[size];
        int count = 0;
        int whitespacesCount = 0;
        boolean startWhitespaces = true;
        for (int i = 0; i < size; ++i) {
            char actualChar = str.charAt(i);
            boolean bl = Character.isWhitespace(actualChar);
            if (bl) {
                if (whitespacesCount == 0 && !startWhitespaces) {
                    newChars[count++] = SPACE.charAt(0);
                }
                ++whitespacesCount;
                continue;
            }
            startWhitespaces = false;
            newChars[count++] = actualChar == '\u00a0' ? 32 : (int)actualChar;
            whitespacesCount = 0;
        }
        if (startWhitespaces) {
            return EMPTY;
        }
        return new String((char[])var2_2, 0, (int)(var3_3 - (whitespacesCount > 0))).trim();
    }

    /*
     * WARNING - void declaration
     */
    public static int ordinalIndexOf(CharSequence str, CharSequence searchStr, int ordinal) {
        void var2_2;
        void var1_1;
        return StringUtils.ordinalIndexOf(str, (CharSequence)var1_1, (int)var2_2, false);
    }

    private static int ordinalIndexOf(CharSequence str, CharSequence searchStr, int ordinal, boolean lastIndex) {
        if (str == null || searchStr == null || ordinal <= 0) {
            return -1;
        }
        if (searchStr.length() == 0) {
            if (lastIndex) {
                return str.length();
            }
            return 0;
        }
        int found = 0;
        int index = lastIndex ? str.length() : -1;
        do {
            if ((index = lastIndex ? CharSequenceUtils.lastIndexOf(str, searchStr, index - 1) : CharSequenceUtils.indexOf(str, searchStr, index + 1)) >= 0) continue;
            return index;
        } while (++found < ordinal);
        return index;
    }

    /*
     * WARNING - void declaration
     */
    public static String overlay(String str, String overlay, int start, int end) {
        void var3_3;
        String string;
        void var1_1;
        void var2_2;
        if (str == null) {
            return null;
        }
        if (overlay == null) {
            overlay = EMPTY;
        }
        int len = str.length();
        if (start < 0) {
            start = 0;
        }
        if (start > len) {
            start = len;
        }
        if (end < 0) {
            end = 0;
        }
        if (end > len) {
            end = len;
        }
        if (start > end) {
            int temp = start;
            start = end;
            end = temp;
        }
        return str.substring(0, (int)var2_2) + (String)var1_1 + string.substring((int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private static String prependIfMissing(String str, CharSequence prefix, boolean ignoreCase, CharSequence ... prefixes) {
        String string;
        void var1_1;
        if (str == null || StringUtils.isEmpty(prefix) || StringUtils.startsWith(str, prefix, ignoreCase)) {
            return str;
        }
        if (ArrayUtils.isNotEmpty(prefixes)) {
            void var3_3;
            for (void p : var3_3) {
                if (!StringUtils.startsWith(str, (CharSequence)p, ignoreCase)) continue;
                return str;
            }
        }
        return var1_1.toString() + string;
    }

    /*
     * WARNING - void declaration
     */
    public static String prependIfMissing(String str, CharSequence prefix, CharSequence ... prefixes) {
        void var2_2;
        void var1_1;
        return StringUtils.prependIfMissing(str, (CharSequence)var1_1, false, (CharSequence[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String prependIfMissingIgnoreCase(String str, CharSequence prefix, CharSequence ... prefixes) {
        void var2_2;
        void var1_1;
        return StringUtils.prependIfMissing(str, (CharSequence)var1_1, true, (CharSequence[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String remove(String str, char remove) {
        void var2_2;
        Object object;
        if (StringUtils.isEmpty(str) || str.indexOf(remove) == -1) {
            return str;
        }
        Object chars = str.toCharArray();
        int pos = 0;
        for (int i = 0; i < ((Object)chars).length; ++i) {
            if (chars[i] == remove) continue;
            chars[pos++] = chars[i];
        }
        return new String((char[])object, 0, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String remove(String str, String remove) {
        void var1_1;
        String string;
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(remove)) {
            return str;
        }
        return StringUtils.replace(string, (String)var1_1, EMPTY, -1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static String removeAll(String text, String regex) {
        void var1_1;
        return RegExUtils.removeAll(text, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String removeEnd(String str, String remove) {
        String string;
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(remove)) {
            return str;
        }
        if (str.endsWith(remove)) {
            void var1_1;
            return str.substring(0, str.length() - var1_1.length());
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static String removeEndIgnoreCase(String str, String remove) {
        String string;
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(remove)) {
            return str;
        }
        if (StringUtils.endsWithIgnoreCase(str, remove)) {
            void var1_1;
            return str.substring(0, str.length() - var1_1.length());
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static String removeFirst(String text, String regex) {
        void var1_1;
        return StringUtils.replaceFirst(text, (String)var1_1, EMPTY);
    }

    /*
     * WARNING - void declaration
     */
    public static String removeIgnoreCase(String str, String remove) {
        void var1_1;
        return StringUtils.replaceIgnoreCase(str, (String)var1_1, EMPTY, -1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static String removePattern(String source, String regex) {
        void var1_1;
        return RegExUtils.removePattern(source, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String removeStart(String str, String remove) {
        String string;
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(remove)) {
            return str;
        }
        if (str.startsWith(remove)) {
            void var1_1;
            return str.substring(var1_1.length());
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static String removeStartIgnoreCase(String str, String remove) {
        String string;
        if (str != null && StringUtils.startsWithIgnoreCase(str, remove)) {
            void var1_1;
            return str.substring(StringUtils.length((CharSequence)var1_1));
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static String repeat(char ch, int repeat) {
        void var1_2;
        char c;
        if (repeat <= 0) {
            return EMPTY;
        }
        char[] buf = new char[repeat];
        Arrays.fill(buf, c);
        return new String((char[])var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String repeat(String str, int repeat) {
        void var3_4;
        if (str == null) {
            return null;
        }
        if (repeat <= 0) {
            return EMPTY;
        }
        int inputLength = str.length();
        if (repeat == 1 || inputLength == 0) {
            return str;
        }
        if (inputLength == 1 && repeat <= 8192) {
            return StringUtils.repeat(str.charAt(0), repeat);
        }
        int outputLength = inputLength * repeat;
        switch (inputLength) {
            case 1: {
                return StringUtils.repeat(str.charAt(0), repeat);
            }
            case 2: {
                void var3_5;
                char ch0 = str.charAt(0);
                char ch1 = str.charAt(1);
                char[] output2 = new char[outputLength];
                for (int i = (repeat << 1) - 2; i >= 0; --i) {
                    output2[i] = ch0;
                    output2[i + 1] = ch1;
                    --i;
                }
                return new String((char[])var3_5);
            }
        }
        StringBuilder buf = new StringBuilder((int)var3_4);
        for (int i = 0; i < repeat; ++i) {
            String string;
            buf.append(string);
        }
        return buf.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String repeat(String str, String separator, int repeat) {
        void var1_1;
        void var2_2;
        String string;
        if (str == null || separator == null) {
            return StringUtils.repeat(str, repeat);
        }
        string = StringUtils.repeat(string + separator, (int)var2_2);
        return StringUtils.removeEnd(string, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String replace(String text, String searchString, String replacement) {
        void var2_2;
        void var1_1;
        return StringUtils.replace(text, (String)var1_1, (String)var2_2, -1);
    }

    /*
     * WARNING - void declaration
     */
    public static String replace(String text, String searchString, String replacement, int max) {
        void var3_3;
        void var2_2;
        void var1_1;
        return StringUtils.replace(text, (String)var1_1, (String)var2_2, (int)var3_3, false);
    }

    private static String replace(String text, String searchString, String replacement, int max, boolean ignoreCase) {
        String string;
        if (StringUtils.isEmpty(text) || StringUtils.isEmpty(searchString) || replacement == null || max == 0) {
            return text;
        }
        if (ignoreCase) {
            searchString = searchString.toLowerCase();
        }
        int start = 0;
        int end = ignoreCase ? StringUtils.indexOfIgnoreCase(text, searchString, 0) : StringUtils.indexOf((CharSequence)text, searchString, 0);
        if (end == -1) {
            return text;
        }
        int replLength = searchString.length();
        int n = Math.max(replacement.length() - replLength, 0);
        int increase = n * (max < 0 ? 16 : Math.min(max, 64));
        StringBuilder buf = new StringBuilder(text.length() + increase);
        while (end != -1) {
            buf.append(text, start, end).append(replacement);
            start = end + replLength;
            if (--max == 0) break;
            end = ignoreCase ? StringUtils.indexOfIgnoreCase(text, searchString, start) : StringUtils.indexOf((CharSequence)text, searchString, start);
        }
        buf.append(text, start, string.length());
        return buf.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static String replaceAll(String text, String regex, String replacement) {
        void var2_2;
        void var1_1;
        return RegExUtils.replaceAll(text, (String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String replaceChars(String str, char searchChar, char replaceChar) {
        void var2_2;
        void var1_1;
        String string;
        if (str == null) {
            return null;
        }
        return string.replace((char)var1_1, (char)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String replaceChars(String str, String searchChars, String replaceChars) {
        String string;
        void var3_3;
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(searchChars)) {
            return str;
        }
        if (replaceChars == null) {
            replaceChars = EMPTY;
        }
        boolean modified = false;
        int replaceCharsLength = replaceChars.length();
        int strLength = str.length();
        StringBuilder buf = new StringBuilder(strLength);
        for (int i = 0; i < strLength; ++i) {
            char ch = str.charAt(i);
            int index = searchChars.indexOf(ch);
            if (index >= 0) {
                modified = true;
                if (index >= replaceCharsLength) continue;
                buf.append(replaceChars.charAt(index));
                continue;
            }
            buf.append(ch);
        }
        if (var3_3 != false) {
            return buf.toString();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static String replaceEach(String text, String[] searchList, String[] replacementList) {
        void var2_2;
        void var1_1;
        return StringUtils.replaceEach(text, (String[])var1_1, (String[])var2_2, false, 0);
    }

    private static String replaceEach(String text, String[] searchList, String[] replacementList, boolean repeat, int timeToLive) {
        while (true) {
            if (timeToLive < 0) {
                HashSet<String> searchSet = new HashSet<String>(Arrays.asList(searchList));
                HashSet<String> replacementSet = new HashSet<String>(Arrays.asList(replacementList));
                searchSet.retainAll(replacementSet);
                if (!searchSet.isEmpty()) {
                    throw new IllegalStateException("Aborting to protect against StackOverflowError - output of one loop is the input of another");
                }
            }
            if (StringUtils.isEmpty(text) || ArrayUtils.isEmpty(searchList) || ArrayUtils.isEmpty(replacementList) || ArrayUtils.isNotEmpty(searchList) && timeToLive == -1) {
                return text;
            }
            int searchLength = searchList.length;
            int replacementLength = replacementList.length;
            if (searchLength != replacementLength) {
                throw new IllegalArgumentException("Search and Replace array lengths don't match: " + searchLength + " vs " + replacementLength);
            }
            boolean[] noMoreMatchesForReplIndex = new boolean[searchLength];
            int textIndex = -1;
            int replaceIndex = -1;
            for (int i = 0; i < searchLength; ++i) {
                if (noMoreMatchesForReplIndex[i] || StringUtils.isEmpty(searchList[i]) || replacementList[i] == null) continue;
                int tempIndex = text.indexOf(searchList[i]);
                if (tempIndex == -1) {
                    noMoreMatchesForReplIndex[i] = true;
                    continue;
                }
                if (textIndex != -1 && tempIndex >= textIndex) continue;
                textIndex = tempIndex;
                replaceIndex = i;
            }
            if (textIndex == -1) {
                return text;
            }
            int start = 0;
            int increase = 0;
            for (int i = 0; i < searchList.length; ++i) {
                int greater;
                if (searchList[i] == null || replacementList[i] == null || (greater = replacementList[i].length() - searchList[i].length()) <= 0) continue;
                increase += 3 * greater;
            }
            increase = Math.min(increase, text.length() / 5);
            StringBuilder buf = new StringBuilder(text.length() + increase);
            while (textIndex != -1) {
                int i;
                for (i = start; i < textIndex; ++i) {
                    buf.append(text.charAt(i));
                }
                buf.append(replacementList[replaceIndex]);
                start = textIndex + searchList[replaceIndex].length();
                textIndex = -1;
                replaceIndex = -1;
                for (i = 0; i < searchLength; ++i) {
                    if (noMoreMatchesForReplIndex[i] || searchList[i] == null || searchList[i].isEmpty() || replacementList[i] == null) continue;
                    int n = text.indexOf(searchList[i], start);
                    if (n == -1) {
                        noMoreMatchesForReplIndex[i] = true;
                        continue;
                    }
                    if (textIndex != -1 && n >= textIndex) continue;
                    textIndex = n;
                    replaceIndex = i;
                }
            }
            int textLength = text.length();
            for (int i = start; i < textLength; ++i) {
                buf.append(text.charAt(i));
            }
            String result = buf.toString();
            if (!repeat) {
                return result;
            }
            --timeToLive;
            text = result;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String replaceEachRepeatedly(String text, String[] searchList, String[] replacementList) {
        void var3_3;
        void var2_2;
        void var1_1;
        String string;
        int timeToLive = searchList == null ? 0 : searchList.length;
        return StringUtils.replaceEach(string, (String[])var1_1, (String[])var2_2, true, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static String replaceFirst(String text, String regex, String replacement) {
        void var2_2;
        void var1_1;
        return RegExUtils.replaceFirst(text, (String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String replaceIgnoreCase(String text, String searchString, String replacement) {
        void var2_2;
        void var1_1;
        return StringUtils.replaceIgnoreCase(text, (String)var1_1, (String)var2_2, -1);
    }

    /*
     * WARNING - void declaration
     */
    public static String replaceIgnoreCase(String text, String searchString, String replacement, int max) {
        void var3_3;
        void var2_2;
        void var1_1;
        return StringUtils.replace(text, (String)var1_1, (String)var2_2, (int)var3_3, true);
    }

    /*
     * WARNING - void declaration
     */
    public static String replaceOnce(String text, String searchString, String replacement) {
        void var2_2;
        void var1_1;
        return StringUtils.replace(text, (String)var1_1, (String)var2_2, 1);
    }

    /*
     * WARNING - void declaration
     */
    public static String replaceOnceIgnoreCase(String text, String searchString, String replacement) {
        void var2_2;
        void var1_1;
        return StringUtils.replaceIgnoreCase(text, (String)var1_1, (String)var2_2, 1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static String replacePattern(String source, String regex, String replacement) {
        void var2_2;
        void var1_1;
        return RegExUtils.replacePattern(source, (String)var1_1, (String)var2_2);
    }

    public static String reverse(String str) {
        String string;
        if (str == null) {
            return null;
        }
        return new StringBuilder(string).reverse().toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String reverseDelimited(String str, char separatorChar) {
        void var1_1;
        Object[] objectArray;
        if (str == null) {
            return null;
        }
        Object[] strs = StringUtils.split(str, separatorChar);
        ArrayUtils.reverse(strs);
        return StringUtils.join(objectArray, (char)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String right(String str, int len) {
        void var1_1;
        String string;
        if (str == null) {
            return null;
        }
        if (len < 0) {
            return EMPTY;
        }
        if (str.length() <= len) {
            return str;
        }
        String string2 = string;
        return string2.substring(string2.length() - var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String rightPad(String str, int size) {
        void var1_1;
        return StringUtils.rightPad(str, (int)var1_1, ' ');
    }

    /*
     * WARNING - void declaration
     */
    public static String rightPad(String str, int size, char padChar) {
        void var3_3;
        void var2_2;
        String string;
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        if (pads > 8192) {
            void var1_1;
            return StringUtils.rightPad(str, (int)var1_1, String.valueOf(padChar));
        }
        return string.concat(StringUtils.repeat((char)var2_2, (int)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public static String rightPad(String str, int size, String padStr) {
        void var1_2;
        String string;
        if (str == null) {
            return null;
        }
        if (StringUtils.isEmpty(padStr)) {
            padStr = SPACE;
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        if (padLen == 1 && pads <= 8192) {
            return StringUtils.rightPad(str, size, padStr.charAt(0));
        }
        if (pads == padLen) {
            return str.concat(padStr);
        }
        if (pads < padLen) {
            return str.concat(padStr.substring(0, pads));
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i = 0; i < pads; ++i) {
            padding[i] = padChars[i % padLen];
        }
        return string.concat(new String((char[])var1_2));
    }

    /*
     * WARNING - void declaration
     */
    public static String rotate(String str, int shift) {
        void var3_3;
        void var1_1;
        String string;
        void var2_2;
        if (str == null) {
            return null;
        }
        int strLen = str.length();
        if (shift == 0 || strLen == 0 || shift % strLen == 0) {
            return str;
        }
        StringBuilder builder = new StringBuilder(strLen);
        int offset = -(shift % var2_2);
        builder.append(StringUtils.substring(str, offset));
        builder.append(StringUtils.substring(string, 0, (int)var1_1));
        return var3_3.toString();
    }

    public static String[] split(String str) {
        return StringUtils.split(str, null, -1);
    }

    /*
     * WARNING - void declaration
     */
    public static String[] split(String str, char separatorChar) {
        void var1_1;
        return StringUtils.splitWorker(str, (char)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public static String[] split(String str, String separatorChars) {
        void var1_1;
        return StringUtils.splitWorker(str, (String)var1_1, -1, false);
    }

    /*
     * WARNING - void declaration
     */
    public static String[] split(String str, String separatorChars, int max) {
        void var2_2;
        void var1_1;
        return StringUtils.splitWorker(str, (String)var1_1, (int)var2_2, false);
    }

    public static String[] splitByCharacterType(String str) {
        return StringUtils.splitByCharacterType(str, false);
    }

    /*
     * WARNING - void declaration
     */
    private static String[] splitByCharacterType(String str, boolean camelCase) {
        void var2_2;
        void var3_3;
        Object object;
        if (str == null) {
            return null;
        }
        if (str.isEmpty()) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        Object c = str.toCharArray();
        ArrayList<String> list = new ArrayList<String>();
        int tokenStart = 0;
        int currentType = Character.getType((char)c[0]);
        for (int pos = 1; pos < ((Object)c).length; ++pos) {
            int type = Character.getType((char)c[pos]);
            if (type == currentType) continue;
            if (camelCase && type == 2 && currentType == 1) {
                int newTokenStart = pos - 1;
                if (newTokenStart != tokenStart) {
                    list.add(new String((char[])c, tokenStart, newTokenStart - tokenStart));
                    tokenStart = newTokenStart;
                }
            } else {
                list.add(new String((char[])c, tokenStart, pos - tokenStart));
                tokenStart = pos;
            }
            int n = type;
        }
        list.add(new String((char[])c, tokenStart, ((Object)object).length - var3_3));
        return var2_2.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    public static String[] splitByCharacterTypeCamelCase(String str) {
        return StringUtils.splitByCharacterType(str, true);
    }

    /*
     * WARNING - void declaration
     */
    public static String[] splitByWholeSeparator(String str, String separator) {
        void var1_1;
        return StringUtils.splitByWholeSeparatorWorker(str, (String)var1_1, -1, false);
    }

    /*
     * WARNING - void declaration
     */
    public static String[] splitByWholeSeparator(String str, String separator, int max) {
        void var2_2;
        void var1_1;
        return StringUtils.splitByWholeSeparatorWorker(str, (String)var1_1, (int)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    public static String[] splitByWholeSeparatorPreserveAllTokens(String str, String separator) {
        void var1_1;
        return StringUtils.splitByWholeSeparatorWorker(str, (String)var1_1, -1, true);
    }

    /*
     * WARNING - void declaration
     */
    public static String[] splitByWholeSeparatorPreserveAllTokens(String str, String separator, int max) {
        void var2_2;
        void var1_1;
        return StringUtils.splitByWholeSeparatorWorker(str, (String)var1_1, (int)var2_2, true);
    }

    private static String[] splitByWholeSeparatorWorker(String str, String separator, int max, boolean preserveAllTokens) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        if (separator == null || EMPTY.equals(separator)) {
            return StringUtils.splitWorker(str, null, max, preserveAllTokens);
        }
        int separatorLength = separator.length();
        ArrayList<String> substrings = new ArrayList<String>();
        int numberOfSubstrings = 0;
        int beg = 0;
        int end = 0;
        while (end < len) {
            end = str.indexOf(separator, beg);
            if (end >= 0) {
                if (end > beg) {
                    if (++numberOfSubstrings == max) {
                        end = len;
                        substrings.add(str.substring(beg));
                        continue;
                    }
                    substrings.add(str.substring(beg, end));
                    beg = end + separatorLength;
                    continue;
                }
                if (preserveAllTokens) {
                    if (++numberOfSubstrings == max) {
                        end = len;
                        substrings.add(str.substring(beg));
                    } else {
                        substrings.add(EMPTY);
                    }
                }
                beg = end + separatorLength;
                continue;
            }
            substrings.add(str.substring(beg));
            end = len;
        }
        return substrings.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    public static String[] splitPreserveAllTokens(String str) {
        return StringUtils.splitWorker(str, null, -1, true);
    }

    /*
     * WARNING - void declaration
     */
    public static String[] splitPreserveAllTokens(String str, char separatorChar) {
        void var1_1;
        return StringUtils.splitWorker(str, (char)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public static String[] splitPreserveAllTokens(String str, String separatorChars) {
        void var1_1;
        return StringUtils.splitWorker(str, (String)var1_1, -1, true);
    }

    /*
     * WARNING - void declaration
     */
    public static String[] splitPreserveAllTokens(String str, String separatorChars, int max) {
        void var2_2;
        void var1_1;
        return StringUtils.splitWorker(str, (String)var1_1, (int)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    private static String[] splitWorker(String str, char separatorChar, boolean preserveAllTokens) {
        void var2_2;
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int start = 0;
        boolean match = false;
        boolean lastMatch = false;
        while (i < len) {
            if (str.charAt(i) == separatorChar) {
                if (match || preserveAllTokens) {
                    list.add(str.substring(start, i));
                    match = false;
                    lastMatch = true;
                }
                start = ++i;
                continue;
            }
            lastMatch = false;
            match = true;
            ++i;
        }
        if (match || var2_2 != false && lastMatch) {
            String string;
            list.add(string.substring(start, i));
        }
        return list.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    /*
     * WARNING - void declaration
     */
    private static String[] splitWorker(String str, String separatorChars, int max, boolean preserveAllTokens) {
        void var3_4;
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> list = new ArrayList<String>();
        int sizePlus1 = 1;
        int i = 0;
        int start = 0;
        boolean match = false;
        boolean lastMatch = false;
        if (separatorChars == null) {
            while (i < len) {
                if (Character.isWhitespace(str.charAt(i))) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        } else if (separatorChars.length() == 1) {
            char sep = separatorChars.charAt(0);
            while (i < len) {
                if (str.charAt(i) == sep) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        } else {
            while (i < len) {
                void var1_1;
                if (var1_1.indexOf(str.charAt(i)) >= 0) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        }
        if (match || var3_4 != false && lastMatch) {
            String string;
            list.add(string.substring(start, i));
        }
        return list.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean startsWith(CharSequence str, CharSequence prefix) {
        void var1_1;
        return StringUtils.startsWith(str, (CharSequence)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean startsWith(CharSequence str, CharSequence prefix, boolean ignoreCase) {
        void var3_3;
        void var1_1;
        void var2_2;
        CharSequence charSequence;
        if (str == null || prefix == null) {
            return str == prefix;
        }
        int preLen = prefix.length();
        if (preLen > str.length()) {
            return false;
        }
        return CharSequenceUtils.regionMatches(charSequence, (boolean)var2_2, 0, (CharSequence)var1_1, 0, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean startsWithAny(CharSequence sequence, CharSequence ... searchStrings) {
        void var1_1;
        if (StringUtils.isEmpty(sequence) || ArrayUtils.isEmpty(searchStrings)) {
            return false;
        }
        for (void searchString : var1_1) {
            if (!StringUtils.startsWith(sequence, (CharSequence)searchString)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean startsWithIgnoreCase(CharSequence str, CharSequence prefix) {
        void var1_1;
        return StringUtils.startsWith(str, (CharSequence)var1_1, true);
    }

    public static String strip(String str) {
        return StringUtils.strip(str, null);
    }

    /*
     * WARNING - void declaration
     */
    public static String strip(String str, String stripChars) {
        void var1_1;
        String string = StringUtils.stripStart(str, stripChars);
        return StringUtils.stripEnd(string, (String)var1_1);
    }

    public static String stripAccents(String input) {
        CharSequence charSequence;
        if (input == null) {
            return null;
        }
        CharSequence decomposed = new StringBuilder(Normalizer.normalize(input, Normalizer.Form.NFD));
        StringUtils.convertRemainingAccentCharacters((StringBuilder)decomposed);
        return STRIP_ACCENTS_PATTERN.matcher(charSequence).replaceAll(EMPTY);
    }

    public static String[] stripAll(String ... strs) {
        return StringUtils.stripAll(strs, null);
    }

    /*
     * WARNING - void declaration
     */
    public static String[] stripAll(String[] strs, String stripChars) {
        void var3_3;
        int strsLen = ArrayUtils.getLength(strs);
        if (strsLen == 0) {
            return strs;
        }
        String[] newArr = new String[strsLen];
        for (int i = 0; i < strsLen; ++i) {
            newArr[i] = StringUtils.strip(strs[i], stripChars);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static String stripEnd(String str, String stripChars) {
        void var2_2;
        String string;
        int end = StringUtils.length(str);
        if (end == 0) {
            return str;
        }
        if (stripChars == null) {
            while (end != 0 && Character.isWhitespace(str.charAt(end - 1))) {
                --end;
            }
        } else {
            if (stripChars.isEmpty()) {
                return str;
            }
            while (end != 0 && stripChars.indexOf(str.charAt(end - 1)) != -1) {
                --end;
            }
        }
        return string.substring(0, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String stripStart(String str, String stripChars) {
        void var3_3;
        String string;
        int start;
        int strLen = StringUtils.length(str);
        if (strLen == 0) {
            return str;
        }
        if (stripChars == null) {
            for (start = 0; start != strLen && Character.isWhitespace(str.charAt(start)); ++start) {
            }
        } else {
            if (stripChars.isEmpty()) {
                return str;
            }
            while (start != strLen && stripChars.indexOf(str.charAt(start)) != -1) {
                ++start;
            }
        }
        return string.substring((int)var3_3);
    }

    public static String stripToEmpty(String str) {
        String string;
        if (str == null) {
            return EMPTY;
        }
        return StringUtils.strip(string, null);
    }

    public static String stripToNull(String str) {
        String string;
        if (str == null) {
            return null;
        }
        if ((str = StringUtils.strip(str, null)).isEmpty()) {
            return null;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static String substring(String str, int start) {
        void var1_1;
        String string;
        if (str == null) {
            return null;
        }
        if (start < 0) {
            start = str.length() + start;
        }
        if (start < 0) {
            start = 0;
        }
        if (start > str.length()) {
            return EMPTY;
        }
        return string.substring((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String substring(String str, int start, int end) {
        void var2_2;
        void var1_1;
        String string;
        if (str == null) {
            return null;
        }
        if (end < 0) {
            end = str.length() + end;
        }
        if (start < 0) {
            start = str.length() + start;
        }
        if (end > str.length()) {
            end = str.length();
        }
        if (start > end) {
            return EMPTY;
        }
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 0;
        }
        return string.substring((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String substringAfter(String str, int separator) {
        void var1_1;
        String string;
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return EMPTY;
        }
        return string.substring((int)(var1_1 + true));
    }

    /*
     * WARNING - void declaration
     */
    public static String substringAfter(String str, String separator) {
        void var1_1;
        void var2_2;
        String string;
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        if (separator == null) {
            return EMPTY;
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return EMPTY;
        }
        return string.substring((int)(var2_2 + var1_1.length()));
    }

    /*
     * WARNING - void declaration
     */
    public static String substringAfterLast(String str, int separator) {
        void var1_1;
        String string;
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1 || pos == str.length() - 1) {
            return EMPTY;
        }
        return string.substring((int)(var1_1 + true));
    }

    /*
     * WARNING - void declaration
     */
    public static String substringAfterLast(String str, String separator) {
        void var1_1;
        void var2_2;
        String string;
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        if (StringUtils.isEmpty(separator)) {
            return EMPTY;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1 || pos == str.length() - separator.length()) {
            return EMPTY;
        }
        return string.substring((int)(var2_2 + var1_1.length()));
    }

    /*
     * WARNING - void declaration
     */
    public static String substringBefore(String str, int separator) {
        void var1_1;
        String string;
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return str;
        }
        return string.substring(0, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String substringBefore(String str, String separator) {
        void var1_2;
        String string;
        if (StringUtils.isEmpty(str) || separator == null) {
            return str;
        }
        if (separator.isEmpty()) {
            return EMPTY;
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return str;
        }
        return string.substring(0, (int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String substringBeforeLast(String str, String separator) {
        void var1_2;
        String string;
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(separator)) {
            return str;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1) {
            return str;
        }
        return string.substring(0, (int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String substringBetween(String str, String tag) {
        void var1_1;
        void v0 = var1_1;
        return StringUtils.substringBetween(str, (String)v0, (String)v0);
    }

    /*
     * WARNING - void declaration
     */
    public static String substringBetween(String str, String open, String close) {
        int end;
        if (!ObjectUtils.allNotNull(str, open, close)) {
            return null;
        }
        int start = str.indexOf(open);
        if (start != -1 && (end = str.indexOf(close, start + open.length())) != -1) {
            void var2_3;
            void var1_1;
            void var3_4;
            String string;
            return string.substring((int)(var3_4 + var1_1.length()), (int)var2_3);
        }
        return null;
    }

    public static String[] substringsBetween(String str, String open, String close) {
        int end;
        int start;
        if (str == null || StringUtils.isEmpty(open) || StringUtils.isEmpty(close)) {
            return null;
        }
        int strLen = str.length();
        if (strLen == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        int closeLen = close.length();
        int openLen = open.length();
        ArrayList<String> list = new ArrayList<String>();
        int pos = 0;
        while (pos < strLen - closeLen && (start = str.indexOf(open, pos)) >= 0 && (end = str.indexOf(close, start += openLen)) >= 0) {
            list.add(str.substring(start, end));
            int n = end + closeLen;
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    /*
     * WARNING - void declaration
     */
    public static String swapCase(String str) {
        void var3_3;
        void var2_2;
        int newCodePoint;
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        int strLen = str.length();
        int[] newCodePoints = new int[strLen];
        int outOffset = 0;
        for (int i = 0; i < strLen; i += Character.charCount(newCodePoint)) {
            int oldCodepoint = str.codePointAt(i);
            if (Character.isUpperCase(oldCodepoint) || Character.isTitleCase(oldCodepoint)) {
                newCodePoint = Character.toLowerCase(oldCodepoint);
            } else if (Character.isLowerCase(newCodePoint)) {
                newCodePoint = Character.toUpperCase(newCodePoint);
            }
            newCodePoints[outOffset++] = newCodePoint;
        }
        return new String((int[])var2_2, 0, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static int[] toCodePoints(CharSequence cs) {
        void var1_1;
        if (cs == null) {
            return null;
        }
        if (cs.length() == 0) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        CharSequence s = cs.toString();
        int[] result = new int[((String)s).codePointCount(0, ((String)s).length())];
        int index = 0;
        for (int i = 0; i < result.length; ++i) {
            result[i] = ((String)s).codePointAt(index);
            index += Character.charCount(result[i]);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static String toEncodedString(byte[] bytes, Charset charset) {
        void var1_1;
        byte[] byArray;
        return new String(byArray, Charsets.toCharset((Charset)var1_1));
    }

    public static String toRootLowerCase(String source) {
        String string;
        if (source == null) {
            return null;
        }
        return string.toLowerCase(Locale.ROOT);
    }

    public static String toRootUpperCase(String source) {
        String string;
        if (source == null) {
            return null;
        }
        return string.toUpperCase(Locale.ROOT);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static String toString(byte[] bytes, String charsetName) throws UnsupportedEncodingException {
        void var1_1;
        byte[] byArray;
        return new String(byArray, Charsets.toCharset((String)var1_1));
    }

    private static String toStringOrEmpty(Object obj) {
        return Objects.toString(obj, EMPTY);
    }

    public static String trim(String str) {
        String string;
        if (str == null) {
            return null;
        }
        return string.trim();
    }

    public static String trimToEmpty(String str) {
        String string;
        if (str == null) {
            return EMPTY;
        }
        return string.trim();
    }

    public static String trimToNull(String str) {
        String string;
        String ts = StringUtils.trim(str);
        if (StringUtils.isEmpty(ts)) {
            return null;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static String truncate(String str, int maxWidth) {
        void var1_1;
        return StringUtils.truncate(str, 0, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String truncate(String str, int offset, int maxWidth) {
        void var1_1;
        String string;
        if (offset < 0) {
            throw new IllegalArgumentException("offset cannot be negative");
        }
        if (maxWidth < 0) {
            throw new IllegalArgumentException("maxWith cannot be negative");
        }
        if (str == null) {
            return null;
        }
        if (offset > str.length()) {
            return EMPTY;
        }
        if (str.length() > maxWidth) {
            void var2_2;
            int ix = Math.min(offset + maxWidth, str.length());
            return str.substring(offset, (int)var2_2);
        }
        return string.substring((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String uncapitalize(String str) {
        void var3_3;
        int newCodePoint;
        int strLen = StringUtils.length(str);
        if (strLen == 0) {
            return str;
        }
        int firstCodepoint = str.codePointAt(0);
        if (firstCodepoint == (newCodePoint = Character.toLowerCase(firstCodepoint))) {
            return str;
        }
        int[] newCodePoints = new int[strLen];
        int outOffset = 0;
        ++outOffset;
        newCodePoints[0] = newCodePoint;
        for (int inOffset = Character.charCount(firstCodepoint); inOffset < strLen; inOffset += Character.charCount((int)var3_3)) {
            int codepoint = str.codePointAt(inOffset);
            newCodePoints[outOffset++] = codepoint;
        }
        return new String(newCodePoints, 0, outOffset);
    }

    /*
     * WARNING - void declaration
     */
    public static String unwrap(String str, char wrapChar) {
        String string;
        if (StringUtils.isEmpty(str) || wrapChar == '\u0000' || str.length() == 1) {
            return str;
        }
        if (str.charAt(0) == wrapChar) {
            String string2 = str;
            if (string2.charAt(string2.length() - 1) == wrapChar) {
                void var1_1;
                int endIndex = str.length() - 1;
                return str.substring(1, (int)var1_1);
            }
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static String unwrap(String str, String wrapToken) {
        String string;
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(wrapToken) || str.length() < 2 * wrapToken.length()) {
            return str;
        }
        if (StringUtils.startsWith(str, wrapToken) && StringUtils.endsWith(str, wrapToken)) {
            int startIndex = str.indexOf(wrapToken);
            int endIndex = str.lastIndexOf(wrapToken);
            int wrapLength = wrapToken.length();
            if (startIndex != -1 && endIndex != -1) {
                void var3_4;
                void var1_2;
                void var2_3;
                return str.substring((int)(var2_3 + var1_2), (int)var3_4);
            }
        }
        return string;
    }

    public static String upperCase(String str) {
        String string;
        if (str == null) {
            return null;
        }
        return string.toUpperCase();
    }

    /*
     * WARNING - void declaration
     */
    public static String upperCase(String str, Locale locale) {
        void var1_1;
        String string;
        if (str == null) {
            return null;
        }
        return string.toUpperCase(LocaleUtils.toLocale((Locale)var1_1));
    }

    public static String valueOf(char[] value) {
        char[] cArray;
        if (value == null) {
            return null;
        }
        return String.valueOf(cArray);
    }

    /*
     * WARNING - void declaration
     */
    public static String wrap(String str, char wrapWith) {
        void var1_1;
        String string;
        if (StringUtils.isEmpty(str) || wrapWith == '\u0000') {
            return str;
        }
        return wrapWith + string + (char)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static String wrap(String str, String wrapWith) {
        void var1_1;
        String string;
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(wrapWith)) {
            return str;
        }
        return wrapWith.concat(string).concat((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String wrapIfMissing(String str, char wrapWith) {
        void var3_3;
        String string;
        void var2_2;
        boolean wrapEnd;
        if (StringUtils.isEmpty(str) || wrapWith == '\u0000') {
            return str;
        }
        boolean wrapStart = str.charAt(0) != wrapWith;
        String string2 = str;
        boolean bl = wrapEnd = string2.charAt(string2.length() - 1) != wrapWith;
        if (!wrapStart && !wrapEnd) {
            return str;
        }
        StringBuilder builder = new StringBuilder(str.length() + 2);
        if (var2_2 != false) {
            builder.append(wrapWith);
        }
        builder.append(string);
        if (var3_3 != false) {
            void var1_1;
            builder.append((char)var1_1);
        }
        return builder.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String wrapIfMissing(String str, String wrapWith) {
        void var3_3;
        String string;
        void var2_2;
        boolean wrapEnd;
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(wrapWith)) {
            return str;
        }
        boolean wrapStart = !str.startsWith(wrapWith);
        boolean bl = wrapEnd = !str.endsWith(wrapWith);
        if (!wrapStart && !wrapEnd) {
            return str;
        }
        StringBuilder builder = new StringBuilder(str.length() + wrapWith.length() + wrapWith.length());
        if (var2_2 != false) {
            builder.append(wrapWith);
        }
        builder.append(string);
        if (var3_3 != false) {
            void var1_1;
            builder.append((String)var1_1);
        }
        return builder.toString();
    }
}

