/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.SerializationException;
import org.apache.commons.lang3.Validate;

public class SerializationUtils {
    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends Serializable> T clone(T object) {
        if (object == null) {
            return null;
        }
        byte[] objectData = SerializationUtils.serialize(object);
        ByteArrayInputStream bais = new ByteArrayInputStream(objectData);
        try {
            Serializable serializable;
            Throwable throwable;
            ClassLoaderAwareObjectInputStream in2222 = new ClassLoaderAwareObjectInputStream((InputStream)((Object)throwable), object.getClass().getClassLoader());
            throwable = null;
            try {
                serializable = (Serializable)in2222.readObject();
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        in2222.close();
                        throw throwable4;
                    }
                    try {
                        in2222.close();
                        throw throwable4;
                    }
                    catch (Throwable in2222) {
                        throwable.addSuppressed(in2222);
                        throw throwable4;
                    }
                }
            }
            in2222.close();
            return (T)serializable;
        }
        catch (ClassNotFoundException ex) {
            throw new SerializationException("ClassNotFoundException while reading cloned object data", ex);
        }
        catch (IOException ex) {
            void var0_3;
            throw new SerializationException("IOException while reading or closing cloned object data", (Throwable)var0_3);
        }
    }

    public static <T> T deserialize(byte[] objectData) {
        byte[] byArray;
        Validate.notNull(objectData, "objectData", new Object[0]);
        return SerializationUtils.deserialize(new ByteArrayInputStream(byArray));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T deserialize(InputStream inputStream) {
        Validate.notNull(inputStream, "inputStream", new Object[0]);
        try {
            Object object;
            InputStream in2222 = new ObjectInputStream(inputStream);
            Throwable throwable = null;
            try {
                object = ((ObjectInputStream)in2222).readObject();
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        ((ObjectInputStream)in2222).close();
                        throw throwable4;
                    }
                    try {
                        ((ObjectInputStream)in2222).close();
                        throw throwable4;
                    }
                    catch (Throwable in2222) {
                        throwable.addSuppressed(in2222);
                        throw throwable4;
                    }
                }
            }
            ((ObjectInputStream)in2222).close();
            return (T)object;
        }
        catch (IOException | ClassNotFoundException ex) {
            void var0_2;
            throw new SerializationException((Throwable)var0_2);
        }
    }

    public static <T extends Serializable> T roundtrip(T obj) {
        return (T)((Serializable)SerializationUtils.deserialize(SerializationUtils.serialize(obj)));
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] serialize(Serializable obj) {
        void var1_1;
        Serializable serializable;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        SerializationUtils.serialize(serializable, baos);
        return var1_1.toByteArray();
    }

    /*
     * WARNING - void declaration
     */
    public static void serialize(Serializable obj, OutputStream outputStream) {
        Validate.notNull(outputStream, "outputStream", new Object[0]);
        try {
            Serializable serializable;
            ObjectOutputStream out2 = new ObjectOutputStream(outputStream);
            Throwable throwable = null;
            try {
                out2.writeObject(serializable);
            }
            catch (Throwable throwable2) {
                try {
                    serializable = throwable2;
                    throwable = throwable2;
                    throw serializable;
                }
                catch (Throwable throwable3) {
                    if (throwable != null) {
                        try {
                            out2.close();
                        }
                        catch (Throwable out2) {
                            throwable.addSuppressed(out2);
                        }
                    } else {
                        out2.close();
                    }
                    throw throwable3;
                }
            }
            out2.close();
        }
        catch (IOException ex) {
            void var1_4;
            throw new SerializationException((Throwable)var1_4);
        }
    }

    static class ClassLoaderAwareObjectInputStream
    extends ObjectInputStream {
        private static final Map<String, Class<?>> primitiveTypes = new HashMap();
        private final ClassLoader classLoader;

        /*
         * WARNING - void declaration
         */
        ClassLoaderAwareObjectInputStream(InputStream in, ClassLoader classLoader) throws IOException {
            super((InputStream)var1_1);
            void var2_2;
            void var1_1;
            this.classLoader = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            String name = desc.getName();
            try {
                return Class.forName(name, false, this.classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    return Class.forName(name, false, Thread.currentThread().getContextClassLoader());
                }
                catch (ClassNotFoundException cnfe) {
                    void var2_2;
                    Class<?> cls = primitiveTypes.get(name);
                    if (cls != null) {
                        void var1_1;
                        return var1_1;
                    }
                    throw var2_2;
                }
            }
        }

        static {
            primitiveTypes.put("byte", Byte.TYPE);
            primitiveTypes.put("short", Short.TYPE);
            primitiveTypes.put("int", Integer.TYPE);
            primitiveTypes.put("long", Long.TYPE);
            primitiveTypes.put("float", Float.TYPE);
            primitiveTypes.put("double", Double.TYPE);
            primitiveTypes.put("boolean", Boolean.TYPE);
            primitiveTypes.put("char", Character.TYPE);
            primitiveTypes.put("void", Void.TYPE);
        }
    }
}

