/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.Random;
import org.apache.commons.lang3.Validate;

public class RandomUtils {
    private static final Random RANDOM = new Random();

    public static boolean nextBoolean() {
        return RANDOM.nextBoolean();
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] nextBytes(int count) {
        void var0_1;
        Validate.isTrue(count >= 0, "Count cannot be negative.", new Object[0]);
        byte[] result = new byte[count];
        RANDOM.nextBytes(result);
        return var0_1;
    }

    /*
     * WARNING - void declaration
     */
    public static int nextInt(int startInclusive, int endExclusive) {
        int n;
        void var1_1;
        Validate.isTrue(endExclusive >= startInclusive, "Start value must be smaller or equal to end value.", new Object[0]);
        Validate.isTrue(startInclusive >= 0, "Both range values must be non-negative.", new Object[0]);
        if (startInclusive == endExclusive) {
            return startInclusive;
        }
        return startInclusive + RANDOM.nextInt((int)(var1_1 - n));
    }

    public static int nextInt() {
        return RandomUtils.nextInt(0, Integer.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    public static long nextLong(long startInclusive, long endExclusive) {
        long l;
        void var2_1;
        Validate.isTrue(endExclusive >= startInclusive, "Start value must be smaller or equal to end value.", new Object[0]);
        Validate.isTrue(startInclusive >= 0L, "Both range values must be non-negative.", new Object[0]);
        if (startInclusive == endExclusive) {
            return startInclusive;
        }
        return startInclusive + RandomUtils.nextLong((long)(var2_1 - l));
    }

    public static long nextLong() {
        return RandomUtils.nextLong(Long.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    private static long nextLong(long n) {
        long bits;
        long val;
        void var2_1;
        while (var2_1 - (val = (bits = RANDOM.nextLong() >>> 1) % n) + (n - 1L) < 0L) {
        }
        return val;
    }

    /*
     * WARNING - void declaration
     */
    public static double nextDouble(double startInclusive, double endExclusive) {
        double d;
        void var2_1;
        Validate.isTrue(endExclusive >= startInclusive, "Start value must be smaller or equal to end value.", new Object[0]);
        Validate.isTrue(startInclusive >= 0.0, "Both range values must be non-negative.", new Object[0]);
        if (startInclusive == endExclusive) {
            return startInclusive;
        }
        return startInclusive + (var2_1 - d) * RANDOM.nextDouble();
    }

    public static double nextDouble() {
        return RandomUtils.nextDouble(0.0, Double.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    public static float nextFloat(float startInclusive, float endExclusive) {
        float f;
        void var1_1;
        Validate.isTrue(endExclusive >= startInclusive, "Start value must be smaller or equal to end value.", new Object[0]);
        Validate.isTrue(startInclusive >= 0.0f, "Both range values must be non-negative.", new Object[0]);
        if (startInclusive == endExclusive) {
            return startInclusive;
        }
        return startInclusive + (var1_1 - f) * RANDOM.nextFloat();
    }

    public static float nextFloat() {
        return RandomUtils.nextFloat(0.0f, Float.MAX_VALUE);
    }
}

