/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.exception.CloneFailedException;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.text.StrBuilder;
import org.apache.commons.lang3.time.DurationUtils;

public class ObjectUtils {
    private static final char AT_SIGN = '@';
    public static final Null NULL = new Null();

    public static boolean allNotNull(Object ... values) {
        Object[] objectArray;
        if (values == null) {
            return false;
        }
        for (Object object : objectArray) {
            if (object != null) continue;
            return false;
        }
        return true;
    }

    public static boolean allNull(Object ... values) {
        return !ObjectUtils.anyNotNull(values);
    }

    public static boolean anyNotNull(Object ... values) {
        return ObjectUtils.firstNonNull(values) != null;
    }

    public static boolean anyNull(Object ... values) {
        return !ObjectUtils.allNotNull(values);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T clone(T obj) {
        if (obj instanceof Cloneable) {
            void var1_1;
            Object result;
            if (obj.getClass().isArray()) {
                Class<?> componentType = obj.getClass().getComponentType();
                if (componentType.isPrimitive()) {
                    int length = Array.getLength(obj);
                    result = Array.newInstance(componentType, length);
                    while (length-- > 0) {
                        Array.set(result, length, Array.get(obj, length));
                    }
                } else {
                    result = ((Object[])obj).clone();
                }
            } else {
                try {
                    result = obj.getClass().getMethod("clone", new Class[0]);
                    result = ((Method)result).invoke(obj, new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    throw new CloneFailedException("Cloneable type " + obj.getClass().getName() + " has no clone method", e);
                }
                catch (IllegalAccessException e) {
                    throw new CloneFailedException("Cannot clone Cloneable type " + obj.getClass().getName(), e);
                }
                catch (InvocationTargetException e) {
                    T t;
                    throw new CloneFailedException("Exception cloning Cloneable type " + t.getClass().getName(), e.getCause());
                }
            }
            return var1_1;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T cloneIfPossible(T obj) {
        void var1_1;
        T clone = ObjectUtils.clone(obj);
        if (clone == null) {
            T t;
            return t;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Comparable<? super T>> int compare(T c1, T c2) {
        void var1_1;
        return ObjectUtils.compare(c1, var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Comparable<? super T>> int compare(T c1, T c2, boolean nullGreater) {
        void var1_1;
        Object object;
        if (c1 == c2) {
            return 0;
        }
        if (c1 == null) {
            if (nullGreater) {
                return 1;
            }
            return -1;
        }
        if (c2 == null) {
            void var2_2;
            if (var2_2 != false) {
                return -1;
            }
            return 1;
        }
        return object.compareTo(var1_1);
    }

    public static boolean CONST(boolean v) {
        return v;
    }

    public static byte CONST(byte v) {
        return v;
    }

    public static char CONST(char v) {
        return v;
    }

    public static double CONST(double v) {
        return v;
    }

    public static float CONST(float v) {
        return v;
    }

    public static int CONST(int v) {
        return v;
    }

    public static long CONST(long v) {
        return v;
    }

    public static short CONST(short v) {
        return v;
    }

    public static <T> T CONST(T v) {
        return v;
    }

    public static byte CONST_BYTE(int v) {
        int n;
        if (v < -128 || v > 127) {
            throw new IllegalArgumentException("Supplied value must be a valid byte literal between -128 and 127: [" + v + "]");
        }
        return (byte)n;
    }

    public static short CONST_SHORT(int v) {
        int n;
        if (v < Short.MIN_VALUE || v > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Supplied value must be a valid byte literal between -32768 and 32767: [" + v + "]");
        }
        return (short)n;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T defaultIfNull(T object, T defaultValue) {
        void var1_1;
        if (object != null) {
            T t;
            return t;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static boolean equals(Object object1, Object object2) {
        void var1_1;
        Object object;
        if (object1 == object2) {
            return true;
        }
        if (object1 == null || object2 == null) {
            return false;
        }
        return object.equals(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public static <T> T firstNonNull(T ... values) {
        if (values != null) {
            T[] TArray;
            for (T val : TArray) {
                void var3_3;
                if (val == null) continue;
                return var3_3;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public static <T> T getFirstNonNull(Supplier<T> ... suppliers) {
        if (suppliers != null) {
            Supplier<T>[] supplierArray;
            for (Supplier<T> supplier : supplierArray) {
                void var3_3;
                T value;
                if (supplier == null || (value = supplier.get()) == null) continue;
                return var3_3;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T getIfNull(T object, Supplier<T> defaultSupplier) {
        void var1_1;
        if (object != null) {
            T t;
            return t;
        }
        if (defaultSupplier == null) {
            return null;
        }
        return var1_1.get();
    }

    @Deprecated
    public static int hashCode(Object obj) {
        Object object;
        if (obj == null) {
            return 0;
        }
        return object.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static int hashCodeMulti(Object ... objects) {
        void var1_1;
        int hash = 1;
        if (objects != null) {
            Object[] objectArray;
            for (Object object : objectArray) {
                int tmpHash = ObjectUtils.hashCode(object);
                hash = hash * 31 + tmpHash;
            }
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static void identityToString(Appendable appendable, Object object) throws IOException {
        void var1_1;
        Appendable appendable2;
        Validate.notNull(object, "object", new Object[0]);
        appendable2.append(object.getClass().getName()).append('@').append(Integer.toHexString(System.identityHashCode(var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    public static String identityToString(Object object) {
        void var2_2;
        Object object2;
        void var1_1;
        if (object == null) {
            return null;
        }
        String name = object.getClass().getName();
        Object hexString = Integer.toHexString(System.identityHashCode(object));
        StringBuilder builder = new StringBuilder(name.length() + 1 + ((String)hexString).length());
        builder.append((String)var1_1).append('@').append((String)object2);
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static void identityToString(StrBuilder builder, Object object) {
        void var1_1;
        void var2_2;
        StrBuilder strBuilder;
        Validate.notNull(object, "object", new Object[0]);
        String name = object.getClass().getName();
        String hexString = Integer.toHexString(System.identityHashCode(object));
        StrBuilder strBuilder2 = builder;
        strBuilder2.ensureCapacity(strBuilder2.length() + name.length() + 1 + hexString.length());
        strBuilder.append((String)var2_2).append('@').append((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void identityToString(StringBuffer buffer, Object object) {
        void var1_1;
        void var2_2;
        StringBuffer stringBuffer;
        Validate.notNull(object, "object", new Object[0]);
        String name = object.getClass().getName();
        String hexString = Integer.toHexString(System.identityHashCode(object));
        StringBuffer stringBuffer2 = buffer;
        stringBuffer2.ensureCapacity(stringBuffer2.length() + name.length() + 1 + hexString.length());
        stringBuffer.append((String)var2_2).append('@').append((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void identityToString(StringBuilder builder, Object object) {
        void var1_1;
        void var2_2;
        StringBuilder stringBuilder;
        Validate.notNull(object, "object", new Object[0]);
        String name = object.getClass().getName();
        String hexString = Integer.toHexString(System.identityHashCode(object));
        StringBuilder stringBuilder2 = builder;
        stringBuilder2.ensureCapacity(stringBuilder2.length() + name.length() + 1 + hexString.length());
        stringBuilder.append((String)var2_2).append('@').append((String)var1_1);
    }

    public static boolean isEmpty(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof CharSequence) {
            return ((CharSequence)object).length() == 0;
        }
        if (object.getClass().isArray()) {
            return Array.getLength(object) == 0;
        }
        if (object instanceof Collection) {
            return ((Collection)object).isEmpty();
        }
        if (object instanceof Map) {
            Object object2;
            return ((Map)object2).isEmpty();
        }
        return false;
    }

    public static boolean isNotEmpty(Object object) {
        return !ObjectUtils.isEmpty(object);
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public static <T extends Comparable<? super T>> T max(T ... values) {
        void var1_1;
        T result = null;
        if (values != null) {
            T[] TArray;
            for (T value : TArray) {
                if (ObjectUtils.compare(value, result, false) <= 0) continue;
                result = value;
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public static <T> T median(Comparator<T> comparator, T ... items) {
        TreeSet<T> treeSet;
        void var1_1;
        Validate.notEmpty(items, "null/empty items", new Object[0]);
        Validate.noNullElements(items);
        Validate.notNull(comparator, "comparator", new Object[0]);
        TreeSet<T> sort = new TreeSet<T>(comparator);
        Collections.addAll(sort, var1_1);
        treeSet = sort.toArray()[(treeSet.size() - 1) / 2];
        return (T)treeSet;
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public static <T extends Comparable<? super T>> T median(T ... items) {
        void var1_1;
        Object object;
        Validate.notEmpty(items);
        Validate.noNullElements(items);
        TreeSet sort = new TreeSet();
        Collections.addAll(sort, object);
        object = (Comparable)sort.toArray()[(var1_1.size() - 1) / 2];
        return (T)object;
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public static <T extends Comparable<? super T>> T min(T ... values) {
        void var1_1;
        T result = null;
        if (values != null) {
            T[] TArray;
            for (T value : TArray) {
                if (ObjectUtils.compare(value, result, true) >= 0) continue;
                result = value;
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public static <T> T mode(T ... items) {
        if (ArrayUtils.isNotEmpty(items)) {
            Object object;
            void var1_1;
            HashMap<T, MutableInt> occurrences = new HashMap<T, MutableInt>(items.length);
            for (T t : items) {
                MutableInt count = (MutableInt)occurrences.get(t);
                if (count == null) {
                    occurrences.put(t, new MutableInt(1));
                    continue;
                }
                count.increment();
            }
            Object result = null;
            int max = 0;
            for (Map.Entry e : var1_1.entrySet()) {
                int cmp = ((MutableInt)e.getValue()).intValue();
                if (cmp == max) {
                    result = null;
                    continue;
                }
                if (cmp <= max) continue;
                max = cmp;
                result = e.getKey();
            }
            return (T)object;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean notEqual(Object object1, Object object2) {
        void var1_1;
        return !ObjectUtils.equals(object1, var1_1);
    }

    public static <T> T requireNonEmpty(T obj) {
        return ObjectUtils.requireNonEmpty(obj, "object");
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T requireNonEmpty(T obj, String message) {
        T t;
        Objects.requireNonNull(obj, message);
        if (ObjectUtils.isEmpty(obj)) {
            void var1_1;
            throw new IllegalArgumentException((String)var1_1);
        }
        return t;
    }

    @Deprecated
    public static String toString(Object obj) {
        Object object;
        if (obj == null) {
            return "";
        }
        return object.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static String toString(Object obj, String nullStr) {
        Object object;
        if (obj == null) {
            void var1_1;
            return var1_1;
        }
        return object.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String toString(Object obj, Supplier<String> supplier) {
        Object object;
        if (obj == null) {
            void var1_1;
            if (supplier == null) {
                return null;
            }
            return (String)var1_1.get();
        }
        return object.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static void wait(Object obj, Duration duration) throws InterruptedException {
        void var1_1;
        DurationUtils.accept(obj::wait, DurationUtils.zeroIfNull((Duration)var1_1));
    }

    public static class Null
    implements Serializable {
        private static final long serialVersionUID = 7092611880189329093L;

        Null() {
        }

        private Object readResolve() {
            return NULL;
        }
    }
}

