/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;

public class LocaleUtils {
    private static final ConcurrentMap<String, List<Locale>> cLanguagesByCountry = new ConcurrentHashMap<String, List<Locale>>();
    private static final ConcurrentMap<String, List<Locale>> cCountriesByLanguage = new ConcurrentHashMap<String, List<Locale>>();

    public static List<Locale> availableLocaleList() {
        return SyncAvoid.AVAILABLE_LOCALE_LIST;
    }

    public static Set<Locale> availableLocaleSet() {
        return SyncAvoid.AVAILABLE_LOCALE_SET;
    }

    /*
     * WARNING - void declaration
     */
    public static List<Locale> countriesByLanguage(String languageCode) {
        void var1_1;
        if (languageCode == null) {
            return Collections.emptyList();
        }
        List<void> countries = (ArrayList)cCountriesByLanguage.get(languageCode);
        if (countries == null) {
            String string;
            countries = new ArrayList();
            Object object = LocaleUtils.availableLocaleList();
            object = object.iterator();
            while (object.hasNext()) {
                void var3_3;
                Locale locale = (Locale)object.next();
                if (!languageCode.equals(locale.getLanguage()) || locale.getCountry().isEmpty() || !locale.getVariant().isEmpty()) continue;
                countries.add(var3_3);
            }
            countries = Collections.unmodifiableList(countries);
            cCountriesByLanguage.putIfAbsent(languageCode, countries);
            countries = (List)cCountriesByLanguage.get(string);
        }
        return var1_1;
    }

    public static boolean isAvailableLocale(Locale locale) {
        Locale locale2;
        return LocaleUtils.availableLocaleList().contains(locale2);
    }

    private static boolean isISO3166CountryCode(String str) {
        String string;
        return StringUtils.isAllUpperCase(str) && string.length() == 2;
    }

    private static boolean isISO639LanguageCode(String str) {
        String string;
        return StringUtils.isAllLowerCase(str) && (str.length() == 2 || string.length() == 3);
    }

    private static boolean isNumericAreaCode(String str) {
        String string;
        return StringUtils.isNumeric(str) && string.length() == 3;
    }

    /*
     * WARNING - void declaration
     */
    public static List<Locale> languagesByCountry(String countryCode) {
        void var1_1;
        if (countryCode == null) {
            return Collections.emptyList();
        }
        List<void> langs = (ArrayList)cLanguagesByCountry.get(countryCode);
        if (langs == null) {
            String string;
            langs = new ArrayList();
            Object object = LocaleUtils.availableLocaleList();
            object = object.iterator();
            while (object.hasNext()) {
                void var3_3;
                Locale locale = (Locale)object.next();
                if (!countryCode.equals(locale.getCountry()) || !locale.getVariant().isEmpty()) continue;
                langs.add(var3_3);
            }
            langs = Collections.unmodifiableList(langs);
            cLanguagesByCountry.putIfAbsent(countryCode, langs);
            langs = (List)cLanguagesByCountry.get(string);
        }
        return var1_1;
    }

    public static List<Locale> localeLookupList(Locale locale) {
        Locale locale2 = locale;
        return LocaleUtils.localeLookupList(locale2, locale2);
    }

    /*
     * WARNING - void declaration
     */
    public static List<Locale> localeLookupList(Locale locale, Locale defaultLocale) {
        void var2_2;
        ArrayList<Object> list = new ArrayList<Object>(4);
        if (locale != null) {
            list.add(locale);
            if (!locale.getVariant().isEmpty()) {
                list.add(new Locale(locale.getLanguage(), locale.getCountry()));
            }
            if (!locale.getCountry().isEmpty()) {
                Locale locale2;
                list.add(new Locale(locale2.getLanguage(), ""));
            }
            if (!list.contains(defaultLocale)) {
                void var1_1;
                list.add(var1_1);
            }
        }
        return Collections.unmodifiableList(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static Locale parseLocale(String str) {
        String string;
        if (LocaleUtils.isISO639LanguageCode(str)) {
            return new Locale(str);
        }
        String[] segments = str.split("_", -1);
        String language = segments[0];
        if (segments.length == 2) {
            String country = segments[1];
            if (LocaleUtils.isISO639LanguageCode(language) && LocaleUtils.isISO3166CountryCode(country) || LocaleUtils.isNumericAreaCode(country)) {
                return new Locale(language, country);
            }
        } else if (segments.length == 3) {
            String country = segments[1];
            String variant = segments[2];
            if (LocaleUtils.isISO639LanguageCode(language) && (country.isEmpty() || LocaleUtils.isISO3166CountryCode(country) || LocaleUtils.isNumericAreaCode(country)) && !variant.isEmpty()) {
                void var1_1;
                void var3_4;
                void var2_2;
                return new Locale((String)var2_2, (String)var3_4, (String)var1_1);
            }
        }
        throw new IllegalArgumentException("Invalid locale format: " + string);
    }

    public static Locale toLocale(Locale locale) {
        if (locale != null) {
            Locale locale2;
            return locale2;
        }
        return Locale.getDefault();
    }

    /*
     * WARNING - void declaration
     */
    public static Locale toLocale(String str) {
        String string;
        if (str == null) {
            return null;
        }
        if (str.isEmpty()) {
            return new Locale("", "");
        }
        if (str.contains("#")) {
            throw new IllegalArgumentException("Invalid locale format: " + str);
        }
        int len = str.length();
        if (len < 2) {
            throw new IllegalArgumentException("Invalid locale format: " + str);
        }
        char c = str.charAt(0);
        if (c == '_') {
            void var1_1;
            void var3_3;
            if (len < 3) {
                throw new IllegalArgumentException("Invalid locale format: " + str);
            }
            char ch1 = str.charAt(1);
            char ch2 = str.charAt(2);
            if (!Character.isUpperCase(c) || !Character.isUpperCase((char)var3_3)) {
                throw new IllegalArgumentException("Invalid locale format: " + str);
            }
            if (len == 3) {
                return new Locale("", str.substring(1, 3));
            }
            if (var1_1 < 5) {
                throw new IllegalArgumentException("Invalid locale format: " + str);
            }
            if (str.charAt(3) != '_') {
                throw new IllegalArgumentException("Invalid locale format: " + str);
            }
            return new Locale("", str.substring(1, 3), str.substring(4));
        }
        return LocaleUtils.parseLocale(string);
    }

    static class SyncAvoid {
        private static final List<Locale> AVAILABLE_LOCALE_LIST;
        private static final Set<Locale> AVAILABLE_LOCALE_SET;

        SyncAvoid() {
        }

        /*
         * WARNING - void declaration
         */
        static {
            void var0;
            ArrayList<Locale> list = new ArrayList<Locale>(Arrays.asList(Locale.getAvailableLocales()));
            AVAILABLE_LOCALE_LIST = Collections.unmodifiableList(list);
            AVAILABLE_LOCALE_SET = Collections.unmodifiableSet(new HashSet(var0));
        }
    }
}

