/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import org.apache.commons.lang3.math.NumberUtils;

public enum JavaVersion {
    JAVA_0_9(1.5f, "0.9"),
    JAVA_1_1(1.1f, "1.1"),
    JAVA_1_2(1.2f, "1.2"),
    JAVA_1_3(1.3f, "1.3"),
    JAVA_1_4(1.4f, "1.4"),
    JAVA_1_5(1.5f, "1.5"),
    JAVA_1_6(1.6f, "1.6"),
    JAVA_1_7(1.7f, "1.7"),
    JAVA_1_8(1.8f, "1.8"),
    JAVA_1_9(9.0f, "9"),
    JAVA_9(9.0f, "9"),
    JAVA_10(10.0f, "10"),
    JAVA_11(11.0f, "11"),
    JAVA_12(12.0f, "12"),
    JAVA_13(13.0f, "13"),
    JAVA_14(14.0f, "14"),
    JAVA_15(15.0f, "15"),
    JAVA_16(16.0f, "16"),
    JAVA_17(17.0f, "17"),
    JAVA_RECENT(JavaVersion.maxVersion(), Float.toString(JavaVersion.maxVersion()));

    private final float value;
    private final String name;

    /*
     * WARNING - void declaration
     */
    private JavaVersion(float value, String name) {
        void var3_3;
        this.value = var3_3;
        this.name = name;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean atLeast(JavaVersion requiredVersion) {
        void var1_1;
        return this.value >= var1_1.value;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean atMost(JavaVersion requiredVersion) {
        void var1_1;
        return this.value <= var1_1.value;
    }

    static JavaVersion getJavaVersion(String nom) {
        return JavaVersion.get(nom);
    }

    /*
     * WARNING - void declaration
     */
    static JavaVersion get(String versionStr) {
        void var1_2;
        float f;
        if (versionStr == null) {
            return null;
        }
        String string = versionStr;
        int n = -1;
        switch (string.hashCode()) {
            case 47611: {
                if (!string.equals("0.9")) break;
                n = 0;
                break;
            }
            case 48564: {
                if (!string.equals("1.1")) break;
                n = 1;
                break;
            }
            case 48565: {
                if (!string.equals("1.2")) break;
                n = 2;
                break;
            }
            case 48566: {
                if (!string.equals("1.3")) break;
                n = 3;
                break;
            }
            case 48567: {
                if (!string.equals("1.4")) break;
                n = 4;
                break;
            }
            case 48568: {
                if (!string.equals("1.5")) break;
                n = 5;
                break;
            }
            case 48569: {
                if (!string.equals("1.6")) break;
                n = 6;
                break;
            }
            case 48570: {
                if (!string.equals("1.7")) break;
                n = 7;
                break;
            }
            case 48571: {
                if (!string.equals("1.8")) break;
                n = 8;
                break;
            }
            case 57: {
                if (!string.equals("9")) break;
                n = 9;
                break;
            }
            case 1567: {
                if (!string.equals("10")) break;
                n = 10;
                break;
            }
            case 1568: {
                if (!string.equals("11")) break;
                n = 11;
                break;
            }
            case 1569: {
                if (!string.equals("12")) break;
                n = 12;
                break;
            }
            case 1570: {
                if (!string.equals("13")) break;
                n = 13;
                break;
            }
            case 1571: {
                if (!string.equals("14")) break;
                n = 14;
                break;
            }
            case 1572: {
                if (!string.equals("15")) break;
                n = 15;
                break;
            }
            case 1573: {
                if (!string.equals("16")) break;
                n = 16;
                break;
            }
            case 1574: {
                if (!string.equals("17")) break;
                n = 17;
            }
        }
        switch (n) {
            case 0: {
                return JAVA_0_9;
            }
            case 1: {
                return JAVA_1_1;
            }
            case 2: {
                return JAVA_1_2;
            }
            case 3: {
                return JAVA_1_3;
            }
            case 4: {
                return JAVA_1_4;
            }
            case 5: {
                return JAVA_1_5;
            }
            case 6: {
                return JAVA_1_6;
            }
            case 7: {
                return JAVA_1_7;
            }
            case 8: {
                return JAVA_1_8;
            }
            case 9: {
                return JAVA_9;
            }
            case 10: {
                return JAVA_10;
            }
            case 11: {
                return JAVA_11;
            }
            case 12: {
                return JAVA_12;
            }
            case 13: {
                return JAVA_13;
            }
            case 14: {
                return JAVA_14;
            }
            case 15: {
                return JAVA_15;
            }
            case 16: {
                return JAVA_16;
            }
            case 17: {
                return JAVA_17;
            }
        }
        float v = JavaVersion.toFloatVersion(versionStr);
        if ((double)f - 1.0 < 1.0) {
            void var1_3;
            String string2;
            int firstComma = Math.max(versionStr.indexOf(46), versionStr.indexOf(44));
            int end = Math.max(versionStr.length(), versionStr.indexOf(44, firstComma));
            if (Float.parseFloat(string2.substring((int)(var1_3 + true), n)) > 0.9f) {
                return JAVA_RECENT;
            }
        } else if (var1_2 > 10.0f) {
            return JAVA_RECENT;
        }
        return null;
    }

    public final String toString() {
        return this.name;
    }

    /*
     * WARNING - void declaration
     */
    private static float maxVersion() {
        float f;
        float v = JavaVersion.toFloatVersion(System.getProperty("java.specification.version", "99.0"));
        if (f > 0.0f) {
            void var0;
            return (float)var0;
        }
        return 99.0f;
    }

    private static float toFloatVersion(String value) {
        String[] stringArray;
        if (value.contains(".")) {
            String[] toParse = value.split("\\.");
            if (toParse.length >= 2) {
                return NumberUtils.toFloat(toParse[0] + '.' + stringArray[1], -1.0f);
            }
        } else {
            return NumberUtils.toFloat((String)stringArray, -1.0f);
        }
        return -1.0f;
    }
}

