/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;

public class EnumUtils {
    private static final String NULL_ELEMENTS_NOT_PERMITTED = "null elements not permitted";
    private static final String CANNOT_STORE_S_S_VALUES_IN_S_BITS = "Cannot store %s %s values in %s bits";
    private static final String S_DOES_NOT_SEEM_TO_BE_AN_ENUM_TYPE = "%s does not seem to be an Enum type";
    private static final String ENUM_CLASS_MUST_BE_DEFINED = "EnumClass must be defined.";

    private static <E extends Enum<E>> Class<E> asEnum(Class<E> enumClass) {
        Class<E> clazz;
        Validate.notNull(enumClass, ENUM_CLASS_MUST_BE_DEFINED, new Object[0]);
        Validate.isTrue(enumClass.isEnum(), S_DOES_NOT_SEEM_TO_BE_AN_ENUM_TYPE, enumClass);
        return clazz;
    }

    /*
     * WARNING - void declaration
     */
    private static <E extends Enum<E>> Class<E> checkBitVectorable(Class<E> enumClass) {
        Class<E> clazz;
        void var1_1;
        Enum[] constants = (Enum[])EnumUtils.asEnum(enumClass).getEnumConstants();
        Validate.isTrue(constants.length <= 64, CANNOT_STORE_S_S_VALUES_IN_S_BITS, ((void)var1_1).length, enumClass.getSimpleName(), 64);
        return clazz;
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public static <E extends Enum<E>> long generateBitVector(Class<E> enumClass, E ... values) {
        void var1_1;
        Class<E> clazz;
        Validate.noNullElements(values);
        return EnumUtils.generateBitVector(clazz, Arrays.asList(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Enum<E>> long generateBitVector(Class<E> enumClass, Iterable<? extends E> values) {
        void var2_2;
        EnumUtils.checkBitVectorable(enumClass);
        Validate.notNull(values);
        long total = 0L;
        for (Enum constant : values) {
            void var1_1;
            Validate.notNull(constant, NULL_ELEMENTS_NOT_PERMITTED, new Object[0]);
            total |= 1L << var1_1.ordinal();
        }
        return (long)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public static <E extends Enum<E>> long[] generateBitVectors(Class<E> enumClass, E ... values) {
        Object object;
        Iterator iterator;
        EnumUtils.asEnum(enumClass);
        Validate.noNullElements(values);
        EnumSet<Enum> condensed = EnumSet.noneOf(enumClass);
        Collections.addAll(condensed, iterator);
        Object result = new long[(((Enum[])enumClass.getEnumConstants()).length - 1) / 64 + 1];
        for (Enum value : condensed) {
            void var2_2;
            Object object2 = result;
            int n = value.ordinal() / 64;
            object2[n] = object2[n] | 1L << var2_2.ordinal() % 64;
        }
        ArrayUtils.reverse((long[])result);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Enum<E>> long[] generateBitVectors(Class<E> enumClass, Iterable<? extends E> values) {
        void var1_1;
        void var2_2;
        EnumUtils.asEnum(enumClass);
        Validate.notNull(values);
        EnumSet<void> condensed = EnumSet.noneOf(enumClass);
        values = values.iterator();
        while (values.hasNext()) {
            Iterator iterator;
            Enum constant = (Enum)values.next();
            Validate.notNull(constant, NULL_ELEMENTS_NOT_PERMITTED, new Object[0]);
            condensed.add((void)iterator);
        }
        long[] result = new long[(((Enum[])enumClass.getEnumConstants()).length - 1) / 64 + 1];
        for (Object value : var2_2) {
            Object object;
            int n = ((Enum)value).ordinal() / 64;
            result[n] = result[n] | 1L << ((Enum)object).ordinal() % 64;
        }
        ArrayUtils.reverse(result);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Enum<E>> E getEnum(Class<E> enumClass, String enumName) {
        void var1_1;
        return EnumUtils.getEnum(enumClass, (String)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Enum<E>> E getEnum(Class<E> enumClass, String enumName, E defaultEnum) {
        if (enumName == null) {
            return defaultEnum;
        }
        try {
            void var1_1;
            Class<E> clazz;
            return Enum.valueOf(clazz, (String)var1_1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            void var2_2;
            return var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Enum<E>> E getEnumIgnoreCase(Class<E> enumClass, String enumName) {
        void var1_1;
        return EnumUtils.getEnumIgnoreCase(enumClass, (String)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Enum<E>> E getEnumIgnoreCase(Class<E> enumClass, String enumName, E defaultEnum) {
        void var2_2;
        Enum[] enumArray;
        if (enumName == null || !enumClass.isEnum()) {
            return defaultEnum;
        }
        for (Enum each : (Enum[])enumArray.getEnumConstants()) {
            if (!each.name().equalsIgnoreCase(enumName)) continue;
            return (E)each;
        }
        return var2_2;
    }

    public static <E extends Enum<E>> List<E> getEnumList(Class<E> enumClass) {
        Class<E> clazz;
        return new ArrayList<E>(Arrays.asList(clazz.getEnumConstants()));
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Enum<E>> Map<String, E> getEnumMap(Class<E> enumClass) {
        void var1_1;
        Enum[] enumArray;
        LinkedHashMap<String, Enum> map = new LinkedHashMap<String, Enum>();
        for (Enum e : (Enum[])enumArray.getEnumConstants()) {
            map.put(e.name(), e);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Enum<E>> boolean isValidEnum(Class<E> enumClass, String enumName) {
        void var1_1;
        return EnumUtils.getEnum(enumClass, (String)var1_1) != null;
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Enum<E>> boolean isValidEnumIgnoreCase(Class<E> enumClass, String enumName) {
        void var1_1;
        return EnumUtils.getEnumIgnoreCase(enumClass, (String)var1_1) != null;
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Enum<E>> EnumSet<E> processBitVector(Class<E> enumClass, long value) {
        void var1_1;
        Class<E> clazz;
        EnumUtils.checkBitVectorable(enumClass).getEnumConstants();
        return EnumUtils.processBitVectors(clazz, new long[]{var1_1});
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Enum<E>> EnumSet<E> processBitVectors(Class<E> enumClass, long ... values) {
        void var2_2;
        Enum[] enumArray;
        EnumSet<Enum> results = EnumSet.noneOf(EnumUtils.asEnum(enumClass));
        long[] lvalues = ArrayUtils.clone(Validate.notNull(values));
        ArrayUtils.reverse(lvalues);
        for (Enum constant : (Enum[])enumArray.getEnumConstants()) {
            int block = constant.ordinal() / 64;
            if (block >= lvalues.length || (lvalues[block] & 1L << constant.ordinal() % 64) == 0L) continue;
            results.add(constant);
        }
        return var2_2;
    }
}

