/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.mutable.MutableObject;

public class ClassUtils {
    public static final char PACKAGE_SEPARATOR_CHAR = '.';
    public static final String PACKAGE_SEPARATOR;
    public static final char INNER_CLASS_SEPARATOR_CHAR = '$';
    public static final String INNER_CLASS_SEPARATOR;
    private static final Map<String, Class<?>> namePrimitiveMap;
    private static final Map<Class<?>, Class<?>> primitiveWrapperMap;
    private static final Map<Class<?>, Class<?>> wrapperPrimitiveMap;
    private static final Map<String, String> abbreviationMap;
    private static final Map<String, String> reverseAbbreviationMap;

    /*
     * WARNING - void declaration
     */
    public static String getShortClassName(Object object, String valueIfNull) {
        Object object2;
        if (object == null) {
            void var1_1;
            return var1_1;
        }
        return ClassUtils.getShortClassName(object2.getClass());
    }

    public static String getShortClassName(Class<?> cls) {
        Class<?> clazz;
        if (cls == null) {
            return "";
        }
        return ClassUtils.getShortClassName(clazz.getName());
    }

    /*
     * WARNING - void declaration
     */
    public static String getShortClassName(String className) {
        void var1_1;
        String string;
        void var3_3;
        void var2_2;
        int lastDotIdx;
        if (StringUtils.isEmpty(className)) {
            return "";
        }
        StringBuilder arrayPrefix = new StringBuilder();
        if (className.startsWith("[")) {
            while (className.charAt(0) == '[') {
                className = className.substring(1);
                arrayPrefix.append("[]");
            }
            if (className.charAt(0) == 'L') {
                String string2 = className;
                if (string2.charAt(string2.length() - 1) == ';') {
                    className = className.substring(1, className.length() - 1);
                }
            }
            if (reverseAbbreviationMap.containsKey(className)) {
                className = reverseAbbreviationMap.get(className);
            }
        }
        int innerIdx = className.indexOf(36, (lastDotIdx = className.lastIndexOf(46)) == -1 ? 0 : lastDotIdx + 1);
        String out = className.substring((int)(var2_2 + true));
        if (var3_3 != -1) {
            out = out.replace('$', '.');
        }
        return string + var1_1;
    }

    public static String getSimpleName(Class<?> cls) {
        return ClassUtils.getSimpleName(cls, "");
    }

    /*
     * WARNING - void declaration
     */
    public static String getSimpleName(Class<?> cls, String valueIfNull) {
        Class<?> clazz;
        if (cls == null) {
            void var1_1;
            return var1_1;
        }
        return clazz.getSimpleName();
    }

    public static String getSimpleName(Object object) {
        return ClassUtils.getSimpleName(object, "");
    }

    /*
     * WARNING - void declaration
     */
    public static String getSimpleName(Object object, String valueIfNull) {
        Object object2;
        if (object == null) {
            void var1_1;
            return var1_1;
        }
        return object2.getClass().getSimpleName();
    }

    public static String getName(Class<?> cls) {
        return ClassUtils.getName(cls, "");
    }

    /*
     * WARNING - void declaration
     */
    public static String getName(Class<?> cls, String valueIfNull) {
        Class<?> clazz;
        if (cls == null) {
            void var1_1;
            return var1_1;
        }
        return clazz.getName();
    }

    public static String getName(Object object) {
        return ClassUtils.getName(object, "");
    }

    /*
     * WARNING - void declaration
     */
    public static String getName(Object object, String valueIfNull) {
        Object object2;
        if (object == null) {
            void var1_1;
            return var1_1;
        }
        return object2.getClass().getName();
    }

    /*
     * WARNING - void declaration
     */
    public static String getPackageName(Object object, String valueIfNull) {
        Object object2;
        if (object == null) {
            void var1_1;
            return var1_1;
        }
        return ClassUtils.getPackageName(object2.getClass());
    }

    public static String getPackageName(Class<?> cls) {
        Class<?> clazz;
        if (cls == null) {
            return "";
        }
        return ClassUtils.getPackageName(clazz.getName());
    }

    /*
     * WARNING - void declaration
     */
    public static String getPackageName(String className) {
        void var1_1;
        String string;
        int i;
        if (StringUtils.isEmpty(className)) {
            return "";
        }
        while (className.charAt(0) == '[') {
            className = className.substring(1);
        }
        if (className.charAt(0) == 'L') {
            String string2 = className;
            if (string2.charAt(string2.length() - 1) == ';') {
                className = className.substring(1);
            }
        }
        if ((i = className.lastIndexOf(46)) == -1) {
            return "";
        }
        return string.substring(0, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String getAbbreviatedName(Class<?> cls, int lengthHint) {
        void var1_1;
        Class<?> clazz;
        if (cls == null) {
            return "";
        }
        return ClassUtils.getAbbreviatedName(clazz.getName(), (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String getAbbreviatedName(String className, int lengthHint) {
        void var2_2;
        Object object;
        if (lengthHint <= 0) {
            throw new IllegalArgumentException("len must be > 0");
        }
        if (className == null) {
            return "";
        }
        if (className.length() <= lengthHint) {
            return className;
        }
        Object abbreviated = className.toCharArray();
        int target = 0;
        int source = 0;
        while (source < ((Object)abbreviated).length) {
            int runAheadTarget = target;
            while (source < ((Object)abbreviated).length && abbreviated[source] != 46) {
                abbreviated[runAheadTarget++] = abbreviated[source++];
            }
            if (ClassUtils.useFull(runAheadTarget, source, ((Object)abbreviated).length, lengthHint) || ++target > runAheadTarget) {
                target = runAheadTarget;
            }
            if (source >= ((Object)abbreviated).length) continue;
            abbreviated[target++] = abbreviated[source++];
        }
        return new String((char[])object, 0, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean useFull(int runAheadTarget, int source, int originalLength, int desiredLength) {
        void var3_3;
        void var1_1;
        void var2_2;
        int n;
        return source >= originalLength || n + var2_2 - var1_1 <= var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static List<Class<?>> getAllSuperclasses(Class<?> cls) {
        void var1_1;
        if (cls == null) {
            return null;
        }
        ArrayList classes = new ArrayList();
        for (Class<?> superclass = cls.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
            classes.add(superclass);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static List<Class<?>> getAllInterfaces(Class<?> cls) {
        void var1_1;
        Class<?> clazz;
        if (cls == null) {
            return null;
        }
        LinkedHashSet interfacesFound = new LinkedHashSet();
        ClassUtils.getAllInterfaces(clazz, interfacesFound);
        return new ArrayList((Collection<Class<?>>)var1_1);
    }

    private static void getAllInterfaces(Class<?> cls, HashSet<Class<?>> interfacesFound) {
        while (cls != null) {
            Class<?>[] classArray = cls.getInterfaces();
            Class<?>[] classArray2 = classArray;
            classArray2 = classArray;
            int n = classArray.length;
            for (int i = 0; i < n; ++i) {
                Class<?> i2 = classArray2[i];
                if (!interfacesFound.add(i2)) continue;
                ClassUtils.getAllInterfaces(i2, interfacesFound);
            }
            cls = cls.getSuperclass();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static List<Class<?>> convertClassNamesToClasses(List<String> classNames) {
        void var1_1;
        Iterator<String> iterator;
        if (classNames == null) {
            return null;
        }
        ArrayList classes = new ArrayList(classNames.size());
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            String className = (String)iterator.next();
            try {
                void var2_2;
                classes.add(Class.forName((String)var2_2));
            }
            catch (Exception exception) {
                classes.add(null);
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> convertClassesToClassNames(List<Class<?>> classes) {
        void var1_1;
        Iterator<Class<?>> iterator;
        if (classes == null) {
            return null;
        }
        ArrayList<String> classNames = new ArrayList<String>(classes.size());
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            Class cls = (Class)iterator.next();
            if (cls == null) {
                classNames.add(null);
                continue;
            }
            classNames.add(var2_2.getName());
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isAssignable(Class<?>[] classArray, Class<?> ... toClassArray) {
        void var1_1;
        return ClassUtils.isAssignable(classArray, var1_1, true);
    }

    public static boolean isAssignable(Class<?>[] classArray, Class<?>[] toClassArray, boolean autoboxing) {
        if (!ArrayUtils.isSameLength(classArray, toClassArray)) {
            return false;
        }
        if (classArray == null) {
            classArray = ArrayUtils.EMPTY_CLASS_ARRAY;
        }
        if (toClassArray == null) {
            toClassArray = ArrayUtils.EMPTY_CLASS_ARRAY;
        }
        for (int i = 0; i < classArray.length; ++i) {
            if (ClassUtils.isAssignable(classArray[i], toClassArray[i], autoboxing)) continue;
            return false;
        }
        return true;
    }

    public static boolean isPrimitiveOrWrapper(Class<?> type) {
        Class<?> clazz;
        if (type == null) {
            return false;
        }
        return type.isPrimitive() || ClassUtils.isPrimitiveWrapper(clazz);
    }

    public static boolean isPrimitiveWrapper(Class<?> type) {
        Class<?> clazz;
        return wrapperPrimitiveMap.containsKey(clazz);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isAssignable(Class<?> cls, Class<?> toClass) {
        void var1_1;
        return ClassUtils.isAssignable(cls, var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isAssignable(Class<?> cls, Class<?> toClass, boolean autoboxing) {
        Class<?> clazz;
        void var1_1;
        void var2_2;
        if (toClass == null) {
            return false;
        }
        if (cls == null) {
            return !toClass.isPrimitive();
        }
        if (var2_2 != false) {
            if (cls.isPrimitive() && !toClass.isPrimitive() && (cls = ClassUtils.primitiveToWrapper(cls)) == null) {
                return false;
            }
            if (toClass.isPrimitive() && !cls.isPrimitive() && (cls = ClassUtils.wrapperToPrimitive(cls)) == null) {
                return false;
            }
        }
        if (cls.equals(toClass)) {
            return true;
        }
        if (cls.isPrimitive()) {
            if (!toClass.isPrimitive()) {
                return false;
            }
            if (Integer.TYPE.equals(cls)) {
                return Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Long.TYPE.equals(cls)) {
                return Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Boolean.TYPE.equals(cls)) {
                return false;
            }
            if (Double.TYPE.equals(cls)) {
                return false;
            }
            if (Float.TYPE.equals(cls)) {
                return Double.TYPE.equals(toClass);
            }
            if (Character.TYPE.equals(cls)) {
                return Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Short.TYPE.equals(cls)) {
                return Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Byte.TYPE.equals(cls)) {
                return Short.TYPE.equals(toClass) || Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            return false;
        }
        return var1_1.isAssignableFrom(clazz);
    }

    /*
     * WARNING - void declaration
     */
    public static Class<?> primitiveToWrapper(Class<?> cls) {
        void var1_1;
        Class<?> convertedClass = cls;
        if (cls != null && cls.isPrimitive()) {
            Class<?> clazz;
            convertedClass = primitiveWrapperMap.get(clazz);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static Class<?>[] primitivesToWrappers(Class<?> ... classes) {
        void var1_1;
        if (classes == null) {
            return null;
        }
        if (classes.length == 0) {
            return classes;
        }
        Class[] convertedClasses = new Class[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            convertedClasses[i] = ClassUtils.primitiveToWrapper(classes[i]);
        }
        return var1_1;
    }

    public static Class<?> wrapperToPrimitive(Class<?> cls) {
        Class<?> clazz;
        return wrapperPrimitiveMap.get(clazz);
    }

    /*
     * WARNING - void declaration
     */
    public static Class<?>[] wrappersToPrimitives(Class<?> ... classes) {
        void var1_1;
        if (classes == null) {
            return null;
        }
        if (classes.length == 0) {
            return classes;
        }
        Class[] convertedClasses = new Class[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            convertedClasses[i] = ClassUtils.wrapperToPrimitive(classes[i]);
        }
        return var1_1;
    }

    public static boolean isInnerClass(Class<?> cls) {
        Class<?> clazz;
        return cls != null && clazz.getEnclosingClass() != null;
    }

    /*
     * WARNING - void declaration
     */
    public static Class<?> getClass(ClassLoader classLoader, String className, boolean initialize) throws ClassNotFoundException {
        try {
            Class<?> clazz = namePrimitiveMap.containsKey(className) ? namePrimitiveMap.get(className) : Class.forName(ClassUtils.toCanonicalName(className), initialize, classLoader);
            return clazz;
        }
        catch (ClassNotFoundException ex) {
            void var3_4;
            int lastDotIndex = className.lastIndexOf(46);
            if (lastDotIndex != -1) {
                try {
                    void var2_2;
                    void var1_1;
                    ClassLoader classLoader2;
                    return ClassUtils.getClass(classLoader2, className.substring(0, lastDotIndex) + '$' + var1_1.substring(lastDotIndex + 1), (boolean)var2_2);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            throw var3_4;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Class<?> getClass(ClassLoader classLoader, String className) throws ClassNotFoundException {
        void var1_1;
        return ClassUtils.getClass(classLoader, (String)var1_1, true);
    }

    public static Class<?> getClass(String className) throws ClassNotFoundException {
        return ClassUtils.getClass(className, true);
    }

    /*
     * WARNING - void declaration
     */
    public static Class<?> getClass(String className, boolean initialize) throws ClassNotFoundException {
        void var1_1;
        String string;
        ClassLoader classLoader;
        ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
        classLoader = contextCL == null ? ClassUtils.class.getClassLoader() : classLoader;
        return ClassUtils.getClass(classLoader, string, (boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Method getPublicMethod(Class<?> cls, String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException {
        void var2_2;
        void var1_1;
        Object object;
        Method method = cls.getMethod(methodName, parameterTypes);
        if (Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
            return method;
        }
        ArrayList arrayList = new ArrayList(ClassUtils.getAllInterfaces(cls));
        arrayList.addAll(ClassUtils.getAllSuperclasses(object));
        for (Class clazz : arrayList) {
            Method method2;
            if (!Modifier.isPublic(clazz.getModifiers())) continue;
            try {
                method2 = clazz.getMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
            if (!Modifier.isPublic(method2.getDeclaringClass().getModifiers())) continue;
            return method2;
        }
        throw new NoSuchMethodException("Can't find a public method for " + (String)var1_1 + " " + ArrayUtils.toString(var2_2));
    }

    /*
     * WARNING - void declaration
     */
    private static String toCanonicalName(String className) {
        String string;
        className = StringUtils.deleteWhitespace(className);
        Validate.notNull(className, "className", new Object[0]);
        if (className.endsWith("[]")) {
            void var1_1;
            StringBuilder classNameBuffer = new StringBuilder();
            while (className.endsWith("[]")) {
                className = className.substring(0, className.length() - 2);
                classNameBuffer.append("[");
            }
            String abbreviation = abbreviationMap.get(className);
            if (abbreviation != null) {
                void var2_2;
                classNameBuffer.append((String)var2_2);
            } else {
                classNameBuffer.append("L").append(className).append(";");
            }
            className = var1_1.toString();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static Class<?>[] toClass(Object ... array) {
        void var1_1;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return ArrayUtils.EMPTY_CLASS_ARRAY;
        }
        Class[] classes = new Class[array.length];
        for (int i = 0; i < array.length; ++i) {
            classes[i] = array[i] == null ? null : array[i].getClass();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static String getShortCanonicalName(Object object, String valueIfNull) {
        Object object2;
        if (object == null) {
            void var1_1;
            return var1_1;
        }
        return ClassUtils.getShortCanonicalName(object2.getClass().getName());
    }

    public static String getCanonicalName(Class<?> cls) {
        return ClassUtils.getCanonicalName(cls, "");
    }

    /*
     * WARNING - void declaration
     */
    public static String getCanonicalName(Class<?> cls, String valueIfNull) {
        String string;
        if (cls == null) {
            return valueIfNull;
        }
        String canonicalName = cls.getCanonicalName();
        if (canonicalName == null) {
            void var1_1;
            return var1_1;
        }
        return string;
    }

    public static String getCanonicalName(Object object) {
        return ClassUtils.getCanonicalName(object, "");
    }

    /*
     * WARNING - void declaration
     */
    public static String getCanonicalName(Object object, String valueIfNull) {
        Object object2;
        if (object == null) {
            return valueIfNull;
        }
        Object canonicalName = object.getClass().getCanonicalName();
        if (canonicalName == null) {
            void var1_1;
            return var1_1;
        }
        return object2;
    }

    public static String getShortCanonicalName(Class<?> cls) {
        Class<?> clazz;
        if (cls == null) {
            return "";
        }
        return ClassUtils.getShortCanonicalName(clazz.getName());
    }

    public static String getShortCanonicalName(String canonicalName) {
        return ClassUtils.getShortClassName(ClassUtils.getCanonicalName(canonicalName));
    }

    /*
     * WARNING - void declaration
     */
    public static String getPackageCanonicalName(Object object, String valueIfNull) {
        Object object2;
        if (object == null) {
            void var1_1;
            return var1_1;
        }
        return ClassUtils.getPackageCanonicalName(object2.getClass().getName());
    }

    public static String getPackageCanonicalName(Class<?> cls) {
        Class<?> clazz;
        if (cls == null) {
            return "";
        }
        return ClassUtils.getPackageCanonicalName(clazz.getName());
    }

    public static String getPackageCanonicalName(String name) {
        return ClassUtils.getPackageName(ClassUtils.getCanonicalName(name));
    }

    private static String getCanonicalName(String className) {
        CharSequence charSequence;
        if ((className = StringUtils.deleteWhitespace(className)) == null) {
            return null;
        }
        int dim = 0;
        while (className.startsWith("[")) {
            ++dim;
            className = className.substring(1);
        }
        if (dim <= 0) {
            return className;
        }
        if (className.startsWith("L")) {
            className = className.substring(1, className.endsWith(";") ? className.length() - 1 : className.length());
        } else if (!className.isEmpty()) {
            className = reverseAbbreviationMap.get(className.substring(0, 1));
        }
        CharSequence canonicalClassNameBuffer = new StringBuilder(className);
        for (int i = 0; i < dim; ++i) {
            ((StringBuilder)canonicalClassNameBuffer).append("[]");
        }
        return ((StringBuilder)charSequence).toString();
    }

    public static Iterable<Class<?>> hierarchy(Class<?> type) {
        return ClassUtils.hierarchy(type, Interfaces.EXCLUDE);
    }

    /*
     * WARNING - void declaration
     */
    public static Iterable<Class<?>> hierarchy(Class<?> type, Interfaces interfacesBehavior) {
        Iterable iterable;
        void var1_1;
        Iterable classes = () -> {
            Serializable serializable;
            Serializable next = new MutableObject<Class>(type);
            return new Iterator<Class<?>>((MutableObject)serializable){
                final /* synthetic */ MutableObject val$next;
                {
                    this.val$next = mutableObject;
                }

                @Override
                public final boolean hasNext() {
                    return this.val$next.getValue() != null;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final Class<?> next() {
                    void var1_1;
                    Class result = (Class)this.val$next.getValue();
                    this.val$next.setValue(result.getSuperclass());
                    return var1_1;
                }

                @Override
                public final void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        };
        if (var1_1 != Interfaces.INCLUDE) {
            return classes;
        }
        return () -> {
            void var1_1;
            Iterator iterator;
            HashSet seenInterfaces = new HashSet();
            Iterator wrapped = iterable.iterator();
            return new Iterator<Class<?>>((Set)var1_1){
                Iterator interfaces = Collections.emptySet().iterator();
                final /* synthetic */ Set val$seenInterfaces;
                {
                    this.val$seenInterfaces = set;
                }

                @Override
                public final boolean hasNext() {
                    return this.interfaces.hasNext() || iterator.hasNext();
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final Class<?> next() {
                    void var1_2;
                    void var2_3;
                    if (this.interfaces.hasNext()) {
                        Class nextInterface = (Class)this.interfaces.next();
                        this.val$seenInterfaces.add(nextInterface);
                        return nextInterface;
                    }
                    Class nextSuperclass = (Class)iterator.next();
                    LinkedHashSet currentInterfaces = new LinkedHashSet();
                    this.walkInterfaces(currentInterfaces, nextSuperclass);
                    this.interfaces = var2_3.iterator();
                    return var1_2;
                }

                private void walkInterfaces(Set<Class<?>> addTo, Class<?> c) {
                    for (Class<?> iface : c.getInterfaces()) {
                        if (!this.val$seenInterfaces.contains(iface)) {
                            addTo.add(iface);
                        }
                        this.walkInterfaces(addTo, iface);
                    }
                }

                @Override
                public final void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        };
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var1_1;
        PACKAGE_SEPARATOR = ".";
        INNER_CLASS_SEPARATOR = "$";
        namePrimitiveMap = new HashMap();
        namePrimitiveMap.put("boolean", Boolean.TYPE);
        namePrimitiveMap.put("byte", Byte.TYPE);
        namePrimitiveMap.put("char", Character.TYPE);
        namePrimitiveMap.put("short", Short.TYPE);
        namePrimitiveMap.put("int", Integer.TYPE);
        namePrimitiveMap.put("long", Long.TYPE);
        namePrimitiveMap.put("double", Double.TYPE);
        namePrimitiveMap.put("float", Float.TYPE);
        namePrimitiveMap.put("void", Void.TYPE);
        primitiveWrapperMap = new HashMap();
        primitiveWrapperMap.put(Boolean.TYPE, Boolean.class);
        primitiveWrapperMap.put(Byte.TYPE, Byte.class);
        primitiveWrapperMap.put(Character.TYPE, Character.class);
        primitiveWrapperMap.put(Short.TYPE, Short.class);
        primitiveWrapperMap.put(Integer.TYPE, Integer.class);
        primitiveWrapperMap.put(Long.TYPE, Long.class);
        primitiveWrapperMap.put(Double.TYPE, Double.class);
        primitiveWrapperMap.put(Float.TYPE, Float.class);
        Class<Void> clazz = Void.TYPE;
        primitiveWrapperMap.put(clazz, clazz);
        wrapperPrimitiveMap = new HashMap();
        Iterator<Map.Entry<Class<?>, Class<?>>> iterator = primitiveWrapperMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Iterator iterator2;
            Class<?> wrapperClass;
            Map.Entry<Class<?>, Class<?>> entry = iterator.next();
            Class<?> primitiveClass = entry.getKey();
            if (primitiveClass.equals(wrapperClass = entry.getValue())) continue;
            wrapperPrimitiveMap.put(wrapperClass, (Class<?>)((Object)iterator2));
        }
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("int", "I");
        m.put("boolean", "Z");
        m.put("float", "F");
        m.put("long", "J");
        m.put("short", "S");
        m.put("byte", "B");
        m.put("double", "D");
        m.put("char", "C");
        HashMap r = new HashMap();
        for (Map.Entry e : m.entrySet()) {
            void var3_3;
            r.put(e.getValue(), var3_3.getKey());
        }
        abbreviationMap = Collections.unmodifiableMap(iterator);
        reverseAbbreviationMap = Collections.unmodifiableMap(var1_1);
    }

    public static enum Interfaces {
        INCLUDE,
        EXCLUDE;

    }
}

