/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class CharUtils {
    private static final String[] CHAR_STRING_ARRAY = new String[128];
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static final char LF = '\n';
    public static final char CR = '\r';
    public static final char NUL = '\u0000';

    @Deprecated
    public static Character toCharacterObject(char ch) {
        return Character.valueOf(ch);
    }

    public static Character toCharacterObject(String str) {
        String string;
        if (StringUtils.isEmpty(str)) {
            return null;
        }
        return Character.valueOf(string.charAt(0));
    }

    public static char toChar(Character ch) {
        Character c;
        Validate.notNull(ch, "ch", new Object[0]);
        return c.charValue();
    }

    /*
     * WARNING - void declaration
     */
    public static char toChar(Character ch, char defaultValue) {
        Character c;
        if (ch == null) {
            void var1_1;
            return (char)var1_1;
        }
        return c.charValue();
    }

    public static char toChar(String str) {
        String string;
        Validate.notEmpty(str, "The String must not be empty", new Object[0]);
        return string.charAt(0);
    }

    /*
     * WARNING - void declaration
     */
    public static char toChar(String str, char defaultValue) {
        String string;
        if (StringUtils.isEmpty(str)) {
            void var1_1;
            return (char)var1_1;
        }
        return string.charAt(0);
    }

    public static int toIntValue(char ch) {
        char c;
        if (!CharUtils.isAsciiNumeric(ch)) {
            throw new IllegalArgumentException("The character " + ch + " is not in the range '0' - '9'");
        }
        return c - 48;
    }

    /*
     * WARNING - void declaration
     */
    public static int toIntValue(char ch, int defaultValue) {
        char c;
        if (!CharUtils.isAsciiNumeric(ch)) {
            void var1_1;
            return (int)var1_1;
        }
        return c - 48;
    }

    public static int toIntValue(Character ch) {
        Character c;
        Validate.notNull(ch, "ch", new Object[0]);
        return CharUtils.toIntValue(c.charValue());
    }

    /*
     * WARNING - void declaration
     */
    public static int toIntValue(Character ch, int defaultValue) {
        void var1_1;
        Character c;
        if (ch == null) {
            return defaultValue;
        }
        return CharUtils.toIntValue(c.charValue(), (int)var1_1);
    }

    public static String toString(char ch) {
        char c;
        if (ch < '\u0080') {
            return CHAR_STRING_ARRAY[ch];
        }
        return new String(new char[]{c});
    }

    public static String toString(Character ch) {
        Character c;
        if (ch == null) {
            return null;
        }
        return CharUtils.toString(c.charValue());
    }

    public static String unicodeEscaped(char ch) {
        char c;
        return "\\u" + HEX_DIGITS[ch >> 12 & 0xF] + HEX_DIGITS[ch >> 8 & 0xF] + HEX_DIGITS[ch >> 4 & 0xF] + HEX_DIGITS[c & 0xF];
    }

    public static String unicodeEscaped(Character ch) {
        Character c;
        if (ch == null) {
            return null;
        }
        return CharUtils.unicodeEscaped(c.charValue());
    }

    public static boolean isAscii(char ch) {
        return ch < '\u0080';
    }

    public static boolean isAsciiPrintable(char ch) {
        char c;
        return ch >= ' ' && c < '\u007f';
    }

    public static boolean isAsciiControl(char ch) {
        char c;
        return ch < ' ' || c == '\u007f';
    }

    public static boolean isAsciiAlpha(char ch) {
        char c;
        return CharUtils.isAsciiAlphaUpper(ch) || CharUtils.isAsciiAlphaLower(c);
    }

    public static boolean isAsciiAlphaUpper(char ch) {
        char c;
        return ch >= 'A' && c <= 'Z';
    }

    public static boolean isAsciiAlphaLower(char ch) {
        char c;
        return ch >= 'a' && c <= 'z';
    }

    public static boolean isAsciiNumeric(char ch) {
        char c;
        return ch >= '0' && c <= '9';
    }

    public static boolean isAsciiAlphanumeric(char ch) {
        char c;
        return CharUtils.isAsciiAlpha(ch) || CharUtils.isAsciiNumeric(c);
    }

    /*
     * WARNING - void declaration
     */
    public static int compare(char x, char y) {
        void var1_1;
        return x - var1_1;
    }

    static {
        for (char c = '\u0000'; c < CHAR_STRING_ARRAY.length; c = (char)(c + '\u0001')) {
            char c2 = c;
            CharUtils.CHAR_STRING_ARRAY[c2] = String.valueOf(c2);
        }
    }
}

