/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import org.apache.commons.lang3.CharSet;
import org.apache.commons.lang3.StringUtils;

public class CharSetUtils {
    public static boolean containsAny(String str, String ... set) {
        Object object;
        if (StringUtils.isEmpty(str) || CharSetUtils.deepEmpty(set)) {
            return false;
        }
        CharSet chars = CharSet.getInstance(set);
        char[] cArray = ((String)object).toCharArray();
        object = cArray;
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Object c = object[i];
            if (!chars.contains((char)c)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static int count(String str, String ... set) {
        void var2_2;
        Object object;
        if (StringUtils.isEmpty(str) || CharSetUtils.deepEmpty(set)) {
            return 0;
        }
        CharSet chars = CharSet.getInstance(set);
        int count = 0;
        char[] cArray = ((String)object).toCharArray();
        object = cArray;
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Object c = object[i];
            if (!chars.contains((char)c)) continue;
            ++count;
        }
        return (int)var2_2;
    }

    private static boolean deepEmpty(String[] strings) {
        if (strings != null) {
            String[] stringArray;
            for (String string : stringArray) {
                if (!StringUtils.isNotEmpty(string)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static String delete(String str, String ... set) {
        void var1_1;
        String string;
        if (StringUtils.isEmpty(str) || CharSetUtils.deepEmpty(set)) {
            return str;
        }
        return CharSetUtils.modify(string, (String[])var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public static String keep(String str, String ... set) {
        void var1_1;
        String string;
        if (str == null) {
            return null;
        }
        if (str.isEmpty() || CharSetUtils.deepEmpty(set)) {
            return "";
        }
        return CharSetUtils.modify(string, (String[])var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    private static String modify(String str, String[] set, boolean expect) {
        void var3_3;
        Object object;
        CharSet chars = CharSet.getInstance(set);
        StringBuilder buffer = new StringBuilder(str.length());
        char[] cArray = ((String)object).toCharArray();
        object = cArray;
        object = cArray;
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Object chr = object[i];
            if (chars.contains((char)chr) != expect) continue;
            buffer.append((char)chr);
        }
        return var3_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String squeeze(String str, String ... set) {
        void var2_2;
        if (StringUtils.isEmpty(str) || CharSetUtils.deepEmpty(set)) {
            return str;
        }
        CharSet chars = CharSet.getInstance(set);
        StringBuilder buffer = new StringBuilder(str.length());
        char[] cArray = str.toCharArray();
        Object chrs = cArray;
        int sz = cArray.length;
        Object lastChar = chrs[0];
        Character inChars = null;
        Character notInChars = null;
        buffer.append((char)lastChar);
        for (int i = 1; i < sz; ++i) {
            Object ch = chrs[i];
            if (ch == lastChar) {
                if (inChars != null && ch == inChars.charValue()) continue;
                if (notInChars == null || ch != notInChars.charValue()) {
                    if (chars.contains((char)ch)) {
                        inChars = Character.valueOf((char)ch);
                        continue;
                    }
                    notInChars = Character.valueOf((char)ch);
                }
            }
            buffer.append((char)ch);
            lastChar = ch;
        }
        return var2_2.toString();
    }
}

