/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.Validate;

final class CharRange
implements Serializable,
Iterable<Character> {
    private static final long serialVersionUID = 8270183163158333422L;
    private final char start;
    private final char end;
    private final boolean negated;
    private transient String iToString;
    static final CharRange[] EMPTY_ARRAY = new CharRange[0];

    /*
     * WARNING - void declaration
     */
    private CharRange(char start, char end, boolean negated) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (start > end) {
            char temp = start;
            start = end;
            end = temp;
        }
        this.start = var1_1;
        this.end = var2_2;
        this.negated = var3_3;
    }

    public static CharRange is(char ch) {
        char c;
        char c2 = c;
        return new CharRange(c2, c2, false);
    }

    public static CharRange isNot(char ch) {
        char c;
        char c2 = c;
        return new CharRange(c2, c2, true);
    }

    /*
     * WARNING - void declaration
     */
    public static CharRange isIn(char start, char end) {
        void var1_1;
        char c;
        return new CharRange(c, (char)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public static CharRange isNotIn(char start, char end) {
        void var1_1;
        char c;
        return new CharRange(c, (char)var1_1, true);
    }

    public final char getStart() {
        return this.start;
    }

    public final char getEnd() {
        return this.end;
    }

    public final boolean isNegated() {
        return this.negated;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean contains(char ch) {
        void var1_1;
        return (ch >= this.start && var1_1 <= this.end) != this.negated;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean contains(CharRange range) {
        void var1_1;
        Validate.notNull(range, "range", new Object[0]);
        if (this.negated) {
            if (range.negated) {
                return this.start >= range.start && this.end <= range.end;
            }
            return range.end < this.start || range.start > this.end;
        }
        if (range.negated) {
            return this.start == '\u0000' && this.end == '\uffff';
        }
        return this.start <= range.start && this.end >= var1_1.end;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object obj) {
        void var1_1;
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CharRange)) {
            return false;
        }
        CharRange other = (CharRange)obj;
        return this.start == other.start && this.end == other.end && this.negated == var1_1.negated;
    }

    public final int hashCode() {
        return 83 + this.start + 7 * this.end + (this.negated ? 1 : 0);
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        if (this.iToString == null) {
            void var1_1;
            StringBuilder buf = new StringBuilder(4);
            if (this.isNegated()) {
                buf.append('^');
            }
            buf.append(this.start);
            if (this.start != this.end) {
                buf.append('-');
                buf.append(this.end);
            }
            this.iToString = var1_1.toString();
        }
        return this.iToString;
    }

    @Override
    public final Iterator<Character> iterator() {
        return new CharacterIterator(this);
    }

    private static class CharacterIterator
    implements Iterator<Character> {
        private char current;
        private final CharRange range;
        private boolean hasNext;

        /*
         * WARNING - void declaration
         */
        private CharacterIterator(CharRange r) {
            void var1_1;
            this.range = var1_1;
            this.hasNext = true;
            if (this.range.negated) {
                if (this.range.start == '\u0000') {
                    if (this.range.end == '\uffff') {
                        this.hasNext = false;
                        return;
                    }
                    this.current = (char)(this.range.end + '\u0001');
                    return;
                }
                this.current = '\u0000';
                return;
            }
            this.current = this.range.start;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void prepareNext() {
            if (this.range.negated) {
                if (this.current != '\uffff') {
                    if (this.current + '\u0001' != this.range.start) {
                        this.current = (char)(this.current + '\u0001');
                        return;
                    }
                    if (this.range.end != '\uffff') {
                        this.current = (char)(this.range.end + '\u0001');
                        return;
                    }
                }
            } else if (this.current < this.range.end) {
                this.current = (char)(this.current + '\u0001');
                return;
            }
            this.hasNext = false;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Character next() {
            void var1_1;
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            char cur = this.current;
            this.prepareNext();
            return Character.valueOf((char)var1_1);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

