/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class BooleanUtils {
    public static final String FALSE = "false";
    public static final String NO = "no";
    public static final String OFF = "off";
    public static final String ON = "on";
    public static final String TRUE = "true";
    public static final String YES = "yes";

    public static boolean and(boolean ... array) {
        boolean[] blArray;
        ObjectUtils.requireNonEmpty(array, "array");
        for (boolean bl : blArray) {
            if (bl) continue;
            return false;
        }
        return true;
    }

    public static Boolean and(Boolean ... array) {
        ObjectUtils.requireNonEmpty(array, "array");
        try {
            Object[] objectArray;
            boolean[] blArray = ArrayUtils.toPrimitive(objectArray);
            objectArray = blArray;
            if (BooleanUtils.and(blArray)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalArgumentException("The array must not contain any null elements");
        }
    }

    public static Boolean[] booleanValues() {
        return new Boolean[]{Boolean.FALSE, Boolean.TRUE};
    }

    /*
     * WARNING - void declaration
     */
    public static int compare(boolean x, boolean y) {
        boolean bl;
        void var1_1;
        if (x == var1_1) {
            return 0;
        }
        if (bl) {
            return 1;
        }
        return -1;
    }

    public static boolean isFalse(Boolean bool) {
        Boolean bl;
        return Boolean.FALSE.equals(bl);
    }

    public static boolean isNotFalse(Boolean bool) {
        return !BooleanUtils.isFalse(bool);
    }

    public static boolean isNotTrue(Boolean bool) {
        return !BooleanUtils.isTrue(bool);
    }

    public static boolean isTrue(Boolean bool) {
        Boolean bl;
        return Boolean.TRUE.equals(bl);
    }

    public static Boolean negate(Boolean bool) {
        Boolean bl;
        if (bool == null) {
            return null;
        }
        if (bl.booleanValue()) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static boolean or(boolean ... array) {
        boolean[] blArray;
        ObjectUtils.requireNonEmpty(array, "array");
        for (boolean bl : blArray) {
            if (!bl) continue;
            return true;
        }
        return false;
    }

    public static Boolean or(Boolean ... array) {
        ObjectUtils.requireNonEmpty(array, "array");
        try {
            Object[] objectArray;
            boolean[] blArray = ArrayUtils.toPrimitive(objectArray);
            objectArray = blArray;
            if (BooleanUtils.or(blArray)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalArgumentException("The array must not contain any null elements");
        }
    }

    public static boolean[] primitiveValues() {
        return new boolean[]{false, true};
    }

    public static boolean toBoolean(Boolean bool) {
        Boolean bl;
        return bool != null && bl != false;
    }

    public static boolean toBoolean(int value) {
        return value != 0;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean toBoolean(int value, int trueValue, int falseValue) {
        void var2_2;
        int n;
        void var1_1;
        if (value == var1_1) {
            return true;
        }
        if (n == var2_2) {
            return false;
        }
        throw new IllegalArgumentException("The Integer did not match either specified value");
    }

    /*
     * WARNING - void declaration
     */
    public static boolean toBoolean(Integer value, Integer trueValue, Integer falseValue) {
        if (value == null) {
            if (trueValue == null) {
                return true;
            }
            if (falseValue == null) {
                return false;
            }
        } else {
            void var2_2;
            Integer n;
            void var1_1;
            if (value.equals(var1_1)) {
                return true;
            }
            if (n.equals(var2_2)) {
                return false;
            }
        }
        throw new IllegalArgumentException("The Integer did not match either specified value");
    }

    public static boolean toBoolean(String str) {
        return BooleanUtils.toBooleanObject(str) == Boolean.TRUE;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean toBoolean(String str, String trueString, String falseString) {
        if (str == trueString) {
            return true;
        }
        if (str == falseString) {
            return false;
        }
        if (str != null) {
            void var2_2;
            String string;
            void var1_1;
            if (str.equals(var1_1)) {
                return true;
            }
            if (string.equals(var2_2)) {
                return false;
            }
        }
        throw new IllegalArgumentException("The String did not match either specified value");
    }

    /*
     * WARNING - void declaration
     */
    public static boolean toBooleanDefaultIfNull(Boolean bool, boolean valueIfNull) {
        Boolean bl;
        if (bool == null) {
            void var1_1;
            return (boolean)var1_1;
        }
        return bl;
    }

    public static Boolean toBooleanObject(int value) {
        if (value == 0) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    /*
     * WARNING - void declaration
     */
    public static Boolean toBooleanObject(int value, int trueValue, int falseValue, int nullValue) {
        void var3_3;
        int n;
        void var2_2;
        void var1_1;
        if (value == var1_1) {
            return Boolean.TRUE;
        }
        if (value == var2_2) {
            return Boolean.FALSE;
        }
        if (n == var3_3) {
            return null;
        }
        throw new IllegalArgumentException("The Integer did not match any specified value");
    }

    public static Boolean toBooleanObject(Integer value) {
        Integer n;
        if (value == null) {
            return null;
        }
        if (n == 0) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    /*
     * WARNING - void declaration
     */
    public static Boolean toBooleanObject(Integer value, Integer trueValue, Integer falseValue, Integer nullValue) {
        if (value == null) {
            if (trueValue == null) {
                return Boolean.TRUE;
            }
            if (falseValue == null) {
                return Boolean.FALSE;
            }
            if (nullValue == null) {
                return null;
            }
        } else {
            void var3_3;
            Integer n;
            void var2_2;
            void var1_1;
            if (value.equals(var1_1)) {
                return Boolean.TRUE;
            }
            if (value.equals(var2_2)) {
                return Boolean.FALSE;
            }
            if (n.equals(var3_3)) {
                return null;
            }
        }
        throw new IllegalArgumentException("The Integer did not match any specified value");
    }

    /*
     * WARNING - void declaration
     */
    public static Boolean toBooleanObject(String str) {
        if (str == TRUE) {
            return Boolean.TRUE;
        }
        if (str == null) {
            return null;
        }
        switch (str.length()) {
            case 1: {
                char ch0 = str.charAt(0);
                if (ch0 == 'y' || ch0 == 'Y' || ch0 == 't' || ch0 == 'T' || ch0 == '1') {
                    return Boolean.TRUE;
                }
                if (ch0 != 'n' && ch0 != 'N' && ch0 != 'f' && ch0 != 'F' && ch0 != '0') break;
                return Boolean.FALSE;
            }
            case 2: {
                char ch0 = str.charAt(0);
                char ch1 = str.charAt(1);
                if (!(ch0 != 'o' && ch0 != 'O' || ch1 != 'n' && ch1 != 'N')) {
                    return Boolean.TRUE;
                }
                if (ch0 != 'n' && ch0 != 'N' || ch1 != 'o' && ch1 != 'O') break;
                return Boolean.FALSE;
            }
            case 3: {
                char ch0 = str.charAt(0);
                char ch1 = str.charAt(1);
                char ch2 = str.charAt(2);
                if (!(ch0 != 'y' && ch0 != 'Y' || ch1 != 'e' && ch1 != 'E' || ch2 != 's' && ch2 != 'S')) {
                    return Boolean.TRUE;
                }
                if (ch0 != 'o' && ch0 != 'O' || ch1 != 'f' && ch1 != 'F' || ch2 != 'f' && ch2 != 'F') break;
                return Boolean.FALSE;
            }
            case 4: {
                char ch0 = str.charAt(0);
                char ch1 = str.charAt(1);
                char ch2 = str.charAt(2);
                char ch3 = str.charAt(3);
                if (ch0 != 't' && ch0 != 'T' || ch1 != 'r' && ch1 != 'R' || ch2 != 'u' && ch2 != 'U' || ch3 != 'e' && ch3 != 'E') break;
                return Boolean.TRUE;
            }
            case 5: {
                void var0_1;
                void var3_13;
                void var2_10;
                void var1_6;
                char ch0 = str.charAt(0);
                char ch1 = str.charAt(1);
                char ch2 = str.charAt(2);
                char ch3 = str.charAt(3);
                char ch4 = str.charAt(4);
                if (ch0 != 'f' && var1_6 != 70 || ch1 != 'a' && var2_10 != 65 || ch2 != 'l' && var3_13 != 76 || ch3 != 's' && ch3 != 'S' || ch4 != 'e' && var0_1 != 69) break;
                return Boolean.FALSE;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static Boolean toBooleanObject(String str, String trueString, String falseString, String nullString) {
        if (str == null) {
            if (trueString == null) {
                return Boolean.TRUE;
            }
            if (falseString == null) {
                return Boolean.FALSE;
            }
            if (nullString == null) {
                return null;
            }
        } else {
            void var3_3;
            String string;
            void var2_2;
            void var1_1;
            if (str.equals(var1_1)) {
                return Boolean.TRUE;
            }
            if (str.equals(var2_2)) {
                return Boolean.FALSE;
            }
            if (string.equals(var3_3)) {
                return null;
            }
        }
        throw new IllegalArgumentException("The String did not match any specified value");
    }

    public static int toInteger(boolean bool) {
        if (bool) {
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public static int toInteger(boolean bool, int trueValue, int falseValue) {
        void var2_2;
        if (bool) {
            void var1_1;
            return (int)var1_1;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static int toInteger(Boolean bool, int trueValue, int falseValue, int nullValue) {
        void var2_2;
        Boolean bl;
        if (bool == null) {
            void var3_3;
            return (int)var3_3;
        }
        if (bl.booleanValue()) {
            void var1_1;
            return (int)var1_1;
        }
        return (int)var2_2;
    }

    public static Integer toIntegerObject(boolean bool) {
        if (bool) {
            return NumberUtils.INTEGER_ONE;
        }
        return NumberUtils.INTEGER_ZERO;
    }

    /*
     * WARNING - void declaration
     */
    public static Integer toIntegerObject(boolean bool, Integer trueValue, Integer falseValue) {
        void var2_2;
        if (bool) {
            void var1_1;
            return var1_1;
        }
        return var2_2;
    }

    public static Integer toIntegerObject(Boolean bool) {
        Boolean bl;
        if (bool == null) {
            return null;
        }
        if (bl.booleanValue()) {
            return NumberUtils.INTEGER_ONE;
        }
        return NumberUtils.INTEGER_ZERO;
    }

    /*
     * WARNING - void declaration
     */
    public static Integer toIntegerObject(Boolean bool, Integer trueValue, Integer falseValue, Integer nullValue) {
        void var2_2;
        Boolean bl;
        if (bool == null) {
            void var3_3;
            return var3_3;
        }
        if (bl.booleanValue()) {
            void var1_1;
            return var1_1;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static String toString(boolean bool, String trueString, String falseString) {
        void var2_2;
        if (bool) {
            void var1_1;
            return var1_1;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static String toString(Boolean bool, String trueString, String falseString, String nullString) {
        void var2_2;
        Boolean bl;
        if (bool == null) {
            void var3_3;
            return var3_3;
        }
        if (bl.booleanValue()) {
            void var1_1;
            return var1_1;
        }
        return var2_2;
    }

    public static String toStringOnOff(boolean bool) {
        return BooleanUtils.toString(bool, ON, OFF);
    }

    public static String toStringOnOff(Boolean bool) {
        return BooleanUtils.toString(bool, ON, OFF, null);
    }

    public static String toStringTrueFalse(boolean bool) {
        return BooleanUtils.toString(bool, TRUE, FALSE);
    }

    public static String toStringTrueFalse(Boolean bool) {
        return BooleanUtils.toString(bool, TRUE, FALSE, null);
    }

    public static String toStringYesNo(boolean bool) {
        return BooleanUtils.toString(bool, YES, NO);
    }

    public static String toStringYesNo(Boolean bool) {
        return BooleanUtils.toString(bool, YES, NO, null);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean xor(boolean ... array) {
        void var1_1;
        boolean[] blArray;
        ObjectUtils.requireNonEmpty(array, "array");
        boolean result = false;
        for (boolean element : blArray) {
            result ^= element;
        }
        return (boolean)var1_1;
    }

    public static Boolean xor(Boolean ... array) {
        ObjectUtils.requireNonEmpty(array, "array");
        try {
            Object[] objectArray;
            boolean[] blArray = ArrayUtils.toPrimitive(objectArray);
            objectArray = blArray;
            if (BooleanUtils.xor(blArray)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalArgumentException("The array must not contain any null elements");
        }
    }
}

