/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.commons.lang3.ArraySorter;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.CharUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.mutable.MutableInt;

public class ArrayUtils {
    public static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
    public static final Boolean[] EMPTY_BOOLEAN_OBJECT_ARRAY = new Boolean[0];
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final Byte[] EMPTY_BYTE_OBJECT_ARRAY = new Byte[0];
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final Character[] EMPTY_CHARACTER_OBJECT_ARRAY = new Character[0];
    public static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    public static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    public static final Double[] EMPTY_DOUBLE_OBJECT_ARRAY = new Double[0];
    public static final Field[] EMPTY_FIELD_ARRAY = new Field[0];
    public static final float[] EMPTY_FLOAT_ARRAY = new float[0];
    public static final Float[] EMPTY_FLOAT_OBJECT_ARRAY = new Float[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final Integer[] EMPTY_INTEGER_OBJECT_ARRAY = new Integer[0];
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    public static final Long[] EMPTY_LONG_OBJECT_ARRAY = new Long[0];
    public static final Method[] EMPTY_METHOD_ARRAY = new Method[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final short[] EMPTY_SHORT_ARRAY = new short[0];
    public static final Short[] EMPTY_SHORT_OBJECT_ARRAY = new Short[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final Throwable[] EMPTY_THROWABLE_ARRAY = new Throwable[0];
    public static final Type[] EMPTY_TYPE_ARRAY = new Type[0];
    public static final int INDEX_NOT_FOUND = -1;

    /*
     * WARNING - void declaration
     */
    public static boolean[] add(boolean[] array, boolean element) {
        boolean[] blArray;
        void var1_1;
        boolean[] blArray2 = (boolean[])ArrayUtils.copyArrayGrow1(array, Boolean.TYPE);
        boolean[] newArray = blArray2;
        blArray2[newArray.length - 1] = var1_1;
        return blArray;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static boolean[] add(boolean[] array, int index, boolean element) {
        void var2_2;
        void var1_1;
        return (boolean[])ArrayUtils.add(array, (int)var1_1, (boolean)var2_2, Boolean.TYPE);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] add(byte[] array, byte element) {
        byte[] byArray;
        void var1_1;
        byte[] byArray2 = (byte[])ArrayUtils.copyArrayGrow1(array, Byte.TYPE);
        byte[] newArray = byArray2;
        byArray2[newArray.length - 1] = var1_1;
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static byte[] add(byte[] array, int index, byte element) {
        void var2_2;
        void var1_1;
        return (byte[])ArrayUtils.add(array, (int)var1_1, (byte)var2_2, Byte.TYPE);
    }

    /*
     * WARNING - void declaration
     */
    public static char[] add(char[] array, char element) {
        char[] cArray;
        void var1_1;
        char[] cArray2 = (char[])ArrayUtils.copyArrayGrow1(array, Character.TYPE);
        char[] newArray = cArray2;
        cArray2[newArray.length - 1] = var1_1;
        return cArray;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static char[] add(char[] array, int index, char element) {
        void var2_2;
        void var1_1;
        return (char[])ArrayUtils.add(array, (int)var1_1, Character.valueOf((char)var2_2), Character.TYPE);
    }

    /*
     * WARNING - void declaration
     */
    public static double[] add(double[] array, double element) {
        double[] dArray;
        void var1_1;
        double[] dArray2 = (double[])ArrayUtils.copyArrayGrow1(array, Double.TYPE);
        double[] newArray = dArray2;
        dArray2[newArray.length - 1] = var1_1;
        return dArray;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static double[] add(double[] array, int index, double element) {
        void var2_2;
        void var1_1;
        return (double[])ArrayUtils.add(array, (int)var1_1, (double)var2_2, Double.TYPE);
    }

    /*
     * WARNING - void declaration
     */
    public static float[] add(float[] array, float element) {
        float[] fArray;
        void var1_1;
        float[] fArray2 = (float[])ArrayUtils.copyArrayGrow1(array, Float.TYPE);
        float[] newArray = fArray2;
        fArray2[newArray.length - 1] = var1_1;
        return fArray;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static float[] add(float[] array, int index, float element) {
        void var2_2;
        void var1_1;
        return (float[])ArrayUtils.add(array, (int)var1_1, Float.valueOf((float)var2_2), Float.TYPE);
    }

    /*
     * WARNING - void declaration
     */
    public static int[] add(int[] array, int element) {
        int[] nArray;
        void var1_1;
        int[] nArray2 = (int[])ArrayUtils.copyArrayGrow1(array, Integer.TYPE);
        int[] newArray = nArray2;
        nArray2[newArray.length - 1] = var1_1;
        return nArray;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static int[] add(int[] array, int index, int element) {
        void var2_2;
        void var1_1;
        return (int[])ArrayUtils.add(array, (int)var1_1, (int)var2_2, Integer.TYPE);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static long[] add(long[] array, int index, long element) {
        void var2_2;
        void var1_1;
        return (long[])ArrayUtils.add(array, (int)var1_1, (long)var2_2, Long.TYPE);
    }

    /*
     * WARNING - void declaration
     */
    public static long[] add(long[] array, long element) {
        long[] lArray;
        void var1_1;
        long[] lArray2 = (long[])ArrayUtils.copyArrayGrow1(array, Long.TYPE);
        long[] newArray = lArray2;
        lArray2[newArray.length - 1] = var1_1;
        return lArray;
    }

    /*
     * WARNING - void declaration
     */
    private static Object add(Object array, int index, Object element, Class<?> clss) {
        void var3_3;
        void var2_2;
        if (array == null) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Length: 0");
            }
            Object joinedArray = Array.newInstance(clss, 1);
            Array.set(joinedArray, 0, element);
            return joinedArray;
        }
        int length = Array.getLength(array);
        if (index > length || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + length);
        }
        Object result = Array.newInstance(clss, length + 1);
        System.arraycopy(array, 0, result, 0, index);
        Array.set(result, index, var2_2);
        if (index < length) {
            void var1_1;
            Object object;
            System.arraycopy(object, index, result, index + 1, length - var1_1);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static short[] add(short[] array, int index, short element) {
        void var2_2;
        void var1_1;
        return (short[])ArrayUtils.add(array, (int)var1_1, (short)var2_2, Short.TYPE);
    }

    /*
     * WARNING - void declaration
     */
    public static short[] add(short[] array, short element) {
        short[] sArray;
        void var1_1;
        short[] sArray2 = (short[])ArrayUtils.copyArrayGrow1(array, Short.TYPE);
        short[] newArray = sArray2;
        sArray2[newArray.length - 1] = var1_1;
        return sArray;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static <T> T[] add(T[] array, int index, T element) {
        void var3_3;
        void var2_2;
        void var1_1;
        Object[] objectArray;
        Class<?> clss;
        if (array != null) {
            clss = array.getClass().getComponentType();
        } else if (element != null) {
            clss = element.getClass();
        } else {
            throw new IllegalArgumentException("Array and element cannot both be null");
        }
        objectArray = (Object[])ArrayUtils.add(objectArray, (int)var1_1, var2_2, var3_3);
        return objectArray;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] add(T[] array, T element) {
        Object[] objectArray;
        void var1_1;
        void var2_2;
        Class<?> type;
        if (array != null) {
            type = array.getClass().getComponentType();
        } else if (element != null) {
            type = element.getClass();
        } else {
            throw new IllegalArgumentException("Arguments cannot both be null");
        }
        Object[] objectArray2 = (Object[])ArrayUtils.copyArrayGrow1(array, var2_2);
        Object[] newArray = objectArray2;
        objectArray2[newArray.length - 1] = var1_1;
        return objectArray;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean[] addAll(boolean[] array1, boolean ... array2) {
        void var2_2;
        void var1_1;
        boolean[] blArray;
        if (array1 == null) {
            return ArrayUtils.clone(array2);
        }
        if (array2 == null) {
            return ArrayUtils.clone(array1);
        }
        boolean[] joinedArray = new boolean[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, blArray.length, ((void)var1_1).length);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] addAll(byte[] array1, byte ... array2) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        if (array1 == null) {
            return ArrayUtils.clone(array2);
        }
        if (array2 == null) {
            return ArrayUtils.clone(array1);
        }
        byte[] joinedArray = new byte[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, byArray.length, ((void)var1_1).length);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static char[] addAll(char[] array1, char ... array2) {
        void var2_2;
        void var1_1;
        char[] cArray;
        if (array1 == null) {
            return ArrayUtils.clone(array2);
        }
        if (array2 == null) {
            return ArrayUtils.clone(array1);
        }
        char[] joinedArray = new char[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, cArray.length, ((void)var1_1).length);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static double[] addAll(double[] array1, double ... array2) {
        void var2_2;
        void var1_1;
        double[] dArray;
        if (array1 == null) {
            return ArrayUtils.clone(array2);
        }
        if (array2 == null) {
            return ArrayUtils.clone(array1);
        }
        double[] joinedArray = new double[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, dArray.length, ((void)var1_1).length);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static float[] addAll(float[] array1, float ... array2) {
        void var2_2;
        void var1_1;
        float[] fArray;
        if (array1 == null) {
            return ArrayUtils.clone(array2);
        }
        if (array2 == null) {
            return ArrayUtils.clone(array1);
        }
        float[] joinedArray = new float[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, fArray.length, ((void)var1_1).length);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static int[] addAll(int[] array1, int ... array2) {
        void var2_2;
        void var1_1;
        int[] nArray;
        if (array1 == null) {
            return ArrayUtils.clone(array2);
        }
        if (array2 == null) {
            return ArrayUtils.clone(array1);
        }
        int[] joinedArray = new int[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, nArray.length, ((void)var1_1).length);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static long[] addAll(long[] array1, long ... array2) {
        void var2_2;
        void var1_1;
        long[] lArray;
        if (array1 == null) {
            return ArrayUtils.clone(array2);
        }
        if (array2 == null) {
            return ArrayUtils.clone(array1);
        }
        long[] joinedArray = new long[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, lArray.length, ((void)var1_1).length);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static short[] addAll(short[] array1, short ... array2) {
        void var2_2;
        void var1_1;
        short[] sArray;
        if (array1 == null) {
            return ArrayUtils.clone(array2);
        }
        if (array2 == null) {
            return ArrayUtils.clone(array1);
        }
        short[] joinedArray = new short[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, sArray.length, ((void)var1_1).length);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] addAll(T[] array1, T ... array2) {
        void var3_4;
        if (array1 == null) {
            return ArrayUtils.clone(array2);
        }
        if (array2 == null) {
            return ArrayUtils.clone(array1);
        }
        Class<?> type1 = array1.getClass().getComponentType();
        Object[] joinedArray = (Object[])Array.newInstance(type1, array1.length + array2.length);
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        try {
            System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        }
        catch (ArrayStoreException ase) {
            void var0_1;
            Class<?> type2 = array2.getClass().getComponentType();
            if (!type1.isAssignableFrom(type2)) {
                void var2_3;
                void var1_2;
                throw new IllegalArgumentException("Cannot store " + var1_2.getName() + " in an array of " + var2_3.getName(), ase);
            }
            throw var0_1;
        }
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean[] addFirst(boolean[] array, boolean element) {
        void var1_1;
        boolean[] blArray;
        if (array == null) {
            return ArrayUtils.add(array, element);
        }
        return ArrayUtils.insert(0, blArray, new boolean[]{var1_1});
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] addFirst(byte[] array, byte element) {
        void var1_1;
        byte[] byArray;
        if (array == null) {
            return ArrayUtils.add(array, element);
        }
        return ArrayUtils.insert(0, byArray, new byte[]{var1_1});
    }

    /*
     * WARNING - void declaration
     */
    public static char[] addFirst(char[] array, char element) {
        void var1_1;
        char[] cArray;
        if (array == null) {
            return ArrayUtils.add(array, element);
        }
        return ArrayUtils.insert(0, cArray, new char[]{var1_1});
    }

    /*
     * WARNING - void declaration
     */
    public static double[] addFirst(double[] array, double element) {
        void var1_1;
        double[] dArray;
        if (array == null) {
            return ArrayUtils.add(array, element);
        }
        return ArrayUtils.insert(0, dArray, new double[]{var1_1});
    }

    /*
     * WARNING - void declaration
     */
    public static float[] addFirst(float[] array, float element) {
        void var1_1;
        float[] fArray;
        if (array == null) {
            return ArrayUtils.add(array, element);
        }
        return ArrayUtils.insert(0, fArray, new float[]{var1_1});
    }

    /*
     * WARNING - void declaration
     */
    public static int[] addFirst(int[] array, int element) {
        void var1_1;
        int[] nArray;
        if (array == null) {
            return ArrayUtils.add(array, element);
        }
        return ArrayUtils.insert(0, nArray, new int[]{var1_1});
    }

    /*
     * WARNING - void declaration
     */
    public static long[] addFirst(long[] array, long element) {
        void var1_1;
        long[] lArray;
        if (array == null) {
            return ArrayUtils.add(array, element);
        }
        return ArrayUtils.insert(0, lArray, new long[]{var1_1});
    }

    /*
     * WARNING - void declaration
     */
    public static short[] addFirst(short[] array, short element) {
        void var1_1;
        short[] sArray;
        if (array == null) {
            return ArrayUtils.add(array, element);
        }
        return ArrayUtils.insert(0, sArray, new short[]{var1_1});
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] addFirst(T[] array, T element) {
        void var1_1;
        T[] TArray;
        if (array == null) {
            return ArrayUtils.add(array, element);
        }
        return ArrayUtils.insert(0, TArray, var1_1);
    }

    public static boolean[] clone(boolean[] array) {
        boolean[] blArray;
        if (array == null) {
            return null;
        }
        return (boolean[])blArray.clone();
    }

    public static byte[] clone(byte[] array) {
        byte[] byArray;
        if (array == null) {
            return null;
        }
        return (byte[])byArray.clone();
    }

    public static char[] clone(char[] array) {
        char[] cArray;
        if (array == null) {
            return null;
        }
        return (char[])cArray.clone();
    }

    public static double[] clone(double[] array) {
        double[] dArray;
        if (array == null) {
            return null;
        }
        return (double[])dArray.clone();
    }

    public static float[] clone(float[] array) {
        float[] fArray;
        if (array == null) {
            return null;
        }
        return (float[])fArray.clone();
    }

    public static int[] clone(int[] array) {
        int[] nArray;
        if (array == null) {
            return null;
        }
        return (int[])nArray.clone();
    }

    public static long[] clone(long[] array) {
        long[] lArray;
        if (array == null) {
            return null;
        }
        return (long[])lArray.clone();
    }

    public static short[] clone(short[] array) {
        short[] sArray;
        if (array == null) {
            return null;
        }
        return (short[])sArray.clone();
    }

    public static <T> T[] clone(T[] array) {
        T[] TArray;
        if (array == null) {
            return null;
        }
        return (Object[])TArray.clone();
    }

    /*
     * WARNING - void declaration
     */
    public static boolean contains(boolean[] array, boolean valueToFind) {
        void var1_1;
        return ArrayUtils.indexOf(array, (boolean)var1_1) != -1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean contains(byte[] array, byte valueToFind) {
        void var1_1;
        return ArrayUtils.indexOf(array, (byte)var1_1) != -1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean contains(char[] array, char valueToFind) {
        void var1_1;
        return ArrayUtils.indexOf(array, (char)var1_1) != -1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean contains(double[] array, double valueToFind) {
        void var1_1;
        return ArrayUtils.indexOf(array, (double)var1_1) != -1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean contains(double[] array, double valueToFind, double tolerance) {
        void var3_2;
        void var1_1;
        return ArrayUtils.indexOf(array, (double)var1_1, 0, (double)var3_2) != -1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean contains(float[] array, float valueToFind) {
        void var1_1;
        return ArrayUtils.indexOf(array, (float)var1_1) != -1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean contains(int[] array, int valueToFind) {
        void var1_1;
        return ArrayUtils.indexOf(array, (int)var1_1) != -1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean contains(long[] array, long valueToFind) {
        void var1_1;
        return ArrayUtils.indexOf(array, (long)var1_1) != -1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean contains(Object[] array, Object objectToFind) {
        void var1_1;
        return ArrayUtils.indexOf(array, var1_1) != -1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean contains(short[] array, short valueToFind) {
        void var1_1;
        return ArrayUtils.indexOf(array, (short)var1_1) != -1;
    }

    /*
     * WARNING - void declaration
     */
    private static Object copyArrayGrow1(Object array, Class<?> newArrayComponentType) {
        void var1_1;
        if (array != null) {
            void var2_3;
            void var1_2;
            Object object;
            int arrayLength = Array.getLength(array);
            Object newArray = Array.newInstance(array.getClass().getComponentType(), arrayLength + 1);
            System.arraycopy(object, 0, newArray, 0, (int)var1_2);
            return var2_3;
        }
        return Array.newInstance(var1_1, 1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T get(T[] array, int index) {
        void var1_1;
        return ArrayUtils.get(array, (int)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T get(T[] array, int index, T defaultValue) {
        void var2_2;
        if (ArrayUtils.isArrayIndexValid(array, index)) {
            void var1_1;
            T[] TArray;
            return TArray[var1_1];
        }
        return var2_2;
    }

    public static int getLength(Object array) {
        Object object;
        if (array == null) {
            return 0;
        }
        return Array.getLength(object);
    }

    public static int hashCode(Object array) {
        Object object;
        return new HashCodeBuilder().append(object).toHashCode();
    }

    /*
     * WARNING - void declaration
     */
    public static BitSet indexesOf(boolean[] array, boolean valueToFind) {
        void var1_1;
        return ArrayUtils.indexesOf(array, (boolean)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static BitSet indexesOf(boolean[] array, boolean valueToFind, int startIndex) {
        void var3_3;
        BitSet bitSet = new BitSet();
        if (array == null) {
            return bitSet;
        }
        while (startIndex < array.length && (startIndex = ArrayUtils.indexOf(array, valueToFind, startIndex)) != -1) {
            bitSet.set(startIndex);
            ++startIndex;
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static BitSet indexesOf(byte[] array, byte valueToFind) {
        void var1_1;
        return ArrayUtils.indexesOf(array, (byte)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static BitSet indexesOf(byte[] array, byte valueToFind, int startIndex) {
        void var3_3;
        BitSet bitSet = new BitSet();
        if (array == null) {
            return bitSet;
        }
        while (startIndex < array.length && (startIndex = ArrayUtils.indexOf(array, valueToFind, startIndex)) != -1) {
            bitSet.set(startIndex);
            ++startIndex;
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static BitSet indexesOf(char[] array, char valueToFind) {
        void var1_1;
        return ArrayUtils.indexesOf(array, (char)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static BitSet indexesOf(char[] array, char valueToFind, int startIndex) {
        void var3_3;
        BitSet bitSet = new BitSet();
        if (array == null) {
            return bitSet;
        }
        while (startIndex < array.length && (startIndex = ArrayUtils.indexOf(array, valueToFind, startIndex)) != -1) {
            bitSet.set(startIndex);
            ++startIndex;
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static BitSet indexesOf(double[] array, double valueToFind) {
        void var1_1;
        return ArrayUtils.indexesOf(array, (double)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static BitSet indexesOf(double[] array, double valueToFind, double tolerance) {
        void var3_2;
        void var1_1;
        return ArrayUtils.indexesOf(array, (double)var1_1, 0, (double)var3_2);
    }

    public static BitSet indexesOf(double[] array, double valueToFind, int startIndex) {
        BitSet bitSet = new BitSet();
        if (array == null) {
            return bitSet;
        }
        while (startIndex < array.length && (startIndex = ArrayUtils.indexOf(array, valueToFind, startIndex)) != -1) {
            bitSet.set(startIndex);
            ++startIndex;
        }
        return bitSet;
    }

    public static BitSet indexesOf(double[] array, double valueToFind, int startIndex, double tolerance) {
        BitSet bitSet = new BitSet();
        if (array == null) {
            return bitSet;
        }
        while (startIndex < array.length && (startIndex = ArrayUtils.indexOf(array, valueToFind, startIndex, tolerance)) != -1) {
            bitSet.set(startIndex);
            ++startIndex;
        }
        return bitSet;
    }

    /*
     * WARNING - void declaration
     */
    public static BitSet indexesOf(float[] array, float valueToFind) {
        void var1_1;
        return ArrayUtils.indexesOf(array, (float)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static BitSet indexesOf(float[] array, float valueToFind, int startIndex) {
        void var3_3;
        BitSet bitSet = new BitSet();
        if (array == null) {
            return bitSet;
        }
        while (startIndex < array.length && (startIndex = ArrayUtils.indexOf(array, valueToFind, startIndex)) != -1) {
            bitSet.set(startIndex);
            ++startIndex;
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static BitSet indexesOf(int[] array, int valueToFind) {
        void var1_1;
        return ArrayUtils.indexesOf(array, (int)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static BitSet indexesOf(int[] array, int valueToFind, int startIndex) {
        void var3_3;
        BitSet bitSet = new BitSet();
        if (array == null) {
            return bitSet;
        }
        while (startIndex < array.length && (startIndex = ArrayUtils.indexOf(array, valueToFind, startIndex)) != -1) {
            bitSet.set(startIndex);
            ++startIndex;
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static BitSet indexesOf(long[] array, long valueToFind) {
        void var1_1;
        return ArrayUtils.indexesOf(array, (long)var1_1, 0);
    }

    public static BitSet indexesOf(long[] array, long valueToFind, int startIndex) {
        BitSet bitSet = new BitSet();
        if (array == null) {
            return bitSet;
        }
        while (startIndex < array.length && (startIndex = ArrayUtils.indexOf(array, valueToFind, startIndex)) != -1) {
            bitSet.set(startIndex);
            ++startIndex;
        }
        return bitSet;
    }

    /*
     * WARNING - void declaration
     */
    public static BitSet indexesOf(Object[] array, Object objectToFind) {
        void var1_1;
        return ArrayUtils.indexesOf(array, var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static BitSet indexesOf(Object[] array, Object objectToFind, int startIndex) {
        void var3_3;
        BitSet bitSet = new BitSet();
        if (array == null) {
            return bitSet;
        }
        while (startIndex < array.length && (startIndex = ArrayUtils.indexOf(array, objectToFind, startIndex)) != -1) {
            bitSet.set(startIndex);
            ++startIndex;
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static BitSet indexesOf(short[] array, short valueToFind) {
        void var1_1;
        return ArrayUtils.indexesOf(array, (short)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static BitSet indexesOf(short[] array, short valueToFind, int startIndex) {
        void var3_3;
        BitSet bitSet = new BitSet();
        if (array == null) {
            return bitSet;
        }
        while (startIndex < array.length && (startIndex = ArrayUtils.indexOf(array, valueToFind, startIndex)) != -1) {
            bitSet.set(startIndex);
            ++startIndex;
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(boolean[] array, boolean valueToFind) {
        void var1_1;
        return ArrayUtils.indexOf(array, (boolean)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(boolean[] array, boolean valueToFind, int startIndex) {
        void i;
        if (ArrayUtils.isEmpty(array)) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        while (i < array.length) {
            if (valueToFind == array[i]) {
                return (int)i;
            }
            ++i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(byte[] array, byte valueToFind) {
        void var1_1;
        return ArrayUtils.indexOf(array, (byte)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(byte[] array, byte valueToFind, int startIndex) {
        void i;
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        while (i < array.length) {
            if (valueToFind == array[i]) {
                return (int)i;
            }
            ++i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(char[] array, char valueToFind) {
        void var1_1;
        return ArrayUtils.indexOf(array, (char)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(char[] array, char valueToFind, int startIndex) {
        void i;
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        while (i < array.length) {
            if (valueToFind == array[i]) {
                return (int)i;
            }
            ++i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(double[] array, double valueToFind) {
        void var1_1;
        return ArrayUtils.indexOf(array, (double)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(double[] array, double valueToFind, double tolerance) {
        void var3_2;
        void var1_1;
        return ArrayUtils.indexOf(array, (double)var1_1, 0, (double)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(double[] array, double valueToFind, int startIndex) {
        void i;
        if (ArrayUtils.isEmpty(array)) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        boolean searchNaN = Double.isNaN(valueToFind);
        while (i < array.length) {
            double element = array[i];
            if (valueToFind == element || searchNaN && Double.isNaN(element)) {
                return (int)i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(double[] array, double valueToFind, int startIndex, double tolerance) {
        if (ArrayUtils.isEmpty(array)) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        double min = valueToFind - tolerance;
        double max = valueToFind + tolerance;
        for (void i = var3_3; i < array.length; ++i) {
            if (!(array[i] >= min) || !(array[i] <= max)) continue;
            return (int)i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(float[] array, float valueToFind) {
        void var1_1;
        return ArrayUtils.indexOf(array, (float)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(float[] array, float valueToFind, int startIndex) {
        void i;
        if (ArrayUtils.isEmpty(array)) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        boolean searchNaN = Float.isNaN(valueToFind);
        while (i < array.length) {
            float element = array[i];
            if (valueToFind == element || searchNaN && Float.isNaN(element)) {
                return (int)i;
            }
            ++i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(int[] array, int valueToFind) {
        void var1_1;
        return ArrayUtils.indexOf(array, (int)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(int[] array, int valueToFind, int startIndex) {
        void i;
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        while (i < array.length) {
            if (valueToFind == array[i]) {
                return (int)i;
            }
            ++i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(long[] array, long valueToFind) {
        void var1_1;
        return ArrayUtils.indexOf(array, (long)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(long[] array, long valueToFind, int startIndex) {
        void i;
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        while (i < array.length) {
            if (valueToFind == array[i]) {
                return (int)i;
            }
            ++i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(Object[] array, Object objectToFind) {
        void var1_1;
        return ArrayUtils.indexOf(array, var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(Object[] array, Object objectToFind, int startIndex) {
        void i;
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (objectToFind == null) {
            while (i < array.length) {
                if (array[i] == null) {
                    return (int)i;
                }
                ++i;
            }
        } else {
            while (i < array.length) {
                if (objectToFind.equals(array[i])) {
                    return (int)i;
                }
                ++i;
            }
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(short[] array, short valueToFind) {
        void var1_1;
        return ArrayUtils.indexOf(array, (short)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(short[] array, short valueToFind, int startIndex) {
        void i;
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        while (i < array.length) {
            if (valueToFind == array[i]) {
                return (int)i;
            }
            ++i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean[] insert(int index, boolean[] array, boolean ... values) {
        void var3_3;
        if (array == null) {
            return null;
        }
        if (ArrayUtils.isEmpty(values)) {
            return ArrayUtils.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        boolean[] result = new boolean[array.length + values.length];
        System.arraycopy(values, 0, result, index, values.length);
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        if (index < array.length) {
            int n;
            void var1_1;
            void var2_2;
            System.arraycopy(array, index, result, index + ((void)var2_2).length, ((void)var1_1).length - n);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] insert(int index, byte[] array, byte ... values) {
        void var3_3;
        if (array == null) {
            return null;
        }
        if (ArrayUtils.isEmpty(values)) {
            return ArrayUtils.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        byte[] result = new byte[array.length + values.length];
        System.arraycopy(values, 0, result, index, values.length);
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        if (index < array.length) {
            int n;
            void var1_1;
            void var2_2;
            System.arraycopy(array, index, result, index + ((void)var2_2).length, ((void)var1_1).length - n);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static char[] insert(int index, char[] array, char ... values) {
        void var3_3;
        if (array == null) {
            return null;
        }
        if (ArrayUtils.isEmpty(values)) {
            return ArrayUtils.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        char[] result = new char[array.length + values.length];
        System.arraycopy(values, 0, result, index, values.length);
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        if (index < array.length) {
            int n;
            void var1_1;
            void var2_2;
            System.arraycopy(array, index, result, index + ((void)var2_2).length, ((void)var1_1).length - n);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static double[] insert(int index, double[] array, double ... values) {
        void var3_3;
        if (array == null) {
            return null;
        }
        if (ArrayUtils.isEmpty(values)) {
            return ArrayUtils.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        double[] result = new double[array.length + values.length];
        System.arraycopy(values, 0, result, index, values.length);
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        if (index < array.length) {
            int n;
            void var1_1;
            void var2_2;
            System.arraycopy(array, index, result, index + ((void)var2_2).length, ((void)var1_1).length - n);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static float[] insert(int index, float[] array, float ... values) {
        void var3_3;
        if (array == null) {
            return null;
        }
        if (ArrayUtils.isEmpty(values)) {
            return ArrayUtils.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        float[] result = new float[array.length + values.length];
        System.arraycopy(values, 0, result, index, values.length);
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        if (index < array.length) {
            int n;
            void var1_1;
            void var2_2;
            System.arraycopy(array, index, result, index + ((void)var2_2).length, ((void)var1_1).length - n);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static int[] insert(int index, int[] array, int ... values) {
        void var3_3;
        if (array == null) {
            return null;
        }
        if (ArrayUtils.isEmpty(values)) {
            return ArrayUtils.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        int[] result = new int[array.length + values.length];
        System.arraycopy(values, 0, result, index, values.length);
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        if (index < array.length) {
            int n;
            void var1_1;
            void var2_2;
            System.arraycopy(array, index, result, index + ((void)var2_2).length, ((void)var1_1).length - n);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static long[] insert(int index, long[] array, long ... values) {
        void var3_3;
        if (array == null) {
            return null;
        }
        if (ArrayUtils.isEmpty(values)) {
            return ArrayUtils.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        long[] result = new long[array.length + values.length];
        System.arraycopy(values, 0, result, index, values.length);
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        if (index < array.length) {
            int n;
            void var1_1;
            void var2_2;
            System.arraycopy(array, index, result, index + ((void)var2_2).length, ((void)var1_1).length - n);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static short[] insert(int index, short[] array, short ... values) {
        void var3_3;
        if (array == null) {
            return null;
        }
        if (ArrayUtils.isEmpty(values)) {
            return ArrayUtils.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        short[] result = new short[array.length + values.length];
        System.arraycopy(values, 0, result, index, values.length);
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        if (index < array.length) {
            int n;
            void var1_1;
            void var2_2;
            System.arraycopy(array, index, result, index + ((void)var2_2).length, ((void)var1_1).length - n);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public static <T> T[] insert(int index, T[] array, T ... values) {
        if (array == null) {
            return null;
        }
        if (ArrayUtils.isEmpty(values)) {
            return ArrayUtils.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        Class<?> clazz = array.getClass().getComponentType();
        Object[] result = (Object[])Array.newInstance(clazz, array.length + values.length);
        System.arraycopy(values, 0, result, index, values.length);
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        if (index < array.length) {
            int n;
            void var1_1;
            void var2_2;
            System.arraycopy(array, index, result, index + ((void)var2_2).length, ((void)var1_1).length - n);
        }
        return clazz;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> boolean isArrayIndexValid(T[] array, int index) {
        void var1_1;
        T[] TArray;
        return index >= 0 && ArrayUtils.getLength(TArray) > var1_1;
    }

    public static boolean isEmpty(boolean[] array) {
        return ArrayUtils.getLength(array) == 0;
    }

    public static boolean isEmpty(byte[] array) {
        return ArrayUtils.getLength(array) == 0;
    }

    public static boolean isEmpty(char[] array) {
        return ArrayUtils.getLength(array) == 0;
    }

    public static boolean isEmpty(double[] array) {
        return ArrayUtils.getLength(array) == 0;
    }

    public static boolean isEmpty(float[] array) {
        return ArrayUtils.getLength(array) == 0;
    }

    public static boolean isEmpty(int[] array) {
        return ArrayUtils.getLength(array) == 0;
    }

    public static boolean isEmpty(long[] array) {
        return ArrayUtils.getLength(array) == 0;
    }

    public static boolean isEmpty(Object[] array) {
        return ArrayUtils.getLength(array) == 0;
    }

    public static boolean isEmpty(short[] array) {
        return ArrayUtils.getLength(array) == 0;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static boolean isEquals(Object array1, Object array2) {
        void var1_1;
        Object object;
        return new EqualsBuilder().append(object, var1_1).isEquals();
    }

    public static boolean isNotEmpty(boolean[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static boolean isNotEmpty(byte[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static boolean isNotEmpty(char[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static boolean isNotEmpty(double[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static boolean isNotEmpty(float[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static boolean isNotEmpty(int[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static boolean isNotEmpty(long[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static boolean isNotEmpty(short[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static <T> boolean isNotEmpty(T[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isSameLength(boolean[] array1, boolean[] array2) {
        void var1_1;
        return ArrayUtils.getLength(array1) == ArrayUtils.getLength(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isSameLength(byte[] array1, byte[] array2) {
        void var1_1;
        return ArrayUtils.getLength(array1) == ArrayUtils.getLength(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isSameLength(char[] array1, char[] array2) {
        void var1_1;
        return ArrayUtils.getLength(array1) == ArrayUtils.getLength(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isSameLength(double[] array1, double[] array2) {
        void var1_1;
        return ArrayUtils.getLength(array1) == ArrayUtils.getLength(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isSameLength(float[] array1, float[] array2) {
        void var1_1;
        return ArrayUtils.getLength(array1) == ArrayUtils.getLength(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isSameLength(int[] array1, int[] array2) {
        void var1_1;
        return ArrayUtils.getLength(array1) == ArrayUtils.getLength(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isSameLength(long[] array1, long[] array2) {
        void var1_1;
        return ArrayUtils.getLength(array1) == ArrayUtils.getLength(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isSameLength(Object array1, Object array2) {
        void var1_1;
        return ArrayUtils.getLength(array1) == ArrayUtils.getLength(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isSameLength(Object[] array1, Object[] array2) {
        void var1_1;
        return ArrayUtils.getLength(array1) == ArrayUtils.getLength(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isSameLength(short[] array1, short[] array2) {
        void var1_1;
        return ArrayUtils.getLength(array1) == ArrayUtils.getLength(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isSameType(Object array1, Object array2) {
        void var1_1;
        Object object;
        if (array1 == null || array2 == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        return object.getClass().getName().equals(var1_1.getClass().getName());
    }

    public static boolean isSorted(boolean[] array) {
        if (array == null || array.length < 2) {
            return true;
        }
        boolean previous = array[0];
        int n = array.length;
        for (int i = 1; i < n; ++i) {
            boolean current = array[i];
            if (BooleanUtils.compare(previous, current) > 0) {
                return false;
            }
            previous = current;
        }
        return true;
    }

    public static boolean isSorted(byte[] array) {
        if (array == null || array.length < 2) {
            return true;
        }
        byte previous = array[0];
        int n = array.length;
        for (int i = 1; i < n; ++i) {
            byte current = array[i];
            if (NumberUtils.compare(previous, current) > 0) {
                return false;
            }
            previous = current;
        }
        return true;
    }

    public static boolean isSorted(char[] array) {
        if (array == null || array.length < 2) {
            return true;
        }
        char previous = array[0];
        int n = array.length;
        for (int i = 1; i < n; ++i) {
            char current = array[i];
            if (CharUtils.compare(previous, current) > 0) {
                return false;
            }
            previous = current;
        }
        return true;
    }

    public static boolean isSorted(double[] array) {
        if (array == null || array.length < 2) {
            return true;
        }
        double previous = array[0];
        int n = array.length;
        for (int i = 1; i < n; ++i) {
            double current = array[i];
            if (Double.compare(previous, current) > 0) {
                return false;
            }
            previous = current;
        }
        return true;
    }

    public static boolean isSorted(float[] array) {
        if (array == null || array.length < 2) {
            return true;
        }
        float previous = array[0];
        int n = array.length;
        for (int i = 1; i < n; ++i) {
            float current = array[i];
            if (Float.compare(previous, current) > 0) {
                return false;
            }
            previous = current;
        }
        return true;
    }

    public static boolean isSorted(int[] array) {
        if (array == null || array.length < 2) {
            return true;
        }
        int previous = array[0];
        int n = array.length;
        for (int i = 1; i < n; ++i) {
            int current = array[i];
            if (NumberUtils.compare(previous, current) > 0) {
                return false;
            }
            previous = current;
        }
        return true;
    }

    public static boolean isSorted(long[] array) {
        if (array == null || array.length < 2) {
            return true;
        }
        long previous = array[0];
        int n = array.length;
        for (int i = 1; i < n; ++i) {
            long current = array[i];
            if (NumberUtils.compare(previous, current) > 0) {
                return false;
            }
            previous = current;
        }
        return true;
    }

    public static boolean isSorted(short[] array) {
        if (array == null || array.length < 2) {
            return true;
        }
        short previous = array[0];
        int n = array.length;
        for (int i = 1; i < n; ++i) {
            short current = array[i];
            if (NumberUtils.compare(previous, current) > 0) {
                return false;
            }
            previous = current;
        }
        return true;
    }

    public static <T extends Comparable<? super T>> boolean isSorted(T[] array) {
        return ArrayUtils.isSorted(array, Comparable::compareTo);
    }

    public static <T> boolean isSorted(T[] array, Comparator<T> comparator) {
        if (comparator == null) {
            throw new IllegalArgumentException("Comparator should not be null.");
        }
        if (array == null || array.length < 2) {
            return true;
        }
        T previous = array[0];
        int n = array.length;
        for (int i = 1; i < n; ++i) {
            T current = array[i];
            if (comparator.compare(previous, current) > 0) {
                return false;
            }
            previous = current;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(boolean[] array, boolean valueToFind) {
        void var1_1;
        return ArrayUtils.lastIndexOf(array, (boolean)var1_1, Integer.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(boolean[] array, boolean valueToFind, int startIndex) {
        void i;
        if (ArrayUtils.isEmpty(array)) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        while (i >= 0) {
            if (valueToFind == array[i]) {
                return (int)i;
            }
            --i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(byte[] array, byte valueToFind) {
        void var1_1;
        return ArrayUtils.lastIndexOf(array, (byte)var1_1, Integer.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(byte[] array, byte valueToFind, int startIndex) {
        void i;
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        while (i >= 0) {
            if (valueToFind == array[i]) {
                return (int)i;
            }
            --i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(char[] array, char valueToFind) {
        void var1_1;
        return ArrayUtils.lastIndexOf(array, (char)var1_1, Integer.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(char[] array, char valueToFind, int startIndex) {
        void i;
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        while (i >= 0) {
            if (valueToFind == array[i]) {
                return (int)i;
            }
            --i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(double[] array, double valueToFind) {
        void var1_1;
        return ArrayUtils.lastIndexOf(array, (double)var1_1, Integer.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(double[] array, double valueToFind, double tolerance) {
        void var3_2;
        void var1_1;
        return ArrayUtils.lastIndexOf(array, (double)var1_1, Integer.MAX_VALUE, (double)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(double[] array, double valueToFind, int startIndex) {
        void i;
        if (ArrayUtils.isEmpty(array)) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        while (i >= 0) {
            if (valueToFind == array[i]) {
                return (int)i;
            }
            --i;
        }
        return -1;
    }

    public static int lastIndexOf(double[] array, double valueToFind, int startIndex, double tolerance) {
        if (ArrayUtils.isEmpty(array)) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        double min = valueToFind - tolerance;
        double max = valueToFind + tolerance;
        for (void i = var3_3; i >= 0; --i) {
            if (!(array[i] >= min) || !(array[i] <= max)) continue;
            return (int)i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(float[] array, float valueToFind) {
        void var1_1;
        return ArrayUtils.lastIndexOf(array, (float)var1_1, Integer.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(float[] array, float valueToFind, int startIndex) {
        void i;
        if (ArrayUtils.isEmpty(array)) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        while (i >= 0) {
            if (valueToFind == array[i]) {
                return (int)i;
            }
            --i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(int[] array, int valueToFind) {
        void var1_1;
        return ArrayUtils.lastIndexOf(array, (int)var1_1, Integer.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(int[] array, int valueToFind, int startIndex) {
        void i;
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        while (i >= 0) {
            if (valueToFind == array[i]) {
                return (int)i;
            }
            --i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(long[] array, long valueToFind) {
        void var1_1;
        return ArrayUtils.lastIndexOf(array, (long)var1_1, Integer.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(long[] array, long valueToFind, int startIndex) {
        void i;
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        while (i >= 0) {
            if (valueToFind == array[i]) {
                return (int)i;
            }
            --i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(Object[] array, Object objectToFind) {
        void var1_1;
        return ArrayUtils.lastIndexOf(array, var1_1, Integer.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(Object[] array, Object objectToFind, int startIndex) {
        block8: {
            void i;
            block7: {
                if (array == null) {
                    return -1;
                }
                if (startIndex < 0) {
                    return -1;
                }
                if (startIndex >= array.length) {
                    startIndex = array.length - 1;
                }
                if (objectToFind != null) break block7;
                while (i >= 0) {
                    if (array[i] == null) {
                        return (int)i;
                    }
                    --i;
                }
                break block8;
            }
            if (!array.getClass().getComponentType().isInstance(objectToFind)) break block8;
            while (i >= 0) {
                if (objectToFind.equals(array[i])) {
                    return (int)i;
                }
                --i;
            }
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(short[] array, short valueToFind) {
        void var1_1;
        return ArrayUtils.lastIndexOf(array, (short)var1_1, Integer.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(short[] array, short valueToFind, int startIndex) {
        void i;
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        while (i >= 0) {
            if (valueToFind == array[i]) {
                return (int)i;
            }
            --i;
        }
        return -1;
    }

    public static boolean[] nullToEmpty(boolean[] array) {
        boolean[] blArray;
        if (ArrayUtils.isEmpty(array)) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        return blArray;
    }

    public static Boolean[] nullToEmpty(Boolean[] array) {
        Boolean[] booleanArray;
        if (ArrayUtils.isEmpty((Object[])array)) {
            return EMPTY_BOOLEAN_OBJECT_ARRAY;
        }
        return booleanArray;
    }

    public static byte[] nullToEmpty(byte[] array) {
        byte[] byArray;
        if (ArrayUtils.isEmpty(array)) {
            return EMPTY_BYTE_ARRAY;
        }
        return byArray;
    }

    public static Byte[] nullToEmpty(Byte[] array) {
        Byte[] byteArray;
        if (ArrayUtils.isEmpty((Object[])array)) {
            return EMPTY_BYTE_OBJECT_ARRAY;
        }
        return byteArray;
    }

    public static char[] nullToEmpty(char[] array) {
        char[] cArray;
        if (ArrayUtils.isEmpty(array)) {
            return EMPTY_CHAR_ARRAY;
        }
        return cArray;
    }

    public static Character[] nullToEmpty(Character[] array) {
        Character[] characterArray;
        if (ArrayUtils.isEmpty((Object[])array)) {
            return EMPTY_CHARACTER_OBJECT_ARRAY;
        }
        return characterArray;
    }

    public static Class<?>[] nullToEmpty(Class<?>[] array) {
        Class<?>[] classArray;
        if (ArrayUtils.isEmpty(array)) {
            return EMPTY_CLASS_ARRAY;
        }
        return classArray;
    }

    public static double[] nullToEmpty(double[] array) {
        double[] dArray;
        if (ArrayUtils.isEmpty(array)) {
            return EMPTY_DOUBLE_ARRAY;
        }
        return dArray;
    }

    public static Double[] nullToEmpty(Double[] array) {
        Double[] doubleArray;
        if (ArrayUtils.isEmpty((Object[])array)) {
            return EMPTY_DOUBLE_OBJECT_ARRAY;
        }
        return doubleArray;
    }

    public static float[] nullToEmpty(float[] array) {
        float[] fArray;
        if (ArrayUtils.isEmpty(array)) {
            return EMPTY_FLOAT_ARRAY;
        }
        return fArray;
    }

    public static Float[] nullToEmpty(Float[] array) {
        Float[] floatArray;
        if (ArrayUtils.isEmpty((Object[])array)) {
            return EMPTY_FLOAT_OBJECT_ARRAY;
        }
        return floatArray;
    }

    public static int[] nullToEmpty(int[] array) {
        int[] nArray;
        if (ArrayUtils.isEmpty(array)) {
            return EMPTY_INT_ARRAY;
        }
        return nArray;
    }

    public static Integer[] nullToEmpty(Integer[] array) {
        Integer[] integerArray;
        if (ArrayUtils.isEmpty((Object[])array)) {
            return EMPTY_INTEGER_OBJECT_ARRAY;
        }
        return integerArray;
    }

    public static long[] nullToEmpty(long[] array) {
        long[] lArray;
        if (ArrayUtils.isEmpty(array)) {
            return EMPTY_LONG_ARRAY;
        }
        return lArray;
    }

    public static Long[] nullToEmpty(Long[] array) {
        Long[] longArray;
        if (ArrayUtils.isEmpty((Object[])array)) {
            return EMPTY_LONG_OBJECT_ARRAY;
        }
        return longArray;
    }

    public static Object[] nullToEmpty(Object[] array) {
        Object[] objectArray;
        if (ArrayUtils.isEmpty(array)) {
            return EMPTY_OBJECT_ARRAY;
        }
        return objectArray;
    }

    public static short[] nullToEmpty(short[] array) {
        short[] sArray;
        if (ArrayUtils.isEmpty(array)) {
            return EMPTY_SHORT_ARRAY;
        }
        return sArray;
    }

    public static Short[] nullToEmpty(Short[] array) {
        Short[] shortArray;
        if (ArrayUtils.isEmpty((Object[])array)) {
            return EMPTY_SHORT_OBJECT_ARRAY;
        }
        return shortArray;
    }

    public static String[] nullToEmpty(String[] array) {
        String[] stringArray;
        if (ArrayUtils.isEmpty(array)) {
            return EMPTY_STRING_ARRAY;
        }
        return stringArray;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] nullToEmpty(T[] array, Class<T[]> type) {
        T[] TArray;
        if (type == null) {
            throw new IllegalArgumentException("The type must not be null");
        }
        if (array == null) {
            void var1_1;
            void v0 = var1_1;
            return (Object[])v0.cast(Array.newInstance(v0.getComponentType(), 0));
        }
        return TArray;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean[] remove(boolean[] array, int index) {
        void var1_1;
        return (boolean[])ArrayUtils.remove((Object)array, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] remove(byte[] array, int index) {
        void var1_1;
        return (byte[])ArrayUtils.remove((Object)array, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static char[] remove(char[] array, int index) {
        void var1_1;
        return (char[])ArrayUtils.remove((Object)array, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static double[] remove(double[] array, int index) {
        void var1_1;
        return (double[])ArrayUtils.remove((Object)array, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static float[] remove(float[] array, int index) {
        void var1_1;
        return (float[])ArrayUtils.remove((Object)array, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int[] remove(int[] array, int index) {
        void var1_1;
        return (int[])ArrayUtils.remove((Object)array, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static long[] remove(long[] array, int index) {
        void var1_1;
        return (long[])ArrayUtils.remove((Object)array, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static Object remove(Object array, int index) {
        void var3_3;
        int length = ArrayUtils.getLength(array);
        if (index < 0 || index >= length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + length);
        }
        Object result = Array.newInstance(array.getClass().getComponentType(), length - 1);
        System.arraycopy(array, 0, result, 0, index);
        if (index < length - 1) {
            void var1_1;
            void var2_2;
            Object object;
            System.arraycopy(object, index + 1, result, index, (int)(var2_2 - var1_1 - true));
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static short[] remove(short[] array, int index) {
        void var1_1;
        return (short[])ArrayUtils.remove((Object)array, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] remove(T[] array, int index) {
        void var1_1;
        return (Object[])ArrayUtils.remove(array, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean[] removeAll(boolean[] array, int ... indices) {
        void var1_1;
        return (boolean[])ArrayUtils.removeAll((Object)array, (int[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] removeAll(byte[] array, int ... indices) {
        void var1_1;
        return (byte[])ArrayUtils.removeAll((Object)array, (int[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static char[] removeAll(char[] array, int ... indices) {
        void var1_1;
        return (char[])ArrayUtils.removeAll((Object)array, (int[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static double[] removeAll(double[] array, int ... indices) {
        void var1_1;
        return (double[])ArrayUtils.removeAll((Object)array, (int[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static float[] removeAll(float[] array, int ... indices) {
        void var1_1;
        return (float[])ArrayUtils.removeAll((Object)array, (int[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int[] removeAll(int[] array, int ... indices) {
        void var1_1;
        return (int[])ArrayUtils.removeAll((Object)array, (int[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static long[] removeAll(long[] array, int ... indices) {
        void var1_1;
        return (long[])ArrayUtils.removeAll((Object)array, (int[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static Object removeAll(Object array, BitSet indices) {
        void var3_4;
        void var2_2;
        int count;
        int set;
        if (array == null) {
            return null;
        }
        int srcLength = ArrayUtils.getLength(array);
        int removals = indices.cardinality();
        Object result = Array.newInstance(array.getClass().getComponentType(), srcLength - removals);
        int srcIndex = 0;
        int destIndex = 0;
        while ((set = indices.nextSetBit(srcIndex)) != -1) {
            count = set - srcIndex;
            if (count > 0) {
                System.arraycopy(array, srcIndex, result, destIndex, count);
                destIndex += count;
            }
            srcIndex = indices.nextClearBit(set);
        }
        count = var2_2 - srcIndex;
        if (count > 0) {
            Object object;
            System.arraycopy(object, srcIndex, result, destIndex, count);
        }
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    static Object removeAll(Object array, int ... indices) {
        int length = ArrayUtils.getLength(array);
        int diff = 0;
        int[] clonedIndices = ArraySorter.sort(ArrayUtils.clone(indices));
        if (ArrayUtils.isNotEmpty(clonedIndices)) {
            int i = clonedIndices.length;
            int prevIndex = length;
            while (--i >= 0) {
                int index = clonedIndices[i];
                if (index < 0 || index >= length) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + length);
                }
                if (index >= prevIndex) continue;
                ++diff;
                prevIndex = index;
            }
        }
        Object result = Array.newInstance(array.getClass().getComponentType(), length - diff);
        if (diff < length) {
            void var5_6;
            int end = length;
            int dest = length - diff;
            for (int i = clonedIndices.length - 1; i >= 0; --i) {
                void var3_3;
                int index = clonedIndices[i];
                if (end - index > 1) {
                    int cp = end - index - 1;
                    System.arraycopy(array, index + 1, result, dest -= cp, cp);
                }
                var5_6 = var3_3;
            }
            if (var5_6 > 0) {
                Object object;
                System.arraycopy(object, 0, result, 0, (int)var5_6);
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static short[] removeAll(short[] array, int ... indices) {
        void var1_1;
        return (short[])ArrayUtils.removeAll((Object)array, (int[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] removeAll(T[] array, int ... indices) {
        void var1_1;
        return (Object[])ArrayUtils.removeAll(array, (int[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static boolean[] removeAllOccurences(boolean[] array, boolean element) {
        void var1_1;
        return (boolean[])ArrayUtils.removeAll((Object)array, ArrayUtils.indexesOf(array, (boolean)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static byte[] removeAllOccurences(byte[] array, byte element) {
        void var1_1;
        return (byte[])ArrayUtils.removeAll((Object)array, ArrayUtils.indexesOf(array, (byte)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static char[] removeAllOccurences(char[] array, char element) {
        void var1_1;
        return (char[])ArrayUtils.removeAll((Object)array, ArrayUtils.indexesOf(array, (char)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static double[] removeAllOccurences(double[] array, double element) {
        void var1_1;
        return (double[])ArrayUtils.removeAll((Object)array, ArrayUtils.indexesOf(array, (double)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static float[] removeAllOccurences(float[] array, float element) {
        void var1_1;
        return (float[])ArrayUtils.removeAll((Object)array, ArrayUtils.indexesOf(array, (float)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static int[] removeAllOccurences(int[] array, int element) {
        void var1_1;
        return (int[])ArrayUtils.removeAll((Object)array, ArrayUtils.indexesOf(array, (int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static long[] removeAllOccurences(long[] array, long element) {
        void var1_1;
        return (long[])ArrayUtils.removeAll((Object)array, ArrayUtils.indexesOf(array, (long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static short[] removeAllOccurences(short[] array, short element) {
        void var1_1;
        return (short[])ArrayUtils.removeAll((Object)array, ArrayUtils.indexesOf(array, (short)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static <T> T[] removeAllOccurences(T[] array, T element) {
        void var1_1;
        return (Object[])ArrayUtils.removeAll((Object)array, ArrayUtils.indexesOf(array, var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static boolean[] removeAllOccurrences(boolean[] array, boolean element) {
        void var1_1;
        return (boolean[])ArrayUtils.removeAll((Object)array, ArrayUtils.indexesOf(array, (boolean)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] removeAllOccurrences(byte[] array, byte element) {
        void var1_1;
        return (byte[])ArrayUtils.removeAll((Object)array, ArrayUtils.indexesOf(array, (byte)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static char[] removeAllOccurrences(char[] array, char element) {
        void var1_1;
        return (char[])ArrayUtils.removeAll((Object)array, ArrayUtils.indexesOf(array, (char)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static double[] removeAllOccurrences(double[] array, double element) {
        void var1_1;
        return (double[])ArrayUtils.removeAll((Object)array, ArrayUtils.indexesOf(array, (double)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static float[] removeAllOccurrences(float[] array, float element) {
        void var1_1;
        return (float[])ArrayUtils.removeAll((Object)array, ArrayUtils.indexesOf(array, (float)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static int[] removeAllOccurrences(int[] array, int element) {
        void var1_1;
        return (int[])ArrayUtils.removeAll((Object)array, ArrayUtils.indexesOf(array, (int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static long[] removeAllOccurrences(long[] array, long element) {
        void var1_1;
        return (long[])ArrayUtils.removeAll((Object)array, ArrayUtils.indexesOf(array, (long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static short[] removeAllOccurrences(short[] array, short element) {
        void var1_1;
        return (short[])ArrayUtils.removeAll((Object)array, ArrayUtils.indexesOf(array, (short)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] removeAllOccurrences(T[] array, T element) {
        void var1_1;
        return (Object[])ArrayUtils.removeAll((Object)array, ArrayUtils.indexesOf(array, var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static boolean[] removeElement(boolean[] array, boolean element) {
        void var1_1;
        boolean[] blArray;
        int index = ArrayUtils.indexOf(array, element);
        if (index == -1) {
            return ArrayUtils.clone(array);
        }
        return ArrayUtils.remove(blArray, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] removeElement(byte[] array, byte element) {
        void var1_1;
        byte[] byArray;
        int index = ArrayUtils.indexOf(array, element);
        if (index == -1) {
            return ArrayUtils.clone(array);
        }
        return ArrayUtils.remove(byArray, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static char[] removeElement(char[] array, char element) {
        void var1_1;
        char[] cArray;
        int index = ArrayUtils.indexOf(array, element);
        if (index == -1) {
            return ArrayUtils.clone(array);
        }
        return ArrayUtils.remove(cArray, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static double[] removeElement(double[] array, double element) {
        void var1_2;
        double[] dArray;
        int index = ArrayUtils.indexOf(array, element);
        if (index == -1) {
            return ArrayUtils.clone(array);
        }
        return ArrayUtils.remove(dArray, (int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public static float[] removeElement(float[] array, float element) {
        void var1_2;
        float[] fArray;
        int index = ArrayUtils.indexOf(array, element);
        if (index == -1) {
            return ArrayUtils.clone(array);
        }
        return ArrayUtils.remove(fArray, (int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public static int[] removeElement(int[] array, int element) {
        void var1_1;
        int[] nArray;
        int index = ArrayUtils.indexOf(array, element);
        if (index == -1) {
            return ArrayUtils.clone(array);
        }
        return ArrayUtils.remove(nArray, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static long[] removeElement(long[] array, long element) {
        void var1_2;
        long[] lArray;
        int index = ArrayUtils.indexOf(array, element);
        if (index == -1) {
            return ArrayUtils.clone(array);
        }
        return ArrayUtils.remove(lArray, (int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public static short[] removeElement(short[] array, short element) {
        void var1_1;
        short[] sArray;
        int index = ArrayUtils.indexOf(array, element);
        if (index == -1) {
            return ArrayUtils.clone(array);
        }
        return ArrayUtils.remove(sArray, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] removeElement(T[] array, Object element) {
        void var1_2;
        T[] TArray;
        int index = ArrayUtils.indexOf(array, element);
        if (index == -1) {
            return ArrayUtils.clone(array);
        }
        return ArrayUtils.remove(TArray, (int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean[] removeElements(boolean[] array, boolean ... values) {
        void var1_1;
        boolean[] blArray;
        if (ArrayUtils.isEmpty(array) || ArrayUtils.isEmpty(values)) {
            return ArrayUtils.clone(array);
        }
        HashMap<Boolean, MutableInt> occurrences = new HashMap<Boolean, MutableInt>(2);
        for (boolean bl : values) {
            Boolean boxed = bl;
            MutableInt count = (MutableInt)occurrences.get(boxed);
            if (count == null) {
                occurrences.put(boxed, new MutableInt(1));
                continue;
            }
            count.increment();
        }
        BitSet toRemove = new BitSet();
        for (int i = 0; i < array.length; ++i) {
            boolean key = array[i];
            MutableInt count = (MutableInt)occurrences.get(key);
            if (count == null) continue;
            if (count.decrementAndGet() == 0) {
                occurrences.remove(key);
            }
            toRemove.set(i);
        }
        return (boolean[])ArrayUtils.removeAll((Object)blArray, (BitSet)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] removeElements(byte[] array, byte ... values) {
        void var1_1;
        byte[] byArray;
        if (ArrayUtils.isEmpty(array) || ArrayUtils.isEmpty(values)) {
            return ArrayUtils.clone(array);
        }
        HashMap<Byte, MutableInt> occurrences = new HashMap<Byte, MutableInt>(values.length);
        for (byte by : values) {
            Byte boxed = by;
            MutableInt count = (MutableInt)occurrences.get(boxed);
            if (count == null) {
                occurrences.put(boxed, new MutableInt(1));
                continue;
            }
            count.increment();
        }
        BitSet toRemove = new BitSet();
        for (int i = 0; i < array.length; ++i) {
            byte key = array[i];
            MutableInt count = (MutableInt)occurrences.get(key);
            if (count == null) continue;
            if (count.decrementAndGet() == 0) {
                occurrences.remove(key);
            }
            toRemove.set(i);
        }
        return (byte[])ArrayUtils.removeAll((Object)byArray, (BitSet)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static char[] removeElements(char[] array, char ... values) {
        void var1_1;
        char[] cArray;
        if (ArrayUtils.isEmpty(array) || ArrayUtils.isEmpty(values)) {
            return ArrayUtils.clone(array);
        }
        HashMap<Character, MutableInt> occurrences = new HashMap<Character, MutableInt>(values.length);
        for (char c : values) {
            Character boxed = Character.valueOf(c);
            MutableInt count = (MutableInt)occurrences.get(boxed);
            if (count == null) {
                occurrences.put(boxed, new MutableInt(1));
                continue;
            }
            count.increment();
        }
        BitSet toRemove = new BitSet();
        for (int i = 0; i < array.length; ++i) {
            char key = array[i];
            MutableInt count = (MutableInt)occurrences.get(Character.valueOf(key));
            if (count == null) continue;
            if (count.decrementAndGet() == 0) {
                occurrences.remove(Character.valueOf(key));
            }
            toRemove.set(i);
        }
        return (char[])ArrayUtils.removeAll((Object)cArray, (BitSet)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static double[] removeElements(double[] array, double ... values) {
        void var1_1;
        double[] dArray;
        if (ArrayUtils.isEmpty(array) || ArrayUtils.isEmpty(values)) {
            return ArrayUtils.clone(array);
        }
        HashMap<Double, MutableInt> occurrences = new HashMap<Double, MutableInt>(values.length);
        for (double d : values) {
            Double boxed = d;
            MutableInt count = (MutableInt)occurrences.get(boxed);
            if (count == null) {
                occurrences.put(boxed, new MutableInt(1));
                continue;
            }
            count.increment();
        }
        BitSet toRemove = new BitSet();
        for (int i = 0; i < array.length; ++i) {
            double key = array[i];
            MutableInt count = (MutableInt)occurrences.get(key);
            if (count == null) continue;
            if (count.decrementAndGet() == 0) {
                occurrences.remove(key);
            }
            toRemove.set(i);
        }
        return (double[])ArrayUtils.removeAll((Object)dArray, (BitSet)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static float[] removeElements(float[] array, float ... values) {
        void var1_1;
        float[] fArray;
        if (ArrayUtils.isEmpty(array) || ArrayUtils.isEmpty(values)) {
            return ArrayUtils.clone(array);
        }
        HashMap<Float, MutableInt> occurrences = new HashMap<Float, MutableInt>(values.length);
        for (float f : values) {
            Float boxed = Float.valueOf(f);
            MutableInt count = (MutableInt)occurrences.get(boxed);
            if (count == null) {
                occurrences.put(boxed, new MutableInt(1));
                continue;
            }
            count.increment();
        }
        BitSet toRemove = new BitSet();
        for (int i = 0; i < array.length; ++i) {
            float key = array[i];
            MutableInt count = (MutableInt)occurrences.get(Float.valueOf(key));
            if (count == null) continue;
            if (count.decrementAndGet() == 0) {
                occurrences.remove(Float.valueOf(key));
            }
            toRemove.set(i);
        }
        return (float[])ArrayUtils.removeAll((Object)fArray, (BitSet)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int[] removeElements(int[] array, int ... values) {
        void var1_1;
        int[] nArray;
        if (ArrayUtils.isEmpty(array) || ArrayUtils.isEmpty(values)) {
            return ArrayUtils.clone(array);
        }
        HashMap<Integer, MutableInt> occurrences = new HashMap<Integer, MutableInt>(values.length);
        for (int n : values) {
            Integer boxed = n;
            MutableInt count = (MutableInt)occurrences.get(boxed);
            if (count == null) {
                occurrences.put(boxed, new MutableInt(1));
                continue;
            }
            count.increment();
        }
        BitSet toRemove = new BitSet();
        for (int i = 0; i < array.length; ++i) {
            int key = array[i];
            MutableInt count = (MutableInt)occurrences.get(key);
            if (count == null) continue;
            if (count.decrementAndGet() == 0) {
                occurrences.remove(key);
            }
            toRemove.set(i);
        }
        return (int[])ArrayUtils.removeAll((Object)nArray, (BitSet)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static long[] removeElements(long[] array, long ... values) {
        void var1_1;
        long[] lArray;
        if (ArrayUtils.isEmpty(array) || ArrayUtils.isEmpty(values)) {
            return ArrayUtils.clone(array);
        }
        HashMap<Long, MutableInt> occurrences = new HashMap<Long, MutableInt>(values.length);
        for (long l : values) {
            Long boxed = l;
            MutableInt count = (MutableInt)occurrences.get(boxed);
            if (count == null) {
                occurrences.put(boxed, new MutableInt(1));
                continue;
            }
            count.increment();
        }
        BitSet toRemove = new BitSet();
        for (int i = 0; i < array.length; ++i) {
            long key = array[i];
            MutableInt count = (MutableInt)occurrences.get(key);
            if (count == null) continue;
            if (count.decrementAndGet() == 0) {
                occurrences.remove(key);
            }
            toRemove.set(i);
        }
        return (long[])ArrayUtils.removeAll((Object)lArray, (BitSet)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static short[] removeElements(short[] array, short ... values) {
        void var1_1;
        short[] sArray;
        if (ArrayUtils.isEmpty(array) || ArrayUtils.isEmpty(values)) {
            return ArrayUtils.clone(array);
        }
        HashMap<Short, MutableInt> occurrences = new HashMap<Short, MutableInt>(values.length);
        for (short s : values) {
            Short boxed = s;
            MutableInt count = (MutableInt)occurrences.get(boxed);
            if (count == null) {
                occurrences.put(boxed, new MutableInt(1));
                continue;
            }
            count.increment();
        }
        BitSet toRemove = new BitSet();
        for (int i = 0; i < array.length; ++i) {
            short key = array[i];
            MutableInt count = (MutableInt)occurrences.get(key);
            if (count == null) continue;
            if (count.decrementAndGet() == 0) {
                occurrences.remove(key);
            }
            toRemove.set(i);
        }
        return (short[])ArrayUtils.removeAll((Object)sArray, (BitSet)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public static <T> T[] removeElements(T[] array, T ... values) {
        void var1_1;
        T[] TArray;
        if (ArrayUtils.isEmpty(array) || ArrayUtils.isEmpty(values)) {
            return ArrayUtils.clone(array);
        }
        HashMap<T, MutableInt> occurrences = new HashMap<T, MutableInt>(values.length);
        for (T v : values) {
            MutableInt count = (MutableInt)occurrences.get(v);
            if (count == null) {
                occurrences.put(v, new MutableInt(1));
                continue;
            }
            count.increment();
        }
        BitSet toRemove = new BitSet();
        for (int i = 0; i < array.length; ++i) {
            T key = array[i];
            MutableInt count = (MutableInt)occurrences.get(key);
            if (count == null) continue;
            if (count.decrementAndGet() == 0) {
                occurrences.remove(key);
            }
            toRemove.set(i);
        }
        Object[] objectArray = (Object[])ArrayUtils.removeAll(TArray, (BitSet)var1_1);
        return objectArray;
    }

    public static void reverse(boolean[] array) {
        boolean[] blArray;
        if (array == null) {
            return;
        }
        ArrayUtils.reverse(array, 0, blArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static void reverse(boolean[] array, int startIndexInclusive, int endIndexExclusive) {
        if (array == null) {
            return;
        }
        int i = Math.max(startIndexInclusive, 0);
        for (int j = Math.min(array.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            void var3_3;
            boolean tmp = array[j];
            array[j] = array[i];
            array[i] = var3_3;
        }
    }

    public static void reverse(byte[] array) {
        byte[] byArray;
        if (array == null) {
            return;
        }
        ArrayUtils.reverse(array, 0, byArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static void reverse(byte[] array, int startIndexInclusive, int endIndexExclusive) {
        if (array == null) {
            return;
        }
        int i = Math.max(startIndexInclusive, 0);
        for (int j = Math.min(array.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            void var3_3;
            byte tmp = array[j];
            array[j] = array[i];
            array[i] = var3_3;
        }
    }

    public static void reverse(char[] array) {
        char[] cArray;
        if (array == null) {
            return;
        }
        ArrayUtils.reverse(array, 0, cArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static void reverse(char[] array, int startIndexInclusive, int endIndexExclusive) {
        if (array == null) {
            return;
        }
        int i = Math.max(startIndexInclusive, 0);
        for (int j = Math.min(array.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            void var3_3;
            char tmp = array[j];
            array[j] = array[i];
            array[i] = var3_3;
        }
    }

    public static void reverse(double[] array) {
        double[] dArray;
        if (array == null) {
            return;
        }
        ArrayUtils.reverse(array, 0, dArray.length);
    }

    public static void reverse(double[] array, int startIndexInclusive, int endIndexExclusive) {
        if (array == null) {
            return;
        }
        int i = Math.max(startIndexInclusive, 0);
        for (int j = Math.min(array.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            double tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static void reverse(float[] array) {
        float[] fArray;
        if (array == null) {
            return;
        }
        ArrayUtils.reverse(array, 0, fArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static void reverse(float[] array, int startIndexInclusive, int endIndexExclusive) {
        if (array == null) {
            return;
        }
        int i = Math.max(startIndexInclusive, 0);
        for (int j = Math.min(array.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            void var3_3;
            float tmp = array[j];
            array[j] = array[i];
            array[i] = var3_3;
        }
    }

    public static void reverse(int[] array) {
        int[] nArray;
        if (array == null) {
            return;
        }
        ArrayUtils.reverse(array, 0, nArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static void reverse(int[] array, int startIndexInclusive, int endIndexExclusive) {
        if (array == null) {
            return;
        }
        int i = Math.max(startIndexInclusive, 0);
        for (int j = Math.min(array.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            void var3_3;
            int tmp = array[j];
            array[j] = array[i];
            array[i] = var3_3;
        }
    }

    public static void reverse(long[] array) {
        long[] lArray;
        if (array == null) {
            return;
        }
        ArrayUtils.reverse(array, 0, lArray.length);
    }

    public static void reverse(long[] array, int startIndexInclusive, int endIndexExclusive) {
        if (array == null) {
            return;
        }
        int i = Math.max(startIndexInclusive, 0);
        for (int j = Math.min(array.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            long tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static void reverse(Object[] array) {
        Object[] objectArray;
        if (array == null) {
            return;
        }
        ArrayUtils.reverse(array, 0, objectArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static void reverse(Object[] array, int startIndexInclusive, int endIndexExclusive) {
        if (array == null) {
            return;
        }
        int i = Math.max(startIndexInclusive, 0);
        for (int j = Math.min(array.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            void var3_3;
            Object tmp = array[j];
            array[j] = array[i];
            array[i] = var3_3;
        }
    }

    public static void reverse(short[] array) {
        short[] sArray;
        if (array == null) {
            return;
        }
        ArrayUtils.reverse(array, 0, sArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static void reverse(short[] array, int startIndexInclusive, int endIndexExclusive) {
        if (array == null) {
            return;
        }
        int i = Math.max(startIndexInclusive, 0);
        for (int j = Math.min(array.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            void var3_3;
            short tmp = array[j];
            array[j] = array[i];
            array[i] = var3_3;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void shift(boolean[] array, int offset) {
        void var1_1;
        boolean[] blArray;
        if (array == null) {
            return;
        }
        ArrayUtils.shift(array, 0, blArray.length, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void shift(boolean[] array, int startIndexInclusive, int endIndexExclusive, int offset) {
        int n;
        if (array == null) {
            return;
        }
        if (startIndexInclusive >= array.length - 1 || endIndexExclusive <= 0) {
            return;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive >= array.length) {
            endIndexExclusive = array.length;
        }
        if ((n = endIndexExclusive - startIndexInclusive) <= 1) {
            return;
        }
        if ((offset %= n) < 0) {
            offset += n;
        }
        while (n > 1 && offset > 0) {
            void var3_3;
            boolean[] blArray;
            void var1_1;
            int n_offset = n - offset;
            if (offset > n_offset) {
                int n2 = startIndexInclusive;
                ArrayUtils.swap(array, n2, n2 + n - n_offset, n_offset);
                n = offset;
                offset -= n_offset;
                continue;
            }
            if (offset < n_offset) {
                int n3 = startIndexInclusive;
                ArrayUtils.swap(array, n3, n3 + n_offset, offset);
                startIndexInclusive += offset;
                n = n_offset;
                continue;
            }
            void v2 = var1_1;
            ArrayUtils.swap(blArray, (int)v2, (int)(v2 + n_offset), (int)var3_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void shift(byte[] array, int offset) {
        void var1_1;
        byte[] byArray;
        if (array == null) {
            return;
        }
        ArrayUtils.shift(array, 0, byArray.length, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void shift(byte[] array, int startIndexInclusive, int endIndexExclusive, int offset) {
        int n;
        if (array == null) {
            return;
        }
        if (startIndexInclusive >= array.length - 1 || endIndexExclusive <= 0) {
            return;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive >= array.length) {
            endIndexExclusive = array.length;
        }
        if ((n = endIndexExclusive - startIndexInclusive) <= 1) {
            return;
        }
        if ((offset %= n) < 0) {
            offset += n;
        }
        while (n > 1 && offset > 0) {
            void var3_3;
            byte[] byArray;
            void var1_1;
            int n_offset = n - offset;
            if (offset > n_offset) {
                int n2 = startIndexInclusive;
                ArrayUtils.swap(array, n2, n2 + n - n_offset, n_offset);
                n = offset;
                offset -= n_offset;
                continue;
            }
            if (offset < n_offset) {
                int n3 = startIndexInclusive;
                ArrayUtils.swap(array, n3, n3 + n_offset, offset);
                startIndexInclusive += offset;
                n = n_offset;
                continue;
            }
            void v2 = var1_1;
            ArrayUtils.swap(byArray, (int)v2, (int)(v2 + n_offset), (int)var3_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void shift(char[] array, int offset) {
        void var1_1;
        char[] cArray;
        if (array == null) {
            return;
        }
        ArrayUtils.shift(array, 0, cArray.length, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void shift(char[] array, int startIndexInclusive, int endIndexExclusive, int offset) {
        int n;
        if (array == null) {
            return;
        }
        if (startIndexInclusive >= array.length - 1 || endIndexExclusive <= 0) {
            return;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive >= array.length) {
            endIndexExclusive = array.length;
        }
        if ((n = endIndexExclusive - startIndexInclusive) <= 1) {
            return;
        }
        if ((offset %= n) < 0) {
            offset += n;
        }
        while (n > 1 && offset > 0) {
            void var3_3;
            char[] cArray;
            void var1_1;
            int n_offset = n - offset;
            if (offset > n_offset) {
                int n2 = startIndexInclusive;
                ArrayUtils.swap(array, n2, n2 + n - n_offset, n_offset);
                n = offset;
                offset -= n_offset;
                continue;
            }
            if (offset < n_offset) {
                int n3 = startIndexInclusive;
                ArrayUtils.swap(array, n3, n3 + n_offset, offset);
                startIndexInclusive += offset;
                n = n_offset;
                continue;
            }
            void v2 = var1_1;
            ArrayUtils.swap(cArray, (int)v2, (int)(v2 + n_offset), (int)var3_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void shift(double[] array, int offset) {
        void var1_1;
        double[] dArray;
        if (array == null) {
            return;
        }
        ArrayUtils.shift(array, 0, dArray.length, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void shift(double[] array, int startIndexInclusive, int endIndexExclusive, int offset) {
        int n;
        if (array == null) {
            return;
        }
        if (startIndexInclusive >= array.length - 1 || endIndexExclusive <= 0) {
            return;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive >= array.length) {
            endIndexExclusive = array.length;
        }
        if ((n = endIndexExclusive - startIndexInclusive) <= 1) {
            return;
        }
        if ((offset %= n) < 0) {
            offset += n;
        }
        while (n > 1 && offset > 0) {
            void var3_3;
            double[] dArray;
            void var1_1;
            int n_offset = n - offset;
            if (offset > n_offset) {
                int n2 = startIndexInclusive;
                ArrayUtils.swap(array, n2, n2 + n - n_offset, n_offset);
                n = offset;
                offset -= n_offset;
                continue;
            }
            if (offset < n_offset) {
                int n3 = startIndexInclusive;
                ArrayUtils.swap(array, n3, n3 + n_offset, offset);
                startIndexInclusive += offset;
                n = n_offset;
                continue;
            }
            void v2 = var1_1;
            ArrayUtils.swap(dArray, (int)v2, (int)(v2 + n_offset), (int)var3_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void shift(float[] array, int offset) {
        void var1_1;
        float[] fArray;
        if (array == null) {
            return;
        }
        ArrayUtils.shift(array, 0, fArray.length, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void shift(float[] array, int startIndexInclusive, int endIndexExclusive, int offset) {
        int n;
        if (array == null) {
            return;
        }
        if (startIndexInclusive >= array.length - 1 || endIndexExclusive <= 0) {
            return;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive >= array.length) {
            endIndexExclusive = array.length;
        }
        if ((n = endIndexExclusive - startIndexInclusive) <= 1) {
            return;
        }
        if ((offset %= n) < 0) {
            offset += n;
        }
        while (n > 1 && offset > 0) {
            void var3_3;
            float[] fArray;
            void var1_1;
            int n_offset = n - offset;
            if (offset > n_offset) {
                int n2 = startIndexInclusive;
                ArrayUtils.swap(array, n2, n2 + n - n_offset, n_offset);
                n = offset;
                offset -= n_offset;
                continue;
            }
            if (offset < n_offset) {
                int n3 = startIndexInclusive;
                ArrayUtils.swap(array, n3, n3 + n_offset, offset);
                startIndexInclusive += offset;
                n = n_offset;
                continue;
            }
            void v2 = var1_1;
            ArrayUtils.swap(fArray, (int)v2, (int)(v2 + n_offset), (int)var3_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void shift(int[] array, int offset) {
        void var1_1;
        int[] nArray;
        if (array == null) {
            return;
        }
        ArrayUtils.shift(array, 0, nArray.length, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void shift(int[] array, int startIndexInclusive, int endIndexExclusive, int offset) {
        int n;
        if (array == null) {
            return;
        }
        if (startIndexInclusive >= array.length - 1 || endIndexExclusive <= 0) {
            return;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive >= array.length) {
            endIndexExclusive = array.length;
        }
        if ((n = endIndexExclusive - startIndexInclusive) <= 1) {
            return;
        }
        if ((offset %= n) < 0) {
            offset += n;
        }
        while (n > 1 && offset > 0) {
            void var3_3;
            int[] nArray;
            void var1_1;
            int n_offset = n - offset;
            if (offset > n_offset) {
                int n2 = startIndexInclusive;
                ArrayUtils.swap(array, n2, n2 + n - n_offset, n_offset);
                n = offset;
                offset -= n_offset;
                continue;
            }
            if (offset < n_offset) {
                int n3 = startIndexInclusive;
                ArrayUtils.swap(array, n3, n3 + n_offset, offset);
                startIndexInclusive += offset;
                n = n_offset;
                continue;
            }
            void v2 = var1_1;
            ArrayUtils.swap(nArray, (int)v2, (int)(v2 + n_offset), (int)var3_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void shift(long[] array, int offset) {
        void var1_1;
        long[] lArray;
        if (array == null) {
            return;
        }
        ArrayUtils.shift(array, 0, lArray.length, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void shift(long[] array, int startIndexInclusive, int endIndexExclusive, int offset) {
        int n;
        if (array == null) {
            return;
        }
        if (startIndexInclusive >= array.length - 1 || endIndexExclusive <= 0) {
            return;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive >= array.length) {
            endIndexExclusive = array.length;
        }
        if ((n = endIndexExclusive - startIndexInclusive) <= 1) {
            return;
        }
        if ((offset %= n) < 0) {
            offset += n;
        }
        while (n > 1 && offset > 0) {
            void var3_3;
            long[] lArray;
            void var1_1;
            int n_offset = n - offset;
            if (offset > n_offset) {
                int n2 = startIndexInclusive;
                ArrayUtils.swap(array, n2, n2 + n - n_offset, n_offset);
                n = offset;
                offset -= n_offset;
                continue;
            }
            if (offset < n_offset) {
                int n3 = startIndexInclusive;
                ArrayUtils.swap(array, n3, n3 + n_offset, offset);
                startIndexInclusive += offset;
                n = n_offset;
                continue;
            }
            void v2 = var1_1;
            ArrayUtils.swap(lArray, (int)v2, (int)(v2 + n_offset), (int)var3_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void shift(Object[] array, int offset) {
        void var1_1;
        Object[] objectArray;
        if (array == null) {
            return;
        }
        ArrayUtils.shift(array, 0, objectArray.length, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void shift(Object[] array, int startIndexInclusive, int endIndexExclusive, int offset) {
        int n;
        if (array == null) {
            return;
        }
        if (startIndexInclusive >= array.length - 1 || endIndexExclusive <= 0) {
            return;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive >= array.length) {
            endIndexExclusive = array.length;
        }
        if ((n = endIndexExclusive - startIndexInclusive) <= 1) {
            return;
        }
        if ((offset %= n) < 0) {
            offset += n;
        }
        while (n > 1 && offset > 0) {
            void var3_3;
            Object[] objectArray;
            void var1_1;
            int n_offset = n - offset;
            if (offset > n_offset) {
                int n2 = startIndexInclusive;
                ArrayUtils.swap(array, n2, n2 + n - n_offset, n_offset);
                n = offset;
                offset -= n_offset;
                continue;
            }
            if (offset < n_offset) {
                int n3 = startIndexInclusive;
                ArrayUtils.swap(array, n3, n3 + n_offset, offset);
                startIndexInclusive += offset;
                n = n_offset;
                continue;
            }
            void v2 = var1_1;
            ArrayUtils.swap(objectArray, (int)v2, (int)(v2 + n_offset), (int)var3_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void shift(short[] array, int offset) {
        void var1_1;
        short[] sArray;
        if (array == null) {
            return;
        }
        ArrayUtils.shift(array, 0, sArray.length, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void shift(short[] array, int startIndexInclusive, int endIndexExclusive, int offset) {
        int n;
        if (array == null) {
            return;
        }
        if (startIndexInclusive >= array.length - 1 || endIndexExclusive <= 0) {
            return;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive >= array.length) {
            endIndexExclusive = array.length;
        }
        if ((n = endIndexExclusive - startIndexInclusive) <= 1) {
            return;
        }
        if ((offset %= n) < 0) {
            offset += n;
        }
        while (n > 1 && offset > 0) {
            void var3_3;
            short[] sArray;
            void var1_1;
            int n_offset = n - offset;
            if (offset > n_offset) {
                int n2 = startIndexInclusive;
                ArrayUtils.swap(array, n2, n2 + n - n_offset, n_offset);
                n = offset;
                offset -= n_offset;
                continue;
            }
            if (offset < n_offset) {
                int n3 = startIndexInclusive;
                ArrayUtils.swap(array, n3, n3 + n_offset, offset);
                startIndexInclusive += offset;
                n = n_offset;
                continue;
            }
            void v2 = var1_1;
            ArrayUtils.swap(sArray, (int)v2, (int)(v2 + n_offset), (int)var3_3);
            return;
        }
    }

    public static void shuffle(boolean[] array) {
        ArrayUtils.shuffle(array, new Random());
    }

    public static void shuffle(boolean[] array, Random random) {
        for (int i = array.length; i > 1; --i) {
            ArrayUtils.swap(array, i - 1, random.nextInt(i), 1);
        }
    }

    public static void shuffle(byte[] array) {
        ArrayUtils.shuffle(array, new Random());
    }

    public static void shuffle(byte[] array, Random random) {
        for (int i = array.length; i > 1; --i) {
            ArrayUtils.swap(array, i - 1, random.nextInt(i), 1);
        }
    }

    public static void shuffle(char[] array) {
        ArrayUtils.shuffle(array, new Random());
    }

    public static void shuffle(char[] array, Random random) {
        for (int i = array.length; i > 1; --i) {
            ArrayUtils.swap(array, i - 1, random.nextInt(i), 1);
        }
    }

    public static void shuffle(double[] array) {
        ArrayUtils.shuffle(array, new Random());
    }

    public static void shuffle(double[] array, Random random) {
        for (int i = array.length; i > 1; --i) {
            ArrayUtils.swap(array, i - 1, random.nextInt(i), 1);
        }
    }

    public static void shuffle(float[] array) {
        ArrayUtils.shuffle(array, new Random());
    }

    public static void shuffle(float[] array, Random random) {
        for (int i = array.length; i > 1; --i) {
            ArrayUtils.swap(array, i - 1, random.nextInt(i), 1);
        }
    }

    public static void shuffle(int[] array) {
        ArrayUtils.shuffle(array, new Random());
    }

    public static void shuffle(int[] array, Random random) {
        for (int i = array.length; i > 1; --i) {
            ArrayUtils.swap(array, i - 1, random.nextInt(i), 1);
        }
    }

    public static void shuffle(long[] array) {
        ArrayUtils.shuffle(array, new Random());
    }

    public static void shuffle(long[] array, Random random) {
        for (int i = array.length; i > 1; --i) {
            ArrayUtils.swap(array, i - 1, random.nextInt(i), 1);
        }
    }

    public static void shuffle(Object[] array) {
        ArrayUtils.shuffle(array, new Random());
    }

    public static void shuffle(Object[] array, Random random) {
        for (int i = array.length; i > 1; --i) {
            ArrayUtils.swap(array, i - 1, random.nextInt(i), 1);
        }
    }

    public static void shuffle(short[] array) {
        ArrayUtils.shuffle(array, new Random());
    }

    public static void shuffle(short[] array, Random random) {
        for (int i = array.length; i > 1; --i) {
            ArrayUtils.swap(array, i - 1, random.nextInt(i), 1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean[] subarray(boolean[] array, int startIndexInclusive, int endIndexExclusive) {
        void var3_3;
        void var2_2;
        void var1_1;
        boolean[] blArray;
        int newSize;
        if (array == null) {
            return null;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive > array.length) {
            endIndexExclusive = array.length;
        }
        if ((newSize = endIndexExclusive - startIndexInclusive) <= 0) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        boolean[] subarray = new boolean[newSize];
        System.arraycopy(blArray, (int)var1_1, subarray, 0, (int)var2_2);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] subarray(byte[] array, int startIndexInclusive, int endIndexExclusive) {
        void var3_3;
        void var2_2;
        void var1_1;
        byte[] byArray;
        int newSize;
        if (array == null) {
            return null;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive > array.length) {
            endIndexExclusive = array.length;
        }
        if ((newSize = endIndexExclusive - startIndexInclusive) <= 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] subarray = new byte[newSize];
        System.arraycopy(byArray, (int)var1_1, subarray, 0, (int)var2_2);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static char[] subarray(char[] array, int startIndexInclusive, int endIndexExclusive) {
        void var3_3;
        void var2_2;
        void var1_1;
        char[] cArray;
        int newSize;
        if (array == null) {
            return null;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive > array.length) {
            endIndexExclusive = array.length;
        }
        if ((newSize = endIndexExclusive - startIndexInclusive) <= 0) {
            return EMPTY_CHAR_ARRAY;
        }
        char[] subarray = new char[newSize];
        System.arraycopy(cArray, (int)var1_1, subarray, 0, (int)var2_2);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static double[] subarray(double[] array, int startIndexInclusive, int endIndexExclusive) {
        void var3_3;
        void var2_2;
        void var1_1;
        double[] dArray;
        int newSize;
        if (array == null) {
            return null;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive > array.length) {
            endIndexExclusive = array.length;
        }
        if ((newSize = endIndexExclusive - startIndexInclusive) <= 0) {
            return EMPTY_DOUBLE_ARRAY;
        }
        double[] subarray = new double[newSize];
        System.arraycopy(dArray, (int)var1_1, subarray, 0, (int)var2_2);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static float[] subarray(float[] array, int startIndexInclusive, int endIndexExclusive) {
        void var3_3;
        void var2_2;
        void var1_1;
        float[] fArray;
        int newSize;
        if (array == null) {
            return null;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive > array.length) {
            endIndexExclusive = array.length;
        }
        if ((newSize = endIndexExclusive - startIndexInclusive) <= 0) {
            return EMPTY_FLOAT_ARRAY;
        }
        float[] subarray = new float[newSize];
        System.arraycopy(fArray, (int)var1_1, subarray, 0, (int)var2_2);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static int[] subarray(int[] array, int startIndexInclusive, int endIndexExclusive) {
        void var3_3;
        void var2_2;
        void var1_1;
        int[] nArray;
        int newSize;
        if (array == null) {
            return null;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive > array.length) {
            endIndexExclusive = array.length;
        }
        if ((newSize = endIndexExclusive - startIndexInclusive) <= 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] subarray = new int[newSize];
        System.arraycopy(nArray, (int)var1_1, subarray, 0, (int)var2_2);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static long[] subarray(long[] array, int startIndexInclusive, int endIndexExclusive) {
        void var3_3;
        void var2_2;
        void var1_1;
        long[] lArray;
        int newSize;
        if (array == null) {
            return null;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive > array.length) {
            endIndexExclusive = array.length;
        }
        if ((newSize = endIndexExclusive - startIndexInclusive) <= 0) {
            return EMPTY_LONG_ARRAY;
        }
        long[] subarray = new long[newSize];
        System.arraycopy(lArray, (int)var1_1, subarray, 0, (int)var2_2);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static short[] subarray(short[] array, int startIndexInclusive, int endIndexExclusive) {
        void var3_3;
        void var2_2;
        void var1_1;
        short[] sArray;
        int newSize;
        if (array == null) {
            return null;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive > array.length) {
            endIndexExclusive = array.length;
        }
        if ((newSize = endIndexExclusive - startIndexInclusive) <= 0) {
            return EMPTY_SHORT_ARRAY;
        }
        short[] subarray = new short[newSize];
        System.arraycopy(sArray, (int)var1_1, subarray, 0, (int)var2_2);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] subarray(T[] array, int startIndexInclusive, int endIndexExclusive) {
        void var3_3;
        void var2_2;
        void var1_1;
        T[] TArray;
        if (array == null) {
            return null;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive > array.length) {
            endIndexExclusive = array.length;
        }
        int newSize = endIndexExclusive - startIndexInclusive;
        Object[] type = array.getClass().getComponentType();
        if (newSize <= 0) {
            type = (Object[])Array.newInstance(type, 0);
            return type;
        }
        Object[] subarray = (Object[])Array.newInstance(type, newSize);
        System.arraycopy(TArray, (int)var1_1, subarray, 0, (int)var2_2);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static void swap(boolean[] array, int offset1, int offset2) {
        void var2_2;
        void var1_1;
        boolean[] blArray;
        if (ArrayUtils.isEmpty(array)) {
            return;
        }
        ArrayUtils.swap(blArray, (int)var1_1, (int)var2_2, 1);
    }

    public static void swap(boolean[] array, int offset1, int offset2, int len) {
        if (ArrayUtils.isEmpty(array) || offset1 >= array.length || offset2 >= array.length) {
            return;
        }
        if (offset1 < 0) {
            offset1 = 0;
        }
        if (offset2 < 0) {
            offset2 = 0;
        }
        len = Math.min(Math.min(len, array.length - offset1), array.length - offset2);
        int i = 0;
        while (i < len) {
            boolean aux = array[offset1];
            array[offset1] = array[offset2];
            array[offset2] = aux;
            ++i;
            ++offset1;
            ++offset2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void swap(byte[] array, int offset1, int offset2) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        if (ArrayUtils.isEmpty(array)) {
            return;
        }
        ArrayUtils.swap(byArray, (int)var1_1, (int)var2_2, 1);
    }

    public static void swap(byte[] array, int offset1, int offset2, int len) {
        if (ArrayUtils.isEmpty(array) || offset1 >= array.length || offset2 >= array.length) {
            return;
        }
        if (offset1 < 0) {
            offset1 = 0;
        }
        if (offset2 < 0) {
            offset2 = 0;
        }
        len = Math.min(Math.min(len, array.length - offset1), array.length - offset2);
        int i = 0;
        while (i < len) {
            byte aux = array[offset1];
            array[offset1] = array[offset2];
            array[offset2] = aux;
            ++i;
            ++offset1;
            ++offset2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void swap(char[] array, int offset1, int offset2) {
        void var2_2;
        void var1_1;
        char[] cArray;
        if (ArrayUtils.isEmpty(array)) {
            return;
        }
        ArrayUtils.swap(cArray, (int)var1_1, (int)var2_2, 1);
    }

    public static void swap(char[] array, int offset1, int offset2, int len) {
        if (ArrayUtils.isEmpty(array) || offset1 >= array.length || offset2 >= array.length) {
            return;
        }
        if (offset1 < 0) {
            offset1 = 0;
        }
        if (offset2 < 0) {
            offset2 = 0;
        }
        len = Math.min(Math.min(len, array.length - offset1), array.length - offset2);
        int i = 0;
        while (i < len) {
            char aux = array[offset1];
            array[offset1] = array[offset2];
            array[offset2] = aux;
            ++i;
            ++offset1;
            ++offset2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void swap(double[] array, int offset1, int offset2) {
        void var2_2;
        void var1_1;
        double[] dArray;
        if (ArrayUtils.isEmpty(array)) {
            return;
        }
        ArrayUtils.swap(dArray, (int)var1_1, (int)var2_2, 1);
    }

    public static void swap(double[] array, int offset1, int offset2, int len) {
        if (ArrayUtils.isEmpty(array) || offset1 >= array.length || offset2 >= array.length) {
            return;
        }
        if (offset1 < 0) {
            offset1 = 0;
        }
        if (offset2 < 0) {
            offset2 = 0;
        }
        len = Math.min(Math.min(len, array.length - offset1), array.length - offset2);
        int i = 0;
        while (i < len) {
            double aux = array[offset1];
            array[offset1] = array[offset2];
            array[offset2] = aux;
            ++i;
            ++offset1;
            ++offset2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void swap(float[] array, int offset1, int offset2) {
        void var2_2;
        void var1_1;
        float[] fArray;
        if (ArrayUtils.isEmpty(array)) {
            return;
        }
        ArrayUtils.swap(fArray, (int)var1_1, (int)var2_2, 1);
    }

    public static void swap(float[] array, int offset1, int offset2, int len) {
        if (ArrayUtils.isEmpty(array) || offset1 >= array.length || offset2 >= array.length) {
            return;
        }
        if (offset1 < 0) {
            offset1 = 0;
        }
        if (offset2 < 0) {
            offset2 = 0;
        }
        len = Math.min(Math.min(len, array.length - offset1), array.length - offset2);
        int i = 0;
        while (i < len) {
            float aux = array[offset1];
            array[offset1] = array[offset2];
            array[offset2] = aux;
            ++i;
            ++offset1;
            ++offset2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void swap(int[] array, int offset1, int offset2) {
        void var2_2;
        void var1_1;
        int[] nArray;
        if (ArrayUtils.isEmpty(array)) {
            return;
        }
        ArrayUtils.swap(nArray, (int)var1_1, (int)var2_2, 1);
    }

    public static void swap(int[] array, int offset1, int offset2, int len) {
        if (ArrayUtils.isEmpty(array) || offset1 >= array.length || offset2 >= array.length) {
            return;
        }
        if (offset1 < 0) {
            offset1 = 0;
        }
        if (offset2 < 0) {
            offset2 = 0;
        }
        len = Math.min(Math.min(len, array.length - offset1), array.length - offset2);
        int i = 0;
        while (i < len) {
            int aux = array[offset1];
            array[offset1] = array[offset2];
            array[offset2] = aux;
            ++i;
            ++offset1;
            ++offset2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void swap(long[] array, int offset1, int offset2) {
        void var2_2;
        void var1_1;
        long[] lArray;
        if (ArrayUtils.isEmpty(array)) {
            return;
        }
        ArrayUtils.swap(lArray, (int)var1_1, (int)var2_2, 1);
    }

    public static void swap(long[] array, int offset1, int offset2, int len) {
        if (ArrayUtils.isEmpty(array) || offset1 >= array.length || offset2 >= array.length) {
            return;
        }
        if (offset1 < 0) {
            offset1 = 0;
        }
        if (offset2 < 0) {
            offset2 = 0;
        }
        len = Math.min(Math.min(len, array.length - offset1), array.length - offset2);
        int i = 0;
        while (i < len) {
            long aux = array[offset1];
            array[offset1] = array[offset2];
            array[offset2] = aux;
            ++i;
            ++offset1;
            ++offset2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void swap(Object[] array, int offset1, int offset2) {
        void var2_2;
        void var1_1;
        Object[] objectArray;
        if (ArrayUtils.isEmpty(array)) {
            return;
        }
        ArrayUtils.swap(objectArray, (int)var1_1, (int)var2_2, 1);
    }

    public static void swap(Object[] array, int offset1, int offset2, int len) {
        if (ArrayUtils.isEmpty(array) || offset1 >= array.length || offset2 >= array.length) {
            return;
        }
        if (offset1 < 0) {
            offset1 = 0;
        }
        if (offset2 < 0) {
            offset2 = 0;
        }
        len = Math.min(Math.min(len, array.length - offset1), array.length - offset2);
        int i = 0;
        while (i < len) {
            Object aux = array[offset1];
            array[offset1] = array[offset2];
            array[offset2] = aux;
            ++i;
            ++offset1;
            ++offset2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void swap(short[] array, int offset1, int offset2) {
        void var2_2;
        void var1_1;
        short[] sArray;
        if (ArrayUtils.isEmpty(array)) {
            return;
        }
        ArrayUtils.swap(sArray, (int)var1_1, (int)var2_2, 1);
    }

    public static void swap(short[] array, int offset1, int offset2, int len) {
        if (ArrayUtils.isEmpty(array) || offset1 >= array.length || offset2 >= array.length) {
            return;
        }
        if (offset1 < 0) {
            offset1 = 0;
        }
        if (offset2 < 0) {
            offset2 = 0;
        }
        if (offset1 == offset2) {
            return;
        }
        len = Math.min(Math.min(len, array.length - offset1), array.length - offset2);
        int i = 0;
        while (i < len) {
            short aux = array[offset1];
            array[offset1] = array[offset2];
            array[offset2] = aux;
            ++i;
            ++offset1;
            ++offset2;
        }
    }

    public static <T> T[] toArray(T ... items) {
        return items;
    }

    /*
     * WARNING - void declaration
     */
    public static Map<Object, Object> toMap(Object[] array) {
        void var1_1;
        if (array == null) {
            return null;
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>((int)((double)array.length * 1.5));
        for (int i = 0; i < array.length; ++i) {
            void var3_3;
            Object[] entry;
            Object object = array[i];
            if (object instanceof Map.Entry) {
                entry = (Object[])object;
                map.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (object instanceof Object[]) {
                entry = (Object[])object;
                if (entry.length < 2) {
                    throw new IllegalArgumentException("Array element " + i + ", '" + object + "', has a length less than 2");
                }
                map.put(entry[0], entry[1]);
                continue;
            }
            throw new IllegalArgumentException("Array element " + i + ", '" + var3_3 + "', is neither of type Map.Entry nor an Array");
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static Boolean[] toObject(boolean[] array) {
        void var1_1;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_BOOLEAN_OBJECT_ARRAY;
        }
        Boolean[] result = new Boolean[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i] ? Boolean.TRUE : Boolean.FALSE;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static Byte[] toObject(byte[] array) {
        void var1_1;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_BYTE_OBJECT_ARRAY;
        }
        Byte[] result = new Byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static Character[] toObject(char[] array) {
        void var1_1;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_CHARACTER_OBJECT_ARRAY;
        }
        Character[] result = new Character[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = Character.valueOf(array[i]);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static Double[] toObject(double[] array) {
        void var1_1;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_DOUBLE_OBJECT_ARRAY;
        }
        Double[] result = new Double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static Float[] toObject(float[] array) {
        void var1_1;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_FLOAT_OBJECT_ARRAY;
        }
        Float[] result = new Float[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = Float.valueOf(array[i]);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static Integer[] toObject(int[] array) {
        void var1_1;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_INTEGER_OBJECT_ARRAY;
        }
        Integer[] result = new Integer[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static Long[] toObject(long[] array) {
        void var1_1;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_LONG_OBJECT_ARRAY;
        }
        Long[] result = new Long[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static Short[] toObject(short[] array) {
        void var1_1;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_SHORT_OBJECT_ARRAY;
        }
        Short[] result = new Short[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean[] toPrimitive(Boolean[] array) {
        void var1_1;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        boolean[] result = new boolean[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean[] toPrimitive(Boolean[] array, boolean valueForNull) {
        void var2_2;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        boolean[] result = new boolean[array.length];
        for (int i = 0; i < array.length; ++i) {
            Boolean b = array[i];
            result[i] = b == null ? valueForNull : b;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] toPrimitive(Byte[] array) {
        void var1_1;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] result = new byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] toPrimitive(Byte[] array, byte valueForNull) {
        void var2_2;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] result = new byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            Byte b = array[i];
            result[i] = b == null ? valueForNull : b;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static char[] toPrimitive(Character[] array) {
        void var1_1;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        char[] result = new char[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i].charValue();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static char[] toPrimitive(Character[] array, char valueForNull) {
        void var2_2;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        char[] result = new char[array.length];
        for (int i = 0; i < array.length; ++i) {
            Character b = array[i];
            result[i] = b == null ? valueForNull : b.charValue();
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static double[] toPrimitive(Double[] array) {
        void var1_1;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_DOUBLE_ARRAY;
        }
        double[] result = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static double[] toPrimitive(Double[] array, double valueForNull) {
        void var3_2;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_DOUBLE_ARRAY;
        }
        double[] result = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            Double b = array[i];
            result[i] = b == null ? valueForNull : b;
        }
        return var3_2;
    }

    /*
     * WARNING - void declaration
     */
    public static float[] toPrimitive(Float[] array) {
        void var1_1;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_FLOAT_ARRAY;
        }
        float[] result = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i].floatValue();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static float[] toPrimitive(Float[] array, float valueForNull) {
        void var2_2;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_FLOAT_ARRAY;
        }
        float[] result = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            Float b = array[i];
            result[i] = b == null ? valueForNull : b.floatValue();
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static int[] toPrimitive(Integer[] array) {
        void var1_1;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] result = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static int[] toPrimitive(Integer[] array, int valueForNull) {
        void var2_2;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] result = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            Integer b = array[i];
            result[i] = b == null ? valueForNull : b;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static long[] toPrimitive(Long[] array) {
        void var1_1;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_LONG_ARRAY;
        }
        long[] result = new long[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static long[] toPrimitive(Long[] array, long valueForNull) {
        void var3_2;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_LONG_ARRAY;
        }
        long[] result = new long[array.length];
        for (int i = 0; i < array.length; ++i) {
            Long b = array[i];
            result[i] = b == null ? valueForNull : b;
        }
        return var3_2;
    }

    public static Object toPrimitive(Object array) {
        Object object;
        if (array == null) {
            return null;
        }
        Class<?> clazz = array.getClass().getComponentType();
        Class<?> pt = ClassUtils.wrapperToPrimitive(clazz);
        if (Boolean.TYPE.equals(pt)) {
            return ArrayUtils.toPrimitive((Boolean[])array);
        }
        if (Character.TYPE.equals(pt)) {
            return ArrayUtils.toPrimitive((Character[])array);
        }
        if (Byte.TYPE.equals(pt)) {
            return ArrayUtils.toPrimitive((Byte[])array);
        }
        if (Integer.TYPE.equals(pt)) {
            return ArrayUtils.toPrimitive((Integer[])array);
        }
        if (Long.TYPE.equals(pt)) {
            return ArrayUtils.toPrimitive((Long[])array);
        }
        if (Short.TYPE.equals(pt)) {
            return ArrayUtils.toPrimitive((Short[])array);
        }
        if (Double.TYPE.equals(pt)) {
            return ArrayUtils.toPrimitive((Double[])array);
        }
        if (Float.TYPE.equals(clazz)) {
            return ArrayUtils.toPrimitive((Float[])array);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static short[] toPrimitive(Short[] array) {
        void var1_1;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_SHORT_ARRAY;
        }
        short[] result = new short[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static short[] toPrimitive(Short[] array, short valueForNull) {
        void var2_2;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_SHORT_ARRAY;
        }
        short[] result = new short[array.length];
        for (int i = 0; i < array.length; ++i) {
            Short b = array[i];
            result[i] = b == null ? valueForNull : b;
        }
        return var2_2;
    }

    public static String toString(Object array) {
        return ArrayUtils.toString(array, "{}");
    }

    /*
     * WARNING - void declaration
     */
    public static String toString(Object array, String stringIfNull) {
        Object object;
        if (array == null) {
            void var1_1;
            return var1_1;
        }
        return new ToStringBuilder(array, ToStringStyle.SIMPLE_STYLE).append(object).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String[] toStringArray(Object[] array) {
        void var1_1;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_STRING_ARRAY;
        }
        String[] result = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i].toString();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static String[] toStringArray(Object[] array, String valueForNullElements) {
        void var2_2;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_STRING_ARRAY;
        }
        String[] result = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            Object object = array[i];
            result[i] = object == null ? valueForNullElements : object.toString();
        }
        return var2_2;
    }
}

