/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.xml;

import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.jupnp.xml.CatalogResourceResolver;
import org.jupnp.xml.ParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class SAXParser {
    public static final URI XML_SCHEMA_NAMESPACE = URI.create("http://www.w3.org/2001/xml.xsd");
    public static final URL XML_SCHEMA_RESOURCE = Thread.currentThread().getContextClassLoader().getResource("org/jupnp/schemas/xml.xsd");
    private final XMLReader xr = this.create();

    public SAXParser() {
        this(null);
    }

    /*
     * WARNING - void declaration
     */
    public SAXParser(DefaultHandler handler) {
        if (handler != null) {
            void var1_1;
            this.xr.setContentHandler((ContentHandler)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setContentHandler(ContentHandler handler) {
        void var1_1;
        this.xr.setContentHandler((ContentHandler)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected XMLReader create() {
        try {
            XMLReader xmlReader;
            if (this.getSchemaSources() != null) {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(true);
                SAXParser sAXParser = this;
                factory.setSchema(sAXParser.createSchema(sAXParser.getSchemaSources()));
                xmlReader = factory.newSAXParser().getXMLReader();
            } else {
                xmlReader = XMLReaderFactory.createXMLReader();
            }
            xmlReader.setErrorHandler(this.getErrorHandler());
            return xmlReader;
        }
        catch (Exception e) {
            void var1_2;
            throw new RuntimeException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Schema createSchema(Source[] schemaSources) {
        try {
            void var1_1;
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            schemaFactory.setResourceResolver(new CatalogResourceResolver((Map<URI, URL>)new HashMap<URI, URL>(){
                {
                    this.put(XML_SCHEMA_NAMESPACE, XML_SCHEMA_RESOURCE);
                }
            }));
            return schemaFactory.newSchema((Source[])var1_1);
        }
        catch (Exception e) {
            void var2_3;
            throw new RuntimeException((Throwable)var2_3);
        }
    }

    protected Source[] getSchemaSources() {
        return null;
    }

    protected ErrorHandler getErrorHandler() {
        return new SimpleErrorHandler();
    }

    /*
     * WARNING - void declaration
     */
    public void parse(InputSource source) throws ParserException {
        try {
            this.xr.parse(source);
            return;
        }
        catch (Exception e) {
            void var1_2;
            throw new ParserException((Throwable)var1_2);
        }
    }

    public static class Handler<I>
    extends DefaultHandler {
        private final Logger logger = LoggerFactory.getLogger(SAXParser.class);
        protected SAXParser parser;
        protected I instance;
        protected Handler parent;
        protected StringBuilder characters = new StringBuilder();
        protected Attributes attributes;

        /*
         * WARNING - void declaration
         */
        public Handler(I instance) {
            this(var1_1, null, null);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Handler(I instance, SAXParser parser) {
            this(var1_1, (SAXParser)var2_2, null);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Handler(I instance, Handler parent) {
            this(var1_1, parent.getParser(), (Handler)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Handler(I instance, SAXParser parser, Handler parent) {
            void var3_3;
            void var1_1;
            this.instance = var1_1;
            this.parser = parser;
            this.parent = var3_3;
            if (parser != null) {
                void var2_2;
                var2_2.setContentHandler(this);
            }
        }

        public I getInstance() {
            return this.instance;
        }

        public SAXParser getParser() {
            return this.parser;
        }

        public Handler getParent() {
            return this.parent;
        }

        protected void switchToParent() {
            if (this.parser != null && this.parent != null) {
                this.parser.setContentHandler(this.parent);
                this.attributes = null;
            }
        }

        public String getCharacters() {
            return this.characters.toString();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            void var2_2;
            this.characters = new StringBuilder();
            this.attributes = new AttributesImpl(attributes);
            this.logger.trace("{} starting: {}", (Object)this.getClass().getSimpleName(), (Object)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            void var3_3;
            void var2_2;
            void var1_1;
            this.characters.append((char[])var1_1, (int)var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            void var2_2;
            void var3_3;
            void var1_1;
            if (this.isLastElement((String)var1_1, localName, (String)var3_3)) {
                this.logger.trace("{}: last element, switching to parent: {}", (Object)this.getClass().getSimpleName(), (Object)localName);
                this.switchToParent();
                return;
            }
            this.logger.trace("{} ending: {}", (Object)this.getClass().getSimpleName(), (Object)var2_2);
        }

        protected boolean isLastElement(String uri, String localName, String qName) {
            return false;
        }

        protected Attributes getAttributes() {
            return this.attributes;
        }
    }

    public static class SimpleErrorHandler
    implements ErrorHandler {
        /*
         * WARNING - void declaration
         */
        @Override
        public void warning(SAXParseException e) throws SAXException {
            void var1_1;
            throw new SAXException((Exception)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void error(SAXParseException e) throws SAXException {
            void var1_1;
            throw new SAXException((Exception)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            void var1_1;
            throw new SAXException((Exception)var1_1);
        }
    }
}

