/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.xml;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.jupnp.xml.CatalogResourceResolver;
import org.jupnp.xml.DOM;
import org.jupnp.xml.DOMElement;
import org.jupnp.xml.ParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class DOMParser<D extends DOM>
implements EntityResolver,
ErrorHandler {
    private final Logger logger = LoggerFactory.getLogger(DOMParser.class);
    public static final URL XML_SCHEMA_RESOURCE = Thread.currentThread().getContextClassLoader().getResource("org/jupnp/schemas/xml.xsd");
    protected Source[] schemaSources;
    protected Schema schema;

    protected DOMParser() {
        this(null);
    }

    /*
     * WARNING - void declaration
     */
    protected DOMParser(Source[] schemaSources) {
        void var1_1;
        this.schemaSources = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Schema getSchema() {
        if (this.schema == null) {
            try {
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                schemaFactory.setResourceResolver(new CatalogResourceResolver((Map<URI, URL>)new HashMap<URI, URL>(){
                    {
                        this.put(DOM.XML_SCHEMA_NAMESPACE, XML_SCHEMA_RESOURCE);
                    }
                }));
                this.schema = this.schemaSources != null ? schemaFactory.newSchema(this.schemaSources) : schemaFactory.newSchema();
            }
            catch (Exception e) {
                void var1_2;
                throw new RuntimeException((Throwable)var1_2);
            }
        }
        return this.schema;
    }

    protected abstract D createDOM(Document var1);

    /*
     * WARNING - void declaration
     */
    public DocumentBuilderFactory createFactory(boolean validating) throws ParserException {
        void var2_3;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setNamespaceAware(true);
            if (validating) {
                factory.setXIncludeAware(true);
                factory.setFeature("http://apache.org/xml/features/xinclude/fixup-base-uris", false);
                factory.setFeature("http://apache.org/xml/features/xinclude/fixup-language", false);
                factory.setSchema(this.getSchema());
                factory.setFeature("http://apache.org/xml/features/validation/dynamic", true);
            }
        }
        catch (ParserConfigurationException e) {
            void var1_2;
            throw new ParserException((Throwable)var1_2);
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public Transformer createTransformer(String method, int indent, boolean standalone) throws ParserException {
        try {
            void var1_1;
            void var3_3;
            TransformerFactory transFactory = TransformerFactory.newInstance();
            if (indent > 0) {
                try {
                    transFactory.setAttribute("indent-number", indent);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            Transformer transformer = transFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", standalone ? "no" : "yes");
            if (var3_3 != false) {
                try {
                    transformer.setOutputProperty("http://www.oracle.com/xml/is-standalone", "yes");
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            transformer.setOutputProperty("indent", indent > 0 ? "yes" : "no");
            if (indent > 0) {
                void var2_2;
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", Integer.toString((int)var2_2));
            }
            transformer.setOutputProperty("method", (String)var1_1);
            return transformer;
        }
        catch (Exception e) {
            throw new ParserException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public D createDocument() {
        try {
            DOMParser dOMParser = this;
            return dOMParser.createDOM(dOMParser.createFactory(false).newDocumentBuilder().newDocument());
        }
        catch (Exception e) {
            void var1_1;
            throw new RuntimeException((Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public D parse(URL url) throws ParserException {
        void var1_1;
        return this.parse((URL)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public D parse(String string) throws ParserException {
        void var1_1;
        return this.parse((String)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public D parse(File file) throws ParserException {
        void var1_1;
        return this.parse((File)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public D parse(InputStream stream) throws ParserException {
        void var1_1;
        return this.parse((InputStream)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public D parse(URL url, boolean validate) throws ParserException {
        if (url == null) {
            throw new IllegalArgumentException("Can't parse null URL");
        }
        try {
            return this.parse(url.openStream(), validate);
        }
        catch (Exception e) {
            void var2_3;
            void var1_1;
            throw new ParserException("Parsing URL failed: " + String.valueOf(var1_1), (Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public D parse(String string, boolean validate) throws ParserException {
        void var2_2;
        void var1_1;
        if (string == null) {
            throw new IllegalArgumentException("Can't parse null string");
        }
        return this.parse(new InputSource(new StringReader((String)var1_1)), (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public D parse(File file, boolean validate) throws ParserException {
        if (file == null) {
            throw new IllegalArgumentException("Can't parse null file");
        }
        try {
            return this.parse(file.toURI().toURL(), validate);
        }
        catch (Exception e) {
            void var2_3;
            void var1_1;
            throw new ParserException("Parsing file failed: " + String.valueOf(var1_1), (Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public D parse(InputStream stream, boolean validate) throws ParserException {
        void var2_2;
        void var1_1;
        return this.parse(new InputSource((InputStream)var1_1), (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public D parse(InputSource source, boolean validate) throws ParserException {
        try {
            void var1_1;
            DocumentBuilder parser = this.createFactory(validate).newDocumentBuilder();
            parser.setEntityResolver(this);
            parser.setErrorHandler(this);
            Document dom = parser.parse(source);
            dom.normalizeDocument();
            return this.createDOM((Document)var1_1);
        }
        catch (Exception e) {
            void var2_4;
            throw this.unwrapException((Exception)var2_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void validate(URL url) throws ParserException {
        void var1_1;
        if (url == null) {
            throw new IllegalArgumentException("Can't validate null URL");
        }
        this.logger.trace("Validating XML of URL: {}", (Object)url);
        this.validate(new StreamSource(var1_1.toString()));
    }

    /*
     * WARNING - void declaration
     */
    public void validate(String string) throws ParserException {
        void var1_1;
        if (string == null) {
            throw new IllegalArgumentException("Can't validate null string");
        }
        this.logger.trace("Validating XML string characters: {}", (Object)string.length());
        this.validate(new SAXSource(new InputSource(new StringReader((String)var1_1))));
    }

    /*
     * WARNING - void declaration
     */
    public void validate(Document document) throws ParserException {
        void var1_1;
        this.validate(new DOMSource((Node)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void validate(DOM dom) throws ParserException {
        void var1_1;
        this.validate(new DOMSource(var1_1.getW3CDocument()));
    }

    /*
     * WARNING - void declaration
     */
    public void validate(Source source) throws ParserException {
        try {
            void var1_1;
            Validator validator = this.getSchema().newValidator();
            validator.setErrorHandler(this);
            validator.validate((Source)var1_1);
            return;
        }
        catch (Exception e) {
            void var2_3;
            throw this.unwrapException((Exception)var2_3);
        }
    }

    public XPathFactory createXPathFactory() {
        return XPathFactory.newInstance();
    }

    /*
     * WARNING - void declaration
     */
    public XPath createXPath(NamespaceContext nsContext) {
        void var2_2;
        void var1_1;
        XPath xpath = this.createXPathFactory().newXPath();
        xpath.setNamespaceContext((NamespaceContext)var1_1);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public XPath createXPath(XPathFactory factory, NamespaceContext nsContext) {
        void var1_1;
        void var2_2;
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext((NamespaceContext)var2_2);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Object getXPathResult(DOM dom, XPath xpath, String expr, QName result) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.getXPathResult(var1_1.getW3CDocument(), (XPath)var2_2, (String)var3_3, result);
    }

    /*
     * WARNING - void declaration
     */
    public Object getXPathResult(DOMElement element, XPath xpath, String expr, QName result) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.getXPathResult(var1_1.getW3CElement(), (XPath)var2_2, (String)var3_3, result);
    }

    /*
     * WARNING - void declaration
     */
    public Object getXPathResult(Node context, XPath xpath, String expr, QName result) {
        try {
            void var3_4;
            void var2_3;
            this.logger.trace("Evaluating xpath query: {}", (Object)expr);
            return var2_3.evaluate((String)var3_4, context, result);
        }
        catch (Exception e) {
            void var1_2;
            throw new RuntimeException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public String print(DOM dom) throws ParserException {
        void var1_1;
        return this.print((DOM)var1_1, 4, true);
    }

    /*
     * WARNING - void declaration
     */
    public String print(DOM dom, int indent) throws ParserException {
        void var2_2;
        void var1_1;
        return this.print((DOM)var1_1, (int)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    public String print(DOM dom, boolean standalone) throws ParserException {
        void var2_2;
        void var1_1;
        return this.print((DOM)var1_1, 4, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public String print(DOM dom, int indent, boolean standalone) throws ParserException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.print(var1_1.getW3CDocument(), (int)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public String print(Document document, int indent, boolean standalone) throws ParserException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.removeIgnorableWSNodes(document.getDocumentElement());
        return this.print(new DOMSource(var1_1.getDocumentElement()), (int)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public String print(String string, int indent, boolean standalone) throws ParserException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.print(new StreamSource(new StringReader((String)var1_1)), (int)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public String print(Source source, int indent, boolean standalone) throws ParserException {
        try {
            void var3_6;
            void var1_1;
            Transformer transformer = this.createTransformer("xml", indent, standalone);
            transformer.setOutputProperty("encoding", "utf-8");
            StringWriter out = new StringWriter();
            transformer.transform((Source)var1_1, new StreamResult(out));
            out.flush();
            return var3_6.toString();
        }
        catch (Exception e) {
            void var2_4;
            throw new ParserException((Throwable)var2_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    public String printHTML(Document dom) throws ParserException {
        void var1_1;
        return this.printHTML((Document)var1_1, 4, true, true);
    }

    /*
     * WARNING - void declaration
     */
    public String printHTML(Document dom, int indent, boolean standalone, boolean doctype) throws ParserException {
        dom = (Document)dom.cloneNode(true);
        DOMParser.accept(dom.getDocumentElement(), new NodeVisitor(4){
            {
                void var2_2;
                super((short)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void visit(Node node) {
                void var1_1;
                CDATASection cdata = (CDATASection)node;
                cdata.getParentNode().setTextContent(var1_1.getData());
            }
        });
        this.removeIgnorableWSNodes(dom.getDocumentElement());
        try {
            String string;
            void var3_6;
            Transformer transformer = this.createTransformer("html", indent, standalone);
            if (doctype) {
                transformer.setOutputProperty("doctype-public", "-//W3C//DTD HTML 4.01 Transitional//EN");
                transformer.setOutputProperty("doctype-system", "http://www.w3.org/TR/html4/loose.dtd");
            }
            StringWriter out = new StringWriter();
            transformer.transform(new DOMSource(dom), new StreamResult(out));
            out.flush();
            String output = var3_6.toString();
            String meta = "\\s*<META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">";
            output = output.replaceFirst(meta, "");
            String xmlns = "<html xmlns=\"http://www.w3.org/1999/xhtml\">";
            string = string.replaceFirst(xmlns, "<html>");
            return string;
        }
        catch (Exception e) {
            void var2_4;
            throw new ParserException((Throwable)var2_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeIgnorableWSNodes(Element element) {
        Node nextNode = element.getFirstChild();
        while (nextNode != null) {
            void var3_3;
            Node child = nextNode;
            nextNode = child.getNextSibling();
            if (this.isIgnorableWSNode(child)) {
                element.removeChild(child);
                continue;
            }
            if (child.getNodeType() != 1) continue;
            this.removeIgnorableWSNodes((Element)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean isIgnorableWSNode(Node node) {
        void var1_1;
        return node.getNodeType() == 3 && var1_1.getTextContent().matches("[\\t\\n\\x0B\\f\\r\\s]+");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warning(SAXParseException e) throws SAXException {
        void var1_1;
        this.logger.warn(var1_1.toString());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(SAXParseException e) throws SAXException {
        void var1_1;
        throw new SAXException(new ParserException((SAXParseException)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        void var1_1;
        throw new SAXException(new ParserException((SAXParseException)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    protected ParserException unwrapException(Exception e) {
        void var1_1;
        if (e.getCause() != null && e.getCause() instanceof ParserException) {
            return (ParserException)e.getCause();
        }
        return new ParserException((Throwable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        InputSource is = systemId.startsWith("file://") ? new InputSource(new FileInputStream(new File(URI.create(systemId)))) : new InputSource(new ByteArrayInputStream(new byte[0]));
        is.setPublicId((String)var1_1);
        is.setSystemId((String)var2_2);
        return var3_3;
    }

    public static String escape(String string) {
        return DOMParser.escape(string, false, false);
    }

    /*
     * WARNING - void declaration
     */
    public static String escape(String string, boolean convertNewlines, boolean convertSpaces) {
        void var1_1;
        if (string == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < string.length()) {
            String entity = null;
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    entity = "&#60;";
                    break;
                }
                case '>': {
                    entity = "&#62;";
                    break;
                }
                case '&': {
                    entity = "&#38;";
                    break;
                }
                case '\"': {
                    entity = "&#34;";
                }
            }
            if (entity != null) {
                sb.append(entity);
            } else {
                sb.append(c);
            }
            ++i;
        }
        String result = sb.toString();
        if (convertSpaces) {
            void var2_3;
            Matcher matcher;
            Matcher matcher2 = Pattern.compile("(\\n+)(\\s*)(.*)").matcher(result);
            StringBuilder temp = new StringBuilder();
            while (matcher2.find()) {
                void var3_4;
                String group = matcher2.group(2);
                StringBuilder spaces = new StringBuilder();
                spaces.append("&#160;".repeat(var3_4.length()));
                matcher2.appendReplacement(temp, "$1" + String.valueOf(spaces) + "$3");
            }
            matcher.appendTail(temp);
            result = var2_3.toString();
        }
        if (var1_1 != false) {
            result = result.replaceAll("\n", "<br/>");
        }
        return result;
    }

    public static String stripElements(String xml) {
        String string;
        if (xml == null) {
            return null;
        }
        return string.replaceAll("<([a-zA-Z]|/).*?>", "");
    }

    /*
     * WARNING - void declaration
     */
    public static void accept(Node node, NodeVisitor visitor) {
        if (node == null) {
            return;
        }
        if (visitor.isHalted()) {
            return;
        }
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            void var3_3;
            Node child = children.item(i);
            if (child.getNodeType() == visitor.nodeType) {
                visitor.visit(child);
                if (visitor.isHalted()) break;
            }
            DOMParser.accept((Node)var3_3, visitor);
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String wrap(String wrapperName, String fragment) {
        void var1_1;
        return DOMParser.wrap(wrapperName, null, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String wrap(String wrapperName, String xmlns, String fragment) {
        void var3_3;
        String string;
        void var2_2;
        StringBuilder wrapper = new StringBuilder();
        wrapper.append("<").append(wrapperName);
        if (xmlns != null) {
            void var1_1;
            wrapper.append(" xmlns=\"").append((String)var1_1).append("\"");
        }
        wrapper.append(">");
        wrapper.append((String)var2_2);
        wrapper.append("</").append(string).append(">");
        return var3_3.toString();
    }

    public static abstract class NodeVisitor {
        private short nodeType;

        /*
         * WARNING - void declaration
         */
        protected NodeVisitor(short nodeType) {
            void var1_1;
            assert (nodeType < 12);
            this.nodeType = var1_1;
        }

        public boolean isHalted() {
            return false;
        }

        public abstract void visit(Node var1);
    }
}

