/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.xml;

import java.util.ArrayList;
import java.util.Collection;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import org.jupnp.xml.ParserException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class DOMElement<CHILD extends DOMElement, PARENT extends DOMElement> {
    public final Builder<PARENT> PARENT_BUILDER;
    public final ArrayBuilder<CHILD> CHILD_BUILDER;
    private final XPath xpath;
    private Element element;

    /*
     * WARNING - void declaration
     */
    protected DOMElement(XPath xpath, Element element) {
        void var2_2;
        void var1_1;
        this.xpath = var1_1;
        this.element = var2_2;
        this.PARENT_BUILDER = this.createParentBuilder(this);
        this.CHILD_BUILDER = this.createChildBuilder(this);
    }

    public Element getW3CElement() {
        return this.element;
    }

    public String getElementName() {
        return this.getW3CElement().getNodeName();
    }

    public String getContent() {
        return this.getW3CElement().getTextContent();
    }

    /*
     * WARNING - void declaration
     */
    public DOMElement<CHILD, PARENT> setContent(String content) {
        void var1_1;
        this.getW3CElement().setTextContent((String)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public String getAttribute(String attribute) {
        String v = this.getW3CElement().getAttribute(attribute);
        if (!v.isEmpty()) {
            void var1_1;
            return var1_1;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public DOMElement setAttribute(String attribute, String value) {
        void var2_2;
        void var1_1;
        this.getW3CElement().setAttribute((String)var1_1, (String)var2_2);
        return this;
    }

    public PARENT getParent() {
        return this.PARENT_BUILDER.build((Element)this.getW3CElement().getParentNode());
    }

    /*
     * WARNING - void declaration
     */
    public CHILD[] getChildren() {
        void var2_2;
        NodeList nodes = this.getW3CElement().getChildNodes();
        ArrayList children = new ArrayList();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeType() == 1) {
                children.add(this.CHILD_BUILDER.build((Element)node));
            }
            ++i;
        }
        return children.toArray(this.CHILD_BUILDER.newChildrenArray(var2_2.size()));
    }

    /*
     * WARNING - void declaration
     */
    public CHILD[] getChildren(String name) {
        void var1_1;
        DOMElement dOMElement = this;
        Collection<CHILD> list = dOMElement.getXPathChildElements(dOMElement.CHILD_BUILDER, this.prefix(name));
        return list.toArray(this.CHILD_BUILDER.newChildrenArray(var1_1.size()));
    }

    /*
     * WARNING - void declaration
     */
    public CHILD getRequiredChild(String name) throws ParserException {
        void var2_2;
        DOMElement[] children = this.getChildren(name);
        if (children.length != 1) {
            void var1_1;
            throw new ParserException("Required single child element of '" + this.getElementName() + "' not found: " + (String)var1_1);
        }
        return var2_2[0];
    }

    /*
     * WARNING - void declaration
     */
    public CHILD[] findChildren(String name) {
        void var1_1;
        DOMElement dOMElement = this;
        Collection<CHILD> list = dOMElement.getXPathChildElements(dOMElement.CHILD_BUILDER, "descendant::" + this.prefix(name));
        return list.toArray(this.CHILD_BUILDER.newChildrenArray(var1_1.size()));
    }

    /*
     * WARNING - void declaration
     */
    public CHILD findChildWithIdentifier(String id) {
        DOMElement dOMElement = this;
        Collection<CHILD> list = dOMElement.getXPathChildElements(dOMElement.CHILD_BUILDER, "descendant::" + this.prefix("*") + "[@id=\"" + id + "\"]");
        if (list.size() == 1) {
            void var1_1;
            return (CHILD)((DOMElement)var1_1.iterator().next());
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public CHILD getFirstChild(String name) {
        void var1_1;
        DOMElement dOMElement = this;
        return dOMElement.getXPathChildElement(dOMElement.CHILD_BUILDER, this.prefix((String)var1_1) + "[1]");
    }

    /*
     * WARNING - void declaration
     */
    public CHILD createChild(String name) {
        void var1_1;
        return this.createChild((String)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public CHILD createChild(String name, String namespaceURI) {
        void var1_1;
        void var2_2;
        Object child = this.CHILD_BUILDER.build(namespaceURI == null ? this.getW3CElement().getOwnerDocument().createElement(name) : this.getW3CElement().getOwnerDocument().createElementNS((String)var2_2, name));
        this.getW3CElement().appendChild(((DOMElement)child).getW3CElement());
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public CHILD appendChild(CHILD el, boolean copy) {
        void var1_1;
        void var2_2;
        DOMElement dOMElement = this;
        el = dOMElement.adoptOrImport(dOMElement.getW3CElement().getOwnerDocument(), el, (boolean)var2_2);
        this.getW3CElement().appendChild(((DOMElement)el).getW3CElement());
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public CHILD replaceChild(CHILD original, CHILD replacement, boolean copy) {
        void var2_2;
        void var1_1;
        void var3_3;
        DOMElement dOMElement = this;
        replacement = dOMElement.adoptOrImport(dOMElement.getW3CElement().getOwnerDocument(), replacement, (boolean)var3_3);
        this.getW3CElement().replaceChild(((DOMElement)replacement).getW3CElement(), var1_1.getW3CElement());
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public void replaceEqualChild(DOMElement source, String identifier) {
        void var1_1;
        void var3_3;
        void var2_2;
        CHILD original = this.findChildWithIdentifier(identifier);
        CHILD replacement = source.findChildWithIdentifier((String)var2_2);
        ((DOMElement)((DOMElement)original).getParent()).replaceChild(var3_3, var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public void removeChild(CHILD el) {
        void var1_1;
        this.getW3CElement().removeChild(var1_1.getW3CElement());
    }

    /*
     * WARNING - void declaration
     */
    public void removeChildren() {
        NodeList children = this.getW3CElement().getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            void var3_3;
            Node child = children.item(i);
            this.getW3CElement().removeChild((Node)var3_3);
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected CHILD adoptOrImport(Document document, CHILD child, boolean copy) {
        void var2_2;
        if (document != null) {
            void var1_1;
            void var3_3;
            child = var3_3 != false ? this.CHILD_BUILDER.build((Element)document.importNode(((DOMElement)child).getW3CElement(), true)) : this.CHILD_BUILDER.build((Element)var1_1.adoptNode(((DOMElement)child).getW3CElement()));
        }
        return var2_2;
    }

    protected abstract Builder<PARENT> createParentBuilder(DOMElement var1);

    protected abstract ArrayBuilder<CHILD> createChildBuilder(DOMElement var1);

    /*
     * WARNING - void declaration
     */
    public String toSimpleXMLString() {
        void var1_1;
        StringBuilder sb = new StringBuilder();
        sb.append("<").append(this.getElementName());
        NamedNodeMap map = this.getW3CElement().getAttributes();
        int i = 0;
        while (i < map.getLength()) {
            Node attr = map.item(i);
            sb.append(" ").append(attr.getNodeName()).append("=\"").append(attr.getTextContent()).append("\"");
            ++i;
        }
        if (!this.getContent().isEmpty()) {
            sb.append(">").append(this.getContent()).append("</").append(this.getElementName()).append(">");
        } else {
            sb.append("/>");
        }
        return var1_1.toString();
    }

    public String toString() {
        return "(" + this.getClass().getSimpleName() + ") " + (this.getW3CElement() == null ? "UNBOUND" : this.getElementName());
    }

    public XPath getXpath() {
        return this.xpath;
    }

    protected String prefix(String localName) {
        return localName;
    }

    /*
     * WARNING - void declaration
     */
    public Collection<PARENT> getXPathParentElements(Builder<CHILD> builder, String expr) {
        void var2_2;
        void var1_1;
        return this.getXPathElements((Builder)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public Collection<CHILD> getXPathChildElements(Builder<CHILD> builder, String expr) {
        void var2_2;
        void var1_1;
        return this.getXPathElements((Builder)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public PARENT getXPathParentElement(Builder<PARENT> builder, String expr) {
        DOMElement dOMElement = this;
        Node node = (Node)dOMElement.getXPathResult(dOMElement.getW3CElement(), expr, XPathConstants.NODE);
        if (node != null && node.getNodeType() == 1) {
            void var2_2;
            void var1_1;
            return (PARENT)var1_1.build((Element)var2_2);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public CHILD getXPathChildElement(Builder<CHILD> builder, String expr) {
        DOMElement dOMElement = this;
        Node node = (Node)dOMElement.getXPathResult(dOMElement.getW3CElement(), expr, XPathConstants.NODE);
        if (node != null && node.getNodeType() == 1) {
            void var2_2;
            void var1_1;
            return (CHILD)var1_1.build((Element)var2_2);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Collection getXPathElements(Builder builder, String expr) {
        void var3_3;
        ArrayList col = new ArrayList();
        DOMElement dOMElement = this;
        NodeList result = (NodeList)dOMElement.getXPathResult(dOMElement.getW3CElement(), expr, XPathConstants.NODESET);
        int i = 0;
        while (i < result.getLength()) {
            Object e = builder.build((Element)result.item(i));
            col.add(e);
            ++i;
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public String getXPathString(XPath xpath, String expr) {
        void var2_2;
        DOMElement dOMElement = this;
        return dOMElement.getXPathResult(dOMElement.getW3CElement(), (String)var2_2, null).toString();
    }

    /*
     * WARNING - void declaration
     */
    public Object getXPathResult(String expr, QName result) {
        void var2_2;
        void var1_1;
        DOMElement dOMElement = this;
        return dOMElement.getXPathResult(dOMElement.getW3CElement(), (String)var1_1, (QName)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public Object getXPathResult(Node context, String expr, QName result) {
        try {
            void var3_4;
            void var2_3;
            if (result == null) {
                return this.xpath.evaluate(expr, context);
            }
            return this.xpath.evaluate((String)var2_3, context, (QName)var3_4);
        }
        catch (Exception e) {
            void var1_2;
            throw new RuntimeException((Throwable)var1_2);
        }
    }

    public static abstract class ArrayBuilder<T extends DOMElement>
    extends Builder<T> {
        /*
         * WARNING - void declaration
         */
        protected ArrayBuilder(DOMElement element) {
            super((DOMElement)var1_1);
            void var1_1;
        }

        public abstract T[] newChildrenArray(int var1);

        public T[] getChildElements() {
            ArrayBuilder arrayBuilder = this;
            return arrayBuilder.buildArray(arrayBuilder.element.getChildren());
        }

        /*
         * WARNING - void declaration
         */
        public T[] getChildElements(String elementName) {
            void var1_1;
            ArrayBuilder arrayBuilder = this;
            return arrayBuilder.buildArray(arrayBuilder.element.getChildren((String)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        protected T[] buildArray(DOMElement[] list) {
            void var2_2;
            DOMElement[] children = this.newChildrenArray(list.length);
            int i = 0;
            while (i < children.length) {
                children[i] = this.build(list[i].getW3CElement());
                ++i;
            }
            return var2_2;
        }
    }

    public static abstract class Builder<T extends DOMElement> {
        public DOMElement element;

        /*
         * WARNING - void declaration
         */
        protected Builder(DOMElement element) {
            void var1_1;
            this.element = var1_1;
        }

        public abstract T build(Element var1);

        /*
         * WARNING - void declaration
         */
        public T firstChildOrNull(String elementName) {
            Object el = this.element.getFirstChild(elementName);
            if (el != null) {
                void var1_1;
                return this.build(var1_1.getW3CElement());
            }
            return null;
        }
    }
}

