/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.util.statemachine;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jupnp.util.statemachine.TransitionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateMachineInvocationHandler
implements InvocationHandler {
    private final Logger logger = LoggerFactory.getLogger(StateMachineInvocationHandler.class);
    public static final String METHOD_ON_ENTRY = "onEntry";
    public static final String METHOD_ON_EXIT = "onExit";
    final Class<?> initialStateClass;
    final Map<Class<?>, Object> stateObjects = new ConcurrentHashMap();
    Object currentState;

    /*
     * WARNING - void declaration
     */
    StateMachineInvocationHandler(List<Class<?>> stateClasses, Class<?> initialStateClass, Class<?>[] constructorArgumentTypes, Object[] constructorArguments) {
        void var2_2;
        StateMachineInvocationHandler stateMachineInvocationHandler;
        this.logger.debug("Creating state machine with initial state: {}", initialStateClass);
        this.initialStateClass = initialStateClass;
        for (Class<?> stateClass : stateClasses) {
            try {
                Object state = constructorArgumentTypes != null ? stateClass.getConstructor(constructorArgumentTypes).newInstance(constructorArguments) : stateClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.logger.debug("Adding state instance: {}", (Object)state.getClass().getName());
                this.stateObjects.put(stateClass, state);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("State " + stateClass.getName() + " has the wrong constructor", e);
            }
            catch (Exception e) {
                throw new RuntimeException("State " + ((Class)((Object)stateMachineInvocationHandler)).getName() + " can't be instantiated", e);
            }
        }
        if (!this.stateObjects.containsKey(initialStateClass)) {
            throw new RuntimeException("Initial state not in list of states: " + String.valueOf(initialStateClass));
        }
        this.currentState = this.stateObjects.get(var2_2);
        stateMachineInvocationHandler = this;
        synchronized (stateMachineInvocationHandler) {
            StateMachineInvocationHandler stateMachineInvocationHandler2 = this;
            stateMachineInvocationHandler2.invokeEntryMethod(stateMachineInvocationHandler2.currentState);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        StateMachineInvocationHandler stateMachineInvocationHandler = this;
        synchronized (stateMachineInvocationHandler) {
            void var2_2;
            Class nextStateClass;
            Object forcedState;
            block7: {
                if ("getCurrentState".equals(method.getName()) && method.getParameterTypes().length == 0) {
                    return this.currentState;
                }
                if (!"forceState".equals(method.getName()) || method.getParameterTypes().length != 1 || args.length != 1 || args[0] == null || !(args[0] instanceof Class)) break block7;
                forcedState = this.stateObjects.get((Class)args[0]);
                if (forcedState == null) {
                    throw new TransitionException("Can't force to invalid state: " + String.valueOf(args[0]));
                }
                this.logger.debug("Forcing state machine into state: {}", (Object)forcedState.getClass().getName());
                StateMachineInvocationHandler stateMachineInvocationHandler2 = this;
                stateMachineInvocationHandler2.invokeExitMethod(stateMachineInvocationHandler2.currentState);
                this.currentState = forcedState;
                this.invokeEntryMethod(forcedState);
                return null;
            }
            Method signalMethod = this.getMethodOfCurrentState((Method)forcedState);
            this.logger.debug("Invoking signal method of current state: {}", (Object)signalMethod);
            Object methodReturn = signalMethod.invoke(this.currentState, args);
            if (methodReturn != null && methodReturn instanceof Class && this.stateObjects.containsKey(nextStateClass = (Class)methodReturn)) {
                void var3_3;
                this.logger.debug("Executing transition to next state: {}", (Object)nextStateClass.getName());
                StateMachineInvocationHandler stateMachineInvocationHandler3 = this;
                stateMachineInvocationHandler3.invokeExitMethod(stateMachineInvocationHandler3.currentState);
                this.currentState = this.stateObjects.get(var3_3);
                StateMachineInvocationHandler stateMachineInvocationHandler4 = this;
                stateMachineInvocationHandler4.invokeEntryMethod(stateMachineInvocationHandler4.currentState);
            }
            return var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Method getMethodOfCurrentState(Method method) {
        try {
            return this.currentState.getClass().getMethod(method.getName(), method.getParameterTypes());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            void var1_1;
            throw new TransitionException("State '" + this.currentState.getClass().getName() + "' doesn't support signal '" + var1_1.getName() + "'");
        }
    }

    /*
     * WARNING - void declaration
     */
    private void invokeEntryMethod(Object state) {
        this.logger.debug("Trying to invoke entry method of state: {}", (Object)state.getClass().getName());
        try {
            Method method = state.getClass().getMethod(METHOD_ON_ENTRY, new Class[0]);
            method.invoke(state, new Object[0]);
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.logger.debug("No entry method found on state: {}", (Object)state.getClass().getName());
            return;
        }
        catch (Exception e) {
            void var2_3;
            void var1_1;
            throw new TransitionException("State '" + var1_1.getClass().getName() + "' entry method threw exception", (Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void invokeExitMethod(Object state) {
        this.logger.debug("Trying to invoking exit method of state: {}", (Object)state.getClass().getName());
        try {
            Method method = state.getClass().getMethod(METHOD_ON_EXIT, new Class[0]);
            method.invoke(state, new Object[0]);
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.logger.debug("No exit method found on state: {}", (Object)state.getClass().getName());
            return;
        }
        catch (Exception e) {
            void var2_3;
            void var1_1;
            throw new TransitionException("State '" + var1_1.getClass().getName() + "' exit method threw exception", (Throwable)var2_3);
        }
    }
}

