/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.util.io;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public final class HexBin {
    private static final int BASELENGTH = 255;
    private static final int LOOKUPLENGTH = 16;
    private static byte[] hexNumberTable = new byte[255];
    private static byte[] lookUpHexAlphabet = new byte[16];

    static {
        Arrays.fill(hexNumberTable, (byte)-1);
        int i = 57;
        while (i >= 48) {
            int n = i--;
            HexBin.hexNumberTable[n] = (byte)(n - 48);
        }
        i = 70;
        while (i >= 65) {
            int n = i--;
            HexBin.hexNumberTable[n] = (byte)(n - 65 + 10);
        }
        i = 102;
        while (i >= 97) {
            int n = i--;
            HexBin.hexNumberTable[n] = (byte)(n - 97 + 10);
        }
        i = 0;
        while (i < 10) {
            HexBin.lookUpHexAlphabet[i] = (byte)(i + 48);
            ++i;
        }
        i = 10;
        while (i <= 15) {
            HexBin.lookUpHexAlphabet[i] = (byte)(i + 65 - 10);
            ++i;
        }
    }

    static boolean isHex(byte octect) {
        byte by;
        return hexNumberTable[by] != -1;
    }

    public static String bytesToString(byte[] binaryData) {
        byte[] byArray;
        if (binaryData == null) {
            return null;
        }
        return new String(HexBin.encode(byArray));
    }

    /*
     * WARNING - void declaration
     */
    public static String bytesToString(byte[] binaryData, String separator) {
        void var2_3;
        if (binaryData == null) {
            return null;
        }
        Object s = new String(HexBin.encode(binaryData));
        StringBuilder sb = new StringBuilder();
        int i = 1;
        char[] cArray = s.toCharArray();
        s = cArray;
        char[] cArray2 = cArray;
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            void var0_1;
            char c = cArray2[n2];
            sb.append((char)var0_1);
            if (i == 2) {
                sb.append(separator);
                i = 1;
            } else {
                ++i;
            }
            ++n2;
        }
        StringBuilder stringBuilder = sb;
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return var2_3.toString();
    }

    public static byte[] stringToBytes(String hexEncoded) {
        return HexBin.decode(hexEncoded.getBytes());
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] stringToBytes(String hexEncoded, String separator) {
        void var1_1;
        return HexBin.decode(hexEncoded.replaceAll((String)var1_1, "").getBytes());
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] encode(byte[] binaryData) {
        void var2_3;
        if (binaryData == null) {
            return null;
        }
        int lengthData = binaryData.length;
        int n = lengthData << 1;
        byte[] encodedData = new byte[n];
        int i = 0;
        while (i < lengthData) {
            encodedData[i << 1] = lookUpHexAlphabet[binaryData[i] >> 4 & 0xF];
            encodedData[(i << 1) + 1] = lookUpHexAlphabet[binaryData[i] & 0xF];
            ++i;
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] decode(byte[] binaryData) {
        void var2_2;
        if (binaryData == null) {
            return null;
        }
        int lengthData = binaryData.length;
        if (lengthData % 2 != 0) {
            return null;
        }
        int lengthDecode = lengthData / 2;
        byte[] decodedData = new byte[lengthDecode];
        int i = 0;
        while (i < lengthDecode) {
            if (!HexBin.isHex(binaryData[i << 1]) || !HexBin.isHex(binaryData[(i << 1) + 1])) {
                return null;
            }
            decodedData[i] = (byte)(hexNumberTable[binaryData[i << 1]] << 4 | hexNumberTable[binaryData[(i << 1) + 1]]);
            ++i;
        }
        return var2_2;
    }

    public static String decode(String binaryData) {
        Object object;
        if (binaryData == null) {
            return null;
        }
        byte[] byArray = HexBin.decode(binaryData.getBytes(StandardCharsets.UTF_8));
        Object decoded = byArray;
        if (byArray == null) {
            return null;
        }
        return new String((byte[])object);
    }

    public static String encode(String binaryData) {
        Object object;
        if (binaryData == null) {
            return null;
        }
        byte[] byArray = HexBin.encode(binaryData.getBytes(StandardCharsets.UTF_8));
        Object encoded = byArray;
        if (byArray == null) {
            return null;
        }
        return new String((byte[])object);
    }
}

