/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Reflections {
    /*
     * WARNING - void declaration
     */
    public static Object invoke(Method method, Object target, Object ... args) throws Exception {
        try {
            return method.invoke(target, args);
        }
        catch (IllegalArgumentException iae) {
            Object object;
            void var1_1;
            Object message = "Could not invoke method by reflection: " + Reflections.toString(method);
            if (args != null && args.length > 0) {
                void var2_2;
                message = (String)message + " with parameters: (" + Reflections.toClassNameString(", ", (Object[])var2_2) + ")";
            }
            message = (String)message + " on: " + var1_1.getClass().getName();
            throw new IllegalArgumentException((String)object, iae);
        }
        catch (InvocationTargetException invocationTargetException) {
            void var3_4;
            InvocationTargetException ite = invocationTargetException;
            if (invocationTargetException.getCause() instanceof Exception) {
                throw (Exception)ite.getCause();
            }
            throw var3_4;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Object get(Field field, Object target) throws Exception {
        Object object;
        boolean accessible = Reflections.canAccessField(field);
        try {
            field.setAccessible(true);
            object = field.get(target);
        }
        catch (IllegalArgumentException iae) {
            try {
                void var3_5;
                void var1_1;
                String message = "Could not get field value by reflection: " + Reflections.toString(field) + " on: " + target.getClass().getName();
                throw new IllegalArgumentException((String)var1_1, (Throwable)var3_5);
            }
            catch (Throwable throwable) {
                void var2_3;
                Field field2;
                field2.setAccessible((boolean)var2_3);
                throw throwable;
            }
        }
        field.setAccessible(accessible);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static Method getMethod(Class clazz, String name) {
        void var1_1;
        Class clazz2;
        Class superClass = clazz;
        while (superClass != null && superClass != Object.class) {
            try {
                return superClass.getDeclaredMethod(name, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                superClass = superClass.getSuperclass();
            }
        }
        throw new IllegalArgumentException("No such method: " + clazz2.getName() + "." + (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void set(Field field, Object target, Object value) throws Exception {
        void var3_5;
        Field field2;
        boolean accessible = Reflections.canAccessField(field);
        try {
            try {
                field.setAccessible(true);
                field.set(target, value);
            }
            catch (IllegalArgumentException iae) {
                void var1_2;
                void var2_4;
                String message = "Could not set field value by reflection: " + Reflections.toString(field) + " on: " + field.getDeclaringClass().getName();
                message = value == null ? message + " with null value" : message + " with value: " + String.valueOf(var2_4.getClass());
                throw new IllegalArgumentException(message, (Throwable)var1_2);
            }
        }
        catch (Throwable throwable) {
            field.setAccessible(accessible);
            throw throwable;
        }
        field2.setAccessible((boolean)var3_5);
    }

    /*
     * WARNING - void declaration
     */
    public static String getMethodPropertyName(String methodName) {
        void var1_1;
        String methodPropertyName = null;
        if (methodName.startsWith("get")) {
            methodPropertyName = Reflections.decapitalize(methodName.substring(3));
        } else if (methodName.startsWith("is")) {
            methodPropertyName = Reflections.decapitalize(methodName.substring(2));
        } else if (methodName.startsWith("set")) {
            String string;
            methodPropertyName = Reflections.decapitalize(string.substring(3));
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static Method getGetterMethod(Class clazz, String name) {
        Class superClass = clazz;
        while (superClass != null && superClass != Object.class) {
            Method[] methodArray = superClass.getDeclaredMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                String methodName = method.getName();
                if (method.getParameterTypes().length == 0) {
                    if (methodName.startsWith("get")) {
                        if (Reflections.decapitalize(methodName.substring(3)).equals(name)) {
                            return method;
                        }
                    } else if (methodName.startsWith("is") && Reflections.decapitalize(methodName.substring(2)).equals(name)) {
                        void var2_2;
                        return var2_2;
                    }
                }
                ++n2;
            }
            superClass = superClass.getSuperclass();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static List<Method> getMethods(Class clazz, Class annotation) {
        void var2_2;
        Class superClass;
        ArrayList<void> methods = new ArrayList<void>();
        while (superClass != null && superClass != Object.class) {
            Method[] methodArray = superClass.getDeclaredMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.isAnnotationPresent(annotation)) {
                    void var3_3;
                    methods.add(var3_3);
                }
                ++n2;
            }
            superClass = superClass.getSuperclass();
        }
        return var2_2;
    }

    public static Field getField(Class clazz, String name) {
        Class superClass = clazz;
        while (superClass != null && superClass != Object.class) {
            try {
                return superClass.getDeclaredField(name);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                superClass = superClass.getSuperclass();
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static List<Field> getFields(Class clazz, Class annotation) {
        void var2_2;
        Class superClass;
        ArrayList<void> fields = new ArrayList<void>();
        while (superClass != null && superClass != Object.class) {
            Field[] fieldArray = superClass.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (field.isAnnotationPresent(annotation)) {
                    void var3_3;
                    fields.add(var3_3);
                }
                ++n2;
            }
            superClass = superClass.getSuperclass();
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<Class<?>> getTypeArguments(Class<T> baseClass, Class<? extends T> childClass) {
        void var1_1;
        Type[] actualTypeArguments;
        Type type;
        HashMap resolvedTypes = new HashMap();
        while (!Reflections.getClass(type).equals(baseClass)) {
            if (type instanceof Class) {
                type = ((Class)type).getGenericSuperclass();
                continue;
            }
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawType = (Class)parameterizedType.getRawType();
            actualTypeArguments = parameterizedType.getActualTypeArguments();
            TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
            int i = 0;
            while (i < actualTypeArguments.length) {
                resolvedTypes.put(typeParameters[i], actualTypeArguments[i]);
                ++i;
            }
            if (rawType.equals(baseClass)) continue;
            type = rawType.getGenericSuperclass();
        }
        actualTypeArguments = type instanceof Class ? ((Class)type).getTypeParameters() : ((ParameterizedType)var1_1).getActualTypeArguments();
        ArrayList typeArgumentsAsClasses = new ArrayList();
        Type[] typeArray = actualTypeArguments;
        int n = actualTypeArguments.length;
        int n2 = 0;
        while (n2 < n) {
            void var3_3;
            Type baseType = typeArray[n2];
            while (resolvedTypes.containsKey(baseType)) {
                baseType = (Type)resolvedTypes.get(baseType);
            }
            typeArgumentsAsClasses.add(Reflections.getClass((Type)var3_3));
            ++n2;
        }
        return typeArgumentsAsClasses;
    }

    public static Class<?> getClass(Type type) {
        while (true) {
            if (type instanceof Class) {
                return (Class)type;
            }
            if (!(type instanceof ParameterizedType)) break;
            type = ((ParameterizedType)type).getRawType();
        }
        if (type instanceof GenericArrayType) {
            Class<?> componentClass = Reflections.getClass(type = ((GenericArrayType)type).getGenericComponentType());
            if (componentClass != null) {
                Class<?> clazz;
                return Array.newInstance(clazz, 0).getClass();
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static Object getAndWrap(Field field, Object target) {
        boolean accessible = Reflections.canAccessField(field);
        try {
            field.setAccessible(true);
            target = Reflections.get(field, target);
            field.setAccessible(accessible);
            return target;
        }
        catch (Exception exception) {
            try {
                void var1_1;
                Exception e = exception;
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new IllegalArgumentException("exception setting: " + field.getName(), (Throwable)var1_1);
            }
            catch (Throwable throwable) {
                void var2_3;
                Field field2;
                field2.setAccessible((boolean)var2_3);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void setAndWrap(Field field, Object target, Object value) {
        void var3_4;
        Field field2;
        boolean accessible = Reflections.canAccessField(field);
        try {
            try {
                void var2_3;
                field.setAccessible(true);
                Reflections.set(field, target, var2_3);
            }
            catch (Exception exception) {
                void var1_1;
                Exception e = exception;
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new IllegalArgumentException("exception setting: " + field.getName(), (Throwable)var1_1);
            }
        }
        catch (Throwable throwable) {
            field.setAccessible(accessible);
            throw throwable;
        }
        field2.setAccessible((boolean)var3_4);
    }

    /*
     * WARNING - void declaration
     */
    public static Object invokeAndWrap(Method method, Object target, Object ... args) {
        try {
            void var2_2;
            return Reflections.invoke(method, target, (Object[])var2_2);
        }
        catch (Exception exception) {
            void var1_1;
            Method method2;
            Exception e = exception;
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("exception invoking: " + method2.getName(), (Throwable)var1_1);
        }
    }

    public static String toString(Member member) {
        Member member2;
        return Reflections.unqualify(member.getDeclaringClass().getName()) + "." + member2.getName();
    }

    public static Class classForName(String name) throws ClassNotFoundException {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(name);
        }
        catch (Exception exception) {
            String string;
            return Class.forName(string);
        }
    }

    public static boolean isClassAvailable(String name) {
        try {
            Reflections.classForName(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }

    public static Class getCollectionElementType(Type collectionType) {
        Object object;
        if (!(collectionType instanceof ParameterizedType)) {
            throw new IllegalArgumentException("collection type not parameterized");
        }
        Object typeArguments = ((ParameterizedType)collectionType).getActualTypeArguments();
        if (((Type[])typeArguments).length == 0) {
            throw new IllegalArgumentException("no type arguments for collection type");
        }
        Object typeArgument = ((Type[])typeArguments).length == 1 ? typeArguments[0] : typeArguments[1];
        if (typeArgument instanceof ParameterizedType) {
            typeArgument = ((ParameterizedType)typeArgument).getRawType();
        }
        if (!(typeArgument instanceof Class)) {
            throw new IllegalArgumentException("type argument not a class");
        }
        return (Class)object;
    }

    public static Class getMapKeyType(Type collectionType) {
        Object object;
        if (!(collectionType instanceof ParameterizedType)) {
            throw new IllegalArgumentException("collection type not parameterized");
        }
        Object typeArguments = ((ParameterizedType)collectionType).getActualTypeArguments();
        if (((Type[])typeArguments).length == 0) {
            throw new IllegalArgumentException("no type arguments for collection type");
        }
        Object typeArgument = typeArguments[0];
        if (!(typeArgument instanceof Class)) {
            throw new IllegalArgumentException("type argument not a class");
        }
        return (Class)object;
    }

    /*
     * WARNING - void declaration
     */
    public static Method getSetterMethod(Class clazz, String name) {
        void var1_1;
        Class clazz2;
        Method[] methodArray;
        Method[] methodArray2 = methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray2[n2];
            String methodName = method.getName();
            if (methodName.startsWith("set") && method.getParameterTypes().length == 1 && Reflections.decapitalize(methodName.substring(3)).equals(name)) {
                return methodArray;
            }
            ++n2;
        }
        throw new IllegalArgumentException("no such setter method: " + clazz2.getName() + "." + (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Method getMethod(Annotation annotation, String name) {
        try {
            void var1_1;
            return annotation.annotationType().getMethod((String)var1_1, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static boolean isInstanceOf(Class clazz, String name) {
        Class c;
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        while (c != Object.class) {
            if (Reflections.instanceOf(c, name)) {
                return true;
            }
            c = c.getSuperclass();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean instanceOf(Class clazz, String name) {
        void var2_2;
        if (name.equals(clazz.getName())) {
            return true;
        }
        boolean found = false;
        Class<?>[] interfaces = clazz.getInterfaces();
        int i = 0;
        while (i < interfaces.length && !found) {
            found = Reflections.instanceOf(interfaces[i], name);
            ++i;
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static String toClassNameString(String sep, Object ... objects) {
        String string;
        void var2_2;
        if (objects.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            builder.append(sep);
            if (object == null) {
                builder.append("null");
            } else {
                void var1_1;
                builder.append(var1_1.getClass().getName());
            }
            ++n2;
        }
        return var2_2.substring(string.length());
    }

    public static String unqualify(String name) {
        return Reflections.unqualify(name, '.');
    }

    /*
     * WARNING - void declaration
     */
    public static String unqualify(String name, char sep) {
        void var1_1;
        String string = name;
        return string.substring(string.lastIndexOf((int)var1_1) + 1);
    }

    public static String decapitalize(String name) {
        Object object;
        if (name == null) {
            return null;
        }
        if (name.isEmpty() || name.length() > 1 && Character.isUpperCase(name.charAt(1))) {
            return name;
        }
        char[] cArray = name.toCharArray();
        Object chars = cArray;
        cArray[0] = Character.toLowerCase((char)chars[0]);
        return new String((char[])object);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean canAccessField(Field field) {
        boolean isAccessible = field.isAccessible();
        try {
            field.setAccessible(true);
        }
        catch (SecurityException securityException) {
            field.setAccessible(isAccessible);
            return false;
        }
        catch (Throwable throwable) {
            void var1_1;
            Field field2;
            field2.setAccessible((boolean)var1_1);
            throw throwable;
        }
        field.setAccessible(isAccessible);
        return true;
    }
}

