/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class MimeType {
    public static final String WILDCARD = "*";
    private String type;
    private String subtype;
    private Map<String, String> parameters;

    public MimeType() {
        this(WILDCARD, WILDCARD);
    }

    /*
     * WARNING - void declaration
     */
    public MimeType(String type, String subtype, Map<String, String> parameters) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.type = type == null ? WILDCARD : type;
        Object object = this.subtype = subtype == null ? WILDCARD : var2_2;
        if (parameters == null) {
            this.parameters = Map.of();
            return;
        }
        TreeMap map = new TreeMap(String::compareToIgnoreCase);
        map.putAll(var3_3);
        this.parameters = Collections.unmodifiableMap(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public MimeType(String type, String subtype) {
        this((String)var1_1, (String)var2_2, Map.of());
        void var2_2;
        void var1_1;
    }

    public String getType() {
        return this.type;
    }

    public boolean isWildcardType() {
        return this.getType().equals(WILDCARD);
    }

    public String getSubtype() {
        return this.subtype;
    }

    public boolean isWildcardSubtype() {
        return this.getSubtype().equals(WILDCARD);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isCompatible(MimeType other) {
        void var1_1;
        if (other == null) {
            return false;
        }
        if (this.type.equals(WILDCARD) || other.type.equals(WILDCARD)) {
            return true;
        }
        if (this.type.equalsIgnoreCase(other.type) && (this.subtype.equals(WILDCARD) || other.subtype.equals(WILDCARD))) {
            return true;
        }
        return this.type.equalsIgnoreCase(other.type) && this.subtype.equalsIgnoreCase(var1_1.subtype);
    }

    /*
     * WARNING - void declaration
     */
    public static MimeType valueOf(String stringValue) throws IllegalArgumentException {
        void var3_4;
        void var2_3;
        if (stringValue == null) {
            throw new IllegalArgumentException("String value is null");
        }
        String params = null;
        int semicolonIndex = stringValue.indexOf(";");
        if (semicolonIndex >= 0) {
            params = stringValue.substring(semicolonIndex + 1).trim();
            stringValue = stringValue.substring(0, semicolonIndex);
        }
        String major = null;
        String subtype = null;
        String[] paths = stringValue.split("/");
        if (paths.length < 2 && stringValue.equals(WILDCARD)) {
            major = WILDCARD;
            subtype = WILDCARD;
        } else if (paths.length == 2) {
            major = paths[0].trim();
            subtype = paths[1].trim();
        } else if (paths.length != 2) {
            throw new IllegalArgumentException("Error parsing string: " + stringValue);
        }
        if (params != null && !params.isEmpty()) {
            HashMap hashMap;
            HashMap map = new HashMap();
            int start = 0;
            while (start < params.length()) {
                start = MimeType.readParamsIntoMap(map, params, start);
            }
            return new MimeType(major, subtype, hashMap);
        }
        return new MimeType((String)var2_3, (String)var3_4);
    }

    /*
     * WARNING - void declaration
     */
    public static int readParamsIntoMap(Map<String, String> map, String params, int start) {
        void var2_3;
        Map<String, String> map2;
        void var1_1;
        boolean quote = false;
        boolean backslash = false;
        int end = MimeType.getEnd(params, start);
        String name = params.substring(start, end).trim();
        if (end < params.length() && params.charAt(end) == '=') {
            ++end;
        }
        StringBuilder buffer = new StringBuilder(params.length() - end);
        int i = end;
        while (i < var1_1.length()) {
            char c = params.charAt(i);
            switch (c) {
                case '\"': {
                    if (backslash) {
                        backslash = false;
                        buffer.append(c);
                        break;
                    }
                    quote = !quote;
                    break;
                }
                case '\\': {
                    if (backslash) {
                        backslash = false;
                        buffer.append(c);
                        break;
                    }
                    backslash = true;
                    break;
                }
                case ';': {
                    if (!quote) {
                        String value = buffer.toString().trim();
                        map.put(name, (String)var1_1);
                        return i + 1;
                    }
                    buffer.append(c);
                    break;
                }
                default: {
                    buffer.append(c);
                }
            }
            ++i;
        }
        String value = buffer.toString().trim();
        map2.put((String)var2_3, value);
        return i;
    }

    /*
     * WARNING - void declaration
     */
    protected static int getEnd(String params, int start) {
        void var1_1;
        void var2_2;
        int equals = params.indexOf(61, start);
        int semicolon = params.indexOf(59, start);
        if (equals == -1 && semicolon == -1) {
            String string;
            return string.length();
        }
        if (equals == -1) {
            return semicolon;
        }
        if (semicolon == -1) {
            return equals;
        }
        return Math.min((int)var2_2, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MimeType mimeType = (MimeType)o;
        if (!Objects.equals(this.parameters, mimeType.parameters)) {
            return false;
        }
        if (!this.subtype.equalsIgnoreCase(mimeType.subtype)) {
            return false;
        }
        return this.type.equalsIgnoreCase(var1_1.type);
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int result = this.type.toLowerCase().hashCode();
        result = result * 31 + this.subtype.toLowerCase().hashCode();
        var1_1 = var1_1 * 31 + (this.parameters != null ? this.parameters.hashCode() : 0);
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder sb = new StringBuilder();
        sb.append(this.toStringNoParameters());
        if (this.getParameters() != null || !this.getParameters().isEmpty()) {
            for (String name : this.getParameters().keySet()) {
                void var2_3;
                sb.append(";").append(name).append("=\"").append(this.getParameters().get(var2_3)).append("\"");
            }
        }
        return var1_1.toString();
    }

    public String toStringNoParameters() {
        return this.getType() + "/" + this.getSubtype();
    }
}

