/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.transport.spi;

import org.jupnp.model.message.StreamRequestMessage;
import org.jupnp.model.message.StreamResponseMessage;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.protocol.ProtocolCreationException;
import org.jupnp.protocol.ProtocolFactory;
import org.jupnp.protocol.ReceivingSync;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UpnpStream
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(UpnpStream.class);
    protected final ProtocolFactory protocolFactory;
    protected ReceivingSync syncProtocol;

    /*
     * WARNING - void declaration
     */
    protected UpnpStream(ProtocolFactory protocolFactory) {
        void var1_1;
        this.protocolFactory = var1_1;
    }

    public ProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    /*
     * WARNING - void declaration
     */
    public StreamResponseMessage process(StreamRequestMessage requestMsg) {
        void var1_1;
        this.logger.trace("Processing stream request message: {}", (Object)requestMsg);
        try {
            this.syncProtocol = this.getProtocolFactory().createReceivingSync(requestMsg);
        }
        catch (ProtocolCreationException e) {
            this.logger.warn("Processing stream request failed", (Throwable)e);
            return new StreamResponseMessage(UpnpResponse.Status.NOT_IMPLEMENTED);
        }
        this.logger.trace("Running protocol for synchronous message processing: {}", (Object)this.syncProtocol);
        this.syncProtocol.run();
        Object responseMsg = this.syncProtocol.getOutputMessage();
        if (responseMsg == null) {
            this.logger.trace("Protocol did not return any response message");
            return null;
        }
        this.logger.trace("Protocol returned response: {}", responseMsg);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected void responseSent(StreamResponseMessage responseMessage) {
        if (this.syncProtocol != null) {
            void var1_1;
            this.syncProtocol.responseSent((StreamResponseMessage)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void responseException(Throwable t) {
        if (this.syncProtocol != null) {
            void var1_1;
            this.syncProtocol.responseException((Throwable)var1_1);
        }
    }

    public String toString() {
        return "(" + this.getClass().getSimpleName() + ")";
    }
}

