/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.transport.spi;

import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jupnp.model.message.StreamRequestMessage;
import org.jupnp.model.message.StreamResponseMessage;
import org.jupnp.transport.spi.StreamClient;
import org.jupnp.transport.spi.StreamClientConfiguration;
import org.jupnp.util.Exceptions;
import org.jupnp.util.SpecificationViolationReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStreamClient<C extends StreamClientConfiguration, REQUEST>
implements StreamClient<C> {
    private final Logger logger = LoggerFactory.getLogger(StreamClient.class);
    private static final int FAILED_REQUESTS_MAX_SIZE = 100;
    private Map<URI, Long> failedRequests = new ConcurrentHashMap<URI, Long>();
    private Map<URI, Long> failedTries = new ConcurrentHashMap<URI, Long>();

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public StreamResponseMessage sendRequest(StreamRequestMessage requestMessage) throws InterruptedException {
        REQUEST request;
        this.logger.trace("Preparing HTTP request: {}", (Object)requestMessage);
        Object object = requestMessage.getUri().toString().split(":");
        object = object[0];
        if (object.equals("https")) {
            SpecificationViolationReporter.report("HTTPS invalid.  Ignoring call " + String.valueOf(requestMessage.getUri()), new Object[0]);
            return null;
        }
        long start = System.nanoTime();
        this.failedTries.putIfAbsent(requestMessage.getUri(), 0L);
        Long previeousFailureTime = this.failedRequests.get(requestMessage.getUri());
        Long numberOfTries = this.failedTries.get(requestMessage.getUri());
        if (this.getConfiguration().getRetryAfterSeconds() > 0 && previeousFailureTime != null) {
            if (start - previeousFailureTime < TimeUnit.SECONDS.toNanos(this.getConfiguration().getRetryAfterSeconds()) && numberOfTries >= (long)this.getConfiguration().getRetryIterations()) {
                this.logger.debug("Will not attempt request because it failed {} times in the last {} seconds: {}", new Object[]{numberOfTries, this.getConfiguration().getRetryAfterSeconds(), requestMessage});
                return null;
            }
            if (start - previeousFailureTime < TimeUnit.SECONDS.toNanos(this.getConfiguration().getRetryAfterSeconds()) && numberOfTries > 0L) {
                this.logger.debug("Previous attempt failed {} times.  Will retry {}", (Object)numberOfTries, (Object)requestMessage);
            } else {
                this.logger.debug("Clearing failed attempt after {} tries", (Object)numberOfTries);
                this.failedRequests.remove(requestMessage.getUri());
                this.failedTries.put(requestMessage.getUri(), 0L);
            }
        }
        if ((request = this.createRequest(requestMessage)) == null) {
            return null;
        }
        Callable<StreamResponseMessage> callable = this.createCallable(requestMessage, request);
        RequestWrapper requestWrapper = new RequestWrapper(callable);
        Future<StreamResponseMessage> future = this.getConfiguration().getRequestExecutorService().submit(requestWrapper);
        try {
            this.logger.trace("Waiting {} seconds for HTTP request to complete: {}", (Object)this.getConfiguration().getTimeoutSeconds(), (Object)requestMessage);
            StreamResponseMessage response = future.get(this.getConfiguration().getTimeoutSeconds(), TimeUnit.SECONDS);
            long elapsed = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
            this.logger.trace("Got HTTP response in {} ms: {}", (Object)elapsed, (Object)requestMessage);
            if (this.getConfiguration().getLogWarningSeconds() > 0 && elapsed > TimeUnit.SECONDS.toMillis(this.getConfiguration().getLogWarningSeconds())) {
                this.logger.warn("HTTP request took a long time ({} ms): {}", (Object)elapsed, (Object)requestMessage);
            }
            StreamResponseMessage streamResponseMessage = response;
            this.onFinally(request);
            return streamResponseMessage;
        }
        catch (InterruptedException interruptedException) {
            this.logger.trace("Interruption, aborting request: {}", (Object)requestMessage);
            this.abort(request);
            throw new InterruptedException("HTTP request interrupted and aborted");
            catch (TimeoutException timeoutException) {
                void var3_6;
                this.logger.info("Timeout of {} seconds while waiting for HTTP request to complete, aborting: {}", (Object)this.getConfiguration().getTimeoutSeconds(), (Object)requestMessage);
                this.abort(request);
                this.handleRequestTimeout(requestMessage, (RequestWrapper)var3_6);
                this.onFinally(request);
                return null;
            }
            catch (ExecutionException executionException) {
                try {
                    void var1_1;
                    ExecutionException executionException2 = executionException;
                    Throwable cause = executionException.getCause();
                    if (!this.logExecutionException(cause)) {
                        String message = "HTTP request failed: " + String.valueOf(requestMessage);
                        if (this.logger.isDebugEnabled()) {
                            this.logger.warn(message, Exceptions.unwrap(cause));
                        } else {
                            this.logger.warn("{} ({})", (Object)message, (Object)Exceptions.unwrap(cause).getMessage());
                        }
                    }
                    this.handleRequestFailure((StreamRequestMessage)var1_1);
                    this.onFinally(request);
                    return null;
                }
                catch (Throwable throwable) {
                    this.onFinally(object);
                    throw throwable;
                }
            }
        }
    }

    protected abstract REQUEST createRequest(StreamRequestMessage var1);

    protected abstract Callable<StreamResponseMessage> createCallable(StreamRequestMessage var1, REQUEST var2);

    protected abstract void abort(REQUEST var1);

    protected abstract boolean logExecutionException(Throwable var1);

    protected void onFinally(REQUEST request) {
    }

    /*
     * WARNING - void declaration
     */
    private void handleRequestFailure(StreamRequestMessage requestMessage) {
        void var1_1;
        if (this.getConfiguration().getRetryAfterSeconds() <= 0) {
            return;
        }
        long currentTime = System.nanoTime();
        this.failedRequests.put(requestMessage.getUri(), currentTime);
        this.failedTries.put(requestMessage.getUri(), this.failedTries.get(var1_1.getUri()) + 1L);
        if (this.failedRequests.size() > 100) {
            void var2_2;
            this.cleanOldFailedRequests((long)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void handleRequestTimeout(StreamRequestMessage requestMessage, RequestWrapper requestWrapper) {
        void var3_3;
        void var1_1;
        void var2_2;
        if (this.getConfiguration().getRetryAfterSeconds() <= 0) {
            return;
        }
        long currentTime = System.nanoTime();
        if (requestWrapper.startTime != null && currentTime - var2_2.startTime > TimeUnit.SECONDS.toNanos(this.getConfiguration().getTimeoutSeconds())) {
            this.failedRequests.put(requestMessage.getUri(), currentTime);
        }
        this.failedTries.put(requestMessage.getUri(), this.failedTries.get(var1_1.getUri()) + 1L);
        this.cleanOldFailedRequests((long)var3_3);
    }

    private void cleanOldFailedRequests(long currentTime) {
        if (this.failedRequests.size() <= 100) {
            return;
        }
        Iterator<Map.Entry<URI, Long>> it = this.failedRequests.entrySet().iterator();
        while (it.hasNext()) {
            long l = currentTime - it.next().getValue();
            if (l <= TimeUnit.SECONDS.toNanos(this.getConfiguration().getRetryAfterSeconds())) continue;
            it.remove();
        }
    }

    private static class RequestWrapper
    implements Callable<StreamResponseMessage> {
        Callable<StreamResponseMessage> task;
        Long startTime = null;

        /*
         * WARNING - void declaration
         */
        public RequestWrapper(Callable<StreamResponseMessage> task) {
            void var1_1;
            this.task = var1_1;
        }

        @Override
        public StreamResponseMessage call() throws Exception {
            this.startTime = System.nanoTime();
            return this.task.call();
        }
    }
}

