/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.transport.impl.jetty;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.util.BytesContentProvider;
import org.eclipse.jetty.client.util.StringContentProvider;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.jupnp.http.Headers;
import org.jupnp.model.message.StreamRequestMessage;
import org.jupnp.model.message.StreamResponseMessage;
import org.jupnp.model.message.UpnpHeaders;
import org.jupnp.model.message.UpnpMessage;
import org.jupnp.model.message.UpnpOperation;
import org.jupnp.model.message.UpnpRequest;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.model.message.header.UpnpHeader;
import org.jupnp.transport.impl.jetty.HeaderUtil;
import org.jupnp.transport.impl.jetty.StreamClientConfigurationImpl;
import org.jupnp.transport.spi.AbstractStreamClient;
import org.jupnp.transport.spi.InitializationException;
import org.jupnp.transport.spi.StreamClient;
import org.jupnp.util.SpecificationViolationReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyStreamClientImpl
extends AbstractStreamClient<StreamClientConfigurationImpl, Request> {
    private final Logger logger = LoggerFactory.getLogger(StreamClient.class);
    protected final StreamClientConfigurationImpl configuration;
    protected final HttpClient httpClient;
    protected final HttpFields defaultHttpFields = new HttpFields();

    /*
     * WARNING - void declaration
     */
    public JettyStreamClientImpl(StreamClientConfigurationImpl configuration) throws InitializationException {
        this.configuration = configuration;
        this.httpClient = new HttpClient();
        this.httpClient.setConnectTimeout((long)((this.getConfiguration().getTimeoutSeconds() + 5) * 1000));
        this.httpClient.setMaxConnectionsPerDestination(2);
        int cpus = Runtime.getRuntime().availableProcessors();
        int maxThreads = 5 * cpus;
        QueuedThreadPool queuedThreadPool = this.createThreadPool("jupnp-jetty-client", 5, maxThreads, 60000);
        this.httpClient.setExecutor((Executor)queuedThreadPool);
        if (this.getConfiguration().getSocketBufferSize() != -1) {
            this.httpClient.setRequestBufferSize(this.getConfiguration().getSocketBufferSize());
            this.httpClient.setResponseBufferSize(this.getConfiguration().getSocketBufferSize());
        }
        try {
            this.httpClient.start();
            return;
        }
        catch (Exception e) {
            void var1_4;
            this.logger.error("Failed to instantiate HTTP client", (Throwable)e);
            throw new InitializationException("Failed to instantiate HTTP client", (Throwable)var1_4);
        }
    }

    @Override
    public StreamClientConfigurationImpl getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Request createRequest(StreamRequestMessage requestMessage) {
        void var3_4;
        void var1_1;
        void var2_3;
        Request request;
        UpnpRequest upnpRequest = (UpnpRequest)requestMessage.getOperation();
        this.logger.trace("Creating HTTP request. URI: '{}' method: '{}'", (Object)upnpRequest.getURI(), (Object)upnpRequest.getMethod());
        switch (upnpRequest.getMethod()) {
            case GET: 
            case POST: 
            case NOTIFY: 
            case SUBSCRIBE: 
            case UNSUBSCRIBE: {
                try {
                    request = this.httpClient.newRequest(upnpRequest.getURI()).method(upnpRequest.getHttpMethodName());
                    break;
                }
                catch (IllegalArgumentException e) {
                    void var1_2;
                    this.logger.debug("Cannot create request because URI '{}' is invalid", (Object)upnpRequest.getURI(), (Object)var1_2);
                    return null;
                }
            }
            default: {
                throw new RuntimeException("Unknown HTTP method: " + upnpRequest.getHttpMethodName());
            }
        }
        switch (var2_3.getMethod()) {
            case POST: 
            case NOTIFY: {
                request.content((ContentProvider)this.createContentProvider((UpnpMessage)var1_1));
            }
        }
        request.getHeaders().add(this.defaultHttpFields);
        if (((UpnpRequest)var1_1.getOperation()).getHttpMinorVersion() == 0) {
            request.version(HttpVersion.HTTP_1_0);
        } else {
            request.version(HttpVersion.HTTP_1_1);
            request.header(HttpHeader.CONNECTION, "close");
        }
        if (!var1_1.getHeaders().containsKey(UpnpHeader.Type.USER_AGENT)) {
            request.agent(this.getConfiguration().getUserAgentValue(var1_1.getUdaMajorVersion(), var1_1.getUdaMinorVersion()));
        }
        HeaderUtil.add(request, (Headers)var1_1.getHeaders());
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Callable<StreamResponseMessage> createCallable(StreamRequestMessage requestMessage, Request request) {
        void var2_2;
        void var1_1;
        return () -> this.lambda$0((StreamRequestMessage)var1_1, (Request)var2_2);
    }

    @Override
    protected void abort(Request request) {
        request.abort((Throwable)new Exception("Request aborted by API"));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean logExecutionException(Throwable t) {
        if (t instanceof IllegalStateException) {
            this.logger.trace("Illegal state: {}", (Object)t.getMessage());
            return true;
        }
        if (t.getMessage().contains("HTTP protocol violation")) {
            void var1_1;
            SpecificationViolationReporter.report(var1_1.getMessage(), new Object[0]);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void stop() {
        this.logger.trace("Shutting down HTTP client connection manager/pool");
        try {
            this.httpClient.stop();
            return;
        }
        catch (Exception e) {
            void var1_1;
            this.logger.info("Shutting down of HTTP client throwed exception", (Throwable)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected <O extends UpnpOperation> ContentProvider.Typed createContentProvider(UpnpMessage<O> upnpMessage) {
        void var1_1;
        if (upnpMessage.getBodyType().equals((Object)UpnpMessage.BodyType.STRING)) {
            this.logger.trace("Preparing HTTP request entity as String");
            return new StringContentProvider(upnpMessage.getBodyString(), upnpMessage.getContentTypeCharset());
        }
        this.logger.trace("Preparing HTTP request entity as byte[]");
        return new BytesContentProvider((byte[][])new byte[][]{var1_1.getBodyBytes()});
    }

    /*
     * WARNING - void declaration
     */
    private QueuedThreadPool createThreadPool(String consumerName, int minThreads, int maxThreads, int keepAliveTimeout) {
        void var2_3;
        void var1_1;
        void var3_4;
        QueuedThreadPool queuedThreadPool = new QueuedThreadPool((int)var3_4, minThreads, keepAliveTimeout);
        queuedThreadPool.setName((String)var1_1);
        queuedThreadPool.setDaemon(true);
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ StreamResponseMessage lambda$0(StreamRequestMessage streamRequestMessage, Request request) throws Exception {
        this.logger.trace("Sending HTTP request: {}", (Object)streamRequestMessage);
        try {
            void var3_4;
            ContentResponse httpResponse = request.send();
            this.logger.trace("Received HTTP response: {}", (Object)httpResponse.getReason());
            UpnpResponse responseOperation = new UpnpResponse(httpResponse.getStatus(), httpResponse.getReason());
            StreamResponseMessage responseMessage = new StreamResponseMessage(responseOperation);
            responseMessage.setHeaders(new UpnpHeaders(HeaderUtil.get((Response)httpResponse)));
            byte[] bytes = httpResponse.getContent();
            if (bytes == null || bytes.length == 0) {
                this.logger.trace("HTTP response message has no entity");
                return responseMessage;
            }
            if (responseMessage.isContentTypeMissingOrText()) {
                this.logger.trace("HTTP response message contains text entity");
            } else {
                this.logger.trace("HTTP response message contains binary entity");
            }
            responseMessage.setBodyCharacters(bytes);
            return var3_4;
        }
        catch (RuntimeException e) {
            void var1_2;
            this.logger.error("Request: {} failed", (Object)request, (Object)e);
            throw var1_2;
        }
    }
}

