/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.transport.impl.jetty;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.jupnp.transport.spi.ServletContainerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyServletContainer
implements ServletContainerAdapter {
    private final Logger logger = LoggerFactory.getLogger((String)JettyServletContainer.class.getName());
    public static final JettyServletContainer INSTANCE = new JettyServletContainer();
    protected Server server;

    private JettyServletContainer() {
        this.resetServer();
    }

    @Override
    public synchronized void setExecutorService(ExecutorService executorService) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized int addConnector(String host, int port) throws IOException {
        void var3_4;
        void var2_3;
        ServerConnector connector = new ServerConnector(this.server);
        connector.setHost(host);
        connector.setPort((int)var2_3);
        connector.open();
        this.server.addConnector((Connector)connector);
        if (this.server.isStarted()) {
            try {
                connector.start();
            }
            catch (Exception e) {
                void var1_2;
                this.logger.warn("Couldn't start connector: {}", (Object)connector, (Object)e);
                throw new RuntimeException("Couldn't start connector", (Throwable)var1_2);
            }
        }
        return var3_4.getLocalPort();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void registerServlet(String contextPath, Servlet servlet) {
        void var3_3;
        void var1_1;
        void var2_2;
        if (this.server.getHandler() != null) {
            this.logger.trace("Server handler is already set: {}", (Object)this.server.getHandler());
            return;
        }
        this.logger.info("Registering UPnP servlet under context path: {}", (Object)contextPath);
        ServletContextHandler servletHandler = new ServletContextHandler(0);
        if (contextPath != null && !contextPath.isEmpty()) {
            servletHandler.setContextPath(contextPath);
        }
        ServletHolder s = new ServletHolder((Servlet)var2_2);
        servletHandler.addServlet((ServletHolder)var1_1, "/*");
        this.server.setHandler((Handler)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void startIfNotRunning() {
        if (!this.server.isStarted() && !this.server.isStarting()) {
            this.logger.info("Starting Jetty server... ");
            try {
                this.server.start();
                return;
            }
            catch (Exception e) {
                void var1_1;
                this.logger.error("Couldn't start Jetty server", (Throwable)e);
                throw new RuntimeException((Throwable)var1_1);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void stopIfRunning() {
        if (!this.server.isStopped() && !this.server.isStopping()) {
            this.logger.info("Stopping Jetty server...");
            try {
                try {
                    this.server.stop();
                }
                catch (Exception e) {
                    void var1_1;
                    this.logger.error("Couldn't stop Jetty server", (Throwable)e);
                    throw new RuntimeException((Throwable)var1_1);
                }
            }
            finally {
                this.resetServer();
            }
        }
    }

    protected void resetServer() {
        this.server = new Server();
    }
}

