/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.transport.impl.blocking;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jupnp.model.message.Connection;
import org.jupnp.protocol.ProtocolFactory;
import org.jupnp.transport.Router;
import org.jupnp.transport.impl.ServletConnection;
import org.jupnp.transport.impl.ServletStreamServerConfigurationImpl;
import org.jupnp.transport.impl.blocking.BlockingServletUpnpStream;
import org.jupnp.transport.impl.blocking.FauxAsyncContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingServlet
extends HttpServlet {
    private static final long serialVersionUID = 3124088565842038644L;
    private final Logger logger = LoggerFactory.getLogger(BlockingServlet.class);
    private final Router router;
    private int mCounter = 0;
    private final ServletStreamServerConfigurationImpl configuration;

    /*
     * WARNING - void declaration
     */
    public BlockingServlet(Router router, ServletStreamServerConfigurationImpl configuration) {
        void var2_2;
        void var1_1;
        this.router = var1_1;
        this.configuration = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        void var1_1;
        void var2_2;
        void var3_3;
        long startTime = System.currentTimeMillis();
        int counter = this.mCounter++;
        this.logger.trace("{}", (Object)String.format("HttpServlet.service(): id: %3d, request URI: %s", counter, req.getRequestURI()));
        this.logger.trace("Handling Servlet request synchronously: {}", (Object)req);
        FauxAsyncContext asyncContext = new FauxAsyncContext(req, resp);
        asyncContext.setTimeout(this.configuration.getAsyncTimeoutSeconds() * 1000);
        BlockingServlet blockingServlet = this;
        BlockingServletUpnpStream stream = new BlockingServletUpnpStream(blockingServlet.router.getProtocolFactory(), asyncContext){
            {
                void var3_3;
                void var2_2;
                super((ProtocolFactory)var2_2, (FauxAsyncContext)var3_3);
            }

            @Override
            protected Connection createConnection() {
                return new ServletConnection(this.getRequest());
            }
        };
        this.router.received(stream);
        asyncContext.waitForTimeoutOrCompletion();
        long duration = System.currentTimeMillis() - var3_3;
        if (asyncContext.isCompleted()) {
            this.logger.trace("{}", (Object)String.format("BlockingServlet completed: id: %3d, duration: %,4d", counter, duration));
            return;
        }
        var2_2.setStatus(500);
        this.logger.warn("{}", (Object)String.format("BlockingServlet timed out: id: %3d, duration: %,4d, request: %s", counter, duration, var1_1));
    }
}

