/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.transport.impl.async;

import java.io.IOException;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jupnp.protocol.ProtocolFactory;
import org.jupnp.transport.impl.ServletUpnpStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AsyncServletUpnpStream
extends ServletUpnpStream
implements AsyncListener {
    private final Logger logger = LoggerFactory.getLogger(AsyncServletUpnpStream.class);
    protected final AsyncContext asyncContext;
    protected final HttpServletRequest request;

    /*
     * WARNING - void declaration
     */
    protected AsyncServletUpnpStream(ProtocolFactory protocolFactory, AsyncContext asyncContext, HttpServletRequest request) {
        super((ProtocolFactory)var1_1);
        void var2_2;
        void var3_3;
        void var1_1;
        this.asyncContext = asyncContext;
        this.request = var3_3;
        var2_2.addListener((AsyncListener)this);
    }

    @Override
    protected HttpServletRequest getRequest() {
        return this.request;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected HttpServletResponse getResponse() {
        void var1_1;
        ServletResponse response = this.asyncContext.getResponse();
        if (response == null) {
            throw new IllegalStateException("Couldn't get response from asynchronous context, already timed out");
        }
        return (HttpServletResponse)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void complete() {
        try {
            this.asyncContext.complete();
            return;
        }
        catch (IllegalStateException e) {
            void var1_1;
            this.logger.info("Error calling servlet container's AsyncContext#complete() method", (Throwable)var1_1);
            return;
        }
    }

    public void onStartAsync(AsyncEvent event) throws IOException {
    }

    /*
     * WARNING - void declaration
     */
    public void onComplete(AsyncEvent event) throws IOException {
        void var1_1;
        this.logger.trace("Completed asynchronous processing of HTTP request: {}", (Object)var1_1.getSuppliedRequest());
        AsyncServletUpnpStream asyncServletUpnpStream = this;
        asyncServletUpnpStream.responseSent(asyncServletUpnpStream.responseMessage);
    }

    /*
     * WARNING - void declaration
     */
    public void onTimeout(AsyncEvent event) throws IOException {
        void var1_1;
        this.logger.trace("Asynchronous processing of HTTP request timed out: {}", (Object)var1_1.getSuppliedRequest());
        this.responseException(new Exception("Asynchronous request timed out"));
    }

    /*
     * WARNING - void declaration
     */
    public void onError(AsyncEvent event) throws IOException {
        void var1_1;
        this.logger.trace("Asynchronous processing of HTTP request error", event.getThrowable());
        this.responseException(var1_1.getThrowable());
    }

    @Override
    public String toString() {
        return "" + this.hashCode();
    }
}

