/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.transport.impl;

import java.net.InetAddress;
import javax.servlet.Servlet;
import org.jupnp.transport.Router;
import org.jupnp.transport.impl.ServletStreamServerConfigurationImpl;
import org.jupnp.transport.impl.async.AsyncServlet;
import org.jupnp.transport.impl.async.AsyncUtil;
import org.jupnp.transport.impl.blocking.BlockingServlet;
import org.jupnp.transport.spi.InitializationException;
import org.jupnp.transport.spi.StreamServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletStreamServerImpl
implements StreamServer<ServletStreamServerConfigurationImpl> {
    private final Logger logger = LoggerFactory.getLogger(ServletStreamServerImpl.class);
    protected final ServletStreamServerConfigurationImpl configuration;
    protected int localPort;

    /*
     * WARNING - void declaration
     */
    public ServletStreamServerImpl(ServletStreamServerConfigurationImpl configuration) {
        void var1_1;
        this.configuration = var1_1;
    }

    @Override
    public ServletStreamServerConfigurationImpl getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void init(InetAddress bindAddress, Router router) throws InitializationException {
        try {
            void var2_3;
            Servlet servlet;
            this.logger.debug("Setting executor service on servlet container adapter");
            this.getConfiguration().getServletContainerAdapter().setExecutorService(router.getConfiguration().getStreamServerExecutorService());
            this.logger.debug("Adding connector: {}:{}", (Object)bindAddress, (Object)this.getConfiguration().getListenPort());
            this.localPort = this.getConfiguration().getServletContainerAdapter().addConnector(bindAddress.getHostAddress(), this.getConfiguration().getListenPort());
            String contextPath = router.getConfiguration().getNamespace().getBasePath().getPath();
            servlet = AsyncUtil.SERVLET3_SUPPORT ? this.createAsyncServlet(router) : this.createBlockingServlet((Router)servlet);
            this.getConfiguration().getServletContainerAdapter().registerServlet(contextPath, (Servlet)var2_3);
            return;
        }
        catch (Exception e) {
            void var1_2;
            throw new InitializationException("Could not initialize " + this.getClass().getSimpleName(), (Throwable)var1_2);
        }
    }

    @Override
    public synchronized int getPort() {
        return this.localPort;
    }

    @Override
    public synchronized void stop() {
        this.getConfiguration().getServletContainerAdapter().stopIfRunning();
    }

    @Override
    public void run() {
        this.getConfiguration().getServletContainerAdapter().startIfNotRunning();
    }

    /*
     * WARNING - void declaration
     */
    protected Servlet createAsyncServlet(Router router) {
        void var1_1;
        return new AsyncServlet((Router)var1_1, this.getConfiguration());
    }

    /*
     * WARNING - void declaration
     */
    protected Servlet createBlockingServlet(Router router) {
        void var1_1;
        return new BlockingServlet((Router)var1_1, this.getConfiguration());
    }
}

