/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.transport.impl;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jupnp.model.UnsupportedDataException;
import org.jupnp.model.XMLUtil;
import org.jupnp.model.action.ActionArgumentValue;
import org.jupnp.model.action.ActionException;
import org.jupnp.model.action.ActionInvocation;
import org.jupnp.model.message.control.ActionMessage;
import org.jupnp.model.message.control.ActionRequestMessage;
import org.jupnp.model.message.control.ActionResponseMessage;
import org.jupnp.model.meta.ActionArgument;
import org.jupnp.model.types.ErrorCode;
import org.jupnp.model.types.InvalidValueException;
import org.jupnp.transport.impl.PooledXmlProcessor;
import org.jupnp.transport.spi.SOAPActionProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SOAPActionProcessorImpl
extends PooledXmlProcessor
implements SOAPActionProcessor,
ErrorHandler {
    private final Logger logger = LoggerFactory.getLogger(SOAPActionProcessor.class);

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeBody(ActionRequestMessage requestMessage, ActionInvocation actionInvocation) throws UnsupportedDataException {
        this.logger.trace("Writing body of {} for: {}", (Object)requestMessage, (Object)actionInvocation);
        try {
            void var2_2;
            Document d = this.newDocument();
            Element body = this.writeBodyElement(d);
            this.writeBodyRequest(d, body, requestMessage, (ActionInvocation)var2_2);
            if (this.logger.isTraceEnabled()) {
                void var1_1;
                this.logger.trace("===================================== SOAP BODY BEGIN ============================================");
                this.logger.trace(var1_1.getBodyString());
                this.logger.trace("-===================================== SOAP BODY END ============================================");
                return;
            }
        }
        catch (Exception e) {
            void var3_4;
            throw new UnsupportedDataException("Can't transform message payload", (Throwable)var3_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeBody(ActionResponseMessage responseMessage, ActionInvocation actionInvocation) throws UnsupportedDataException {
        this.logger.trace("Writing body of {} for: {}", (Object)responseMessage, (Object)actionInvocation);
        try {
            Document d = this.newDocument();
            Element body = this.writeBodyElement(d);
            if (actionInvocation.getFailure() != null) {
                this.writeBodyFailure(d, body, responseMessage, actionInvocation);
            } else {
                void var2_2;
                this.writeBodyResponse(d, body, responseMessage, (ActionInvocation)var2_2);
            }
            if (this.logger.isTraceEnabled()) {
                void var1_1;
                this.logger.trace("===================================== SOAP BODY BEGIN ============================================");
                this.logger.trace(var1_1.getBodyString());
                this.logger.trace("-===================================== SOAP BODY END ============================================");
                return;
            }
        }
        catch (Exception e) {
            void var3_4;
            throw new UnsupportedDataException("Can't transform message payload", (Throwable)var3_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void readBody(ActionRequestMessage requestMessage, ActionInvocation actionInvocation) throws UnsupportedDataException {
        this.logger.trace("Reading body of {} for: {}", (Object)requestMessage, (Object)actionInvocation);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("===================================== SOAP BODY BEGIN ============================================");
            this.logger.trace(requestMessage.getBodyString());
            this.logger.trace("-===================================== SOAP BODY END ============================================");
        }
        String body = this.getMessageBody(requestMessage);
        try {
            void var2_2;
            void var1_1;
            Document d = this.readDocument(new InputSource(new StringReader(body)), this);
            Element bodyElement = this.readBodyElement(d);
            this.readBodyRequest(d, bodyElement, (ActionRequestMessage)var1_1, (ActionInvocation)var2_2);
            return;
        }
        catch (Exception e) {
            void var3_3;
            throw new UnsupportedDataException("Can't transform message payload", e, var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void readBody(ActionResponseMessage responseMsg, ActionInvocation actionInvocation) throws UnsupportedDataException {
        this.logger.trace("Reading body of {} for: {}", (Object)responseMsg, (Object)actionInvocation);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("===================================== SOAP BODY BEGIN ============================================");
            this.logger.trace(responseMsg.getBodyString());
            this.logger.trace("-===================================== SOAP BODY END ============================================");
        }
        String body = this.getMessageBody(responseMsg);
        try {
            void var2_2;
            Document d = this.readDocument(new InputSource(new StringReader(body)), this);
            Element bodyElement = this.readBodyElement(d);
            ActionException failure = this.readBodyFailure(d, bodyElement);
            if (failure == null) {
                void var1_1;
                this.readBodyResponse(d, bodyElement, (ActionResponseMessage)var1_1, actionInvocation);
                return;
            }
            var2_2.setFailure(failure);
            return;
        }
        catch (Exception e) {
            void var3_3;
            throw new UnsupportedDataException("Can't transform message payload", e, var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void writeBodyFailure(Document d, Element bodyElement, ActionResponseMessage message, ActionInvocation actionInvocation) throws Exception {
        void var1_1;
        void var3_3;
        void var2_2;
        this.writeFaultElement(d, (Element)var2_2, actionInvocation);
        var3_3.setBody(this.toString((Document)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    protected void writeBodyRequest(Document d, Element bodyElement, ActionRequestMessage message, ActionInvocation actionInvocation) throws Exception {
        void var1_1;
        void var3_3;
        void var2_2;
        Element actionRequestElement = this.writeActionRequestElement(d, bodyElement, message, actionInvocation);
        this.writeActionInputArguments(d, (Element)var2_2, actionInvocation);
        var3_3.setBody(this.toString((Document)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    protected void writeBodyResponse(Document d, Element bodyElement, ActionResponseMessage message, ActionInvocation actionInvocation) throws Exception {
        void var1_1;
        void var3_3;
        void var2_2;
        Element actionResponseElement = this.writeActionResponseElement(d, bodyElement, message, actionInvocation);
        this.writeActionOutputArguments(d, (Element)var2_2, actionInvocation);
        var3_3.setBody(this.toString((Document)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    protected ActionException readBodyFailure(Document d, Element bodyElement) throws Exception {
        void var2_2;
        return this.readFaultElement((Element)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected void readBodyRequest(Document d, Element bodyElement, ActionRequestMessage message, ActionInvocation actionInvocation) throws Exception {
        void var1_1;
        void var3_3;
        void var2_2;
        Element actionRequestElement = this.readActionRequestElement((Element)var2_2, (ActionRequestMessage)var3_3, actionInvocation);
        this.readActionInputArguments((Element)var1_1, actionInvocation);
    }

    /*
     * WARNING - void declaration
     */
    protected void readBodyResponse(Document d, Element bodyElement, ActionResponseMessage message, ActionInvocation actionInvocation) throws Exception {
        void var1_1;
        void var2_2;
        Element actionResponse = this.readActionResponseElement((Element)var2_2, actionInvocation);
        this.readActionOutputArguments((Element)var1_1, actionInvocation);
    }

    /*
     * WARNING - void declaration
     */
    protected Element writeBodyElement(Document d) {
        void var1_1;
        void var2_2;
        void var3_3;
        Element envelopeElement = d.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "s:Envelope");
        Attr encodingStyleAttr = d.createAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "s:encodingStyle");
        encodingStyleAttr.setValue("http://schemas.xmlsoap.org/soap/encoding/");
        envelopeElement.setAttributeNode((Attr)var3_3);
        d.appendChild(envelopeElement);
        Element bodyElement = d.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "s:Body");
        var2_2.appendChild(bodyElement);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected Element readBodyElement(Document d) {
        Element envelopeElement = d.getDocumentElement();
        if (envelopeElement == null || !this.getUnprefixedNodeName(envelopeElement).equals("Envelope")) {
            throw new RuntimeException("Response root element was not 'Envelope'");
        }
        NodeList envelopeElementChildren = envelopeElement.getChildNodes();
        int i = 0;
        while (i < envelopeElementChildren.getLength()) {
            Node envelopeChild = envelopeElementChildren.item(i);
            if (envelopeChild.getNodeType() == 1 && this.getUnprefixedNodeName(envelopeChild).equals("Body")) {
                void var3_3;
                return (Element)var3_3;
            }
            ++i;
        }
        throw new RuntimeException("Response envelope did not contain 'Body' child element");
    }

    /*
     * WARNING - void declaration
     */
    protected Element writeActionRequestElement(Document d, Element bodyElement, ActionRequestMessage message, ActionInvocation actionInvocation) {
        void var1_1;
        void var2_2;
        void var3_3;
        this.logger.trace("Writing action request element: {}", (Object)actionInvocation.getAction().getName());
        Element actionRequestElement = d.createElementNS(var3_3.getActionNamespace(), "u:" + actionInvocation.getAction().getName());
        var2_2.appendChild(actionRequestElement);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected Element readActionRequestElement(Element bodyElement, ActionRequestMessage message, ActionInvocation actionInvocation) {
        void var2_2;
        NodeList bodyChildren = bodyElement.getChildNodes();
        this.logger.trace("Looking for action request element matching namespace: {}", (Object)message.getActionNamespace());
        int i = 0;
        while (i < bodyChildren.getLength()) {
            String unprefixedName;
            Node bodyChild = bodyChildren.item(i);
            if (bodyChild.getNodeType() == 1 && (unprefixedName = this.getUnprefixedNodeName(bodyChild)).equals(actionInvocation.getAction().getName())) {
                if (bodyChild.getNamespaceURI() == null || !bodyChild.getNamespaceURI().equals(message.getActionNamespace())) {
                    throw new UnsupportedDataException("Illegal or missing namespace on action request element: " + String.valueOf(bodyChild));
                }
                this.logger.trace("Reading action request element: {}", (Object)unprefixedName);
                return (Element)bodyChild;
            }
            ++i;
        }
        throw new UnsupportedDataException("Could not read action request element matching namespace: " + var2_2.getActionNamespace());
    }

    /*
     * WARNING - void declaration
     */
    protected Element writeActionResponseElement(Document d, Element bodyElement, ActionResponseMessage message, ActionInvocation actionInvocation) {
        void var1_1;
        void var2_2;
        void var3_3;
        this.logger.trace("Writing action response element: {}", (Object)actionInvocation.getAction().getName());
        Element actionResponseElement = d.createElementNS(var3_3.getActionNamespace(), "u:" + actionInvocation.getAction().getName() + "Response");
        var2_2.appendChild(actionResponseElement);
        return var1_1;
    }

    protected Element readActionResponseElement(Element bodyElement, ActionInvocation actionInvocation) {
        NodeList bodyChildren = bodyElement.getChildNodes();
        int i = 0;
        while (i < bodyChildren.getLength()) {
            Node bodyChild = bodyChildren.item(i);
            if (bodyChild.getNodeType() == 1 && this.getUnprefixedNodeName(bodyChild).equals(actionInvocation.getAction().getName() + "Response")) {
                this.logger.trace("Reading action response element: {}", (Object)this.getUnprefixedNodeName(bodyChild));
                return (Element)bodyChild;
            }
            ++i;
        }
        this.logger.trace("Could not read action response element");
        return null;
    }

    protected void writeActionInputArguments(Document d, Element actionRequestElement, ActionInvocation actionInvocation) {
        ActionArgument<S>[] actionArgumentArray = actionInvocation.getAction().getInputArguments();
        int n = actionArgumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionArgument argument = actionArgumentArray[n2];
            this.logger.trace("Writing action input argument: {}", (Object)argument.getName());
            String value = actionInvocation.getInput(argument) != null ? actionInvocation.getInput(argument).toString() : "";
            XMLUtil.appendNewElement(d, actionRequestElement, argument.getName(), value);
            ++n2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void readActionInputArguments(Element actionRequestElement, ActionInvocation actionInvocation) throws ActionException {
        void var2_2;
        void var1_1;
        actionInvocation.setInput(this.readArgumentValues(var1_1.getChildNodes(), var2_2.getAction().getInputArguments()));
    }

    protected void writeActionOutputArguments(Document d, Element actionResponseElement, ActionInvocation actionInvocation) {
        ActionArgument<S>[] actionArgumentArray = actionInvocation.getAction().getOutputArguments();
        int n = actionArgumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionArgument argument = actionArgumentArray[n2];
            this.logger.trace("Writing action output argument: {}", (Object)argument.getName());
            String value = actionInvocation.getOutput(argument) != null ? actionInvocation.getOutput(argument).toString() : "";
            XMLUtil.appendNewElement(d, actionResponseElement, argument.getName(), value);
            ++n2;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void readActionOutputArguments(Element actionResponseElement, ActionInvocation actionInvocation) throws ActionException {
        void var2_2;
        void var1_1;
        actionInvocation.setOutput(this.readArgumentValues(var1_1.getChildNodes(), var2_2.getAction().getOutputArguments()));
    }

    /*
     * WARNING - void declaration
     */
    protected void writeFaultElement(Document d, Element bodyElement, ActionInvocation actionInvocation) {
        void var3_4;
        void var1_1;
        void var2_3;
        Element faultElement = d.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "s:Fault");
        bodyElement.appendChild(faultElement);
        XMLUtil.appendNewElement(d, faultElement, "faultcode", "s:Client");
        XMLUtil.appendNewElement(d, faultElement, "faultstring", "UPnPError");
        Element detailElement = d.createElement("detail");
        faultElement.appendChild(detailElement);
        Element upnpErrorElement = d.createElementNS("urn:schemas-upnp-org:control-1-0", "UPnPError");
        detailElement.appendChild(upnpErrorElement);
        int errorCode = actionInvocation.getFailure().getErrorCode();
        String errorDescription = actionInvocation.getFailure().getMessage();
        this.logger.trace("Writing fault element: {} - {}", (Object)errorCode, (Object)errorDescription);
        XMLUtil.appendNewElement(d, upnpErrorElement, "errorCode", Integer.toString((int)var2_3));
        XMLUtil.appendNewElement((Document)var1_1, upnpErrorElement, "errorDescription", var3_4);
    }

    /*
     * WARNING - void declaration
     */
    protected ActionException readFaultElement(Element bodyElement) {
        void var2_2;
        boolean receivedFaultElement = false;
        String errorCode = null;
        String errorDescription = null;
        NodeList bodyChildren = bodyElement.getChildNodes();
        int i = 0;
        while (i < bodyChildren.getLength()) {
            Node bodyChild = bodyChildren.item(i);
            if (bodyChild.getNodeType() == 1 && this.getUnprefixedNodeName(bodyChild).equals("Fault")) {
                receivedFaultElement = true;
                NodeList faultChildren = bodyChild.getChildNodes();
                int j = 0;
                while (j < faultChildren.getLength()) {
                    Node faultChild = faultChildren.item(j);
                    if (faultChild.getNodeType() == 1 && this.getUnprefixedNodeName(faultChild).equals("detail")) {
                        NodeList detailChildren = faultChild.getChildNodes();
                        int x = 0;
                        while (x < detailChildren.getLength()) {
                            Node detailChild = detailChildren.item(x);
                            if (detailChild.getNodeType() == 1 && this.getUnprefixedNodeName(detailChild).equals("UPnPError")) {
                                NodeList errorChildren = detailChild.getChildNodes();
                                int y = 0;
                                while (y < errorChildren.getLength()) {
                                    Node errorChild = errorChildren.item(y);
                                    if (errorChild.getNodeType() == 1) {
                                        if (this.getUnprefixedNodeName(errorChild).equals("errorCode")) {
                                            errorCode = XMLUtil.getTextContent(errorChild);
                                        }
                                        if (this.getUnprefixedNodeName(errorChild).equals("errorDescription")) {
                                            errorDescription = XMLUtil.getTextContent(errorChild);
                                        }
                                    }
                                    ++y;
                                }
                            }
                            ++x;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (errorCode != null) {
            try {
                void var3_3;
                int numericCode = Integer.parseInt((String)var3_3);
                ErrorCode standardErrorCode = ErrorCode.getByCode(numericCode);
                if (standardErrorCode != null) {
                    this.logger.trace("Reading fault element: {} - {}", (Object)standardErrorCode.getCode(), errorDescription);
                    return new ActionException(standardErrorCode, errorDescription, false);
                }
                this.logger.trace("Reading fault element: {} - {}", (Object)numericCode, errorDescription);
                return new ActionException(numericCode, errorDescription);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Error code was not a number", e);
            }
        }
        if (var2_2 != false) {
            throw new RuntimeException("Received fault element but no error code");
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected String getMessageBody(ActionMessage message) throws UnsupportedDataException {
        void var1_1;
        if (!message.isBodyNonEmptyString()) {
            throw new UnsupportedDataException("Can't transform null or non-string/zero-length body of: " + String.valueOf(message));
        }
        return var1_1.getBodyString().trim();
    }

    /*
     * WARNING - void declaration
     */
    protected String toString(Document d) throws Exception {
        void var1_1;
        String output = XMLUtil.documentToString(d);
        while (output.endsWith("\n") || output.endsWith("\r")) {
            output = output.substring(0, output.length() - 1);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected String getUnprefixedNodeName(Node node) {
        void var1_1;
        if (node.getPrefix() != null) {
            return node.getNodeName().substring(node.getPrefix().length() + 1);
        }
        return var1_1.getNodeName();
    }

    /*
     * WARNING - void declaration
     */
    protected ActionArgumentValue[] readArgumentValues(NodeList nodeList, ActionArgument[] args) throws ActionException {
        void var3_3;
        List<Node> nodes = this.getMatchingNodes(nodeList, args);
        ActionArgumentValue[] values = new ActionArgumentValue[args.length];
        int i = 0;
        while (i < args.length) {
            ActionArgument arg = args[i];
            Node node = this.findActionArgumentNode(nodes, arg);
            if (node == null) {
                throw new ActionException(ErrorCode.ARGUMENT_VALUE_INVALID, "Could not find argument '" + arg.getName() + "' node");
            }
            this.logger.trace("Reading action argument: {}", (Object)arg.getName());
            String value = XMLUtil.getTextContent(node);
            values[i] = this.createValue(arg, value);
            ++i;
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    protected List<Node> getMatchingNodes(NodeList nodeList, ActionArgument[] args) throws ActionException {
        ArrayList<String> names = new ArrayList<String>();
        ActionArgument[] actionArgumentArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            ActionArgument argument = actionArgumentArray[n2];
            names.add(argument.getName());
            names.addAll(Arrays.asList(argument.getAliases()));
            ++n2;
        }
        ArrayList<Node> matches = new ArrayList<Node>();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node child = nodeList.item(i);
            if (child.getNodeType() == 1 && names.contains(this.getUnprefixedNodeName(child))) {
                matches.add(child);
            }
            ++i;
        }
        if (matches.size() < args.length) {
            void var2_2;
            throw new ActionException(ErrorCode.ARGUMENT_VALUE_INVALID, "Invalid number of input or output arguments in XML message, expected " + ((void)var2_2).length + " but found " + matches.size());
        }
        return matches;
    }

    /*
     * WARNING - void declaration
     */
    protected ActionArgumentValue createValue(ActionArgument arg, String value) throws ActionException {
        try {
            return new ActionArgumentValue(arg, (Object)value);
        }
        catch (InvalidValueException e) {
            void var2_3;
            void var1_1;
            throw new ActionException(ErrorCode.ARGUMENT_VALUE_INVALID, "Wrong type or invalid value for '" + var1_1.getName() + "': " + e.getMessage(), (Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Node findActionArgumentNode(List<Node> nodes, ActionArgument arg) {
        for (Node node : nodes) {
            void var1_1;
            if (!arg.isNameOrAlias(this.getUnprefixedNodeName(node))) continue;
            return var1_1;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warning(SAXParseException e) throws SAXException {
        void var1_1;
        this.logger.warn(var1_1.toString());
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        throw e;
    }
}

