/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.transport.impl;

import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class PooledXmlProcessor {
    private final DocumentBuilderFactory documentBuilderFactory;
    private final ConcurrentLinkedQueue<DocumentBuilder> builderPool;
    private final transient Logger logger = LoggerFactory.getLogger(PooledXmlProcessor.class);
    private boolean reuseDocumentBuilders;

    protected PooledXmlProcessor() {
        this(20);
    }

    /*
     * WARNING - void declaration
     */
    protected PooledXmlProcessor(int basePoolSize) {
        this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
        this.documentBuilderFactory.setNamespaceAware(true);
        this.builderPool = new ConcurrentLinkedQueue();
        try {
            this.reuseDocumentBuilders = this.isDocumentBuilderReusable();
            if (this.reuseDocumentBuilders) {
                this.logger.debug("Adding {} instances to the pool because DocumentBuilders can be reused", (Object)basePoolSize);
                int i = 0;
                while (i < basePoolSize) {
                    this.builderPool.add(this.documentBuilderFactory.newDocumentBuilder());
                    ++i;
                }
                return;
            }
            this.logger.debug("Not adding instances to the pool because DocumentBuilders cannot be reused");
            return;
        }
        catch (ParserConfigurationException e) {
            void var2_3;
            this.logger.error("Error when invoking newDocumentBuilder()", (Throwable)var2_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isDocumentBuilderReusable() throws ParserConfigurationException {
        void var1_1;
        DocumentBuilder builder = this.documentBuilderFactory.newDocumentBuilder();
        builder.reset();
        return var1_1.isNamespaceAware();
    }

    protected Document newDocument() throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        return this.getDocument(null, null);
    }

    /*
     * WARNING - void declaration
     */
    protected Document readDocument(InputSource inputSource, ErrorHandler errorHandler) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        void var2_2;
        void var1_1;
        return this.getDocument((InputSource)var1_1, (ErrorHandler)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected Document readDocument(InputSource inputSource) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        void var1_1;
        return this.getDocument((InputSource)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    private Document getDocument(InputSource inputSource, ErrorHandler errorHandler) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        Document document;
        DocumentBuilder builder;
        block5: {
            builder = this.reuseDocumentBuilders ? this.builderPool.poll() : null;
            if (builder == null) {
                builder = this.documentBuilderFactory.newDocumentBuilder();
            }
            try {
                if (errorHandler != null) {
                    void var2_3;
                    builder.setErrorHandler((ErrorHandler)var2_3);
                }
                if (inputSource == null) break block5;
                document = builder.parse((InputSource)((Object)document));
            }
            catch (Throwable throwable) {
                void var3_4;
                this.returnBuilder((DocumentBuilder)var3_4);
                throw throwable;
            }
            this.returnBuilder(builder);
            return document;
        }
        document = builder.newDocument();
        this.returnBuilder(builder);
        return document;
    }

    /*
     * WARNING - void declaration
     */
    private void returnBuilder(DocumentBuilder builder) throws FactoryConfigurationError {
        if (this.reuseDocumentBuilders) {
            void var1_1;
            builder.reset();
            this.builderPool.add((DocumentBuilder)var1_1);
        }
    }
}

