/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.transport.impl;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.jupnp.transport.spi.InitializationException;
import org.jupnp.transport.spi.NetworkAddressFactory;
import org.jupnp.transport.spi.NoNetworkException;
import org.jupnp.util.Iterators;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkAddressFactoryImpl
implements NetworkAddressFactory {
    public static final int DEFAULT_TCP_HTTP_LISTEN_PORT = 0;
    public static final int DEFAULT_MULTICAST_RESPONSE_LISTEN_PORT = 0;
    private final Logger logger = LoggerFactory.getLogger(NetworkAddressFactoryImpl.class);
    protected final Set<String> useInterfaces = new HashSet<String>();
    protected final Set<String> useAddresses = new HashSet<String>();
    protected final List<NetworkInterface> networkInterfaces = new ArrayList<NetworkInterface>();
    protected final List<InetAddress> bindAddresses = new ArrayList<InetAddress>();
    protected int streamListenPort;
    protected int multicastResponsePort;

    public NetworkAddressFactoryImpl() throws InitializationException {
        this(0, 0);
    }

    /*
     * WARNING - void declaration
     */
    public NetworkAddressFactoryImpl(int streamListenPort, int multicastResponsePort) throws InitializationException {
        this((int)var1_1, (int)var2_2, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public NetworkAddressFactoryImpl(int streamListenPort, int multicastResponsePort, String interfaces) throws InitializationException {
        void var2_2;
        void var1_1;
        String useAddressesString;
        String useInterfacesString = interfaces != null && !interfaces.isBlank() ? interfaces : System.getProperty("org.jupnp.network.useInterfaces");
        if (useInterfacesString != null) {
            String[] userInterfacesStrings = useInterfacesString.split(",");
            this.useInterfaces.addAll(Arrays.asList(userInterfacesStrings));
        }
        if ((useAddressesString = System.getProperty("org.jupnp.network.useAddresses")) != null) {
            void var3_3;
            String[] useAddressesStrings = useAddressesString.split(",");
            this.useAddresses.addAll(Arrays.asList(var3_3));
        }
        this.discoverNetworkInterfaces();
        this.discoverBindAddresses();
        if (this.networkInterfaces.isEmpty() || this.bindAddresses.isEmpty()) {
            this.logger.warn("No usable network interface or addresses found");
            if (this.requiresNetworkInterface()) {
                throw new NoNetworkException("Could not discover any usable network interfaces and/or addresses");
            }
        }
        this.streamListenPort = var1_1;
        this.multicastResponsePort = var2_2;
    }

    protected boolean requiresNetworkInterface() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void logInterfaceInformation() {
        List<NetworkInterface> list = this.networkInterfaces;
        synchronized (list) {
            if (this.networkInterfaces.isEmpty()) {
                this.logger.info("No network interface to display!");
                return;
            }
            for (NetworkInterface networkInterface : this.networkInterfaces) {
                try {
                    this.logInterfaceInformation(networkInterface);
                }
                catch (SocketException e) {
                    void var2_4;
                    this.logger.warn("Exception while logging network interface information", (Throwable)var2_4);
                }
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InetAddress getMulticastGroup() {
        try {
            return InetAddress.getByName("239.255.255.250");
        }
        catch (UnknownHostException e) {
            void var1_1;
            throw new RuntimeException((Throwable)var1_1);
        }
    }

    @Override
    public int getMulticastPort() {
        return 1900;
    }

    @Override
    public int getMulticastResponsePort() {
        if (this.multicastResponsePort > 0) {
            return this.multicastResponsePort;
        }
        return 0;
    }

    @Override
    public int getStreamListenPort() {
        return this.streamListenPort;
    }

    @Override
    public Iterator<NetworkInterface> getNetworkInterfaces() {
        NetworkAddressFactoryImpl networkAddressFactoryImpl = this;
        return new Iterators.Synchronized<NetworkInterface>(networkAddressFactoryImpl.networkInterfaces){
            {
                void var2_2;
                super(var2_2);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected void synchronizedRemove(int index) {
                List<NetworkInterface> list = NetworkAddressFactoryImpl.this.networkInterfaces;
                synchronized (list) {
                    void var1_1;
                    NetworkAddressFactoryImpl.this.networkInterfaces.remove((int)var1_1);
                    return;
                }
            }
        };
    }

    @Override
    public Iterator<InetAddress> getBindAddresses() {
        NetworkAddressFactoryImpl networkAddressFactoryImpl = this;
        return new Iterators.Synchronized<InetAddress>(networkAddressFactoryImpl.bindAddresses){
            {
                void var2_2;
                super(var2_2);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected void synchronizedRemove(int index) {
                List<InetAddress> list = NetworkAddressFactoryImpl.this.bindAddresses;
                synchronized (list) {
                    void var1_1;
                    NetworkAddressFactoryImpl.this.bindAddresses.remove((int)var1_1);
                    return;
                }
            }
        };
    }

    @Override
    public boolean hasUsableNetwork() {
        return !this.networkInterfaces.isEmpty() && !this.bindAddresses.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] getHardwareAddress(InetAddress inetAddress) {
        try {
            NetworkInterface iface = NetworkInterface.getByInetAddress(inetAddress);
            if (iface != null) {
                return iface.getHardwareAddress();
            }
            return null;
        }
        catch (Exception e) {
            void var2_3;
            void var1_1;
            this.logger.warn("Cannot get hardware address for: {}", (Object)var1_1, (Object)var2_3);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InetAddress getBroadcastAddress(InetAddress inetAddress) {
        List<NetworkInterface> list = this.networkInterfaces;
        synchronized (list) {
            for (NetworkInterface iface : this.networkInterfaces) {
                for (InterfaceAddress interfaceAddress : this.getInterfaceAddresses(iface)) {
                    void var3_4;
                    if (interfaceAddress == null || !interfaceAddress.getAddress().equals(inetAddress)) continue;
                    return var3_4.getBroadcast();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Short getAddressNetworkPrefixLength(InetAddress inetAddress) {
        List<NetworkInterface> list = this.networkInterfaces;
        synchronized (list) {
            void var1_2;
            void var3_5;
            Iterator<NetworkInterface> iterator = this.networkInterfaces.iterator();
            block3: while (true) {
                InterfaceAddress interfaceAddress;
                if (!iterator.hasNext()) {
                    return null;
                }
                NetworkInterface iface = iterator.next();
                Iterator<InterfaceAddress> iterator2 = this.getInterfaceAddresses(iface).iterator();
                do {
                    if (!iterator2.hasNext()) continue block3;
                } while ((interfaceAddress = iterator2.next()) == null || !interfaceAddress.getAddress().equals(inetAddress));
                break;
            }
            short prefix = var3_5.getNetworkPrefixLength();
            if (prefix <= 0) return null;
            if (prefix >= 32) return null;
            return (short)var1_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InetAddress getLocalAddress(NetworkInterface networkInterface, boolean isIPv6, InetAddress remoteAddress) {
        void var1_1;
        InetAddress localIPInSubnet = this.getBindAddressInSubnetOf(remoteAddress);
        if (localIPInSubnet != null) {
            return localIPInSubnet;
        }
        this.logger.trace("Could not find local bind address in same subnet as: {}", (Object)remoteAddress.getHostAddress());
        for (InetAddress interfaceAddress : this.getInetAddresses(networkInterface)) {
            void var3_3;
            if (isIPv6 && interfaceAddress instanceof Inet6Address) {
                return interfaceAddress;
            }
            if (isIPv6 || !(interfaceAddress instanceof Inet4Address)) continue;
            return var3_3;
        }
        throw new IllegalStateException("Can't find any IPv4 or IPv6 address on interface: " + var1_1.getDisplayName());
    }

    protected List<InterfaceAddress> getInterfaceAddresses(NetworkInterface networkInterface) {
        return networkInterface.getInterfaceAddresses();
    }

    protected List<InetAddress> getInetAddresses(NetworkInterface networkInterface) {
        return Collections.list(networkInterface.getInetAddresses());
    }

    /*
     * WARNING - void declaration
     */
    protected InetAddress getBindAddressInSubnetOf(InetAddress inetAddress) {
        List<NetworkInterface> list = this.networkInterfaces;
        synchronized (list) {
            for (NetworkInterface iface : this.networkInterfaces) {
                for (InterfaceAddress ifaceAddress : this.getInterfaceAddresses(iface)) {
                    void var3_4;
                    List<InetAddress> list2 = this.bindAddresses;
                    synchronized (list2) {
                        if (ifaceAddress == null || !this.bindAddresses.contains(ifaceAddress.getAddress())) {
                            continue;
                        }
                    }
                    if (!this.isInSubnet(inetAddress.getAddress(), ifaceAddress.getAddress().getAddress(), ifaceAddress.getNetworkPrefixLength())) continue;
                    return var3_4.getAddress();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isInSubnet(byte[] ip, byte[] network, short prefix) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (ip.length != network.length) {
            return false;
        }
        if (prefix / 8 > ip.length) {
            return false;
        }
        int i = 0;
        while (prefix >= 8 && i < ip.length) {
            if (ip[i] != network[i]) {
                return false;
            }
            ++i;
            prefix = (short)(prefix - 8);
        }
        if (i == ip.length) {
            return true;
        }
        byte mask = (byte)(~((1 << 8 - prefix) - 1));
        return (var1_1[i] & mask) == (var2_2[i] & var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected void discoverNetworkInterfaces() throws InitializationException {
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            for (NetworkInterface iface : Collections.list(enumeration)) {
                this.logger.trace("Analyzing network interface: {}", (Object)iface.getDisplayName());
                if (this.isUsableNetworkInterface(iface)) {
                    this.logger.trace("Discovered usable network interface: {}", (Object)iface.getDisplayName());
                    List<NetworkInterface> list = this.networkInterfaces;
                    synchronized (list) {
                        this.networkInterfaces.add(iface);
                        continue;
                    }
                }
                this.logger.trace("Ignoring non-usable network interface: {}", (Object)iface.getDisplayName());
            }
            return;
        }
        catch (Exception e) {
            void var1_2;
            throw new InitializationException("Could not not analyze local network interfaces", (Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isUsableNetworkInterface(NetworkInterface iface) throws Exception {
        if (!iface.isUp()) {
            this.logger.trace("Skipping network interface (down): {}", (Object)iface.getDisplayName());
            return false;
        }
        if (this.getInetAddresses(iface).isEmpty()) {
            this.logger.trace("Skipping network interface without bound IP addresses: {}", (Object)iface.getDisplayName());
            return false;
        }
        if (iface.isPointToPoint()) {
            this.logger.trace("Skipping point-to-point network interface: {}", (Object)iface.getDisplayName());
            return false;
        }
        if (iface.getName().toLowerCase(Locale.ENGLISH).startsWith("vmnet") || iface.getDisplayName() != null && iface.getDisplayName().toLowerCase(Locale.ENGLISH).contains("vmnet")) {
            this.logger.trace("Skipping network interface (VMWare): {}", (Object)iface.getDisplayName());
            return false;
        }
        if (iface.getName().toLowerCase(Locale.ENGLISH).startsWith("vnic")) {
            this.logger.trace("Skipping network interface (Parallels): {}", (Object)iface.getDisplayName());
            return false;
        }
        if (iface.getName().toLowerCase(Locale.ENGLISH).startsWith("vboxnet")) {
            this.logger.trace("Skipping network interface (Virtual Box): {}", (Object)iface.getDisplayName());
            return false;
        }
        if (iface.getName().toLowerCase(Locale.ENGLISH).contains("virtual")) {
            this.logger.trace("Skipping network interface (named '*virtual*'): {}", (Object)iface.getDisplayName());
            return false;
        }
        if (iface.getName().toLowerCase(Locale.ENGLISH).startsWith("ppp")) {
            this.logger.trace("Skipping network interface (PPP): {}", (Object)iface.getDisplayName());
            return false;
        }
        if (iface.isLoopback()) {
            this.logger.trace("Skipping network interface (ignoring loopback): {}", (Object)iface.getDisplayName());
            return false;
        }
        if (!this.useInterfaces.isEmpty() && !this.useInterfaces.contains(iface.getName())) {
            this.logger.trace("Skipping unwanted network interface (OSGi parameter 'interfaces' or -D {}): {}", (Object)"org.jupnp.network.useInterfaces", (Object)iface.getName());
            return false;
        }
        if (!iface.supportsMulticast()) {
            void var1_1;
            this.logger.warn("Network interface may not be multicast capable: {}", (Object)var1_1.getDisplayName());
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected void discoverBindAddresses() throws InitializationException {
        try {
            List<NetworkInterface> list = this.networkInterfaces;
            synchronized (list) {
                Iterator<NetworkInterface> it = this.networkInterfaces.iterator();
                while (it.hasNext()) {
                    void var3_4;
                    NetworkInterface networkInterface = it.next();
                    this.logger.trace("Discovering addresses of interface: {}", (Object)networkInterface.getDisplayName());
                    int usableAddresses = 0;
                    for (InetAddress inetAddress : this.getInetAddresses(networkInterface)) {
                        if (inetAddress == null) {
                            this.logger.warn("Network has a null address: {}", (Object)networkInterface.getDisplayName());
                            continue;
                        }
                        if (this.isUsableAddress(networkInterface, inetAddress)) {
                            this.logger.trace("Discovered usable network interface address: {}", (Object)inetAddress.getHostAddress());
                            ++usableAddresses;
                            List<InetAddress> list2 = this.bindAddresses;
                            synchronized (list2) {
                                this.bindAddresses.add(inetAddress);
                                continue;
                            }
                        }
                        this.logger.trace("Ignoring non-usable network interface address: {}", (Object)inetAddress.getHostAddress());
                    }
                    if (usableAddresses != 0) continue;
                    this.logger.trace("Network interface has no usable addresses, removing: {}", (Object)var3_4.getDisplayName());
                    it.remove();
                }
                return;
            }
        }
        catch (Exception e) {
            void var1_2;
            throw new InitializationException("Could not not analyze local network interfaces", (Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isUsableAddress(NetworkInterface networkInterface, InetAddress address) {
        if (!(address instanceof Inet4Address)) {
            this.logger.trace("Skipping unsupported non-IPv4 address: {}", (Object)address);
            return false;
        }
        if (address.isLoopbackAddress()) {
            this.logger.trace("Skipping loopback address: {}", (Object)address);
            return false;
        }
        if (!this.useAddresses.isEmpty() && !this.useAddresses.contains(address.getHostAddress())) {
            void var2_2;
            this.logger.trace("Skipping unwanted address: {}", (Object)var2_2);
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected void logInterfaceInformation(NetworkInterface networkInterface) throws SocketException {
        void var1_1;
        Iterator<InterfaceAddress> inetAddress;
        this.logger.info("---------------------------------------------------------------------------------");
        this.logger.info("Interface display name: {}", (Object)networkInterface.getDisplayName());
        if (networkInterface.getParent() != null) {
            this.logger.info("Parent Info: {}", (Object)networkInterface.getParent());
        }
        this.logger.info("Name: {}", (Object)networkInterface.getName());
        Enumeration<InetAddress> enumeration = networkInterface.getInetAddresses();
        Iterator<NetworkInterface> iterator = Collections.list(enumeration).iterator();
        while (iterator.hasNext()) {
            inetAddress = iterator.next();
            this.logger.info("InetAddress: {}", inetAddress);
        }
        inetAddress = networkInterface.getInterfaceAddresses();
        inetAddress = inetAddress.iterator();
        while (inetAddress.hasNext()) {
            InterfaceAddress interfaceAddress = inetAddress.next();
            if (interfaceAddress == null) {
                this.logger.warn("Skipping null InterfaceAddress!");
                continue;
            }
            this.logger.info(" Interface Address");
            this.logger.info("  Address: {}", (Object)interfaceAddress.getAddress());
            this.logger.info("  Broadcast: {}", (Object)interfaceAddress.getBroadcast());
            this.logger.info("  Prefix length: {}", (Object)((InterfaceAddress)((Object)iterator)).getNetworkPrefixLength());
        }
        iterator = networkInterface.getSubInterfaces();
        for (NetworkInterface subIf : Collections.list(iterator)) {
            if (subIf == null) {
                this.logger.warn("Skipping null NetworkInterface sub-interface");
                continue;
            }
            this.logger.info("\tSub Interface Display name: {}", (Object)subIf.getDisplayName());
            this.logger.info("\tSub Interface Name: {}", (Object)((NetworkInterface)((Object)enumeration)).getName());
        }
        this.logger.info("Up? {}", (Object)networkInterface.isUp());
        this.logger.info("Loopback? {}", (Object)networkInterface.isLoopback());
        this.logger.info("PointToPoint? {}", (Object)networkInterface.isPointToPoint());
        this.logger.info("Supports multicast? {}", (Object)networkInterface.supportsMulticast());
        this.logger.info("Virtual? {}", (Object)networkInterface.isVirtual());
        this.logger.info("Hardware address: {}", (Object)Arrays.toString(networkInterface.getHardwareAddress()));
        this.logger.info("MTU: {}", (Object)var1_1.getMTU());
    }
}

