/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.transport.impl;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import org.jupnp.model.message.Connection;
import org.jupnp.model.message.StreamRequestMessage;
import org.jupnp.model.message.StreamResponseMessage;
import org.jupnp.model.message.UpnpHeaders;
import org.jupnp.model.message.UpnpMessage;
import org.jupnp.model.message.UpnpRequest;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.protocol.ProtocolFactory;
import org.jupnp.transport.spi.UpnpStream;
import org.jupnp.util.io.IO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpExchangeUpnpStream
extends UpnpStream {
    private final Logger logger = LoggerFactory.getLogger((String)HttpExchangeUpnpStream.class.getName());
    private HttpExchange httpExchange;

    /*
     * WARNING - void declaration
     */
    protected HttpExchangeUpnpStream(ProtocolFactory protocolFactory, HttpExchange httpExchange) {
        super((ProtocolFactory)var1_1);
        void var2_2;
        void var1_1;
        this.httpExchange = var2_2;
    }

    public HttpExchange getHttpExchange() {
        return this.httpExchange;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        try {
            Object bodyBytes;
            this.logger.trace("Processing HTTP request: {} {}", (Object)this.getHttpExchange().getRequestMethod(), (Object)this.getHttpExchange().getRequestURI());
            StreamRequestMessage requestMessage22 = new StreamRequestMessage(UpnpRequest.Method.getByHttpName(this.getHttpExchange().getRequestMethod()), this.getHttpExchange().getRequestURI());
            if (((UpnpRequest)requestMessage22.getOperation()).getMethod().equals((Object)UpnpRequest.Method.UNKNOWN)) {
                this.logger.trace("Method not supported by UPnP stack: {}", (Object)this.getHttpExchange().getRequestMethod());
                throw new RuntimeException("Method not supported: " + this.getHttpExchange().getRequestMethod());
            }
            ((UpnpRequest)requestMessage22.getOperation()).setHttpMinorVersion(this.getHttpExchange().getProtocol().toUpperCase(Locale.ROOT).equals("HTTP/1.1") ? 1 : 0);
            this.logger.trace("Created new request message: {}", (Object)requestMessage22);
            requestMessage22.setConnection(this.createConnection());
            requestMessage22.setHeaders(new UpnpHeaders(this.getHttpExchange().getRequestHeaders()));
            Throwable throwable = null;
            try (InputStream is = this.getHttpExchange().getRequestBody();){
                bodyBytes = IO.readAllBytes(is);
            }
            catch (Throwable requestMessage22) {
                if (throwable == null) {
                    throwable = requestMessage22;
                } else if (throwable != requestMessage22) {
                    throwable.addSuppressed(requestMessage22);
                }
                throw throwable;
            }
            this.logger.trace("Reading request body bytes: {}", (Object)((byte[])bodyBytes).length);
            if (((byte[])bodyBytes).length > 0 && requestMessage22.isContentTypeMissingOrText()) {
                this.logger.trace("Request contains textual entity body, converting then setting string on message");
                requestMessage22.setBodyCharacters((byte[])bodyBytes);
            } else if (((byte[])bodyBytes).length > 0) {
                this.logger.trace("Request contains binary entity body, setting bytes on message");
                requestMessage22.setBody(UpnpMessage.BodyType.BYTES, bodyBytes);
            } else {
                this.logger.trace("Request did not contain entity body");
            }
            StreamResponseMessage responseMessage = this.process(requestMessage22);
            if (responseMessage != null) {
                this.logger.trace("Preparing HTTP response message: {}", (Object)responseMessage);
                this.getHttpExchange().getResponseHeaders().putAll(responseMessage.getHeaders());
                byte[] responseBodyBytes2 = responseMessage.hasBody() ? responseMessage.getBodyBytes() : null;
                int contentLength = responseBodyBytes2 != null ? responseBodyBytes2.length : -1;
                this.logger.trace("Sending HTTP response message: {} with content length: {}", (Object)responseMessage, (Object)contentLength);
                this.getHttpExchange().sendResponseHeaders(((UpnpResponse)responseMessage.getOperation()).getStatusCode(), contentLength);
                if (contentLength > 0) {
                    this.logger.trace("Response message has body, writing bytes to stream...");
                    bodyBytes = null;
                    try (OutputStream os = this.getHttpExchange().getResponseBody();){
                        os.write(responseBodyBytes2);
                        os.flush();
                    }
                    catch (Throwable responseBodyBytes2) {
                        if (bodyBytes == null) {
                            bodyBytes = responseBodyBytes2;
                        } else if (bodyBytes != responseBodyBytes2) {
                            ((Throwable)bodyBytes).addSuppressed(responseBodyBytes2);
                        }
                        throw bodyBytes;
                    }
                }
            } else {
                this.logger.trace("Sending HTTP response status: {}", (Object)404);
                this.getHttpExchange().sendResponseHeaders(404, -1L);
            }
            this.responseSent((StreamResponseMessage)((Object)throwable));
            return;
        }
        catch (Exception e) {
            void var1_4;
            this.logger.trace("Exception occurred during UPnP stream processing", (Throwable)e);
            try {
                this.httpExchange.sendResponseHeaders(500, -1L);
            }
            catch (IOException ioe) {
                void var2_12;
                this.logger.warn("Couldn't send error response: {}", (Object)ioe.getMessage(), (Object)var2_12);
            }
            this.responseException((Throwable)var1_4);
            return;
        }
    }

    protected abstract Connection createConnection();
}

