/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.transport;

import java.net.BindException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jupnp.UpnpServiceConfiguration;
import org.jupnp.model.NetworkAddress;
import org.jupnp.model.message.IncomingDatagramMessage;
import org.jupnp.model.message.OutgoingDatagramMessage;
import org.jupnp.model.message.StreamRequestMessage;
import org.jupnp.model.message.StreamResponseMessage;
import org.jupnp.protocol.ProtocolCreationException;
import org.jupnp.protocol.ProtocolFactory;
import org.jupnp.protocol.ReceivingAsync;
import org.jupnp.transport.DisableRouter;
import org.jupnp.transport.EnableRouter;
import org.jupnp.transport.Router;
import org.jupnp.transport.RouterException;
import org.jupnp.transport.spi.DatagramIO;
import org.jupnp.transport.spi.InitializationException;
import org.jupnp.transport.spi.MulticastReceiver;
import org.jupnp.transport.spi.NetworkAddressFactory;
import org.jupnp.transport.spi.NoNetworkException;
import org.jupnp.transport.spi.StreamClient;
import org.jupnp.transport.spi.StreamServer;
import org.jupnp.transport.spi.UpnpStream;
import org.jupnp.util.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouterImpl
implements Router {
    private final Logger logger = LoggerFactory.getLogger(Router.class);
    protected UpnpServiceConfiguration configuration;
    protected ProtocolFactory protocolFactory;
    protected volatile boolean enabled;
    protected ReentrantReadWriteLock routerLock = new ReentrantReadWriteLock(true);
    protected Lock readLock = this.routerLock.readLock();
    protected Lock writeLock = this.routerLock.writeLock();
    protected NetworkAddressFactory networkAddressFactory;
    protected StreamClient streamClient;
    protected final Map<NetworkInterface, MulticastReceiver> multicastReceivers = new HashMap<NetworkInterface, MulticastReceiver>();
    protected final Map<InetAddress, DatagramIO> datagramIOs = new HashMap<InetAddress, DatagramIO>();
    protected final Map<InetAddress, StreamServer> streamServers = new HashMap<InetAddress, StreamServer>();

    protected RouterImpl() {
    }

    /*
     * WARNING - void declaration
     */
    public RouterImpl(UpnpServiceConfiguration configuration, ProtocolFactory protocolFactory) {
        void var2_2;
        void var1_1;
        this.configuration = var1_1;
        this.protocolFactory = var2_2;
    }

    public boolean enable(EnableRouter event) throws RouterException {
        return this.enable();
    }

    public boolean disable(DisableRouter event) throws RouterException {
        return this.disable();
    }

    @Override
    public UpnpServiceConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public ProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean enable() throws RouterException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean disable() throws RouterException {
        RouterImpl routerImpl = this;
        routerImpl.lock(routerImpl.writeLock);
        try {
            if (this.enabled) {
                this.logger.debug("Disabling network services...");
                if (this.streamClient != null) {
                    this.logger.debug("Stopping stream client connection management/pool");
                    this.streamClient.stop();
                    this.streamClient = null;
                }
                for (Map.Entry<InetAddress, StreamServer> entry : this.streamServers.entrySet()) {
                    this.logger.debug("Stopping stream server on address: {}", (Object)entry.getKey());
                    entry.getValue().stop();
                }
                this.streamServers.clear();
                for (Map.Entry<Object, Runnable> entry : this.multicastReceivers.entrySet()) {
                    this.logger.debug("Stopping multicast receiver on interface: {}", (Object)((NetworkInterface)entry.getKey()).getDisplayName());
                    ((MulticastReceiver)entry.getValue()).stop();
                }
                this.multicastReceivers.clear();
                for (Map.Entry<Object, Runnable> entry : this.datagramIOs.entrySet()) {
                    this.logger.debug("Stopping datagram I/O on address: {}", entry.getKey());
                    ((DatagramIO)entry.getValue()).stop();
                }
                this.datagramIOs.clear();
                this.networkAddressFactory = null;
                this.enabled = false;
                RouterImpl routerImpl2 = this;
                routerImpl2.unlock(routerImpl2.writeLock);
                return true;
            }
            RouterImpl routerImpl3 = this;
            routerImpl3.unlock(routerImpl3.writeLock);
            return false;
        }
        catch (Throwable throwable) {
            RouterImpl routerImpl4 = this;
            routerImpl4.unlock(routerImpl4.writeLock);
            throw throwable;
        }
    }

    @Override
    public void shutdown() throws RouterException {
        this.disable();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handleStartFailure(InitializationException e) throws InitializationException {
        void var1_1;
        if (e instanceof NoNetworkException) {
            this.logger.info("Unable to initialize network router, no network found.");
            return;
        }
        this.logger.error("Unable to initialize network router", (Throwable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<NetworkAddress> getActiveStreamServers(InetAddress preferredAddress) throws RouterException {
        List<NetworkAddress> list;
        block5: {
            ArrayList<NetworkAddress> streamServerAddresses;
            block6: {
                Iterator<Map.Entry<InetAddress, StreamServer>> iterator;
                StreamServer preferredServer;
                RouterImpl routerImpl = this;
                routerImpl.lock(routerImpl.readLock);
                if (!this.enabled || this.streamServers.isEmpty()) break block5;
                streamServerAddresses = new ArrayList<NetworkAddress>();
                if (preferredAddress == null || (preferredServer = this.streamServers.get(preferredAddress)) == null) break block6;
                streamServerAddresses.add(new NetworkAddress((InetAddress)preferredAddress, iterator.getPort(), this.networkAddressFactory.getHardwareAddress((InetAddress)preferredAddress)));
                preferredAddress = streamServerAddresses;
                RouterImpl routerImpl2 = this;
                routerImpl2.unlock(routerImpl2.readLock);
                return preferredAddress;
            }
            try {
                void var2_3;
                for (Map.Entry<InetAddress, StreamServer> entry : this.streamServers.entrySet()) {
                    byte[] hardwareAddress = this.networkAddressFactory.getHardwareAddress(entry.getKey());
                    streamServerAddresses.add(new NetworkAddress(entry.getKey(), ((StreamServer)list.getValue()).getPort(), hardwareAddress));
                }
                list = var2_3;
                RouterImpl routerImpl = this;
                routerImpl.unlock(routerImpl.readLock);
                return list;
            }
            catch (Throwable throwable) {
                RouterImpl routerImpl = this;
                routerImpl.unlock(routerImpl.readLock);
                throw throwable;
            }
        }
        list = List.of();
        RouterImpl routerImpl = this;
        routerImpl.unlock(routerImpl.readLock);
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void received(IncomingDatagramMessage msg) {
        if (!this.enabled) {
            this.logger.debug("Router disabled, ignoring incoming message: {}", (Object)msg);
            return;
        }
        try {
            void var1_1;
            ReceivingAsync protocol = this.getProtocolFactory().createReceivingAsync(msg);
            if (protocol == null) {
                this.logger.trace("No protocol, ignoring received message: {}", (Object)msg);
                return;
            }
            this.logger.debug("Received asynchronous message: {}", (Object)var1_1);
            this.getConfiguration().getRemoteListenerExecutor().execute(protocol);
            return;
        }
        catch (ProtocolCreationException e) {
            void var2_3;
            this.logger.warn("Handling received datagram failed", (Throwable)var2_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void received(UpnpStream stream) {
        void var1_1;
        if (!this.enabled) {
            this.logger.debug("Router disabled, ignoring incoming: {}", (Object)stream);
            return;
        }
        this.logger.debug("Received synchronous stream: {}", (Object)stream);
        this.getConfiguration().getSyncProtocolExecutorService().execute((Runnable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void send(OutgoingDatagramMessage msg) throws RouterException {
        RouterImpl routerImpl = this;
        routerImpl.lock(routerImpl.readLock);
        try {
            if (this.enabled) {
                for (DatagramIO datagramIO : this.datagramIOs.values()) {
                    datagramIO.send(msg);
                }
            } else {
                void var1_1;
                this.logger.debug("Router disabled, not sending datagram: {}", (Object)var1_1);
            }
        }
        catch (Throwable throwable) {
            RouterImpl routerImpl2 = this;
            routerImpl2.unlock(routerImpl2.readLock);
            throw throwable;
        }
        RouterImpl routerImpl3 = this;
        routerImpl3.unlock(routerImpl3.readLock);
    }

    /*
     * Exception decompiling
     */
    @Override
    public StreamResponseMessage send(StreamRequestMessage msg) throws RouterException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void broadcast(byte[] bytes) throws RouterException {
        RouterImpl routerImpl = this;
        routerImpl.lock(routerImpl.readLock);
        try {
            if (this.enabled) {
                for (Map.Entry<InetAddress, DatagramIO> entry : this.datagramIOs.entrySet()) {
                    void var2_4;
                    InetAddress broadcast = this.networkAddressFactory.getBroadcastAddress(entry.getKey());
                    if (broadcast == null) continue;
                    this.logger.debug("Sending UDP datagram to broadcast address: {}", (Object)broadcast.getHostAddress());
                    DatagramPacket packet = new DatagramPacket(bytes, bytes.length, broadcast, 9);
                    ((DatagramIO)var2_4.getValue()).send(packet);
                }
            } else {
                void var1_1;
                this.logger.debug("Router disabled, not broadcasting bytes: {}", (Object)((void)var1_1).length);
            }
        }
        catch (Throwable throwable) {
            RouterImpl routerImpl2 = this;
            routerImpl2.unlock(routerImpl2.readLock);
            throw throwable;
        }
        RouterImpl routerImpl3 = this;
        routerImpl3.unlock(routerImpl3.readLock);
    }

    /*
     * WARNING - void declaration
     */
    protected void startInterfaceBasedTransports(Iterator<NetworkInterface> interfaces) throws InitializationException {
        while (interfaces.hasNext()) {
            Iterator<Map.Entry<NetworkInterface, MulticastReceiver>> iterator;
            NetworkInterface networkInterface = interfaces.next();
            MulticastReceiver multicastReceiver = this.getConfiguration().createMulticastReceiver(this.networkAddressFactory);
            if (multicastReceiver == null) {
                this.logger.info("Configuration did not create a MulticastReceiver for: {}", (Object)networkInterface);
                continue;
            }
            this.logger.debug("Init multicast receiver on interface: {}", (Object)networkInterface.getDisplayName());
            RouterImpl routerImpl = this;
            multicastReceiver.init(networkInterface, routerImpl, routerImpl.networkAddressFactory, this.getConfiguration().getDatagramProcessor());
            this.multicastReceivers.put(networkInterface, (MulticastReceiver)((Object)iterator));
        }
        for (Map.Entry<NetworkInterface, MulticastReceiver> entry : this.multicastReceivers.entrySet()) {
            void var2_2;
            this.logger.debug("Starting multicast receiver on interface: {}", (Object)entry.getKey().getDisplayName());
            this.getConfiguration().getMulticastReceiverExecutor().execute((Runnable)var2_2.getValue());
        }
    }

    protected void startAddressBasedTransports(Iterator<InetAddress> addresses) throws InitializationException {
        while (addresses.hasNext()) {
            Iterator<Map.Entry<InetAddress, Runnable>> iterator;
            InetAddress inetAddress = addresses.next();
            StreamServer streamServer = this.getConfiguration().createStreamServer(this.networkAddressFactory);
            if (streamServer == null) {
                this.logger.info("Configuration did not create a StreamServer for: {}", (Object)inetAddress);
            } else {
                try {
                    this.logger.debug("Init stream server on address: {}", (Object)inetAddress);
                    streamServer.init(inetAddress, this);
                    this.streamServers.put(inetAddress, streamServer);
                }
                catch (InitializationException initializationException) {
                    InitializationException e = initializationException;
                    Throwable cause = Exceptions.unwrap(initializationException);
                    if (cause instanceof BindException) {
                        this.logger.warn("Failed to init StreamServer. Removing unusable address: {}", (Object)inetAddress, (Object)cause);
                        addresses.remove();
                        continue;
                    }
                    throw e;
                }
            }
            DatagramIO datagramIO = this.getConfiguration().createDatagramIO(this.networkAddressFactory);
            if (datagramIO == null) {
                this.logger.info("Configuration did not create a StreamServer for: {}", (Object)inetAddress);
                continue;
            }
            this.logger.debug("Init datagram I/O on address: {}", (Object)inetAddress);
            RouterImpl routerImpl = this;
            datagramIO.init(inetAddress, this.networkAddressFactory.getMulticastResponsePort(), routerImpl, routerImpl.getConfiguration().getDatagramProcessor());
            this.datagramIOs.put(inetAddress, (DatagramIO)((Object)iterator));
        }
        for (Map.Entry<InetAddress, StreamServer> entry : this.streamServers.entrySet()) {
            this.logger.debug("Starting stream server on address: {}", (Object)entry.getKey());
            this.getConfiguration().getStreamServerExecutorService().execute(entry.getValue());
        }
        for (Map.Entry<InetAddress, Runnable> entry : this.datagramIOs.entrySet()) {
            this.logger.debug("Starting datagram I/O on address: {}", (Object)entry.getKey());
            this.getConfiguration().getDatagramIOExecutor().execute(entry.getValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void lock(Lock lock, int timeoutMilliseconds) throws RouterException {
        try {
            this.logger.trace("Trying to obtain lock with timeout milliseconds '{}': {}", (Object)timeoutMilliseconds, (Object)lock.getClass().getSimpleName());
            if (lock.tryLock(timeoutMilliseconds, TimeUnit.MILLISECONDS)) {
                this.logger.trace("Acquired router lock: {}", (Object)lock.getClass().getSimpleName());
                return;
            }
            throw new RouterException("Router wasn't available exclusively after waiting " + timeoutMilliseconds + "ms, lock failed: " + lock.getClass().getSimpleName());
        }
        catch (InterruptedException e) {
            void var2_3;
            void var1_1;
            throw new RouterException("Interruption while waiting for exclusive access: " + var1_1.getClass().getSimpleName(), (Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void lock(Lock lock) throws RouterException {
        void var1_1;
        this.lock((Lock)var1_1, this.getLockTimeoutMillis());
    }

    /*
     * WARNING - void declaration
     */
    protected void unlock(Lock lock) {
        void var1_1;
        this.logger.trace("Releasing router lock: {}", (Object)lock.getClass().getSimpleName());
        var1_1.unlock();
    }

    protected int getLockTimeoutMillis() {
        return 6000;
    }
}

