/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.registry;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jupnp.UpnpServiceConfiguration;
import org.jupnp.model.ValidationException;
import org.jupnp.model.gena.GENASubscription;
import org.jupnp.model.meta.Device;
import org.jupnp.model.meta.DeviceIdentity;
import org.jupnp.model.resource.Resource;
import org.jupnp.model.types.DeviceType;
import org.jupnp.model.types.ServiceType;
import org.jupnp.model.types.UDN;
import org.jupnp.registry.RegistrationException;
import org.jupnp.registry.RegistryImpl;
import org.jupnp.registry.RegistryItem;

abstract class RegistryItems<D extends Device, S extends GENASubscription> {
    protected final RegistryImpl registry;
    protected final Set<RegistryItem<UDN, D>> deviceItems = new HashSet<RegistryItem<UDN, D>>();
    protected final Set<RegistryItem<String, S>> subscriptionItems = new HashSet<RegistryItem<String, S>>();

    /*
     * WARNING - void declaration
     */
    RegistryItems(RegistryImpl registry) {
        void var1_1;
        this.registry = var1_1;
    }

    Set<RegistryItem<UDN, D>> getDeviceItems() {
        return this.deviceItems;
    }

    Set<RegistryItem<String, S>> getSubscriptionItems() {
        return this.subscriptionItems;
    }

    abstract void add(D var1);

    abstract boolean remove(D var1);

    abstract void removeAll();

    abstract void maintain();

    abstract void shutdown();

    /*
     * WARNING - void declaration
     */
    D get(UDN udn, boolean rootOnly) {
        for (RegistryItem<UDN, D> item : this.deviceItems) {
            void var3_4;
            Object foundDevice;
            Device device = (Device)item.getItem();
            if (((DeviceIdentity)device.getIdentity()).getUdn().equals(udn)) {
                return (D)device;
            }
            if (rootOnly || (foundDevice = ((Device)item.getItem()).findDevice(udn)) == null) continue;
            return var3_4;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    Collection<D> get(DeviceType deviceType) {
        void var2_2;
        HashSet devices = new HashSet();
        for (RegistryItem<UDN, D> registryItem : this.deviceItems) {
            Device[] d = ((Device)registryItem.getItem()).findDevices(deviceType);
            if (d == null) continue;
            devices.addAll(Arrays.asList(registryItem));
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    Collection<D> get(ServiceType serviceType) {
        void var2_2;
        HashSet devices = new HashSet();
        for (RegistryItem<UDN, D> registryItem : this.deviceItems) {
            Device[] d = ((Device)registryItem.getItem()).findDevices(serviceType);
            if (d == null) continue;
            devices.addAll(Arrays.asList(registryItem));
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    Collection<D> get() {
        void var1_1;
        HashSet<Device> devices = new HashSet<Device>();
        for (RegistryItem<UDN, D> item : this.deviceItems) {
            void var2_3;
            devices.add((Device)var2_3.getItem());
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    boolean contains(D device) {
        void var1_1;
        return this.contains(((DeviceIdentity)var1_1.getIdentity()).getUdn());
    }

    /*
     * WARNING - void declaration
     */
    boolean contains(UDN udn) {
        void var1_1;
        return this.deviceItems.contains(new RegistryItem(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    void addSubscription(S subscription) {
        void var1_1;
        S s = subscription;
        RegistryItem<String, S> subscriptionItem = new RegistryItem<String, S>(((GENASubscription)subscription).getSubscriptionId(), s, ((GENASubscription)s).getActualDurationSeconds());
        this.subscriptionItems.add((RegistryItem<String, S>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    boolean updateSubscription(S subscription) {
        if (this.removeSubscription(subscription)) {
            void var1_1;
            this.addSubscription(var1_1);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    boolean removeSubscription(S subscription) {
        void var1_1;
        return this.subscriptionItems.remove(new RegistryItem(var1_1.getSubscriptionId()));
    }

    /*
     * WARNING - void declaration
     */
    S getSubscription(String subscriptionId) {
        for (RegistryItem<String, S> registryItem : this.subscriptionItems) {
            void var2_3;
            if (!registryItem.getKey().equals(subscriptionId)) continue;
            return (S)((GENASubscription)var2_3.getItem());
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    Resource[] getResources(Device device) throws RegistrationException {
        UpnpServiceConfiguration config = this.registry.getConfiguration();
        if (config != null) {
            try {
                void var2_3;
                return var2_3.getNamespace().getResources(device);
            }
            catch (ValidationException e) {
                void var1_2;
                throw new RegistrationException("Resource discover error", (Throwable)var1_2);
            }
        }
        return new Resource[0];
    }
}

