/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.registry;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jupnp.UpnpService;
import org.jupnp.UpnpServiceConfiguration;
import org.jupnp.model.DiscoveryOptions;
import org.jupnp.model.ServiceReference;
import org.jupnp.model.gena.LocalGENASubscription;
import org.jupnp.model.gena.RemoteGENASubscription;
import org.jupnp.model.meta.Device;
import org.jupnp.model.meta.LocalDevice;
import org.jupnp.model.meta.RemoteDevice;
import org.jupnp.model.meta.RemoteDeviceIdentity;
import org.jupnp.model.meta.Service;
import org.jupnp.model.resource.Resource;
import org.jupnp.model.types.DeviceType;
import org.jupnp.model.types.ServiceType;
import org.jupnp.model.types.UDN;
import org.jupnp.protocol.ProtocolFactory;
import org.jupnp.registry.LocalItems;
import org.jupnp.registry.Registry;
import org.jupnp.registry.RegistryItem;
import org.jupnp.registry.RegistryListener;
import org.jupnp.registry.RegistryMaintainer;
import org.jupnp.registry.RemoteItems;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryImpl
implements Registry {
    private final Logger logger = LoggerFactory.getLogger(Registry.class);
    protected UpnpService upnpService;
    protected RegistryMaintainer registryMaintainer;
    protected final Set<RemoteGENASubscription> pendingSubscriptionsLock = new HashSet<RemoteGENASubscription>();
    protected Object lock = new Object();
    protected final Set<RegistryListener> registryListeners = new CopyOnWriteArraySet<RegistryListener>();
    protected final Set<RegistryItem<URI, Resource>> resourceItems = Collections.newSetFromMap(new ConcurrentHashMap());
    protected final List<Runnable> pendingExecutions = new LinkedList<Runnable>();
    protected final ReentrantReadWriteLock remoteItemsLock = new ReentrantReadWriteLock(true);
    protected final ReentrantReadWriteLock localItemsLock = new ReentrantReadWriteLock(true);
    protected final RemoteItems remoteItems = new RemoteItems(this);
    protected final LocalItems localItems = new LocalItems(this);

    public RegistryImpl() {
    }

    public RegistryImpl(UpnpService upnpService) {
        Object object;
        this.logger.trace("Creating Registry: {}", (Object)this.getClass().getName());
        this.upnpService = object;
        this.logger.trace("Starting registry background maintenance...");
        object = this.lock;
        synchronized (object) {
            this.registryMaintainer = this.createRegistryMaintainer();
            if (this.registryMaintainer != null) {
                this.getConfiguration().getRegistryMaintainerExecutor().execute(this.registryMaintainer);
            }
            return;
        }
    }

    @Override
    public UpnpService getUpnpService() {
        return this.upnpService;
    }

    @Override
    public UpnpServiceConfiguration getConfiguration() {
        return this.getUpnpService().getConfiguration();
    }

    @Override
    public ProtocolFactory getProtocolFactory() {
        return this.getUpnpService().getProtocolFactory();
    }

    protected RegistryMaintainer createRegistryMaintainer() {
        RegistryImpl registryImpl = this;
        return new RegistryMaintainer(registryImpl, registryImpl.getConfiguration().getRegistryMaintenanceIntervalMillis());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addListener(RegistryListener listener) {
        void var1_1;
        this.registryListeners.add((RegistryListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeListener(RegistryListener listener) {
        void var1_1;
        this.registryListeners.remove(var1_1);
    }

    @Override
    public Collection<RegistryListener> getListeners() {
        return Collections.unmodifiableCollection(this.registryListeners);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean notifyDiscoveryStart(RemoteDevice device) {
        if (this.getRemoteDevice(((RemoteDeviceIdentity)device.getIdentity()).getUdn(), true) != null) {
            this.logger.trace("Not notifying listeners, already registered: {}", (Object)device);
            return false;
        }
        for (RegistryListener listener : this.getListeners()) {
            void var2_3;
            this.getConfiguration().getRegistryListenerExecutor().execute(() -> this.lambda$0((RegistryListener)var2_3, device));
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void notifyDiscoveryFailure(RemoteDevice device, Exception e) {
        for (RegistryListener listener : this.getListeners()) {
            void var3_4;
            this.getConfiguration().getRegistryListenerExecutor().execute(() -> this.lambda$1((RegistryListener)var3_4, device, e));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addDevice(LocalDevice localDevice) {
        this.remoteItemsLock.readLock().lock();
        try {
            this.localItemsLock.writeLock().lock();
            try {
                void var1_1;
                this.localItems.add((LocalDevice)var1_1);
            }
            finally {
                this.localItemsLock.writeLock().unlock();
            }
        }
        finally {
            this.remoteItemsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addDevice(LocalDevice localDevice, DiscoveryOptions options) {
        this.remoteItemsLock.readLock().lock();
        try {
            this.localItemsLock.writeLock().lock();
            try {
                void var2_4;
                void var1_1;
                this.localItems.add((LocalDevice)var1_1, (DiscoveryOptions)var2_4);
            }
            finally {
                this.localItemsLock.writeLock().unlock();
            }
        }
        finally {
            this.remoteItemsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setDiscoveryOptions(UDN udn, DiscoveryOptions options) {
        this.localItemsLock.writeLock().lock();
        try {
            void var2_3;
            void var1_1;
            this.localItems.setDiscoveryOptions((UDN)var1_1, (DiscoveryOptions)var2_3);
        }
        finally {
            this.localItemsLock.writeLock().unlock();
        }
    }

    @Override
    public DiscoveryOptions getDiscoveryOptions(UDN udn) {
        this.localItemsLock.readLock().lock();
        try {
            DiscoveryOptions discoveryOptions;
            discoveryOptions = this.localItems.getDiscoveryOptions((UDN)((Object)discoveryOptions));
            return discoveryOptions;
        }
        finally {
            this.localItemsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addDevice(RemoteDevice remoteDevice) {
        this.remoteItemsLock.writeLock().lock();
        try {
            this.localItemsLock.readLock().lock();
            try {
                void var1_1;
                this.remoteItems.add((RemoteDevice)var1_1);
            }
            finally {
                this.localItemsLock.readLock().unlock();
            }
        }
        finally {
            this.remoteItemsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean update(RemoteDeviceIdentity rdIdentity) {
        this.remoteItemsLock.writeLock().lock();
        try {
            this.localItemsLock.readLock().lock();
            try {
                void var1_1;
                boolean bl = this.remoteItems.update((RemoteDeviceIdentity)var1_1);
                this.localItemsLock.readLock().unlock();
                return bl;
            }
            catch (Throwable throwable) {
                this.localItemsLock.readLock().unlock();
                throw throwable;
            }
        }
        finally {
            this.remoteItemsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean removeDevice(LocalDevice localDevice) {
        this.localItemsLock.writeLock().lock();
        try {
            void var1_1;
            boolean bl = this.localItems.remove((LocalDevice)var1_1);
            return bl;
        }
        finally {
            this.localItemsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean removeDevice(RemoteDevice remoteDevice) {
        this.remoteItemsLock.writeLock().lock();
        try {
            void var1_1;
            boolean bl = this.remoteItems.remove((RemoteDevice)var1_1);
            return bl;
        }
        finally {
            this.remoteItemsLock.writeLock().unlock();
        }
    }

    @Override
    public void removeAllLocalDevices() {
        this.localItemsLock.writeLock().lock();
        try {
            this.localItems.removeAll();
        }
        finally {
            this.localItemsLock.writeLock().unlock();
        }
    }

    @Override
    public void removeAllRemoteDevices() {
        this.remoteItemsLock.writeLock().lock();
        try {
            this.remoteItems.removeAll();
        }
        finally {
            this.remoteItemsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean removeDevice(UDN udn) {
        Device device = this.getDevice(udn, true);
        if (device != null && device instanceof LocalDevice) {
            return this.removeDevice((LocalDevice)device);
        }
        if (device != null && device instanceof RemoteDevice) {
            void var1_1;
            return this.removeDevice((RemoteDevice)var1_1);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Device getDevice(UDN udn, boolean rootOnly) {
        void var2_2;
        void var1_1;
        Device device = this.getLocalDevice(udn, rootOnly);
        if (device != null) {
            return device;
        }
        device = this.getRemoteDevice((UDN)var1_1, (boolean)var2_2);
        if (device != null) {
            void var3_3;
            return var3_3;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LocalDevice getLocalDevice(UDN udn, boolean rootOnly) {
        this.localItemsLock.readLock().lock();
        try {
            void var2_3;
            LocalDevice localDevice;
            localDevice = (LocalDevice)this.localItems.get((UDN)((Object)localDevice), (boolean)var2_3);
            return localDevice;
        }
        finally {
            this.localItemsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public RemoteDevice getRemoteDevice(UDN udn, boolean rootOnly) {
        this.remoteItemsLock.readLock().lock();
        try {
            void var2_3;
            RemoteDevice remoteDevice;
            remoteDevice = (RemoteDevice)this.remoteItems.get((UDN)((Object)remoteDevice), (boolean)var2_3);
            return remoteDevice;
        }
        finally {
            this.remoteItemsLock.readLock().unlock();
        }
    }

    @Override
    public Collection<LocalDevice> getLocalDevices() {
        this.localItemsLock.readLock().lock();
        try {
            Collection<LocalDevice> collection = Collections.unmodifiableCollection(this.localItems.get());
            return collection;
        }
        finally {
            this.localItemsLock.readLock().unlock();
        }
    }

    @Override
    public Collection<RemoteDevice> getRemoteDevices() {
        this.remoteItemsLock.readLock().lock();
        try {
            Collection<RemoteDevice> collection = Collections.unmodifiableCollection(this.remoteItems.get());
            return collection;
        }
        finally {
            this.remoteItemsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Collection<Device> getDevices() {
        void var1_1;
        HashSet<Object> all = new HashSet<Object>();
        this.remoteItemsLock.readLock().lock();
        try {
            all.addAll(this.remoteItems.get());
        }
        finally {
            this.remoteItemsLock.readLock().unlock();
        }
        this.localItemsLock.readLock().lock();
        try {
            all.addAll(this.localItems.get());
        }
        finally {
            this.localItemsLock.readLock().unlock();
        }
        return Collections.unmodifiableCollection(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Collection<Device> getDevices(DeviceType deviceType) {
        void var2_4;
        HashSet devices = new HashSet();
        this.remoteItemsLock.readLock().lock();
        try {
            devices.addAll(this.remoteItems.get(deviceType));
        }
        finally {
            this.remoteItemsLock.readLock().unlock();
        }
        this.localItemsLock.readLock().lock();
        try {
            void var1_1;
            devices.addAll(this.localItems.get((DeviceType)var1_1));
        }
        finally {
            this.localItemsLock.readLock().unlock();
        }
        return Collections.unmodifiableCollection(var2_4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Collection<Device> getDevices(ServiceType serviceType) {
        void var2_4;
        HashSet devices = new HashSet();
        this.remoteItemsLock.readLock().lock();
        try {
            devices.addAll(this.remoteItems.get(serviceType));
        }
        finally {
            this.remoteItemsLock.readLock().unlock();
        }
        this.localItemsLock.readLock().lock();
        try {
            void var1_1;
            devices.addAll(this.localItems.get((ServiceType)var1_1));
        }
        finally {
            this.localItemsLock.readLock().unlock();
        }
        return Collections.unmodifiableCollection(var2_4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Service getService(ServiceReference serviceReference) {
        Device device = this.getDevice(serviceReference.getUdn(), false);
        if (device != null) {
            void var1_1;
            void var2_2;
            return var2_2.findService(var1_1.getServiceId());
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Resource getResource(URI pathQuery) throws IllegalArgumentException {
        if (pathQuery.isAbsolute()) {
            throw new IllegalArgumentException("Resource URI can not be absolute, only path and query:" + String.valueOf(pathQuery));
        }
        for (RegistryItem<URI, Resource> registryItem : this.resourceItems) {
            Resource resource = registryItem.getItem();
            if (!resource.matches(pathQuery)) continue;
            return resource;
        }
        if (pathQuery.getPath().endsWith("/")) {
            URI pathQueryWithoutSlash = URI.create(pathQuery.toString().substring(0, pathQuery.toString().length() - 1));
            for (RegistryItem<URI, Resource> registryItem : this.resourceItems) {
                void var1_1;
                Resource resource = registryItem.getItem();
                if (!resource.matches(pathQueryWithoutSlash)) continue;
                return var1_1;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T extends Resource> T getResource(Class<T> resourceType, URI pathQuery) throws IllegalArgumentException {
        void var1_1;
        Resource resource = this.getResource(pathQuery);
        if (resource != null && var1_1.isAssignableFrom(resource.getClass())) {
            void var2_2;
            return var2_2;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Collection<Resource> getResources() {
        void var1_1;
        HashSet<Resource> s = new HashSet<Resource>(this.resourceItems.size());
        for (RegistryItem<URI, Resource> resourceItem : this.resourceItems) {
            void var2_3;
            s.add((Resource)var2_3.getItem());
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T extends Resource> Collection<T> getResources(Class<T> resourceType) {
        void var2_2;
        HashSet<Resource> s = new HashSet<Resource>(this.resourceItems.size());
        for (RegistryItem<URI, Resource> resourceItem : this.resourceItems) {
            void var3_4;
            if (!resourceType.isAssignableFrom(resourceItem.getItem().getClass())) continue;
            s.add((Resource)var3_4.getItem());
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addResource(Resource resource) {
        void var1_1;
        this.addResource((Resource)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addResource(Resource resource, int maxAgeSeconds) {
        void var1_1;
        void var2_2;
        RegistryItem<URI, Resource> resourceItem = new RegistryItem<URI, Resource>(resource.getPathQuery(), resource, (int)var2_2);
        this.resourceItems.remove(resourceItem);
        this.resourceItems.add((RegistryItem<URI, Resource>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean removeResource(Resource resource) {
        void var1_1;
        return this.resourceItems.remove(new RegistryItem(var1_1.getPathQuery()));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addLocalSubscription(LocalGENASubscription subscription) {
        this.localItemsLock.writeLock().lock();
        try {
            void var1_1;
            this.localItems.addSubscription(var1_1);
        }
        finally {
            this.localItemsLock.writeLock().unlock();
        }
    }

    @Override
    public LocalGENASubscription getLocalSubscription(String subscriptionId) {
        this.localItemsLock.readLock().lock();
        try {
            LocalGENASubscription localGENASubscription;
            localGENASubscription = (LocalGENASubscription)this.localItems.getSubscription((String)((Object)localGENASubscription));
            return localGENASubscription;
        }
        finally {
            this.localItemsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean updateLocalSubscription(LocalGENASubscription subscription) {
        this.localItemsLock.writeLock().lock();
        try {
            void var1_1;
            boolean bl = this.localItems.updateSubscription(var1_1);
            return bl;
        }
        finally {
            this.localItemsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean removeLocalSubscription(LocalGENASubscription subscription) {
        this.localItemsLock.writeLock().lock();
        try {
            void var1_1;
            boolean bl = this.localItems.removeSubscription(var1_1);
            return bl;
        }
        finally {
            this.localItemsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addRemoteSubscription(RemoteGENASubscription subscription) {
        this.remoteItemsLock.writeLock().lock();
        try {
            void var1_1;
            this.remoteItems.addSubscription(var1_1);
        }
        finally {
            this.remoteItemsLock.writeLock().unlock();
        }
    }

    @Override
    public RemoteGENASubscription getRemoteSubscription(String subscriptionId) {
        this.remoteItemsLock.readLock().lock();
        try {
            RemoteGENASubscription remoteGENASubscription;
            remoteGENASubscription = (RemoteGENASubscription)this.remoteItems.getSubscription((String)((Object)remoteGENASubscription));
            return remoteGENASubscription;
        }
        finally {
            this.remoteItemsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void updateRemoteSubscription(RemoteGENASubscription subscription) {
        this.remoteItemsLock.writeLock().lock();
        try {
            void var1_1;
            this.remoteItems.updateSubscription(var1_1);
        }
        finally {
            this.remoteItemsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeRemoteSubscription(RemoteGENASubscription subscription) {
        this.remoteItemsLock.writeLock().lock();
        try {
            void var1_1;
            this.remoteItems.removeSubscription(var1_1);
        }
        finally {
            this.remoteItemsLock.writeLock().unlock();
        }
    }

    @Override
    public void advertiseLocalDevices() {
        this.localItemsLock.readLock().lock();
        try {
            this.localItems.advertiseLocalDevices();
        }
        finally {
            this.localItemsLock.readLock().unlock();
        }
    }

    @Override
    public void shutdown() {
        this.logger.trace("Shutting down registry...");
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.registryMaintainer != null) {
                this.registryMaintainer.stop();
            }
        }
        List<Runnable> list = this.pendingExecutions;
        synchronized (list) {
            this.logger.trace("Executing final pending operations on shutdown: {}", (Object)this.pendingExecutions.size());
            this.runPendingExecutions(false);
        }
        for (RegistryListener registryListener : this.registryListeners) {
            registryListener.beforeShutdown(this);
        }
        for (RegistryItem registryItem : this.resourceItems) {
            ((Resource)registryItem.getItem()).shutdown();
        }
        this.remoteItemsLock.writeLock().lock();
        try {
            this.remoteItems.shutdown();
        }
        finally {
            this.remoteItemsLock.writeLock().unlock();
        }
        this.localItemsLock.writeLock().lock();
        try {
            this.localItems.shutdown();
        }
        finally {
            this.localItemsLock.writeLock().unlock();
        }
        for (RegistryListener registryListener : this.registryListeners) {
            registryListener.afterShutdown();
        }
    }

    @Override
    public void pause() {
        Object object = this.lock;
        synchronized (object) {
            if (this.registryMaintainer != null) {
                this.logger.trace("Pausing registry maintenance");
                this.runPendingExecutions(true);
                this.registryMaintainer.stop();
                this.registryMaintainer = null;
            }
            return;
        }
    }

    @Override
    public void resume() {
        Object object = this.lock;
        synchronized (object) {
            if (this.registryMaintainer == null) {
                this.logger.trace("Resuming registry maintenance");
                this.remoteItemsLock.writeLock().lock();
                try {
                    this.localItemsLock.readLock().lock();
                    try {
                        this.remoteItems.resume();
                    }
                    finally {
                        this.localItemsLock.readLock().unlock();
                    }
                }
                finally {
                    this.remoteItemsLock.writeLock().unlock();
                }
                this.registryMaintainer = this.createRegistryMaintainer();
                if (this.registryMaintainer != null) {
                    this.getConfiguration().getRegistryMaintainerExecutor().execute(this.registryMaintainer);
                }
            }
            return;
        }
    }

    @Override
    public boolean isPaused() {
        Object object = this.lock;
        synchronized (object) {
            return this.registryMaintainer == null;
        }
    }

    /*
     * WARNING - void declaration
     */
    void maintain() {
        List<Runnable> list;
        this.logger.trace("Maintaining registry...");
        Iterator<RegistryItem<URI, Resource>> it = this.resourceItems.iterator();
        while (it.hasNext()) {
            RegistryItem<URI, Resource> item = it.next();
            if (!item.getExpirationDetails().hasExpired()) continue;
            this.logger.trace("Removing expired resource: {}", list);
            it.remove();
        }
        list = this.pendingExecutions;
        synchronized (list) {
            for (RegistryItem<URI, Resource> resourceItem : this.resourceItems) {
                void var1_1;
                resourceItem.getItem().maintain(this.pendingExecutions, var1_1.getExpirationDetails());
            }
        }
        this.remoteItemsLock.writeLock().lock();
        try {
            this.remoteItems.maintain();
        }
        finally {
            this.remoteItemsLock.writeLock().unlock();
        }
        this.localItemsLock.writeLock().lock();
        try {
            this.localItems.maintain();
        }
        finally {
            this.localItemsLock.writeLock().unlock();
        }
        this.runPendingExecutions(true);
    }

    /*
     * WARNING - void declaration
     */
    void executeAsyncProtocol(Runnable runnable) {
        List<Runnable> list = this.pendingExecutions;
        synchronized (list) {
            void var1_1;
            this.pendingExecutions.add((Runnable)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    void runPendingExecutions(boolean async) {
        List<Runnable> list = this.pendingExecutions;
        synchronized (list) {
            this.logger.trace("Executing pending operations: {}", (Object)this.pendingExecutions.size());
            for (Runnable pendingExecution : this.pendingExecutions) {
                void var3_4;
                if (async) {
                    this.getConfiguration().getAsyncProtocolExecutor().execute(pendingExecution);
                    continue;
                }
                var3_4.run();
            }
            if (!this.pendingExecutions.isEmpty()) {
                this.pendingExecutions.clear();
            }
            return;
        }
    }

    public void printDebugLog() {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("====================================    REMOTE   ================================================");
            this.remoteItemsLock.readLock().lock();
            try {
                for (RemoteDevice remoteDevice : this.remoteItems.get()) {
                    this.logger.trace(remoteDevice.toString());
                }
            }
            finally {
                this.remoteItemsLock.readLock().unlock();
            }
            this.logger.trace("====================================    LOCAL    ================================================");
            this.localItemsLock.readLock().lock();
            try {
                for (LocalDevice localDevice : this.localItems.get()) {
                    this.logger.trace(localDevice.toString());
                }
            }
            finally {
                this.localItemsLock.readLock().unlock();
            }
            this.logger.trace("====================================  RESOURCES  ================================================");
            for (RegistryItem registryItem : this.resourceItems) {
                this.logger.trace(registryItem.toString());
            }
            this.logger.trace("=================================================================================================");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void registerPendingRemoteSubscription(RemoteGENASubscription subscription) {
        Set<RemoteGENASubscription> set = this.pendingSubscriptionsLock;
        synchronized (set) {
            void var1_1;
            this.pendingSubscriptionsLock.add((RemoteGENASubscription)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void unregisterPendingRemoteSubscription(RemoteGENASubscription subscription) {
        Set<RemoteGENASubscription> set = this.pendingSubscriptionsLock;
        synchronized (set) {
            void var1_1;
            if (this.pendingSubscriptionsLock.remove(var1_1)) {
                this.pendingSubscriptionsLock.notifyAll();
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public RemoteGENASubscription getWaitRemoteSubscription(String subscriptionId) {
        Set<RemoteGENASubscription> set = this.pendingSubscriptionsLock;
        synchronized (set) {
            do {
                RemoteGENASubscription subscription;
                if ((subscription = this.getRemoteSubscription(subscriptionId)) != null) {
                    void var3_3;
                    return var3_3;
                }
                if (this.pendingSubscriptionsLock.isEmpty()) continue;
                try {
                    this.logger.trace("Subscription not found, waiting for pending subscription procedure to terminate.");
                    this.pendingSubscriptionsLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            } while (!this.pendingSubscriptionsLock.isEmpty());
        }
        return null;
    }

    private /* synthetic */ void lambda$0(RegistryListener registryListener, RemoteDevice remoteDevice) {
        registryListener.remoteDeviceDiscoveryStarted(this, remoteDevice);
    }

    private /* synthetic */ void lambda$1(RegistryListener registryListener, RemoteDevice remoteDevice, Exception exception) {
        registryListener.remoteDeviceDiscoveryFailed(this, remoteDevice, exception);
    }
}

