/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.registry;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import org.jupnp.model.DiscoveryOptions;
import org.jupnp.model.gena.CancelReason;
import org.jupnp.model.gena.LocalGENASubscription;
import org.jupnp.model.meta.Device;
import org.jupnp.model.meta.DeviceIdentity;
import org.jupnp.model.meta.LocalDevice;
import org.jupnp.model.meta.LocalService;
import org.jupnp.model.resource.Resource;
import org.jupnp.model.types.UDN;
import org.jupnp.protocol.async.SendingNotificationByebye;
import org.jupnp.registry.RegistrationException;
import org.jupnp.registry.Registry;
import org.jupnp.registry.RegistryImpl;
import org.jupnp.registry.RegistryItem;
import org.jupnp.registry.RegistryItems;
import org.jupnp.registry.RegistryListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LocalItems
extends RegistryItems<LocalDevice, LocalGENASubscription> {
    private final Logger logger = LoggerFactory.getLogger(Registry.class);
    protected Map<UDN, DiscoveryOptions> discoveryOptions = new HashMap<UDN, DiscoveryOptions>();
    protected long lastAliveIntervalTimestamp = 0L;
    protected Random randomGenerator = new Random();

    /*
     * WARNING - void declaration
     */
    LocalItems(RegistryImpl registry) {
        super((RegistryImpl)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected void setDiscoveryOptions(UDN udn, DiscoveryOptions options) {
        void var1_1;
        if (options != null) {
            void var2_2;
            this.discoveryOptions.put(udn, (DiscoveryOptions)var2_2);
            return;
        }
        this.discoveryOptions.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected DiscoveryOptions getDiscoveryOptions(UDN udn) {
        void var1_1;
        return this.discoveryOptions.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isAdvertised(UDN udn) {
        void var1_1;
        return this.getDiscoveryOptions(udn) == null || this.getDiscoveryOptions((UDN)var1_1).isAdvertised();
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isByeByeBeforeFirstAlive(UDN udn) {
        void var1_1;
        return this.getDiscoveryOptions(udn) != null && this.getDiscoveryOptions((UDN)var1_1).isByeByeBeforeFirstAlive();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void add(LocalDevice localDevice) throws RegistrationException {
        void var1_1;
        this.add((LocalDevice)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    void add(LocalDevice localDevice, DiscoveryOptions options) throws RegistrationException {
        void var2_2;
        this.setDiscoveryOptions(((DeviceIdentity)localDevice.getIdentity()).getUdn(), options);
        if (this.registry.getDevice(((DeviceIdentity)localDevice.getIdentity()).getUdn(), false) != null) {
            this.logger.trace("Ignoring addition, device already registered: {}", (Object)localDevice);
            return;
        }
        this.logger.trace("Adding local device to registry: {}", (Object)localDevice);
        Resource[] resourceArray = this.getResources(localDevice);
        int n = resourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            Resource deviceResource = resourceArray[n2];
            if (this.registry.getResource(deviceResource.getPathQuery()) != null) {
                throw new RegistrationException("URI namespace conflict with already registered resource: " + String.valueOf(deviceResource));
            }
            this.registry.addResource(deviceResource);
            this.logger.trace("Registered resource: {}", (Object)deviceResource);
            ++n2;
        }
        this.logger.trace("Adding item to registry with expiration in seconds: {}", (Object)((DeviceIdentity)localDevice.getIdentity()).getMaxAgeSeconds());
        LocalDevice localDevice2 = localDevice;
        RegistryItem<UDN, LocalDevice> localItem = new RegistryItem<UDN, LocalDevice>(((DeviceIdentity)localDevice.getIdentity()).getUdn(), localDevice2, ((DeviceIdentity)localDevice2.getIdentity()).getMaxAgeSeconds());
        this.getDeviceItems().add(localItem);
        this.logger.trace("Registered local device: {}", localItem);
        if (this.isByeByeBeforeFirstAlive(localItem.getKey())) {
            this.advertiseByebye(localDevice, true);
        }
        if (this.isAdvertised((UDN)var2_2.getKey())) {
            this.advertiseAlive(localDevice);
        }
        for (RegistryListener listener : this.registry.getListeners()) {
            void var3_7;
            this.registry.getConfiguration().getRegistryListenerExecutor().execute(() -> this.lambda$0((RegistryListener)var3_7, localDevice));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Collection<LocalDevice> get() {
        void var1_1;
        HashSet<LocalDevice> c = new HashSet<LocalDevice>();
        for (RegistryItem item : this.getDeviceItems()) {
            void var2_3;
            c.add((LocalDevice)var2_3.getItem());
        }
        return Collections.unmodifiableCollection(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    boolean remove(LocalDevice localDevice) throws RegistrationException {
        void var1_1;
        return this.remove((LocalDevice)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    boolean remove(LocalDevice localDevice, boolean shuttingDown) throws RegistrationException {
        LocalDevice registeredDevice = (LocalDevice)this.get(((DeviceIdentity)localDevice.getIdentity()).getUdn(), true);
        if (registeredDevice != null) {
            void var2_2;
            this.logger.trace("Removing local device from registry: {}", (Object)localDevice);
            this.setDiscoveryOptions(((DeviceIdentity)localDevice.getIdentity()).getUdn(), null);
            this.getDeviceItems().remove(new RegistryItem(((DeviceIdentity)localDevice.getIdentity()).getUdn()));
            Resource[] resourceArray = this.getResources(localDevice);
            int n = resourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                Resource deviceResource = resourceArray[n2];
                if (this.registry.removeResource(deviceResource)) {
                    this.logger.trace("Unregistered resource: {}", (Object)deviceResource);
                }
                ++n2;
            }
            Iterator it = this.getSubscriptionItems().iterator();
            while (it.hasNext()) {
                RegistryItem incomingSubscription = it.next();
                UDN uDN = ((DeviceIdentity)((Device)((LocalService)((LocalGENASubscription)incomingSubscription.getItem()).getService()).getDevice()).getIdentity()).getUdn();
                if (!uDN.equals(((DeviceIdentity)registeredDevice.getIdentity()).getUdn())) continue;
                this.logger.trace("Removing incoming subscription: {}", (Object)incomingSubscription.getKey());
                it.remove();
                if (shuttingDown) continue;
                this.registry.getConfiguration().getRegistryListenerExecutor().execute(() -> ((LocalGENASubscription)incomingSubscription.getItem()).end(CancelReason.DEVICE_WAS_REMOVED));
            }
            if (this.isAdvertised(((DeviceIdentity)localDevice.getIdentity()).getUdn())) {
                this.advertiseByebye(localDevice, !shuttingDown);
            }
            if (var2_2 == false) {
                for (RegistryListener listener : this.registry.getListeners()) {
                    this.registry.getConfiguration().getRegistryListenerExecutor().execute(() -> listener.localDeviceRemoved(this.registry, localDevice));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    void removeAll() {
        this.removeAll(false);
    }

    void removeAll(boolean shuttingDown) {
        LocalDevice[] localDeviceArray;
        LocalDevice[] localDeviceArray2 = localDeviceArray = this.get().toArray(new LocalDevice[this.get().size()]);
        int n = localDeviceArray.length;
        int n2 = 0;
        while (n2 < n) {
            LocalDevice device = localDeviceArray2[n2];
            this.remove((LocalDevice)localDeviceArray, shuttingDown);
            ++n2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void advertiseLocalDevices() {
        for (RegistryItem localItem : this.deviceItems) {
            void var1_2;
            if (!this.isAdvertised(localItem.getKey())) continue;
            this.advertiseAlive((LocalDevice)var1_2.getItem());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void maintain() {
        void var3_9;
        void var1_1;
        if (this.getDeviceItems().isEmpty()) {
            return;
        }
        HashSet<Object> expiredLocalItems = new HashSet<Object>();
        int aliveIntervalMillis = this.registry.getConfiguration().getAliveIntervalMillis();
        if (aliveIntervalMillis > 0) {
            long now = System.currentTimeMillis();
            if (now - this.lastAliveIntervalTimestamp > (long)aliveIntervalMillis) {
                this.lastAliveIntervalTimestamp = now;
                for (RegistryItem localItem : this.getDeviceItems()) {
                    void var2_3;
                    if (!this.isAdvertised(localItem.getKey())) continue;
                    this.logger.trace("Flooding advertisement of local item: {}", localItem);
                    expiredLocalItems.add(var2_3);
                }
            }
        } else {
            this.lastAliveIntervalTimestamp = 0L;
            for (RegistryItem localItem : this.getDeviceItems()) {
                if (!this.isAdvertised(localItem.getKey()) || !localItem.getExpirationDetails().hasExpired(true)) continue;
                this.logger.trace("Local item has expired: {}", localItem);
                expiredLocalItems.add(localItem);
            }
        }
        for (RegistryItem<UDN, Object> expiredLocalItem : var1_1) {
            this.logger.trace("Refreshing local device advertisement: {}", expiredLocalItem.getItem());
            this.advertiseAlive((LocalDevice)expiredLocalItem.getItem());
            expiredLocalItem.getExpirationDetails().stampLastRefresh();
        }
        HashSet expiredIncomingSubscriptions = new HashSet();
        for (RegistryItem item : this.getSubscriptionItems()) {
            if (!item.getExpirationDetails().hasExpired(false)) continue;
            expiredIncomingSubscriptions.add(item);
        }
        for (RegistryItem<String, Object> subscription : var3_9) {
            this.logger.trace("Removing expired: {}", subscription);
            this.removeSubscription((LocalGENASubscription)subscription.getItem());
            ((LocalGENASubscription)subscription.getItem()).end(CancelReason.EXPIRED);
        }
    }

    @Override
    void shutdown() {
        this.logger.trace("Clearing all registered subscriptions to local devices during shutdown");
        this.getSubscriptionItems().clear();
        this.logger.trace("Removing all local devices from registry during shutdown");
        this.removeAll(true);
    }

    /*
     * WARNING - void declaration
     */
    protected void advertiseAlive(LocalDevice localDevice) {
        void var1_1;
        this.registry.executeAsyncProtocol(() -> this.lambda$3((LocalDevice)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    protected void advertiseByebye(LocalDevice localDevice, boolean asynchronous) {
        void var1_1;
        void var2_2;
        SendingNotificationByebye prot = this.registry.getProtocolFactory().createSendingNotificationByebye(localDevice);
        if (var2_2 != false) {
            this.registry.executeAsyncProtocol(prot);
            return;
        }
        var1_1.run();
    }

    private /* synthetic */ void lambda$0(RegistryListener registryListener, LocalDevice localDevice) {
        registryListener.localDeviceAdded(this.registry, localDevice);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$3(LocalDevice localDevice) {
        try {
            this.logger.trace("Sleeping some milliseconds to avoid flooding the network with ALIVE msgs");
            Thread.sleep(this.randomGenerator.nextInt(100));
        }
        catch (InterruptedException e) {
            void var2_2;
            this.logger.error("Background execution interrupted", (Throwable)var2_2);
        }
        this.registry.getProtocolFactory().createSendingNotificationAlive(localDevice).run();
    }
}

