/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.protocol.sync;

import org.jupnp.UpnpService;
import org.jupnp.model.gena.CancelReason;
import org.jupnp.model.gena.RemoteGENASubscription;
import org.jupnp.model.message.StreamRequestMessage;
import org.jupnp.model.message.StreamResponseMessage;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.model.message.gena.OutgoingUnsubscribeRequestMessage;
import org.jupnp.model.meta.RemoteService;
import org.jupnp.protocol.SendingSync;
import org.jupnp.transport.RouterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendingUnsubscribe
extends SendingSync<OutgoingUnsubscribeRequestMessage, StreamResponseMessage> {
    private final Logger logger = LoggerFactory.getLogger(SendingUnsubscribe.class);
    protected final RemoteGENASubscription subscription;

    /*
     * WARNING - void declaration
     */
    public SendingUnsubscribe(UpnpService upnpService, RemoteGENASubscription subscription) {
        super(upnpService, new OutgoingUnsubscribeRequestMessage(subscription, var1_1.getConfiguration().getEventSubscriptionHeaders((RemoteService)subscription.getService())));
        void var2_2;
        void var1_1;
        this.subscription = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected StreamResponseMessage executeSync() throws RouterException {
        this.logger.trace("Sending unsubscribe request: {}", this.getInputMessage());
        StreamResponseMessage response = null;
        try {
            StreamResponseMessage streamResponseMessage = response = this.getUpnpService().getRouter().send((StreamRequestMessage)this.getInputMessage());
            this.onUnsubscribe(response);
            return streamResponseMessage;
        }
        catch (Throwable throwable) {
            void var1_1;
            this.onUnsubscribe((StreamResponseMessage)var1_1);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void onUnsubscribe(StreamResponseMessage response) {
        void var1_1;
        this.getUpnpService().getRegistry().removeRemoteSubscription(this.subscription);
        this.getUpnpService().getConfiguration().getRegistryListenerExecutor().execute(() -> this.lambda$0((StreamResponseMessage)var1_1));
    }

    private /* synthetic */ void lambda$0(StreamResponseMessage streamResponseMessage) {
        if (streamResponseMessage == null) {
            this.logger.trace("Unsubscribe failed, no response received");
            this.subscription.end(CancelReason.UNSUBSCRIBE_FAILED, null);
            return;
        }
        if (((UpnpResponse)streamResponseMessage.getOperation()).isFailed()) {
            this.logger.trace("Unsubscribe failed, response was: {}", (Object)streamResponseMessage);
            this.subscription.end(CancelReason.UNSUBSCRIBE_FAILED, (UpnpResponse)streamResponseMessage.getOperation());
            return;
        }
        this.logger.trace("Unsubscribe successful, response was: {}", (Object)streamResponseMessage);
        this.subscription.end(null, (UpnpResponse)streamResponseMessage.getOperation());
    }
}

