/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.protocol.sync;

import java.util.List;
import org.jupnp.UpnpService;
import org.jupnp.model.NetworkAddress;
import org.jupnp.model.gena.RemoteGENASubscription;
import org.jupnp.model.message.StreamRequestMessage;
import org.jupnp.model.message.StreamResponseMessage;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.model.message.gena.IncomingSubscribeResponseMessage;
import org.jupnp.model.message.gena.OutgoingSubscribeRequestMessage;
import org.jupnp.model.meta.RemoteService;
import org.jupnp.protocol.SendingSync;
import org.jupnp.transport.RouterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendingSubscribe
extends SendingSync<OutgoingSubscribeRequestMessage, IncomingSubscribeResponseMessage> {
    private final Logger logger;
    protected final RemoteGENASubscription subscription;

    /*
     * WARNING - void declaration
     */
    public SendingSubscribe(UpnpService upnpService, RemoteGENASubscription subscription, List<NetworkAddress> activeStreamServers) {
        void var2_2;
        void var1_1;
        void var3_3;
        RemoteGENASubscription remoteGENASubscription = subscription;
        super(upnpService, new OutgoingSubscribeRequestMessage(remoteGENASubscription, remoteGENASubscription.getEventCallbackURLs((List<NetworkAddress>)var3_3, upnpService.getConfiguration().getNamespace()), var1_1.getConfiguration().getEventSubscriptionHeaders((RemoteService)subscription.getService())));
        this.logger = LoggerFactory.getLogger(SendingSubscribe.class);
        this.subscription = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected IncomingSubscribeResponseMessage executeSync() throws RouterException {
        if (!((OutgoingSubscribeRequestMessage)this.getInputMessage()).hasCallbackURLs()) {
            this.logger.trace("Subscription failed, no active local callback URLs available (network disabled?)");
            this.getUpnpService().getConfiguration().getRegistryListenerExecutor().execute(() -> this.subscription.fail(null));
            return null;
        }
        this.logger.trace("Sending subscription request: {}", this.getInputMessage());
        try {
            void var2_3;
            void var1_1;
            StreamResponseMessage response;
            this.getUpnpService().getRegistry().registerPendingRemoteSubscription(this.subscription);
            try {
                response = this.getUpnpService().getRouter().send((StreamRequestMessage)this.getInputMessage());
            }
            catch (RouterException routerException) {
                this.onSubscriptionFailure();
                this.getUpnpService().getRegistry().unregisterPendingRemoteSubscription(this.subscription);
                return null;
            }
            if (response == null) {
                this.onSubscriptionFailure();
                return null;
            }
            IncomingSubscribeResponseMessage responseMessage = new IncomingSubscribeResponseMessage(response);
            if (((UpnpResponse)response.getOperation()).isFailed()) {
                this.logger.trace("Subscription failed, response was: {}", (Object)responseMessage);
                this.getUpnpService().getConfiguration().getRegistryListenerExecutor().execute(() -> this.subscription.fail((UpnpResponse)responseMessage.getOperation()));
            } else if (!responseMessage.isValidHeaders()) {
                this.logger.error("Subscription failed, invalid or missing (SID, Timeout) response headers");
                this.getUpnpService().getConfiguration().getRegistryListenerExecutor().execute(() -> this.subscription.fail((UpnpResponse)responseMessage.getOperation()));
            } else {
                this.logger.trace("Subscription established, adding to registry, response was: {}", (Object)var1_1);
                this.subscription.setSubscriptionId(responseMessage.getSubscriptionId());
                this.subscription.setActualSubscriptionDurationSeconds(responseMessage.getSubscriptionDurationSeconds());
                this.getUpnpService().getRegistry().addRemoteSubscription(this.subscription);
                this.getUpnpService().getConfiguration().getRegistryListenerExecutor().execute(this.subscription::establish);
            }
            var1_1 = var2_3;
            return var1_1;
        }
        finally {
            this.getUpnpService().getRegistry().unregisterPendingRemoteSubscription(this.subscription);
        }
    }

    protected void onSubscriptionFailure() {
        this.logger.trace("Subscription failed");
        this.getUpnpService().getConfiguration().getRegistryListenerExecutor().execute(() -> this.subscription.fail(null));
    }
}

