/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.protocol.sync;

import org.jupnp.UpnpService;
import org.jupnp.model.gena.CancelReason;
import org.jupnp.model.gena.RemoteGENASubscription;
import org.jupnp.model.message.StreamRequestMessage;
import org.jupnp.model.message.StreamResponseMessage;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.model.message.gena.IncomingSubscribeResponseMessage;
import org.jupnp.model.message.gena.OutgoingRenewalRequestMessage;
import org.jupnp.model.meta.RemoteService;
import org.jupnp.protocol.SendingSync;
import org.jupnp.transport.RouterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendingRenewal
extends SendingSync<OutgoingRenewalRequestMessage, IncomingSubscribeResponseMessage> {
    private final Logger logger = LoggerFactory.getLogger(SendingRenewal.class);
    protected final RemoteGENASubscription subscription;

    /*
     * WARNING - void declaration
     */
    public SendingRenewal(UpnpService upnpService, RemoteGENASubscription subscription) {
        super(upnpService, new OutgoingRenewalRequestMessage(subscription, var1_1.getConfiguration().getEventSubscriptionHeaders((RemoteService)subscription.getService())));
        void var2_2;
        void var1_1;
        this.subscription = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected IncomingSubscribeResponseMessage executeSync() throws RouterException {
        void var2_3;
        StreamResponseMessage response;
        this.logger.trace("Sending subscription renewal request: {}", this.getInputMessage());
        try {
            response = this.getUpnpService().getRouter().send((StreamRequestMessage)this.getInputMessage());
        }
        catch (RouterException e) {
            this.onRenewalFailure();
            throw e;
        }
        if (response == null) {
            this.onRenewalFailure();
            return null;
        }
        IncomingSubscribeResponseMessage responseMessage = new IncomingSubscribeResponseMessage(response);
        if (((UpnpResponse)response.getOperation()).isFailed()) {
            this.logger.trace("Subscription renewal failed, response was: {}", (Object)response);
            this.getUpnpService().getRegistry().removeRemoteSubscription(this.subscription);
            this.getUpnpService().getConfiguration().getRegistryListenerExecutor().execute(() -> this.subscription.end(CancelReason.RENEWAL_FAILED, (UpnpResponse)responseMessage.getOperation()));
        } else if (!responseMessage.isValidHeaders()) {
            this.logger.error("Subscription renewal failed, invalid or missing (SID, Timeout) response headers");
            this.getUpnpService().getConfiguration().getRegistryListenerExecutor().execute(() -> this.subscription.end(CancelReason.RENEWAL_FAILED, (UpnpResponse)responseMessage.getOperation()));
        } else {
            void var1_1;
            this.logger.trace("Subscription renewed, updating in registry, response was: {}", (Object)var1_1);
            this.subscription.setActualSubscriptionDurationSeconds(responseMessage.getSubscriptionDurationSeconds());
            this.getUpnpService().getRegistry().updateRemoteSubscription(this.subscription);
        }
        return var2_3;
    }

    protected void onRenewalFailure() {
        this.logger.trace("Subscription renewal failed, removing subscription from registry");
        this.getUpnpService().getRegistry().removeRemoteSubscription(this.subscription);
        this.getUpnpService().getConfiguration().getRegistryListenerExecutor().execute(() -> this.subscription.end(CancelReason.RENEWAL_FAILED, null));
    }
}

