/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.protocol.sync;

import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.List;
import org.jupnp.UpnpService;
import org.jupnp.model.gena.CancelReason;
import org.jupnp.model.gena.LocalGENASubscription;
import org.jupnp.model.message.StreamRequestMessage;
import org.jupnp.model.message.StreamResponseMessage;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.model.message.gena.IncomingSubscribeRequestMessage;
import org.jupnp.model.message.gena.OutgoingSubscribeResponseMessage;
import org.jupnp.model.meta.LocalService;
import org.jupnp.model.resource.ServiceEventSubscriptionResource;
import org.jupnp.protocol.ReceivingSync;
import org.jupnp.transport.RouterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceivingSubscribe
extends ReceivingSync<StreamRequestMessage, OutgoingSubscribeResponseMessage> {
    private final Logger logger = LoggerFactory.getLogger(ReceivingSubscribe.class);
    protected LocalGENASubscription subscription;

    /*
     * WARNING - void declaration
     */
    public ReceivingSubscribe(UpnpService upnpService, StreamRequestMessage inputMessage) {
        super((UpnpService)var1_1, var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected OutgoingSubscribeResponseMessage executeSync() throws RouterException {
        ServiceEventSubscriptionResource resource = this.getUpnpService().getRegistry().getResource(ServiceEventSubscriptionResource.class, ((StreamRequestMessage)this.getInputMessage()).getUri());
        if (resource == null) {
            this.logger.trace("No local resource found: {}", this.getInputMessage());
            return null;
        }
        this.logger.trace("Found local event subscription matching relative request URI: {}", (Object)((StreamRequestMessage)this.getInputMessage()).getUri());
        IncomingSubscribeRequestMessage requestMessage = new IncomingSubscribeRequestMessage((StreamRequestMessage)this.getInputMessage(), (LocalService)resource.getModel());
        if (requestMessage.getCallbackURLs() != null) {
            for (URL callbackUrl : requestMessage.getCallbackURLs()) {
                try {
                    void var3_4;
                    InetAddress callbackAddress = InetAddress.getByName(callbackUrl.getHost());
                    if (callbackAddress.isLoopbackAddress() || callbackAddress.isLinkLocalAddress() || var3_4.isSiteLocalAddress()) continue;
                    this.logger.trace("Callback URL not on accepted address range: {}", this.getInputMessage());
                    return new OutgoingSubscribeResponseMessage(UpnpResponse.Status.PRECONDITION_FAILED);
                }
                catch (UnknownHostException unknownHostException) {
                    this.logger.trace("Unknown host for callback URL: {}", this.getInputMessage());
                    return new OutgoingSubscribeResponseMessage(UpnpResponse.Status.PRECONDITION_FAILED);
                }
            }
        }
        if (requestMessage.getSubscriptionId() != null && (requestMessage.hasNotificationHeader() || requestMessage.getCallbackURLs() != null)) {
            this.logger.trace("Subscription ID and NT or Callback in subscribe request: {}", this.getInputMessage());
            return new OutgoingSubscribeResponseMessage(UpnpResponse.Status.BAD_REQUEST);
        }
        if (requestMessage.getSubscriptionId() != null) {
            return this.processRenewal((LocalService)resource.getModel(), requestMessage);
        }
        if (requestMessage.hasNotificationHeader() && requestMessage.getCallbackURLs() != null) {
            void var2_2;
            void var1_1;
            return this.processNewSubscription((LocalService)var1_1.getModel(), (IncomingSubscribeRequestMessage)var2_2);
        }
        this.logger.trace("No subscription ID, no NT or Callback, neither subscription or renewal: {}", this.getInputMessage());
        return new OutgoingSubscribeResponseMessage(UpnpResponse.Status.PRECONDITION_FAILED);
    }

    /*
     * WARNING - void declaration
     */
    protected OutgoingSubscribeResponseMessage processRenewal(LocalService service, IncomingSubscribeRequestMessage requestMessage) {
        void var2_2;
        this.subscription = this.getUpnpService().getRegistry().getLocalSubscription(requestMessage.getSubscriptionId());
        if (this.subscription == null) {
            this.logger.trace("Invalid subscription ID for renewal request: {}", this.getInputMessage());
            return new OutgoingSubscribeResponseMessage(UpnpResponse.Status.PRECONDITION_FAILED);
        }
        this.logger.trace("Renewing subscription: {}", (Object)this.subscription);
        this.subscription.setSubscriptionDuration(var2_2.getRequestedTimeoutSeconds());
        if (this.getUpnpService().getRegistry().updateLocalSubscription(this.subscription)) {
            return new OutgoingSubscribeResponseMessage(this.subscription);
        }
        this.logger.trace("Subscription went away before it could be renewed: {}", this.getInputMessage());
        return new OutgoingSubscribeResponseMessage(UpnpResponse.Status.PRECONDITION_FAILED);
    }

    /*
     * WARNING - void declaration
     */
    protected OutgoingSubscribeResponseMessage processNewSubscription(LocalService service, IncomingSubscribeRequestMessage requestMessage) {
        Integer timeoutSeconds;
        List<URL> callbackURLs = requestMessage.getCallbackURLs();
        if (callbackURLs == null || callbackURLs.isEmpty()) {
            this.logger.trace("Missing or invalid Callback URLs in subscribe request: {}", this.getInputMessage());
            return new OutgoingSubscribeResponseMessage(UpnpResponse.Status.PRECONDITION_FAILED);
        }
        if (!requestMessage.hasNotificationHeader()) {
            this.logger.trace("Missing or invalid NT header in subscribe request: {}", this.getInputMessage());
            return new OutgoingSubscribeResponseMessage(UpnpResponse.Status.PRECONDITION_FAILED);
        }
        timeoutSeconds = this.getUpnpService().getConfiguration().isReceivedSubscriptionTimeoutIgnored() ? null : ((IncomingSubscribeRequestMessage)((Object)timeoutSeconds)).getRequestedTimeoutSeconds();
        try {
            void var3_4;
            void var2_3;
            this.subscription = new LocalGENASubscription(service, (Integer)var2_3, (List)var3_4){
                {
                    void var3_3;
                    void var2_2;
                    super((LocalService)var2_2, (Integer)var3_3, $anonymous2);
                }

                @Override
                public void established() {
                }

                @Override
                public void ended(CancelReason reason) {
                }

                @Override
                public void eventReceived() {
                    ReceivingSubscribe.this.getUpnpService().getConfiguration().getSyncProtocolExecutorService().execute(ReceivingSubscribe.this.getUpnpService().getProtocolFactory().createSendingEvent(this));
                }
            };
        }
        catch (Exception e) {
            void var1_2;
            this.logger.warn("Couldn't create local subscription to service", (Throwable)var1_2);
            return new OutgoingSubscribeResponseMessage(UpnpResponse.Status.INTERNAL_SERVER_ERROR);
        }
        this.logger.trace("Adding subscription to registry: {}", (Object)this.subscription);
        this.getUpnpService().getRegistry().addLocalSubscription(this.subscription);
        this.logger.trace("Returning subscription response, waiting to send initial event");
        return new OutgoingSubscribeResponseMessage(this.subscription);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void responseSent(StreamResponseMessage responseMessage) {
        if (this.subscription == null) {
            return;
        }
        if (responseMessage != null && !((UpnpResponse)responseMessage.getOperation()).isFailed() && this.subscription.getCurrentSequence().getValue() == 0L) {
            this.logger.trace("Establishing subscription");
            this.subscription.registerOnService();
            this.subscription.establish();
            this.logger.trace("Response to subscription sent successfully, now sending initial event asynchronously");
            this.getUpnpService().getConfiguration().getAsyncProtocolExecutor().execute(this.getUpnpService().getProtocolFactory().createSendingEvent(this.subscription));
            return;
        }
        if (this.subscription.getCurrentSequence().getValue() == 0L) {
            this.logger.trace("Subscription request's response aborted, not sending initial event");
            if (responseMessage == null) {
                this.logger.trace("Reason: No response at all from subscriber");
            } else {
                void var1_1;
                this.logger.trace("Reason: {}", var1_1.getOperation());
            }
            this.logger.trace("Removing subscription from registry: {}", (Object)this.subscription);
            this.getUpnpService().getRegistry().removeLocalSubscription(this.subscription);
        }
    }

    @Override
    public void responseException(Throwable t) {
        if (this.subscription == null) {
            return;
        }
        this.logger.trace("Response could not be send to subscriber, removing local GENA subscription: {}", (Object)this.subscription);
        this.getUpnpService().getRegistry().removeLocalSubscription(this.subscription);
    }
}

