/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.protocol.sync;

import org.jupnp.UpnpService;
import org.jupnp.model.UnsupportedDataException;
import org.jupnp.model.action.ActionCancelledException;
import org.jupnp.model.action.ActionException;
import org.jupnp.model.action.ActionInvocation;
import org.jupnp.model.action.RemoteActionInvocation;
import org.jupnp.model.message.StreamRequestMessage;
import org.jupnp.model.message.StreamResponseMessage;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.model.message.control.IncomingActionRequestMessage;
import org.jupnp.model.message.control.OutgoingActionResponseMessage;
import org.jupnp.model.message.header.ContentTypeHeader;
import org.jupnp.model.message.header.UpnpHeader;
import org.jupnp.model.meta.LocalService;
import org.jupnp.model.resource.ServiceControlResource;
import org.jupnp.model.types.ErrorCode;
import org.jupnp.protocol.ReceivingSync;
import org.jupnp.transport.RouterException;
import org.jupnp.util.Exceptions;
import org.jupnp.util.SpecificationViolationReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceivingAction
extends ReceivingSync<StreamRequestMessage, StreamResponseMessage> {
    private final Logger logger = LoggerFactory.getLogger(ReceivingAction.class);

    /*
     * WARNING - void declaration
     */
    public ReceivingAction(UpnpService upnpService, StreamRequestMessage inputMessage) {
        super((UpnpService)var1_1, var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected StreamResponseMessage executeSync() throws RouterException {
        OutgoingActionResponseMessage responseMessage;
        block10: {
            RemoteActionInvocation invocation;
            block11: {
                ServiceControlResource resource;
                ContentTypeHeader contentTypeHeader = ((StreamRequestMessage)this.getInputMessage()).getHeaders().getFirstHeader(UpnpHeader.Type.CONTENT_TYPE, ContentTypeHeader.class);
                if (contentTypeHeader != null && !contentTypeHeader.isUDACompliantXML()) {
                    SpecificationViolationReporter.report("Received invalid Content-Type '{}': {}", contentTypeHeader, this.getInputMessage());
                    return new StreamResponseMessage(new UpnpResponse(UpnpResponse.Status.UNSUPPORTED_MEDIA_TYPE));
                }
                if (contentTypeHeader == null) {
                    SpecificationViolationReporter.report("Received without Content-Type: {}", this.getInputMessage());
                }
                if ((resource = this.getUpnpService().getRegistry().getResource(ServiceControlResource.class, ((StreamRequestMessage)this.getInputMessage()).getUri())) == null) {
                    this.logger.trace("No local resource found: {}", this.getInputMessage());
                    return null;
                }
                this.logger.trace("Found local action resource matching relative request URI: {}", (Object)((StreamRequestMessage)this.getInputMessage()).getUri());
                IncomingActionRequestMessage requestMessage = new IncomingActionRequestMessage((StreamRequestMessage)this.getInputMessage(), (LocalService)resource.getModel());
                this.logger.trace("Created incoming action request message: {}", (Object)requestMessage);
                invocation = new RemoteActionInvocation(requestMessage.getAction(), this.getRemoteClientInfo());
                this.logger.trace("Reading body of request message");
                this.getUpnpService().getConfiguration().getSoapActionProcessor().readBody(requestMessage, (ActionInvocation)invocation);
                this.logger.trace("Executing on local service: {}", (Object)invocation);
                ((LocalService)resource.getModel()).getExecutor(invocation.getAction()).execute(invocation);
                if (invocation.getFailure() == null) {
                    responseMessage = new OutgoingActionResponseMessage(invocation.getAction());
                    break block10;
                }
                if (!(invocation.getFailure() instanceof ActionCancelledException)) break block11;
                this.logger.trace("Action execution was cancelled, returning 404 to client");
                return null;
            }
            try {
                responseMessage = new OutgoingActionResponseMessage(UpnpResponse.Status.INTERNAL_SERVER_ERROR, invocation.getAction());
            }
            catch (ActionException e) {
                this.logger.trace("Error executing local action", (Throwable)e);
                invocation = new RemoteActionInvocation(e, this.getRemoteClientInfo());
                responseMessage = new OutgoingActionResponseMessage(UpnpResponse.Status.INTERNAL_SERVER_ERROR);
            }
            catch (UnsupportedDataException e) {
                this.logger.warn("Error reading action request XML body", (Throwable)e);
                invocation = new RemoteActionInvocation(Exceptions.unwrap(e) instanceof ActionException ? (ActionException)Exceptions.unwrap(e) : new ActionException(ErrorCode.ACTION_FAILED, e.getMessage()), this.getRemoteClientInfo());
                responseMessage = new OutgoingActionResponseMessage(UpnpResponse.Status.INTERNAL_SERVER_ERROR);
            }
        }
        try {
            void var1_1;
            void var2_6;
            this.logger.trace("Writing body of response message");
            this.getUpnpService().getConfiguration().getSoapActionProcessor().writeBody(responseMessage, (ActionInvocation)var2_6);
            this.logger.trace("Returning finished response message: {}", (Object)responseMessage);
            return var1_1;
        }
        catch (UnsupportedDataException e) {
            void var3_5;
            this.logger.warn("Failure writing body of response message, sending '500 Internal Server Error' without body", (Throwable)var3_5);
            return new StreamResponseMessage(UpnpResponse.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

