/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.protocol.async;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jupnp.UpnpService;
import org.jupnp.model.Location;
import org.jupnp.model.NetworkAddress;
import org.jupnp.model.message.OutgoingDatagramMessage;
import org.jupnp.model.message.discovery.OutgoingNotificationRequest;
import org.jupnp.model.message.discovery.OutgoingNotificationRequestDeviceType;
import org.jupnp.model.message.discovery.OutgoingNotificationRequestRootDevice;
import org.jupnp.model.message.discovery.OutgoingNotificationRequestServiceType;
import org.jupnp.model.message.discovery.OutgoingNotificationRequestUDN;
import org.jupnp.model.meta.LocalDevice;
import org.jupnp.model.types.NotificationSubtype;
import org.jupnp.model.types.ServiceType;
import org.jupnp.protocol.SendingAsync;
import org.jupnp.transport.RouterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SendingNotification
extends SendingAsync {
    private final Logger logger = LoggerFactory.getLogger(SendingNotification.class);
    private LocalDevice device;

    /*
     * WARNING - void declaration
     */
    protected SendingNotification(UpnpService upnpService, LocalDevice device) {
        super((UpnpService)var1_1);
        void var2_2;
        void var1_1;
        this.device = var2_2;
    }

    public LocalDevice getDevice() {
        return this.device;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void execute() throws RouterException {
        List<NetworkAddress> activeStreamServers = this.getUpnpService().getRouter().getActiveStreamServers(null);
        if (activeStreamServers.isEmpty()) {
            this.logger.trace("Aborting notifications, no active stream servers found (network disabled?)");
            return;
        }
        ArrayList<Location> descriptorLocations = new ArrayList<Location>();
        for (NetworkAddress activeStreamServer : activeStreamServers) {
            descriptorLocations.add(new Location(activeStreamServer, this.getUpnpService().getConfiguration().getNamespace().getDescriptorPathString(this.getDevice())));
        }
        int i = 0;
        while (i < this.getBulkRepeat()) {
            try {
                for (Location descriptorLocation : descriptorLocations) {
                    this.sendMessages(descriptorLocation);
                }
                this.logger.trace("Sleeping {} milliseconds", (Object)this.getBulkIntervalMilliseconds());
                Thread.sleep(this.getBulkIntervalMilliseconds());
            }
            catch (InterruptedException e) {
                void var3_5;
                this.logger.warn("Advertisement thread was interrupted", (Throwable)var3_5);
            }
            ++i;
        }
    }

    protected int getBulkRepeat() {
        return 3;
    }

    protected int getBulkIntervalMilliseconds() {
        return 150;
    }

    /*
     * WARNING - void declaration
     */
    public void sendMessages(Location descriptorLocation) throws RouterException {
        void var1_1;
        OutgoingNotificationRequest upnpMessage;
        this.logger.trace("Sending root device messages: {}", (Object)this.getDevice());
        SendingNotification sendingNotification = this;
        List<OutgoingNotificationRequest> list = sendingNotification.createDeviceMessages(sendingNotification.getDevice(), descriptorLocation);
        Iterator<OutgoingNotificationRequest> iterator = list.iterator();
        while (iterator.hasNext()) {
            upnpMessage = iterator.next();
            this.getUpnpService().getRouter().send(upnpMessage);
        }
        if (this.getDevice().hasEmbeddedDevices()) {
            LocalDevice[] localDeviceArray = (LocalDevice[])this.getDevice().findEmbeddedDevices();
            int n = localDeviceArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object embeddedDevice = localDeviceArray[n2];
                this.logger.trace("Sending embedded device messages: {}", embeddedDevice);
                embeddedDevice = this.createDeviceMessages((LocalDevice)embeddedDevice, descriptorLocation);
                Iterator<OutgoingNotificationRequest> iterator2 = embeddedDevice.iterator();
                while (iterator2.hasNext()) {
                    upnpMessage = iterator2.next();
                    this.getUpnpService().getRouter().send(upnpMessage);
                }
                ++n2;
            }
        }
        SendingNotification sendingNotification2 = this;
        List<OutgoingNotificationRequest> serviceTypeMsgs = sendingNotification2.createServiceTypeMessages(sendingNotification2.getDevice(), (Location)var1_1);
        if (!serviceTypeMsgs.isEmpty()) {
            this.logger.trace("Sending service type messages");
            for (OutgoingNotificationRequest upnpMessage2 : list) {
                this.getUpnpService().getRouter().send((OutgoingDatagramMessage)((Object)iterator));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected List<OutgoingNotificationRequest> createDeviceMessages(LocalDevice device, Location descriptorLocation) {
        void var3_3;
        void var1_1;
        void var2_2;
        ArrayList<OutgoingNotificationRequest> msgs = new ArrayList<OutgoingNotificationRequest>();
        if (device.isRoot()) {
            msgs.add(new OutgoingNotificationRequestRootDevice(descriptorLocation, device, this.getNotificationSubtype()));
        }
        msgs.add(new OutgoingNotificationRequestUDN(descriptorLocation, device, this.getNotificationSubtype()));
        msgs.add(new OutgoingNotificationRequestDeviceType((Location)var2_2, (LocalDevice)var1_1, this.getNotificationSubtype()));
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    protected List<OutgoingNotificationRequest> createServiceTypeMessages(LocalDevice device, Location descriptorLocation) {
        void var3_3;
        ArrayList<OutgoingNotificationRequestServiceType> msgs = new ArrayList<OutgoingNotificationRequestServiceType>();
        ServiceType[] serviceTypeArray = device.findServiceTypes();
        int n = serviceTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceType serviceType = serviceTypeArray[n2];
            msgs.add(new OutgoingNotificationRequestServiceType(descriptorLocation, device, this.getNotificationSubtype(), serviceType));
            ++n2;
        }
        return var3_3;
    }

    protected abstract NotificationSubtype getNotificationSubtype();
}

