/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.protocol.async;

import org.jupnp.UpnpService;
import org.jupnp.model.ValidationException;
import org.jupnp.model.message.IncomingDatagramMessage;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.model.message.discovery.IncomingSearchResponse;
import org.jupnp.model.meta.RemoteDevice;
import org.jupnp.model.meta.RemoteDeviceIdentity;
import org.jupnp.protocol.ReceivingAsync;
import org.jupnp.protocol.RetrieveRemoteDescriptors;
import org.jupnp.transport.RouterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceivingSearchResponse
extends ReceivingAsync<IncomingSearchResponse> {
    private final Logger logger = LoggerFactory.getLogger(ReceivingSearchResponse.class);

    /*
     * WARNING - void declaration
     */
    public ReceivingSearchResponse(UpnpService upnpService, IncomingDatagramMessage<UpnpResponse> inputMessage) {
        super((UpnpService)var1_1, new IncomingSearchResponse((IncomingDatagramMessage<UpnpResponse>)var2_2));
        void var2_2;
        void var1_1;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void execute() throws RouterException {
        block10: {
            if (!((IncomingSearchResponse)this.getInputMessage()).isSearchResponseMessage()) {
                this.logger.trace("Ignoring invalid search response message: {}", this.getInputMessage());
                return;
            }
            udn = ((IncomingSearchResponse)this.getInputMessage()).getRootDeviceUDN();
            if (udn == null) {
                this.logger.trace("Ignoring search response message without UDN: {}", this.getInputMessage());
                return;
            }
            rdIdentity = new RemoteDeviceIdentity((IncomingSearchResponse)this.getInputMessage());
            this.logger.trace("Received device search response: {}", (Object)rdIdentity);
            if (this.getUpnpService().getRegistry().update(rdIdentity)) {
                this.logger.trace("Remote device was already known: {}", (Object)udn);
                return;
            }
            try {
                rd = new RemoteDevice(rdIdentity);
                break block10;
            }
            catch (ValidationException e) {
                this.logger.warn("Validation errors of device during discovery: {}", (Object)rdIdentity);
                ** for (validationError : e.getErrors())
            }
lbl-1000:
            // 1 sources

            {
                this.logger.warn(validationError.toString());
                continue;
            }
lbl21:
            // 1 sources

            return;
        }
        if (validationError.getDescriptorURL() == null) {
            this.logger.trace("Ignoring message without location URL header: {}", this.getInputMessage());
            return;
        }
        if (validationError.getMaxAgeSeconds() == null) {
            this.logger.trace("Ignoring message without max-age header: {}", this.getInputMessage());
            return;
        }
        if (RetrieveRemoteDescriptors.isRetrievalInProgress(rd)) {
            this.logger.trace("Skip submitting task, active retrieval for URL already in progress: {}", (Object)((RemoteDeviceIdentity)rd.getIdentity()).getDescriptorURL());
            return;
        }
        conf = this.getUpnpService().getConfiguration();
        if (conf != null && (executor = var3_4.getAsyncProtocolExecutor()) != null) {
            var2_2.execute(new RetrieveRemoteDescriptors(this.getUpnpService(), (RemoteDevice)var1_1));
        }
    }
}

