/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.protocol.async;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.jupnp.UpnpService;
import org.jupnp.model.DiscoveryOptions;
import org.jupnp.model.Location;
import org.jupnp.model.NetworkAddress;
import org.jupnp.model.message.IncomingDatagramMessage;
import org.jupnp.model.message.OutgoingDatagramMessage;
import org.jupnp.model.message.UpnpRequest;
import org.jupnp.model.message.discovery.IncomingSearchRequest;
import org.jupnp.model.message.discovery.OutgoingSearchResponse;
import org.jupnp.model.message.discovery.OutgoingSearchResponseDeviceType;
import org.jupnp.model.message.discovery.OutgoingSearchResponseRootDevice;
import org.jupnp.model.message.discovery.OutgoingSearchResponseServiceType;
import org.jupnp.model.message.discovery.OutgoingSearchResponseUDN;
import org.jupnp.model.message.header.DeviceTypeHeader;
import org.jupnp.model.message.header.MXHeader;
import org.jupnp.model.message.header.RootDeviceHeader;
import org.jupnp.model.message.header.STAllHeader;
import org.jupnp.model.message.header.ServiceTypeHeader;
import org.jupnp.model.message.header.UDNHeader;
import org.jupnp.model.message.header.UpnpHeader;
import org.jupnp.model.meta.Device;
import org.jupnp.model.meta.DeviceIdentity;
import org.jupnp.model.meta.LocalDevice;
import org.jupnp.model.types.DeviceType;
import org.jupnp.model.types.ServiceType;
import org.jupnp.model.types.UDN;
import org.jupnp.protocol.ReceivingAsync;
import org.jupnp.transport.RouterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceivingSearch
extends ReceivingAsync<IncomingSearchRequest> {
    private final Logger logger = LoggerFactory.getLogger(ReceivingSearch.class);
    private final boolean LOG_ENABLED = this.logger.isTraceEnabled();
    protected final Random randomGenerator = new Random();

    /*
     * WARNING - void declaration
     */
    public ReceivingSearch(UpnpService upnpService, IncomingDatagramMessage<UpnpRequest> inputMessage) {
        super((UpnpService)var1_1, new IncomingSearchRequest((IncomingDatagramMessage<UpnpRequest>)var2_2));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void execute() throws RouterException {
        if (this.getUpnpService().getRouter() == null) {
            this.logger.trace("Router hasn't completed initialization, ignoring received search message");
            return;
        }
        if (!((IncomingSearchRequest)this.getInputMessage()).isMANSSDPDiscover()) {
            this.logger.trace("Invalid search request, no or invalid MAN ssdp:discover header: {}", this.getInputMessage());
            return;
        }
        UpnpHeader searchTarget = ((IncomingSearchRequest)this.getInputMessage()).getSearchTarget();
        if (searchTarget == null) {
            this.logger.trace("Invalid search request, did not contain ST header: {}", this.getInputMessage());
            return;
        }
        List<NetworkAddress> activeStreamServers = this.getUpnpService().getRouter().getActiveStreamServers(((IncomingSearchRequest)this.getInputMessage()).getLocalAddress());
        if (activeStreamServers.isEmpty()) {
            this.logger.trace("Aborting search response, no active stream servers found (network disabled?)");
            return;
        }
        for (NetworkAddress activeStreamServer : activeStreamServers) {
            void var2_2;
            this.sendResponses(searchTarget, (NetworkAddress)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean waitBeforeExecution() throws InterruptedException {
        Integer mx = ((IncomingSearchRequest)this.getInputMessage()).getMX();
        if (mx == null) {
            this.logger.trace("Invalid search request, did not contain MX header: {}", this.getInputMessage());
            return false;
        }
        if (mx > 120 || mx <= 0) {
            mx = MXHeader.DEFAULT_VALUE;
        }
        if (!this.getUpnpService().getRegistry().getLocalDevices().isEmpty()) {
            void var1_2;
            int sleepTime = this.randomGenerator.nextInt(mx * 1000);
            this.logger.trace("Sleeping {} milliseconds to avoid flooding with search responses", (Object)sleepTime);
            Thread.sleep((long)var1_2);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected void sendResponses(UpnpHeader searchTarget, NetworkAddress activeStreamServer) throws RouterException {
        void var1_1;
        if (searchTarget instanceof STAllHeader) {
            this.sendSearchResponseAll(activeStreamServer);
            return;
        }
        if (searchTarget instanceof RootDeviceHeader) {
            this.sendSearchResponseRootDevices(activeStreamServer);
            return;
        }
        if (searchTarget instanceof UDNHeader) {
            this.sendSearchResponseUDN((UDN)searchTarget.getValue(), activeStreamServer);
            return;
        }
        if (searchTarget instanceof DeviceTypeHeader) {
            this.sendSearchResponseDeviceType((DeviceType)searchTarget.getValue(), activeStreamServer);
            return;
        }
        if (searchTarget instanceof ServiceTypeHeader) {
            void var2_2;
            this.sendSearchResponseServiceType((ServiceType)searchTarget.getValue(), (NetworkAddress)var2_2);
            return;
        }
        this.logger.warn("Non-implemented search request target: {}", var1_1.getClass());
    }

    /*
     * WARNING - void declaration
     */
    protected void sendSearchResponseAll(NetworkAddress activeStreamServer) throws RouterException {
        if (this.LOG_ENABLED) {
            this.logger.trace("Responding to 'all' search with advertisement messages for all local devices");
        }
        for (LocalDevice localDevice : this.getUpnpService().getRegistry().getLocalDevices()) {
            void var2_3;
            List<OutgoingSearchResponse> serviceTypeMsgs;
            if (this.isAdvertisementDisabled(localDevice)) continue;
            if (this.LOG_ENABLED) {
                this.logger.trace("Sending root device messages: {}", (Object)localDevice);
            }
            List<OutgoingSearchResponse> list = this.createDeviceMessages(localDevice, activeStreamServer);
            for (OutgoingSearchResponse upnpMessage : list) {
                this.getUpnpService().getRouter().send(upnpMessage);
            }
            if (localDevice.hasEmbeddedDevices()) {
                LocalDevice[] localDeviceArray = (LocalDevice[])localDevice.findEmbeddedDevices();
                int n = localDeviceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object embeddedDevice = localDeviceArray[n2];
                    if (this.LOG_ENABLED) {
                        this.logger.trace("Sending embedded device messages: {}", embeddedDevice);
                    }
                    embeddedDevice = this.createDeviceMessages((LocalDevice)embeddedDevice, activeStreamServer);
                    Iterator<OutgoingSearchResponse> iterator = embeddedDevice.iterator();
                    while (iterator.hasNext()) {
                        OutgoingSearchResponse upnpMessage;
                        upnpMessage = iterator.next();
                        this.getUpnpService().getRouter().send(upnpMessage);
                    }
                    ++n2;
                }
            }
            if ((serviceTypeMsgs = this.createServiceTypeMessages((LocalDevice)var2_3, activeStreamServer)).isEmpty()) continue;
            if (this.LOG_ENABLED) {
                this.logger.trace("Sending service type messages");
            }
            for (OutgoingSearchResponse upnpMessage : serviceTypeMsgs) {
                this.getUpnpService().getRouter().send(upnpMessage);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected List<OutgoingSearchResponse> createDeviceMessages(LocalDevice device, NetworkAddress activeStreamServer) {
        void var3_3;
        Iterator iterator;
        ArrayList<OutgoingSearchResponse> msgs = new ArrayList<OutgoingSearchResponse>();
        if (device.isRoot()) {
            msgs.add(new OutgoingSearchResponseRootDevice((IncomingDatagramMessage)this.getInputMessage(), this.getDescriptorLocation(activeStreamServer, device), device));
        }
        msgs.add(new OutgoingSearchResponseUDN((IncomingDatagramMessage)this.getInputMessage(), this.getDescriptorLocation(activeStreamServer, device), device));
        msgs.add(new OutgoingSearchResponseDeviceType((IncomingDatagramMessage)this.getInputMessage(), this.getDescriptorLocation((NetworkAddress)((Object)iterator), device), device));
        for (OutgoingSearchResponse msg : msgs) {
            void var1_1;
            this.prepareOutgoingSearchResponse((OutgoingSearchResponse)var1_1);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    protected List<OutgoingSearchResponse> createServiceTypeMessages(LocalDevice device, NetworkAddress activeStreamServer) {
        void var3_3;
        ArrayList<OutgoingSearchResponseServiceType> msgs = new ArrayList<OutgoingSearchResponseServiceType>();
        ServiceType[] serviceTypeArray = device.findServiceTypes();
        int n = serviceTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceType serviceType = serviceTypeArray[n2];
            OutgoingSearchResponseServiceType message = new OutgoingSearchResponseServiceType((IncomingDatagramMessage)this.getInputMessage(), this.getDescriptorLocation(activeStreamServer, device), device, serviceType);
            this.prepareOutgoingSearchResponse(message);
            msgs.add(message);
            ++n2;
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    protected void sendSearchResponseRootDevices(NetworkAddress activeStreamServer) throws RouterException {
        this.logger.trace("Responding to root device search with advertisement messages for all local root devices");
        for (LocalDevice device : this.getUpnpService().getRegistry().getLocalDevices()) {
            void var2_3;
            if (this.isAdvertisementDisabled(device)) continue;
            OutgoingSearchResponseRootDevice message = new OutgoingSearchResponseRootDevice((IncomingDatagramMessage)this.getInputMessage(), this.getDescriptorLocation(activeStreamServer, device), device);
            this.prepareOutgoingSearchResponse(message);
            this.getUpnpService().getRouter().send((OutgoingDatagramMessage)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void sendSearchResponseUDN(UDN udn, NetworkAddress activeStreamServer) throws RouterException {
        Device device = this.getUpnpService().getRegistry().getDevice(udn, false);
        if (device != null && device instanceof LocalDevice) {
            void var1_1;
            void var3_3;
            void var2_2;
            if (this.isAdvertisementDisabled((LocalDevice)device)) {
                return;
            }
            this.logger.trace("Responding to UDN device search: {}", (Object)udn);
            OutgoingSearchResponseUDN message = new OutgoingSearchResponseUDN((IncomingDatagramMessage)this.getInputMessage(), this.getDescriptorLocation((NetworkAddress)var2_2, (LocalDevice)device), (LocalDevice)var3_3);
            this.prepareOutgoingSearchResponse(message);
            this.getUpnpService().getRouter().send((OutgoingDatagramMessage)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void sendSearchResponseDeviceType(DeviceType deviceType, NetworkAddress activeStreamServer) throws RouterException {
        this.logger.trace("Responding to device type search: {}", deviceType);
        deviceType = this.getUpnpService().getRegistry().getDevices((DeviceType)deviceType);
        Iterator<Device> iterator = deviceType.iterator();
        while (iterator.hasNext()) {
            void var1_1;
            Device device = iterator.next();
            if (!(device instanceof LocalDevice) || this.isAdvertisementDisabled((LocalDevice)device)) continue;
            this.logger.trace("Sending matching device type search result for: {}", (Object)device);
            OutgoingSearchResponseDeviceType message = new OutgoingSearchResponseDeviceType((IncomingDatagramMessage)this.getInputMessage(), this.getDescriptorLocation(activeStreamServer, (LocalDevice)device), (LocalDevice)device);
            this.prepareOutgoingSearchResponse(message);
            this.getUpnpService().getRouter().send((OutgoingDatagramMessage)var1_1);
        }
    }

    protected void sendSearchResponseServiceType(ServiceType serviceType, NetworkAddress activeStreamServer) throws RouterException {
        this.logger.trace("Responding to service type search: {}", (Object)serviceType);
        Collection<Device> collection = this.getUpnpService().getRegistry().getDevices(serviceType);
        for (Device device : collection) {
            if (!(device instanceof LocalDevice) || this.isAdvertisementDisabled((LocalDevice)device)) continue;
            this.logger.trace("Sending matching service type search result: {}", (Object)device);
            OutgoingSearchResponseServiceType message = new OutgoingSearchResponseServiceType((IncomingDatagramMessage)this.getInputMessage(), this.getDescriptorLocation(activeStreamServer, (LocalDevice)device), (LocalDevice)device, serviceType);
            this.prepareOutgoingSearchResponse(message);
            this.getUpnpService().getRouter().send((OutgoingDatagramMessage)((Object)collection));
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Location getDescriptorLocation(NetworkAddress activeStreamServer, LocalDevice device) {
        void var2_2;
        void var1_1;
        return new Location((NetworkAddress)var1_1, this.getUpnpService().getConfiguration().getNamespace().getDescriptorPathString((Device)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isAdvertisementDisabled(LocalDevice device) {
        void var1_1;
        DiscoveryOptions options = this.getUpnpService().getRegistry().getDiscoveryOptions(((DeviceIdentity)device.getIdentity()).getUdn());
        return options != null && !var1_1.isAdvertised();
    }

    protected void prepareOutgoingSearchResponse(OutgoingSearchResponse message) {
    }
}

