/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.protocol.async;

import org.jupnp.UpnpService;
import org.jupnp.model.ValidationException;
import org.jupnp.model.message.IncomingDatagramMessage;
import org.jupnp.model.message.UpnpRequest;
import org.jupnp.model.message.discovery.IncomingNotificationRequest;
import org.jupnp.model.meta.RemoteDevice;
import org.jupnp.model.meta.RemoteDeviceIdentity;
import org.jupnp.protocol.ReceivingAsync;
import org.jupnp.protocol.RetrieveRemoteDescriptors;
import org.jupnp.transport.RouterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceivingNotification
extends ReceivingAsync<IncomingNotificationRequest> {
    private final Logger logger = LoggerFactory.getLogger(ReceivingNotification.class);

    /*
     * WARNING - void declaration
     */
    public ReceivingNotification(UpnpService upnpService, IncomingDatagramMessage<UpnpRequest> inputMessage) {
        super((UpnpService)var1_1, new IncomingNotificationRequest((IncomingDatagramMessage<UpnpRequest>)var2_2));
        void var2_2;
        void var1_1;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void execute() throws RouterException {
        block11: {
            udn = ((IncomingNotificationRequest)this.getInputMessage()).getUDN();
            if (udn == null) {
                this.logger.trace("Ignoring notification message without UDN: {}", this.getInputMessage());
                return;
            }
            rdIdentity = new RemoteDeviceIdentity((IncomingNotificationRequest)this.getInputMessage());
            this.logger.trace("Received device notification: {}", (Object)rdIdentity);
            try {
                rd = new RemoteDevice(rdIdentity);
                break block11;
            }
            catch (ValidationException e) {
                this.logger.warn("Validation errors of device during discovery: {}", (Object)rdIdentity);
                ** for (validationError : e.getErrors())
            }
lbl-1000:
            // 1 sources

            {
                this.logger.warn(var1_3.toString());
                continue;
            }
lbl15:
            // 1 sources

            return;
        }
        if (((IncomingNotificationRequest)this.getInputMessage()).isAliveMessage()) {
            this.logger.trace("Received device ALIVE advertisement, descriptor location is: {}", (Object)rdIdentity.getDescriptorURL());
            if (rdIdentity.getDescriptorURL() == null) {
                this.logger.trace("Ignoring message without location URL header: {}", this.getInputMessage());
                return;
            }
            if (rdIdentity.getMaxAgeSeconds() == null) {
                this.logger.trace("Ignoring message without max-age header: {}", this.getInputMessage());
                return;
            }
            if (this.getUpnpService().getRegistry().update((RemoteDeviceIdentity)var2_5)) {
                this.logger.trace("Remote device was already known: {}", (Object)var1_1);
                return;
            }
            this.getUpnpService().getConfiguration().getAsyncProtocolExecutor().execute(new RetrieveRemoteDescriptors(this.getUpnpService(), rd));
            return;
        }
        if (((IncomingNotificationRequest)this.getInputMessage()).isByeByeMessage()) {
            this.logger.trace("Received device BYEBYE advertisement");
            var1_4 = this.getUpnpService().getRegistry().removeDevice(rd);
            if (var1_4) {
                this.logger.trace("Removed remote device from registry: {}", (Object)var3_6);
                return;
            }
        } else {
            this.logger.trace("Ignoring unknown notification message: {}", this.getInputMessage());
        }
    }
}

