/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.protocol;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.jupnp.UpnpService;
import org.jupnp.binding.xml.DescriptorBindingException;
import org.jupnp.binding.xml.ServiceDescriptorBinder;
import org.jupnp.model.ValidationException;
import org.jupnp.model.message.StreamRequestMessage;
import org.jupnp.model.message.StreamResponseMessage;
import org.jupnp.model.message.UpnpHeaders;
import org.jupnp.model.message.UpnpRequest;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.model.meta.Icon;
import org.jupnp.model.meta.RemoteDevice;
import org.jupnp.model.meta.RemoteDeviceIdentity;
import org.jupnp.model.meta.RemoteService;
import org.jupnp.model.types.ServiceType;
import org.jupnp.model.types.UDN;
import org.jupnp.registry.RegistrationException;
import org.jupnp.transport.RouterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetrieveRemoteDescriptors
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(RetrieveRemoteDescriptors.class);
    private final UpnpService upnpService;
    private RemoteDevice rd;
    private static final ConcurrentHashMap<URL, Boolean> activeRetrievals = new ConcurrentHashMap();
    protected List<UDN> errorsAlreadyLogged = new ArrayList<UDN>();

    /*
     * WARNING - void declaration
     */
    public RetrieveRemoteDescriptors(UpnpService upnpService, RemoteDevice rd) {
        void var2_2;
        void var1_1;
        this.upnpService = var1_1;
        this.rd = var2_2;
    }

    public UpnpService getUpnpService() {
        return this.upnpService;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        void var1_1;
        URL deviceURL = ((RemoteDeviceIdentity)this.rd.getIdentity()).getDescriptorURL();
        if (this.getUpnpService().getRegistry().getRemoteDevice(((RemoteDeviceIdentity)this.rd.getIdentity()).getUdn(), true) != null) {
            this.logger.trace("Exiting early, already discovered: {}", (Object)deviceURL);
            return;
        }
        if (activeRetrievals.putIfAbsent(deviceURL, Boolean.TRUE) != null) {
            this.logger.trace("Exiting early, active retrieval for URL already in progress: {}", (Object)deviceURL);
            return;
        }
        try {
            try {
                this.describe();
            }
            catch (RouterException e) {
                void var2_2;
                this.logger.warn("Descriptor retrieval failed: {}", (Object)deviceURL, (Object)var2_2);
                activeRetrievals.remove(deviceURL);
                return;
            }
        }
        catch (Throwable throwable) {
            activeRetrievals.remove(deviceURL);
            throw throwable;
        }
        activeRetrievals.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void describe() throws RouterException {
        void var2_2;
        void var1_1;
        String descriptorContent;
        StreamResponseMessage deviceDescMsg;
        if (this.getUpnpService().getRouter() == null) {
            this.logger.warn("Router not yet initialized");
            return;
        }
        try {
            StreamRequestMessage deviceDescRetrievalMsg = new StreamRequestMessage(UpnpRequest.Method.GET, ((RemoteDeviceIdentity)this.rd.getIdentity()).getDescriptorURL());
            UpnpHeaders headers = this.getUpnpService().getConfiguration().getDescriptorRetrievalHeaders((RemoteDeviceIdentity)this.rd.getIdentity());
            if (headers != null) {
                deviceDescRetrievalMsg.getHeaders().putAll(headers);
            }
            this.logger.debug("Sending device descriptor retrieval message: {}", (Object)deviceDescRetrievalMsg);
            deviceDescMsg = this.getUpnpService().getRouter().send(deviceDescRetrievalMsg);
        }
        catch (IllegalArgumentException e) {
            this.logger.warn("Device descriptor retrieval failed: {}, possibly invalid URL", (Object)((RemoteDeviceIdentity)this.rd.getIdentity()).getDescriptorURL(), (Object)e);
            return;
        }
        if (deviceDescMsg == null) {
            this.logger.warn("Device descriptor retrieval failed, no response: {}", (Object)((RemoteDeviceIdentity)this.rd.getIdentity()).getDescriptorURL());
            return;
        }
        if (((UpnpResponse)deviceDescMsg.getOperation()).isFailed()) {
            this.logger.warn("Device descriptor retrieval failed: {}, {}", (Object)((RemoteDeviceIdentity)this.rd.getIdentity()).getDescriptorURL(), (Object)((UpnpResponse)deviceDescMsg.getOperation()).getResponseDetails());
            return;
        }
        if (!deviceDescMsg.isContentTypeTextUDA()) {
            this.logger.debug("Received device descriptor without or with invalid Content-Type: {}", (Object)((RemoteDeviceIdentity)this.rd.getIdentity()).getDescriptorURL());
        }
        if ((descriptorContent = deviceDescMsg.getBodyString()) == null || descriptorContent.isEmpty()) {
            this.logger.warn("Received empty device descriptor: {}", (Object)((RemoteDeviceIdentity)this.rd.getIdentity()).getDescriptorURL());
            return;
        }
        this.logger.debug("Received root device descriptor: {}", (Object)var1_1);
        this.describe((String)var2_2);
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void describe(String descriptorXML) throws RouterException {
        notifiedStart = false;
        describedDevice = null;
        try {
            var4_4 = this.getUpnpService().getConfiguration().getDeviceDescriptorBinderUDA10();
            describedDevice = var4_4.describe(this.rd, descriptorXML);
            this.logger.debug("Remote device described (without services) notifying listeners: {}", (Object)describedDevice);
            notifiedStart = this.getUpnpService().getRegistry().notifyDiscoveryStart(describedDevice);
            this.logger.debug("Hydrating described device's services: {}", (Object)describedDevice);
            hydratedDevice = this.describeServices(describedDevice);
            if (hydratedDevice == null) {
                if (!this.errorsAlreadyLogged.contains(((RemoteDeviceIdentity)this.rd.getIdentity()).getUdn())) {
                    this.errorsAlreadyLogged.add(((RemoteDeviceIdentity)this.rd.getIdentity()).getUdn());
                    this.logger.warn("Device service description failed: {}", (Object)this.rd);
                }
                if (!notifiedStart) return;
                this.getUpnpService().getRegistry().notifyDiscoveryFailure(describedDevice, new DescriptorBindingException("Device service description failed: " + String.valueOf(this.rd)));
                this.logger.debug("Adding described remote device to registry: {}", (Object)describedDevice);
                this.getUpnpService().getRegistry().addDevice(describedDevice);
                return;
            }
            this.logger.debug("Adding fully hydrated remote device to registry: {}", (Object)hydratedDevice);
            this.getUpnpService().getRegistry().addDevice(hydratedDevice);
            return;
        }
        catch (ValidationException e) {
            if (this.errorsAlreadyLogged.contains(((RemoteDeviceIdentity)this.rd.getIdentity()).getUdn())) return;
            this.errorsAlreadyLogged.add(((RemoteDeviceIdentity)this.rd.getIdentity()).getUdn());
            this.logger.warn("Could not validate device model: {}", (Object)this.rd);
            ** for (validationError : e.getErrors())
        }
lbl-1000:
        // 1 sources

        {
            this.logger.warn(var1_1.toString());
            continue;
        }
lbl31:
        // 1 sources

        if (describedDevice == null || !notifiedStart) return;
        this.getUpnpService().getRegistry().notifyDiscoveryFailure(describedDevice, e);
        return;
        catch (DescriptorBindingException e) {
            this.logger.warn("Could not hydrate device or its services from descriptor: {}", (Object)this.rd, (Object)e);
            if (describedDevice == null || !notifiedStart) return;
            this.getUpnpService().getRegistry().notifyDiscoveryFailure(describedDevice, e);
            return;
        }
        catch (RegistrationException e) {
            this.logger.warn("Adding hydrated device to registry failed: {}", (Object)this.rd, (Object)e);
            if (describedDevice == null || var2_2 == false) return;
            this.getUpnpService().getRegistry().notifyDiscoveryFailure((RemoteDevice)var3_3, e);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected RemoteDevice describeServices(RemoteDevice currentDevice) throws RouterException, DescriptorBindingException, ValidationException {
        void var2_2;
        void var1_1;
        List<RemoteService> list;
        ArrayList<RemoteService> describedServices = new ArrayList<RemoteService>();
        if (currentDevice.hasServices()) {
            list = this.filterExclusiveServices(currentDevice.getServices());
            for (RemoteService service : list) {
                RemoteService svc = this.describeService(service);
                if (svc == null) continue;
                describedServices.add(svc);
            }
        }
        ArrayList<RemoteDevice> describedEmbeddedDevices = new ArrayList<RemoteDevice>();
        if (currentDevice.hasEmbeddedDevices()) {
            RemoteDevice[] remoteDeviceArray = currentDevice.getEmbeddedDevices();
            int svc = remoteDeviceArray.length;
            int n = 0;
            while (n < svc) {
                RemoteDevice describedEmbeddedDevice;
                RemoteDevice embeddedDevice = remoteDeviceArray[n];
                if (embeddedDevice != null && (describedEmbeddedDevice = this.describeServices(embeddedDevice)) != null) {
                    describedEmbeddedDevices.add(describedEmbeddedDevice);
                }
                ++n;
            }
        }
        if (currentDevice.hasServices() && describedServices.isEmpty() || currentDevice.hasEmbeddedDevices() && describedEmbeddedDevices.isEmpty()) {
            return null;
        }
        Icon[] iconDupes = new Icon[currentDevice.getIcons().length];
        int i = 0;
        while (i < currentDevice.getIcons().length) {
            Icon icon = currentDevice.getIcons()[i];
            iconDupes[i] = icon.deepCopy();
            ++i;
        }
        RemoteDevice remoteDevice = currentDevice;
        return remoteDevice.newInstance(((RemoteDeviceIdentity)remoteDevice.getIdentity()).getUdn(), currentDevice.getVersion(), currentDevice.getType(), currentDevice.getDetails(), iconDupes, var1_1.toServiceArray((Collection<RemoteService>)var2_2), list);
    }

    /*
     * WARNING - void declaration
     */
    protected RemoteService describeService(RemoteService service) throws RouterException, DescriptorBindingException, ValidationException {
        void var1_1;
        void var3_3;
        ServiceDescriptorBinder serviceDescriptorBinder;
        String descriptorContent;
        URL descriptorURL;
        try {
            descriptorURL = ((RemoteDevice)service.getDevice()).normalizeURI(service.getDescriptorURI());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.logger.warn("Could not normalize service descriptor URL: {}", (Object)service.getDescriptorURI());
            return null;
        }
        StreamRequestMessage serviceDescRetrievalMsg = new StreamRequestMessage(UpnpRequest.Method.GET, descriptorURL);
        UpnpHeaders headers = this.getUpnpService().getConfiguration().getDescriptorRetrievalHeaders((RemoteDeviceIdentity)((RemoteDevice)service.getDevice()).getIdentity());
        if (headers != null) {
            serviceDescRetrievalMsg.getHeaders().putAll(headers);
        }
        this.logger.debug("Sending service descriptor retrieval message: {}", (Object)serviceDescRetrievalMsg);
        StreamResponseMessage serviceDescMsg = this.getUpnpService().getRouter().send(serviceDescRetrievalMsg);
        if (serviceDescMsg == null) {
            this.logger.warn("Could not retrieve service descriptor, no response: {}", (Object)service);
            return null;
        }
        if (((UpnpResponse)serviceDescMsg.getOperation()).isFailed()) {
            this.logger.warn("Service descriptor retrieval failed: {}, {}", (Object)descriptorURL, (Object)((UpnpResponse)serviceDescMsg.getOperation()).getResponseDetails());
            return null;
        }
        if (!serviceDescMsg.isContentTypeTextUDA()) {
            this.logger.debug("Received service descriptor without or with invalid Content-Type: {}", (Object)descriptorURL);
        }
        if ((descriptorContent = serviceDescMsg.getBodyString()) == null || descriptorContent.isEmpty()) {
            this.logger.warn("Received empty service descriptor: {}", (Object)serviceDescriptorBinder);
            return null;
        }
        this.logger.debug("Received service descriptor, hydrating service model: {}", (Object)var3_3);
        serviceDescriptorBinder = this.getUpnpService().getConfiguration().getServiceDescriptorBinderUDA10();
        return (RemoteService)serviceDescriptorBinder.describe(var1_1, descriptorContent);
    }

    /*
     * WARNING - void declaration
     */
    protected List<RemoteService> filterExclusiveServices(RemoteService[] services) {
        void var3_3;
        ServiceType[] exclusiveTypes = this.getUpnpService().getConfiguration().getExclusiveServiceTypes();
        if (exclusiveTypes == null || exclusiveTypes.length == 0) {
            return Arrays.asList(services);
        }
        ArrayList<RemoteService> exclusiveServices = new ArrayList<RemoteService>();
        RemoteService[] remoteServiceArray = services;
        int n = services.length;
        int n2 = 0;
        while (n2 < n) {
            RemoteService discoveredService = remoteServiceArray[n2];
            ServiceType[] serviceTypeArray = exclusiveTypes;
            int n3 = exclusiveTypes.length;
            int n4 = 0;
            while (n4 < n3) {
                ServiceType exclusiveType = serviceTypeArray[n4];
                if (discoveredService.getServiceType().implementsVersion(exclusiveType)) {
                    this.logger.debug("Including exclusive service: {}", (Object)discoveredService);
                    exclusiveServices.add(discoveredService);
                } else {
                    this.logger.debug("Excluding unwanted service: {}", (Object)exclusiveType);
                }
                ++n4;
            }
            ++n2;
        }
        return var3_3;
    }

    public static boolean isRetrievalInProgress(RemoteDevice rd) {
        RemoteDevice remoteDevice;
        if (rd == null) {
            throw new IllegalArgumentException("RemoteDevice must not be null!");
        }
        return activeRetrievals.containsKey(((RemoteDeviceIdentity)remoteDevice.getIdentity()).getDescriptorURL());
    }
}

