/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.protocol;

import org.jupnp.UpnpService;
import org.jupnp.model.message.UpnpMessage;
import org.jupnp.model.message.header.UpnpHeader;
import org.jupnp.transport.RouterException;
import org.jupnp.util.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReceivingAsync<M extends UpnpMessage>
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(UpnpService.class);
    private final UpnpService upnpService;
    private M inputMessage;

    /*
     * WARNING - void declaration
     */
    protected ReceivingAsync(UpnpService upnpService, M inputMessage) {
        void var2_2;
        void var1_1;
        this.upnpService = var1_1;
        this.inputMessage = var2_2;
    }

    public UpnpService getUpnpService() {
        return this.upnpService;
    }

    public M getInputMessage() {
        return this.inputMessage;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        boolean proceed;
        try {
            proceed = this.waitBeforeExecution();
        }
        catch (InterruptedException interruptedException) {
            this.logger.info("Protocol wait before execution interrupted (on shutdown?): {}", (Object)this.getClass().getSimpleName());
            proceed = false;
        }
        if (proceed) {
            try {
                this.execute();
                return;
            }
            catch (Exception exception) {
                void var1_2;
                Exception e = exception;
                Throwable throwable = Exceptions.unwrap(exception);
                if (throwable instanceof InterruptedException) {
                    this.logger.info("Interrupted protocol '{}'", (Object)this.getClass().getSimpleName(), (Object)e);
                    return;
                }
                throw new RuntimeException("Fatal error while executing protocol '" + this.getClass().getSimpleName() + "'", (Throwable)var1_2);
            }
        }
    }

    protected boolean waitBeforeExecution() throws InterruptedException {
        return true;
    }

    protected abstract void execute() throws RouterException;

    /*
     * WARNING - void declaration
     */
    protected <H extends UpnpHeader> H getFirstHeader(UpnpHeader.Type headerType, Class<H> subtype) {
        void var2_2;
        void var1_1;
        return ((UpnpMessage)this.getInputMessage()).getHeaders().getFirstHeader((UpnpHeader.Type)var1_1, var2_2);
    }

    public String toString() {
        return "(" + this.getClass().getSimpleName() + ")";
    }
}

