/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.protocol;

import java.net.URI;
import java.net.URL;
import java.util.List;
import org.jupnp.UpnpService;
import org.jupnp.UpnpServiceConfiguration;
import org.jupnp.model.NetworkAddress;
import org.jupnp.model.action.ActionInvocation;
import org.jupnp.model.gena.LocalGENASubscription;
import org.jupnp.model.gena.RemoteGENASubscription;
import org.jupnp.model.message.IncomingDatagramMessage;
import org.jupnp.model.message.StreamRequestMessage;
import org.jupnp.model.message.UpnpRequest;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.model.message.header.UpnpHeader;
import org.jupnp.model.meta.LocalDevice;
import org.jupnp.model.meta.RemoteDevice;
import org.jupnp.model.meta.RemoteDeviceIdentity;
import org.jupnp.model.meta.RemoteService;
import org.jupnp.model.types.InvalidValueException;
import org.jupnp.model.types.NamedServiceType;
import org.jupnp.model.types.NotificationSubtype;
import org.jupnp.model.types.ServiceType;
import org.jupnp.protocol.ProtocolCreationException;
import org.jupnp.protocol.ProtocolFactory;
import org.jupnp.protocol.ReceivingAsync;
import org.jupnp.protocol.ReceivingSync;
import org.jupnp.protocol.async.ReceivingNotification;
import org.jupnp.protocol.async.ReceivingSearch;
import org.jupnp.protocol.async.ReceivingSearchResponse;
import org.jupnp.protocol.async.SendingNotificationAlive;
import org.jupnp.protocol.async.SendingNotificationByebye;
import org.jupnp.protocol.async.SendingSearch;
import org.jupnp.protocol.sync.ReceivingAction;
import org.jupnp.protocol.sync.ReceivingEvent;
import org.jupnp.protocol.sync.ReceivingRetrieval;
import org.jupnp.protocol.sync.ReceivingSubscribe;
import org.jupnp.protocol.sync.ReceivingUnsubscribe;
import org.jupnp.protocol.sync.SendingAction;
import org.jupnp.protocol.sync.SendingEvent;
import org.jupnp.protocol.sync.SendingRenewal;
import org.jupnp.protocol.sync.SendingSubscribe;
import org.jupnp.protocol.sync.SendingUnsubscribe;
import org.jupnp.transport.RouterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolFactoryImpl
implements ProtocolFactory {
    private final Logger logger = LoggerFactory.getLogger(ProtocolFactory.class);
    protected final UpnpService upnpService;

    protected ProtocolFactoryImpl() {
        this.upnpService = null;
    }

    /*
     * WARNING - void declaration
     */
    public ProtocolFactoryImpl(UpnpService upnpService) {
        void var1_1;
        this.logger.trace("Creating ProtocolFactory: {}", (Object)this.getClass().getName());
        this.upnpService = var1_1;
    }

    @Override
    public UpnpService getUpnpService() {
        return this.upnpService;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ReceivingAsync createReceivingAsync(IncomingDatagramMessage message) throws ProtocolCreationException {
        void var1_1;
        this.logger.trace("Creating protocol for incoming asynchronous: {}", (Object)message);
        if (message.getOperation() instanceof UpnpRequest) {
            switch (((UpnpRequest)message.getOperation()).getMethod()) {
                case NOTIFY: {
                    if (this.isByeBye(message) || this.isSupportedServiceAdvertisement(message)) {
                        return this.createReceivingNotification(message);
                    }
                    return null;
                }
                case MSEARCH: {
                    return this.createReceivingSearch(message);
                }
            }
        } else if (message.getOperation() instanceof UpnpResponse) {
            if (this.isSupportedServiceAdvertisement(message)) {
                return this.createReceivingSearchResponse(message);
            }
            return null;
        }
        throw new ProtocolCreationException("Protocol for incoming datagram message not found: " + String.valueOf(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    protected ReceivingAsync createReceivingNotification(IncomingDatagramMessage<UpnpRequest> incomingRequest) {
        void var1_1;
        return new ReceivingNotification(this.getUpnpService(), (IncomingDatagramMessage<UpnpRequest>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected ReceivingAsync createReceivingSearch(IncomingDatagramMessage<UpnpRequest> incomingRequest) {
        void var1_1;
        return new ReceivingSearch(this.getUpnpService(), (IncomingDatagramMessage<UpnpRequest>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected ReceivingAsync createReceivingSearchResponse(IncomingDatagramMessage<UpnpResponse> incomingResponse) {
        void var1_1;
        return new ReceivingSearchResponse(this.getUpnpService(), (IncomingDatagramMessage<UpnpResponse>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isByeBye(IncomingDatagramMessage message) {
        void var1_1;
        String ntsHeader = message.getHeaders().getFirstHeader(UpnpHeader.Type.NTS.getHttpName());
        return ntsHeader != null && var1_1.equals(NotificationSubtype.BYEBYE.getHeaderString());
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isSupportedServiceAdvertisement(IncomingDatagramMessage message) {
        void var1_1;
        UpnpServiceConfiguration config = this.upnpService.getConfiguration();
        if (config == null) {
            return false;
        }
        ServiceType[] exclusiveServiceTypes = config.getExclusiveServiceTypes();
        if (exclusiveServiceTypes == null) {
            return false;
        }
        if (exclusiveServiceTypes.length == 0) {
            return true;
        }
        String usnHeader = message.getHeaders().getFirstHeader(UpnpHeader.Type.USN.getHttpName());
        if (usnHeader == null) {
            return false;
        }
        try {
            NamedServiceType nst = NamedServiceType.valueOf(usnHeader);
            ServiceType[] serviceTypeArray = exclusiveServiceTypes;
            int n = exclusiveServiceTypes.length;
            int n2 = 0;
            while (n2 < n) {
                void var2_2;
                ServiceType exclusiveServiceType = serviceTypeArray[n2];
                if (nst.getServiceType().implementsVersion((ServiceType)var2_2)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (InvalidValueException invalidValueException) {
            this.logger.trace("Not a named service type header value: {}", (Object)usnHeader);
        }
        this.logger.trace("Service advertisement not supported, dropping it: {}", (Object)var1_1);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ReceivingSync createReceivingSync(StreamRequestMessage message) throws ProtocolCreationException {
        void var1_1;
        this.logger.trace("Creating protocol for incoming synchronous: {}", (Object)message);
        if (((UpnpRequest)message.getOperation()).getMethod().equals((Object)UpnpRequest.Method.GET)) {
            return this.createReceivingRetrieval(message);
        }
        if (this.getUpnpService().getConfiguration().getNamespace().isControlPath(message.getUri())) {
            if (((UpnpRequest)message.getOperation()).getMethod().equals((Object)UpnpRequest.Method.POST)) {
                return this.createReceivingAction(message);
            }
        } else if (this.getUpnpService().getConfiguration().getNamespace().isEventSubscriptionPath(message.getUri())) {
            if (((UpnpRequest)message.getOperation()).getMethod().equals((Object)UpnpRequest.Method.SUBSCRIBE)) {
                return this.createReceivingSubscribe(message);
            }
            if (((UpnpRequest)message.getOperation()).getMethod().equals((Object)UpnpRequest.Method.UNSUBSCRIBE)) {
                return this.createReceivingUnsubscribe(message);
            }
        } else if (this.getUpnpService().getConfiguration().getNamespace().isEventCallbackPath(message.getUri())) {
            if (((UpnpRequest)message.getOperation()).getMethod().equals((Object)UpnpRequest.Method.NOTIFY)) {
                return this.createReceivingEvent(message);
            }
        } else if (message.getUri().getPath().contains("/event/cb")) {
            void var2_2;
            this.logger.warn("Fixing trailing garbage in event message path: {}", (Object)message.getUri().getPath());
            String invalid = message.getUri().toString();
            message.setUri(URI.create(invalid.substring(0, var2_2.indexOf("/cb") + 3)));
            if (this.getUpnpService().getConfiguration().getNamespace().isEventCallbackPath(message.getUri()) && ((UpnpRequest)message.getOperation()).getMethod().equals((Object)UpnpRequest.Method.NOTIFY)) {
                return this.createReceivingEvent(message);
            }
        }
        throw new ProtocolCreationException("Protocol for message type not found: " + String.valueOf(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SendingNotificationAlive createSendingNotificationAlive(LocalDevice localDevice) {
        void var1_1;
        return new SendingNotificationAlive(this.getUpnpService(), (LocalDevice)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SendingNotificationByebye createSendingNotificationByebye(LocalDevice localDevice) {
        void var1_1;
        return new SendingNotificationByebye(this.getUpnpService(), (LocalDevice)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SendingSearch createSendingSearch(UpnpHeader searchTarget, int mxSeconds) {
        void var2_2;
        void var1_1;
        return new SendingSearch(this.getUpnpService(), (UpnpHeader)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SendingAction createSendingAction(ActionInvocation actionInvocation, URL controlURL) {
        void var2_2;
        void var1_1;
        return new SendingAction(this.getUpnpService(), (ActionInvocation)var1_1, (URL)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SendingSubscribe createSendingSubscribe(RemoteGENASubscription subscription) throws ProtocolCreationException {
        try {
            void var1_1;
            List<NetworkAddress> activeStreamServers = this.getUpnpService().getRouter().getActiveStreamServers(((RemoteDeviceIdentity)((RemoteDevice)((RemoteService)subscription.getService()).getDevice()).getIdentity()).getDiscoveredOnLocalAddress());
            return new SendingSubscribe(this.getUpnpService(), (RemoteGENASubscription)var1_1, activeStreamServers);
        }
        catch (RouterException e) {
            void var2_3;
            throw new ProtocolCreationException("Failed to obtain local stream servers (for event callback URL creation) from router", (Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SendingRenewal createSendingRenewal(RemoteGENASubscription subscription) {
        void var1_1;
        return new SendingRenewal(this.getUpnpService(), (RemoteGENASubscription)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SendingUnsubscribe createSendingUnsubscribe(RemoteGENASubscription subscription) {
        void var1_1;
        return new SendingUnsubscribe(this.getUpnpService(), (RemoteGENASubscription)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SendingEvent createSendingEvent(LocalGENASubscription subscription) {
        void var1_1;
        return new SendingEvent(this.getUpnpService(), (LocalGENASubscription)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected ReceivingRetrieval createReceivingRetrieval(StreamRequestMessage message) {
        void var1_1;
        return new ReceivingRetrieval(this.getUpnpService(), (StreamRequestMessage)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected ReceivingAction createReceivingAction(StreamRequestMessage message) {
        void var1_1;
        return new ReceivingAction(this.getUpnpService(), (StreamRequestMessage)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected ReceivingSubscribe createReceivingSubscribe(StreamRequestMessage message) {
        void var1_1;
        return new ReceivingSubscribe(this.getUpnpService(), (StreamRequestMessage)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected ReceivingUnsubscribe createReceivingUnsubscribe(StreamRequestMessage message) {
        void var1_1;
        return new ReceivingUnsubscribe(this.getUpnpService(), (StreamRequestMessage)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected ReceivingEvent createReceivingEvent(StreamRequestMessage message) {
        void var1_1;
        return new ReceivingEvent(this.getUpnpService(), (StreamRequestMessage)var1_1);
    }
}

