/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.types;

import org.jupnp.util.SpecificationViolationReporter;

public abstract class UnsignedVariableInteger {
    protected long value;

    protected UnsignedVariableInteger() {
    }

    /*
     * WARNING - void declaration
     */
    protected UnsignedVariableInteger(long value) throws NumberFormatException {
        void var1_1;
        this.setValue((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected UnsignedVariableInteger(String s) throws NumberFormatException {
        void var1_1;
        if (s.startsWith("-")) {
            SpecificationViolationReporter.report("Invalid negative integer value '" + s + "', assuming value 0!", new Object[0]);
            s = "0";
        }
        this.setValue(Long.parseLong(var1_1.trim()));
    }

    /*
     * WARNING - void declaration
     */
    protected UnsignedVariableInteger setValue(long value) {
        void var1_1;
        this.isInRange(value);
        this.value = var1_1;
        return this;
    }

    public Long getValue() {
        return this.value;
    }

    /*
     * WARNING - void declaration
     */
    public void isInRange(long value) throws NumberFormatException {
        if (value < (long)this.getMinValue() || value > this.getBits().getMaxValue()) {
            void var1_1;
            throw new NumberFormatException("Value must be between " + this.getMinValue() + " and " + this.getBits().getMaxValue() + ": " + (long)var1_1);
        }
    }

    public int getMinValue() {
        return 0;
    }

    public abstract Bits getBits();

    /*
     * WARNING - void declaration
     */
    public UnsignedVariableInteger increment(boolean rolloverToOne) {
        void var1_1;
        this.value = this.value + 1L > this.getBits().getMaxValue() ? (long)(var1_1 != false ? 1 : 0) : ++this.value;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnsignedVariableInteger that = (UnsignedVariableInteger)o;
        return this.value == var1_1.value;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public String toString() {
        return Long.toString(this.value);
    }

    public static enum Bits {
        EIGHT(255L),
        SIXTEEN(65535L),
        TWENTYFOUR(0xFFFFFFL),
        THIRTYTWO(0xFFFFFFFFL);

        private final long maxValue;

        /*
         * WARNING - void declaration
         */
        private Bits(long maxValue) {
            void var3_3;
            this.maxValue = var3_3;
        }

        public final long getMaxValue() {
            return this.maxValue;
        }
    }
}

