/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.types;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.UUID;
import org.jupnp.model.ModelUtil;

public class UDN {
    public static final String PREFIX = "uuid:";
    private String identifierString;

    /*
     * WARNING - void declaration
     */
    public UDN(String identifierString) {
        void var1_1;
        this.identifierString = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public UDN(UUID uuid) {
        void var1_1;
        this.identifierString = var1_1.toString();
    }

    public boolean isUDA11Compliant() {
        try {
            UUID.fromString(this.identifierString);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public String getIdentifierString() {
        return this.identifierString;
    }

    public static UDN valueOf(String udnString) {
        String string;
        return new UDN(udnString.startsWith(PREFIX) ? udnString.substring(5) : string);
    }

    /*
     * WARNING - void declaration
     */
    public static UDN uniqueSystemIdentifier(String salt) {
        StringBuilder systemSalt = new StringBuilder();
        if (ModelUtil.ANDROID_RUNTIME) {
            throw new RuntimeException("This method does not create a unique identifier on Android, see the Javadoc and use new UDN(UUID) instead!");
        }
        systemSalt.append(new String(ModelUtil.getFirstNetworkInterfaceHardwareAddress(), StandardCharsets.UTF_8));
        try {
            String string;
            byte[] hash = MessageDigest.getInstance("MD5").digest(systemSalt.toString().getBytes(StandardCharsets.UTF_8));
            return new UDN(new UUID(new BigInteger(-1, hash).longValue(), string.hashCode()));
        }
        catch (Exception e) {
            void var1_2;
            throw new RuntimeException((Throwable)var1_2);
        }
    }

    public String toString() {
        return PREFIX + this.getIdentifierString();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof UDN)) {
            return false;
        }
        UDN udn = (UDN)o;
        return this.identifierString.equals(var1_1.identifierString);
    }

    public int hashCode() {
        return this.identifierString.hashCode();
    }
}

